/***************************************************************************
                          job_deletetrackphysically.cpp  -  description
                             -------------------
    begin                : Tue Jun 12 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_deletetrackphysically.h"

#include "datadispatcher.h"
#include "database.h"
#include "jobmanager.h"
#include "gui.h"

#include "job_disconnectfromdatabase.h"

#include "lvi_smbshare.h"
#include "lvi_nfsexport.h"

#include "qdir.h"

#include <qmessagebox.h>

#ifdef EMBEDDED
#include <mysql.h>
#endif

Job_DeleteTrackPhysically::Job_DeleteTrackPhysically(TRACK *_track)
: track(_track) {}

void Job_DeleteTrackPhysically::run() {
    int error;

    if (verbose==8)
        qWarning( "    >run() tread:%p type:%s HANDLE:%p", this, JOB_CODE[type()], currentThread() );

    #ifdef EMBEDDED

    mysql_thread_init();
    #endif

    app->lock()
    ;
    datadispatcher->eventAddEditLock();
    if(track->medium == MEDIUM_HARDDISK)
        datadispatcher->eventStartedHarddiskSynchronizing();
    else if(track->medium == MEDIUM_SMB)
        datadispatcher->eventStartedSMBSynchronizing(gui->getSourcer()->getSMBByID(track->id));
    else if(track->medium == MEDIUM_NFS)
        datadispatcher->eventStartedNFSSynchronizing(gui->getSourcer()->getNFSByID(track->id));
    int userIsSure = QMessageBox::warning(gui, _("Message"),
                                          _("Are you sure you want to remove %1/%2  physically?").arg(track->path).arg(track->filename), QMessageBox::Yes, QMessageBox::No);

    app->unlock();

    error = 0;

    if(userIsSure == QMessageBox::Yes) {
        QDir dir(track->path);
        if(dir.remove(track->filename)) {
            QList<TRACK> list;
            list.append(track);
            database->lock()
            ;
            database->deleteTracks(&list);
            error = database->getError();
            database->unlock();
        }
    }

    if(!error) {
        database->lock()
        ;
        app->lock()
        ;
        if(userIsSure == QMessageBox::Yes) {
            datadispatcher->eventNewArtistDelta(database->getArtistDelta());
            datadispatcher->eventNewTrackListing(database->getLastQuery());
            datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(0),0);
            int ID = gui->getPlaylisting()->getDisplayedPlaylistID();
            if(ID > 0)
                datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(ID),ID);
            error = database->getError();
        }

        if(!error) {
            if(track->medium == MEDIUM_HARDDISK)
                datadispatcher->eventStoppedHarddiskSynchronizing();
            else if(track->medium == MEDIUM_SMB)
                datadispatcher->eventStoppedSMBSynchronizing(gui->getSourcer()->getSMBByID(track->id));
            else if(track->medium == MEDIUM_NFS)
                datadispatcher->eventStoppedNFSSynchronizing(gui->getSourcer()->getNFSByID(track->id));
        }
        datadispatcher->eventRemoveEditLock();

        app->unlock();
        database->unlock();
    }

    if(error) {
        app->lock()
        ;
        if(track->medium == MEDIUM_HARDDISK)
            datadispatcher->eventStoppedHarddiskSynchronizing();
        else if(track->medium == MEDIUM_SMB)
            datadispatcher->eventStoppedSMBSynchronizing(gui->getSourcer()->getSMBByID(track->id));
        else if(track->medium == MEDIUM_NFS)
            datadispatcher->eventStoppedNFSSynchronizing(gui->getSourcer()->getNFSByID(track->id));
        app->unlock();
        jobman->lock()
        ;
        jobman->addJob(new Job_DisconnectFromDatabase());
        jobman->unlock();
    }

    delete track;

    jobman->lock()
    ;
    jobman->jobDone(this);
    jobman->unlock();
    #ifdef EMBEDDED

    mysql_thread_end();
    #endif

    if (verbose==8)
        qWarning( "    >exit() thread:%p type:%s HANDLE: %p", this, JOB_CODE[type()], currentThread() );

    exit();
}

Job_DeleteTrackPhysically::~Job_DeleteTrackPhysically() {}
