/***************************************************************************
                          tagger_mp3.h  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGGER_MP3_H
#define TAGGER_MP3_H

#include "tagger.h"

struct MP3Header {
    unsigned int sync;
    unsigned int version;
    unsigned int layer;
    bool         isProtected;
    unsigned int bitrate;
    unsigned int frequency;
    bool         isPadded;
    bool         isPrivate;
    unsigned int mode;
    unsigned int mode_ext;
    bool         isCopyrighted;
    bool         isOriginal;
    unsigned int emphasis;
};

struct ID3Tag {
    char title[31];
    char artist[31];
    char album[31];
    char year[5];
    char comment[31];
    unsigned char track[1];
    unsigned char genre[1];
};

struct ID3v2Tag {
    QString title;
    QString artist;
    QString album;
    QString year;
    QString comment;
    int track;
    int genre;
};

struct MP3Info {
    QString          filename;
    QFile            file;
    struct MP3Header header;
    struct ID3Tag    id3;
    struct ID3v2Tag  id3v2;
    unsigned int     dataSize;
    unsigned int     size;
    unsigned int     frames;
    unsigned int     seconds;
    unsigned int     layer;
    unsigned int     frequency;
    unsigned int     bitrate;
    bool             isVBR;
    float            vbr_average;
    bool             header_isValid;
    int              badFrames;
};

class Tagger_MP3 {
public:
    Tagger_MP3();

    static bool getInfo(TRACK *track, bool lazyRead);
    static bool getTagOnly(TRACK *track);
    static bool writeInfo(TRACK *track);

    ~Tagger_MP3();

private:
    static int getMP3Info(MP3Info *mp3, bool scanFull, bool vbrScanFull);
    static int getFirstHeader(MP3Info *mp3, long startPos);
    static int getNextHeader(MP3Info *mp3);
    static int getHeader(MP3Info *mp3, MP3Header *header);
    static int frameLength(MP3Header *header);
    static int sameConstant(MP3Header *h1, MP3Header *h2);
    static int getID3(MP3Info *mp3);
    static int putID3(MP3Info *mp3);
    static char *pad(char *s, int length);
    static char *unpad(char *s);
};

#endif
