/**
 ** Proll (PROM replacement)
 ** Copyright 1999 Pete Zaitcev
 ** This code is licensed under GNU General Public License.
 **/
#include <stdarg.h>

#include <crs.h>
#include <asi.h>
#include "pgtsrmmu.h"
#include "phys_ro.h"
#include "vconsole.h"
#include "version.h"
#include <general.h>		/* __P() */
#include <net.h>		/* init_net() */
#include <romlib.h>		/* we are a provider for part of this. */
#include <netpriv.h>		/* myipaddr */
#include <arpa.h>
#include <system.h>		/* our own prototypes */

#if 0
static int iga_find_darkest(void);
static void iga_set_color(int x, unsigned r, unsigned g, unsigned b);
#endif
static void roxy_get_macaddr(unsigned char *p);
static void roxy_leds_ctl(int leds, int on);

struct vconterm dp0;
struct mem cmem;		/* Current memory, virtual */
struct mem cio;			/* Current I/O space */
struct phym pmem;		/* Current phys. mem. */
struct pcic cpcic;		/* Current PCIC. */

/*
 */
void prolmain()
{
	static char fname[14] = "00000000.PROL";
	static struct banks bb;
	int nmegs;
	int i;
	unsigned int hiphybas;
	void *romvec;

#if 0
	iga_set_color(255, 0, 0, 0);		/* background black */
	iga_set_color(0, 255, 255, 255);	/* foreground white */
#endif
	vcon_init(&dp0, PHYS_RO_SU_A);
	printk("PROLL %s Roxy BOOTP+LEDS\n", PROLL_VERSION_STRING);

	/* XXX What if 16MB DIMM, do they exist still?? */
	get_banks_layout(&bb, 1);		/* XXX One 32-MB bank... */
	if (bb.nbanks <= 0) {
		printk("No memory found\n");
		return;
	}

	nmegs = 0;
	for (i = 0; i < bb.nbanks; i++) {
		printk("bank %d 0x%x[0x%x]\n", i,
		    bb.bankv[i].start, bb.bankv[i].length);
		nmegs += bb.bankv[i].length/(1024*1024);
	}
	printk("%d MB total\n", nmegs);

	i = bb.nbanks - 1;
	hiphybas = bb.bankv[i].start + bb.bankv[i].length - PROLSIZE;
	/* printk("high phys base 0x%x\n", hiphybas); */ /* P3 */

	/*
	 * We generate tables and switch two times.
	 * We start off being in low physical memory (LOADBASE) and
	 * mapped to high virtual (PROLBASE), running off PROM tables.
	 * These tables are located somewhere in upper physical so
	 * when we copy ourselves up we may step on them. The
	 * solution is to create temporary pages in low physical memory,
	 * then use them to move ourselves high. After that we may
	 * create new tables in high physical memory.
	 */

	mem_init(&cmem, (char *) &_end, (char *)(PROLBASE+PROLSIZE));
	makepages(&pmem, LOADBASE);

#if 0
	proc_tablewalk(0, PROLBASE+PROLSIZE-PAGE_SIZE);
	mem_tablewalk((pmem.pctp[0]&(~0xF))<<4, PROLBASE+PROLSIZE-PAGE_SIZE);
#endif
	init_mmu_swift((unsigned int)pmem.pctp - PROLBASE + LOADBASE);
	move_phys_high(hiphybas, PROLSIZE);
	/*
	 * We did not use the dynamic memory for anything but
	 * page tables, which are left down in low memory. Reinitiate cmem.
	 */
	mem_fini(&cmem);
	mem_init(&cmem, (char *) &_end, (char *)(PROLBASE+PROLSIZE));
	makepages(&pmem, hiphybas);
	init_mmu_swift((unsigned int)pmem.pctp - PROLBASE + hiphybas);

	mem_init(&cio, (char *)(PROLBASE+PROLSIZE),
	    (char *)(PROLBASE+PROLSIZE+IOMAPSIZE));

	pcic_init(&cpcic, hiphybas);

#if 0
	/* Enable PCI DMA accesses into DRAM in MID register. */
	i = ld_bypass(0x10002000);
	printk("MID 0x%x\n", i);
	st_bypass(0x10002000, i | 0x10000);
#endif

	idprom[0] = 1;
	idprom[1] = 0x80;
	roxy_get_macaddr(idprom + 2);

	sched_init();
	roxy_leds_ctl(0x7, 1);	/* All on: start */

	cse_probe();
	init_net();
#if 1 /* RARP */
	if (rarp() != 0) fatal();
	/* printrarp(); */
	roxy_leds_ctl(0x1, 0);	/* Right off - got rarp */
	xtoa(myipaddr, fname, 8);
	if (load(servaddr, fname) != 0) fatal();
#else
	if (bootp() != 0) fatal();
	roxy_leds_ctl(0x1, 0);	/* Right off - got bootp */
	/*
	 * boot_rec.bp_file cannot be used because system PROM uses
	 * it to locate ourselves. If we load from boot_rec.bp_file,
	 * we will loop reloading PROLL over and over again.
	 * Thus we use traditional PROLL scheme "HEXIPADDR.PROL".
	 */
	xtoa(myipaddr, fname, 8);
	if (load(boot_rec.bp_siaddr, fname) != 0) fatal();
#endif

#if 0
	pcic_map_irq(&cpcic, PHYS_JK_PIN_RTC, PHYS_JK_IRQ_RTC);
#endif
	romvec = init_openprom(bb.nbanks, bb.bankv, hiphybas);

	roxy_leds_ctl(0x2, 0);	/* Middle off, */
	roxy_leds_ctl(0x1, 1);	/*   right on - waiting */
	printk("Memory used: virt 0x%x:0x%x[%dK] iomap 0x%x:0x%x\n",
	    PROLBASE, (int)cmem.curp, ((unsigned) cmem.curp - PROLBASE)/1024,
	    (int)cio.start, (int)cio.curp);
	set_timeout(5);  while (!chk_timeout()) { }  /* Let user read */

	roxy_leds_ctl(0x6, 0);	/* Leave only left - startup */
	{
		void (*entry)(void *, int) = (void (*)(void*, int)) LOADBASE;
		entry(romvec, 0);
	}

	printk("bye.\n");	/* Not reached, but let it be. */
	mem_fini(&cmem);
	vcon_fini(&dp0);
	/* XXX Redo head.S so that it starts kernel */
}

#if 0
static int iga_find_darkest()
{
	unsigned int mmbase = PHYS_JK_MM_IGA | 0x00800000;
	unsigned int r, g, b, mod, mod1;
	int i, darkest;

	darkest = 0;
	mod = 0xff*0xff * 3;
	for (i = 0; i < 256; i++) {
		stb_bypass(mmbase + 0x3C7, i);
		r = ldb_bypass(mmbase + 0x3C9);
		g = ldb_bypass(mmbase + 0x3C9);
		b = ldb_bypass(mmbase + 0x3C9);
		mod1 = r*r + g*g + b*b;
		if (mod1 < mod) {
			mod = mod1;
			darkest = i;
		}
	}
/* P3 */ printk("darkest %d(0x%x) mod 0%x\n", darkest, darkest, mod);
	return darkest;
}

static void iga_set_color(int index,
    unsigned int r, unsigned int g, unsigned int b)
{
	unsigned int mmbase = PHYS_JK_PCI_IO;

	stb_bypass(mmbase + 0x3C8, index);
	stb_bypass(mmbase + 0x3C9, r);
	stb_bypass(mmbase + 0x3C9, g);
	stb_bypass(mmbase + 0x3C9, b);
}

/*
 * This comes handy when we unplug the keyboard then say "boot net".
 * The system comes up with a disabled screen.
 */
static void iga_enable_visual()
{
	unsigned int mmbase = PHYS_JK_PCI_IO;

	stb_bypass(mmbase + 0x3C0, 0x20);
}
#endif

/*
 * Structure of Roxy Flash is exeedingly overcomplicated,
 * so we just pull the MAC address from Ethernet chip.
 * Presumably we are just loaded over it and it was not reset.
 */
static void roxy_get_macaddr(unsigned char *p)
{
	int i;
	unsigned int addr;
	unsigned int w;

	for (i = 0; i < 3; i++) {
		addr = 0x3000030a;		/* Address latch */
		w = 0x5801;			/* Offset 0x158, swapped */
		w += (i<<9);
		__asm__ __volatile__("stha %0, [%1] %2\n\t" : :
		    "r" (w), "r" (addr), "i" (ASI_M_BYPASS) : "memory");
		addr = 0x3000030c;		/* Data nipple */
		__asm__ __volatile__("lduha [%1] %2, %0\n\t" :
		    "=r" (w) : "r" (addr), "i" (ASI_M_BYPASS));
		*p++ = w>>8;
		*p++ = w;
	}
}

/*
 * LEDs
 */

#ifndef CONFIG_CMD
#define CONFIG_CMD(bus, device_fn, where)	\
 (0x80000000 | (((unsigned int)bus) << 16) |	\
 (((unsigned int)device_fn) << 8) | (where & ~3))
#endif

struct ledaddr {
	int reg, mask;
};

static struct ledaddr ledv[] = {
	{ 0xc2, 0x10 },		/* Left (does not go off for some reason) */
	{ 0xc3, 0x02 },		/* Middle (yellow) */
	{ 0xc3, 0x04 }		/* Right */
};

static void roxy_leds_ctl(int leds, int on) {
	struct ledaddr *ledp;
	/*
	 * Normal address for PMU is 0x88 (or 0xe0),
	 * but Norm's ROM disables it for some reason.
	 * Disable bit is register 0x5f, mask 0x04, 1 == Disable.
	 * We use the pass-through range in bridge configuration space.
	 * Right thing to do would be to do read(0x5f)&0x04,
	 * if <>0 then devfn = 0x38 else devfn = 0x88;
	 */
	unsigned devfn = 0x38;
	unsigned where;
	unsigned int w;
	int i;

	/* Enable GPIO[23,22]. */
	where = 0xc6;
	st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(0,devfn,where));
	stb_bypass(PHYS_JK_PCI_CFD + (where & 7), 0x06);

	ledp = ledv;
	for (i = 0; i < sizeof(ledv)/sizeof(ledv[0]); i++) {
		if ((leds & (1 << i)) == 0) continue;

		where = ledp->reg;
		st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(0,devfn,where));
		w = ldb_bypass(PHYS_JK_PCI_CFD + (where & 7));

		if (on) w |= ledp->mask; else w &= ~ledp->mask;

		st_bp_swap(PHYS_JK_PCI_CFA, CONFIG_CMD(0,devfn,where));
		stb_bypass(PHYS_JK_PCI_CFD + (where & 7), w);

		ledp++;
	}
}

/*
 * dvma_alloc over iommu_alloc.
 */
void *dvma_alloc(int size, unsigned int *pphys)
{
        return pcic_alloc(&cpcic, size, pphys);
}

/*
 */
unsigned long virt_to_bus(volatile void *addr)
{
	return pcic_virt_to_bus(addr);
}

/*
 * Stub for hme.c
 */
unsigned long sbus_dvma_addr(void *addr) {
	printk("sbus_dvma_addr!\n");
	return (~0);
}

/*
 */
void udelay(unsigned long usecs)
{
	int i, n = usecs * 50;
	for (i = 0; i < n; i++) { }
}
