/**
 ** Console over 'su' (PC style serial port)
 ** Copyright 1999 Pete Zaitcev
 ** This code is licensed under GNU General Public License.
 **/

#include "vconsole.h"
#include <system.h>

#define SU_DATA 0x00
#define SU_IER  0x01
#define SU_IIR  0x02
#define SU_LCR  0x03
#define SU_MCR  0x04
#define SU_LSR  0x05
#define SU_MSR  0x06

int vcon_init(struct vconterm *t, unsigned int a0)
{

	t->impl = (void *) a0;

	t->vc_x = 0;    t->vc_y = 0;
	t->backp = 0;    t->backc = 0;

	return 0;
}

int vcon_write(struct vconterm *t, char *data, int leng)
{
	while (leng != 0) {
		leng--;
		vcon_putch(t, *data++);
	}
	return leng;
}

int vcon_putch(struct vconterm *t, char c)
{
	unsigned su_ptr = (unsigned) t->impl;

	while ((ldb_bypass(su_ptr + SU_LSR) & 0x60) != 0x60) { }
	stb_bypass(su_ptr, c);
	return 0;
}

int vcon_read(struct vconterm *t, char *data, int leng)
{
	return 0;
}

int vcon_getch(struct vconterm *t)
{
	return -1;
}

void vcon_fini(struct vconterm *t)
{
	/* violent crash in the end */
	;
}
