/**
 ** A console device
 ** Copyright 1999 Pete Zaitcev
 ** This code is licensed under GNU General Public License.
 **/
#ifndef VCONSOLE_H
#define VCONSOLE_H

struct vconterm {
	void *impl;

	char *backp;		/* Interpreted deferred writable characters */
	int backc;		/* Same, count */

	int vc_x, vc_y;		/* XXX Make vcon_xxx() to use cellmap->xpos_ */
};

int vcon_init(struct vconterm *t, unsigned int a0);
int vcon_write(struct vconterm *t, char *data, int leng);
int vcon_putch(struct vconterm *t, char c);
int vcon_read(struct vconterm *t, char *data, int leng);
int vcon_getch(struct vconterm *t);
void vcon_fini(struct vconterm *t);

#endif
