# $Id: KeyEdit.pm,v 1.5 2001/05/08 01:50:50 muhri Exp $
# -*- perl -*-
package Pronto::KeyEdit;
use strict;
use vars qw ( %gdk_key %realkey );

sub get_hash
{

	my @gdk_keys = &get_array("gdk_keys");
	my $i = 0;
	foreach(&get_array("keys")) {
		$gdk_key{$_} = $gdk_keys[$i];
		$realkey{$gdk_keys[$i]} = $_;
		$i++;
	}
	my ($alt,$ctl,$none) = &get_array("mods");
	$gdk_key{'Empty-Folder'} = 0x064;		
	$gdk_key{'Empty-Folder'.'mod'} = $ctl;	
	$gdk_key{'Mini-Browser'} = 0x062;
	$gdk_key{'Mini-Browser'.'mod'} = $alt;
	$gdk_key{'Save'} = 0x073;
	$gdk_key{'Save'.'mod'} = $alt;
	$gdk_key{'Exit'} = 0x078;
	$gdk_key{'Exit'.'mod'} = $alt;
	$gdk_key{'Send-and-Receive'} = 0x06d;
	$gdk_key{'Send-and-Receive'.'mod'} = $alt;
	$gdk_key{'AdressBook'} = 0x061;
	$gdk_key{'AdressBook'.'mod'} = $alt;
	$gdk_key{'New-Message'} = 0x06e;
	$gdk_key{'New-Message'.'mod'} = $alt;
	$gdk_key{'Options'} = 0x06f;
	$gdk_key{'Options'.'mod'} = $ctl;
	$gdk_key{'Reply'} = 0x072;
	$gdk_key{'Reply'.'mod'} = $alt;
	$gdk_key{'Reply-To-List'} = 0x06c;
	$gdk_key{'Reply-To-List'.'mod'} = $alt;
	$gdk_key{'Forward'} = 0x066;
	$gdk_key{'Forward'.'mod'} = $alt;
	$gdk_key{'View-Win'} = 0x076;
	$gdk_key{'View-Win'.'mod'} = $ctl;
	$gdk_key{'View-Header'} = 0x068;
	$gdk_key{'View-Header'.'mod'} = $ctl;
	$gdk_key{'View-Source'} = 0x073;
	$gdk_key{'View-Source'.'mod'} = $ctl;
	$gdk_key{'Delete'} = 0x064;
	$gdk_key{'Delete'.'mod'} = $alt;
	$gdk_key{'Select-All'} = 0x061;
	$gdk_key{'Select-All'.'mod'} = $ctl;
	$gdk_key{'Thread-Subject'} = 0x073;
	$gdk_key{'Thread-Subject'.'mod'} = $none;
	$gdk_key{'KeyEdit'} = 0x06b;
	$gdk_key{'KeyEdit'.'mod'} = $alt;
	$gdk_key{'NextUnread'} = 0x020;
	$gdk_key{'NextUnread'.'mod'} = $alt;
	$gdk_key{'Reply-All-Including-Self'} =  0x069;
	$gdk_key{'Reply-All-Including-Self'.'mod'} = $alt;
	$gdk_key{'Reply-All-Execluding-Self'} = 0x077;
	$gdk_key{'Reply-All-Execluding-Self'.'mod'} = $alt;
	$gdk_key{'Edit'} =  0x065;
	$gdk_key{'Edit'.'mod'} = $alt;
	$gdk_key{'Toggle-Threads'} = 0x074;
	$gdk_key{'Toggle-Threads'.'mod'} = $alt;
	$gdk_key{'HTML-View'} = 0x06d;
	$gdk_key{'HTML-View'.'mod'} = $ctl;
	read_keys();	
	return %gdk_key;
}

sub init_key_editor
{
	my ($dialog,@titles);
	$dialog = new Gtk::Dialog;
	$dialog->set_title(_("Pronto's Key bindings Editor"));
	$dialog->set_default_size(300,300);
	$dialog->signal_connect("destroy", sub { $dialog->destroy; });
	@titles = (_("Action"),_("Modifier"),_("Key"));
	$dialog->{'clist'} = new_with_titles Gtk::CList(@titles);
	$dialog->{'clist'}->set_column_width(0,100);
	for (1..2) {
		$dialog->{'clist'}->set_column_width($_,60);  
		$dialog->{'clist'}->set_column_justification($_,"center");
	}	
	$dialog->{'sw'} = new Gtk::ScrolledWindow(undef,undef);
	$dialog->{'sw'}->set_policy('automatic','automatic');
	$dialog->{'sw'}->add($dialog->{'clist'});
	$dialog->vbox->pack_start($dialog->{'sw'},1,1,0);
	$dialog->{'ok'} = new Gtk::Button(_("Ok"));
	$dialog->{'ok'}->signal_connect("clicked" => \&ok, $dialog);
	$dialog->{'edit'} = new Gtk::Button(_("Edit"));
	$dialog->{'edit'}->signal_connect("clicked" => \&edit, $dialog->{'clist'});
	$dialog->{'cancel'} = new Gtk::Button(_("Cancel"));
	$dialog->{'cancel'}->signal_connect("clicked", sub { $dialog->destroy; });
	$dialog->action_area->pack_start($dialog->{'ok'},1,1,0);
	$dialog->action_area->pack_start($dialog->{'edit'},1,1,0);
	$dialog->action_area->pack_start($dialog->{'cancel'},1,1,0);
	insert_into_list($dialog->{'clist'});
	show_all $dialog;
}

sub insert_into_list
{
	my ($clist) = @_;
	foreach(&get_array("commands")) {
		$clist->append($_,$gdk_key{$_."mod"},$realkey{$gdk_key{$_}});
	}	
}	

sub get_array
{
	my ($array) = @_;
	if (!$array) { return undef; }
	if ($array eq "commands") {
		my @commands = ("Mini-Browser","Save","Exit",
				"Select-All","Options","Send-and-Receive",
				"AdressBook","New-Message","Reply",
				"Reply-To-List","Edit","View-Win","View-Header",
				"View-Source", "Delete","Thread-Subject"
				,"Forward","KeyEdit","NextUnread","Reply-All-Including-Self",
				"Reply-All-Execluding-Self","Toggle-Threads",
				"HTML-View", "Empty-Folder");
		return @commands;
	}
	if ($array eq "mods") {
		my @mods = ("Alt","Ctrl","None");
		return @mods;
	}
	if ($array eq "keys") {		
		my @key = (
			   "a","b","c","d","e",
			   "f","g","h","i","j",
			   "k","l","m","n","o",
			   "p","q","r","s","t",
			   "u","v","w","x","y",
			   "z","space"
			   );
		return @key;
	}	
	if ($array eq "gdk_keys") {
		my @gdk_keys = (
				0x061,0x062,0x063,0x064,
				0x065,0x066,0x067,0x068,
				0x069,0x06a,0x06b,0x06c,
				0x06d,0x06e,0x06f,0x070,
				0x071,0x072,0x073,0x074,
				0x075,0x076,0x077,0x078,
				0x079,0x07a,0x020
       				);
		return @gdk_keys;
	}	
}

sub ok
{
	my ($button, $dialog) = @_;
	$dialog->destroy();
	
}

sub edit
{
	my ($button,$clist) = @_;
	my (@selection,$dialog,$action,$mod,$key);
	@selection = $clist->selection();
	if (!@selection) { return 1; }
	$dialog = new Gtk::Dialog;
	$dialog->set_title(_("Edit Key"));
	$action = $clist->get_text($selection[0],0);
	$mod = $clist->get_text($selection[0],1);
	$key = $clist->get_text($selection[0],2);
	$dialog->{'action'} = new Gtk::Entry;
	$dialog->{'action'}->set_editable(0);
	$dialog->{'mod'} = new Gtk::Combo;
	$dialog->{'key'} = new Gtk::Combo;
	$dialog->{'mod'}->set_popdown_strings(&get_array("mods"));
	$dialog->{'key'}->set_popdown_strings(&get_array("keys"));
	$dialog->{'action'}->set_text($action);
	$dialog->{'mod'}->entry->set_text($mod);
	$dialog->{'key'}->entry->set_text($key);
	$dialog->{'ok'} = new Gtk::Button(_("Ok"));
	$dialog->{'ok'}->signal_connect("clicked" => \&process_entry, $dialog, $clist, @selection);
	$dialog->{'cancel'} = new Gtk::Button("Cancel");
	$dialog->{'cancel'}->signal_connect("clicked", sub { $dialog->destroy });
	$dialog->vbox->pack_start($dialog->{'action'},0,0,0);
	$dialog->vbox->pack_start($dialog->{'mod'},0,0,0);
	$dialog->vbox->pack_start($dialog->{'key'},0,0,0);
	$dialog->action_area->pack_start($dialog->{'ok'},1,1,0);
	$dialog->action_area->pack_start($dialog->{'cancel'},1,1,0);
	show_all $dialog; 
	return 1;
}	

sub process_entry
{
	my ($button,$dialog,$clist, @selection) = @_;
	my ($action,$mod,$key);
	$action = $dialog->{'action'}->get_text;
	$mod = $dialog->{'mod'}->entry->get_text;
	$key = $dialog->{'key'}->entry->get_text;
	$gdk_key{$action} = $gdk_key{$key};
	$gdk_key{$action.'mod'} = $mod;
	$dialog->destroy;
	$clist->set_text($selection[0],1,$mod);
	$clist->set_text($selection[0],2,$key);
	make_key_config();
	return 1;
}	

sub read_keys 
{
	if (!-f "$main::prefs{'MailDir'}/pronto.keys") {
		make_key_config();
	}	
	open(KEYS, "$main::prefs{'MailDir'}/pronto.keys");
	while (<KEYS>) {
		chomp;
		my @key = split(/,/,$_);
		$gdk_key{$key[0].'mod'} = $key[1];
		$gdk_key{$key[0]} = $key[2];
		
	}
	close(KEYS);
	make_key_config();
}

sub make_key_config
{
	open(TMP, ">$main::prefs{'MailDir'}/pronto.keys");
	foreach (&get_array("commands")) {
		print TMP $_ . "," . $gdk_key{$_.'mod'} . "," . $gdk_key{$_} . "\n";
	}
	close(TMP);
	chmod(0600, "$main::prefs{'MailDir'}/pronto.keys");

}

1;
