package HTMLWidget::FolderTree;

use strict;

sub new {
  my $class = shift;
  my $template = shift;
  my $self = {indent => 0,
	      indent_step => 4,
	      template => $template};
  
  return bless $self, $class;
}

sub insert_node {
  my ($self, $parent, $sibling, $text, $spacing, 
      $pixmap_closed, $mask_closed, $pixmap_open, $mask_open,
      $is_leaf, $expanded) = @_;
  
  my $tn = HTMLWidget::TreeNode->new($text, $parent, $sibling);

  unshift @{$self->{nodes}}, $tn;

  return $tn;
}

sub draw {
  my $self = shift;

  my @nodes = @_;

  @nodes = grep { !$_->{parent} } @{$self->{nodes}} unless @nodes;

  foreach my $node (@nodes) {
    $self->{template}->process("folders_body.html", {indent  => "&nbsp;" x $self->{indent},
						     folder  => $node->{text}->[0],
						     box     => $main::ft_id{$node},
						     msg     => $self->{texts}->[1]->{$node},
						     new     => $self->{texts}->[2]->{$node},
						     style   => $self->{style}->{$node},
						     session => &main::param('session')})
	|| die $self->{template}->error();
    print "\n";
    my @children = grep { $_->{parent} && $node == $_->{parent}} @{$self->{nodes}};
    $self->{indent} += $self->{indent_step};
    $self->draw(@children) if @children;
    $self->{indent} -= $self->{indent_step};
  }

}

sub node_set_text {
  my ($self, $node, $column, $text) = @_;

  $self->{texts}->[$column]->{$node} = $text;
}

sub node_get_text {
  my ($self, $node, $column) = @_;

  return $self->{texts}->[$column]->{$node};
}

sub node_set_row_style {
  my ($self, $node, $style) = @_;

  $self->{style}->{$node} = $style;
}

sub selection {
  my $self = shift;

  return @{$self->{selection}};
}

sub AUTOLOAD {
}

1;

package HTMLWidget::TreeNode;

sub new {
  my ($class, $text, $parent, $sibling) = @_;

  my $self = {text => $text,
	      parent => $parent,
	      sibling => $sibling};

  return bless $self, $class;
}

1;
