#ifndef LINUX_MODULE_H_INCLUDED
#define LINUX_MODULE_H_INCLUDED /* allow multiple inclusions */

/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: linux_module.h,v 1.18 2004/01/09 20:29:28 type2 Exp $ */

/*
 * This is the Linux oprofile loadable module sampler header.
 */

/*
 * ----------------------------- Defines ---------------------------------
 */
#define CURRENT_OPROFILE "0.7.1"

/* oprofile device and control files */
#define op_dir "/var/lib/oprofile"
#define op_devfile  op_dir"/opdev"
#define op_hashfile op_dir"/ophashmapdev"
#define op_notefile op_dir"/opnotedev"

#define op_controldir "/proc/sys/dev/oprofile/"
#define op_bufsizefile op_controldir "bufsize"
#define op_notesizefile op_controldir "notesize"
#define op_dumpfile op_controldir "dump"
#define op_controlfile op_controldir "sample"
/* new with oprofile-0.0.9 */
#define op_cpu_typefile op_controldir "cpu_type"
#define op_rtc_valuefile op_controldir "rtc_value"
/* pre 0.5 */
#define op_hashsizefile op_controldir "hashsize"

#define op_moddir "oprofile"
#define op_modname "oprofile"

struct _op_perf_counter {
    unsigned int      count;
    unsigned int      enabled;
    unsigned int      event;
    unsigned int      kernel;
    unsigned int      unit_mask;
    unsigned int      user;
    
    unsigned int      hz;
};

enum oprof_state {
    STOPPED = 0,
    STOPPING = 1,
    RUNNING = 2
};

typedef struct _op_ctl_struct {
    int                     notefh;
    int                     hashfh;
    int                     devfh;

    int                     hascpuinfo;

    unsigned int            bufsize;    /* max size of sample buffer */
    unsigned int            hashsize;   /* size of hashmap */
    unsigned int            notesize;   /* max size of notes buffer */

    struct op_buffer_head  *curbufhead; /* buffer header 0.5+ */
    struct op_note         *curnbuf;    /* the current notes buffer 0.5+ */
    struct op_hash_index   *hashmap;    /* the path hashmap */

    int                     flushrate;
    int                     readerror;
    unsigned long           samplehz;   /* Sampling rate */
    
    int                     has_sys_call_table;
    int                     ckroot;
    unsigned long           addr_sys_call_table;
    unsigned long           addr_sys_mmap2;
    unsigned long           addr_start_gate;
    unsigned long           addr_stop_gate;
    unsigned long           addr_gate_map_start;
    unsigned long           addr_gate_map_end;

    struct _op_perf_counter p0; 
    struct _op_perf_counter p1; 

} op_ctl_t;

typedef enum {
    CPU_NO_GOOD = -1, /**< unsupported CPU type */
    CPU_PPRO, /**< Pentium Pro */
    CPU_PII, /**< Pentium II series */
    CPU_PIII, /**< Pentium III series */
    CPU_ATHLON, /**< AMD P6 series */
    CPU_TIMER_INT, /**< CPU using the timer interrupt */
    CPU_RTC, /**< other CPU to use the RTC */
    CPU_P4,  /**< Pentium 4 / Xeon series */
    CPU_IA64, /**< Generic IA64 */
    CPU_IA64_1, /**< IA64 Merced */
    CPU_IA64_2, /**< IA64 McKinley */
    CPU_HAMMER, /**< AMD Hammer family */
    CPU_P4_HT2, /**< Pentium 4 / Xeon series with 2 hyper-threads */
    CPU_AXP_EV4, /**< Alpha EV4 family */
    CPU_AXP_EV5, /**< Alpha EV5 family */
    CPU_AXP_PCA56, /**< Alpha PCA56 family */
    CPU_AXP_EV6, /**< Alpha EV6 family */
    CPU_AXP_EV67, /**< Alpha EV67 family */
    MAX_CPU_TYPE
} op_cpu_t;


/*
 * ------------------------ Exported global data ----------------------------
 */
extern op_ctl_t gOp;


/*
 * ------------------------ Exported prototypes --------------------------
 */
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void sigalrm_handler(int);
int op_init(void);
int op_attach(void);
void op_shutdown(void);
void op_flush(void);
void op_autoflush(unsigned int);
int op_read_buffer(void);
int op_empty_buffer(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif  /* !LINUX_MODULE_H_INCLUDED */

