# 
# Prospect: a developer's system profiler.
# System Tests: symbol discrimination.
#
# COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
#
# Author: Bob Montgomery, HP
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 59 Temple
# Place - Suite 330, Boston, MA 02111-1307, USA.
#

# $Id: checktime.awk,v 1.5 2004/01/09 20:29:28 type2 Exp $

{
    if (NF == 0) {
        ; #do nothing on blank lines
    } else if ($1 == "fact_command") {
        cmdname = $2;
        cmdline = substr($0,length($1)+2)
    }  else if ($1 == "fact_description") {
        printf "********************************************************\n";
        printf "Checking times: %s\n", substr($0, length($1)+2);
    } else if ($1 == "fact_frequency") {
        freq = $2;
    } else if ($1 == "fact_user_time") {
        user_time = $2;
    } else if ($1 == "fact_sys_time") {
        sys_time = $2;
    } else if ($1 == "Time:") {
        pcmdline =substr($0, length($1)+2);
        tail=match(pcmdline," *$");
        if (tail) {
            pcmdline=substr(pcmdline,1,tail-1);
        }
        if (cmdline != pcmdline) {
            printf "ERROR (%d): command lines don't match: \"%s\" != \"%s\"\n",
                NR, cmdline, substr($0, length($1)+2);
            error++;
        }
    } else if (($1 == "Sampling") && ($2 == "frequency:")) {
        pfreq = $3;
        if (pfreq != freq) {
            printf "NOTE: Frequency difference, ";
            printf "requested: %d, reported: %d\n", freq, pfreq;
        }
    } else if ($0 ~ "==---") {
            after = 1;
            if (!found_command) {
                printf "ERROR (%d): \"%s\" missing from process summary\n",
                    NR, cmdname;
                error++;
            }
    } else if ($1 == cmdname) {  
        if (!after) {
            found_command = 1;
            puser_hits = $3;
            puser_time = $4;
            psys_hits = $5;
            psys_time = $6;
            if (pfreq == 0) {
                printf "ERROR (%d): prospect frequency missing\n", NR;
                error++;
            } else if ((puser_hits < pfreq) || (puser_time < 1.0)) {
                printf "TEST_ERROR (%d): run time too low: %d < %d, %f < %f\n", 
                    NR, puser_hits, pfreq, puser_time, 1.0;
                error++;
            } else {
                cuser_time = puser_hits/pfreq;
                diff = cuser_time - puser_time;
                if (diff < 0) diff = -diff;
                if (diff/puser_time > 0.01) {
                    printf "ERROR (%d): user hits to time conversion error: ",
                        NR;
                    printf "expected %6.4f got %6.4f\n", 
                        cuser_time, puser_time;
                    error++;
                }
                diff = puser_time - user_time;
                if (diff < 0) diff = -diff;
                if (diff / puser_time > 0.02) {
                    printf "NOTE: user cpu: time command: %6.4f, ",
                        user_time;
                    printf "prospect: %6.4f, error: %6.2f%%\n", 
                        puser_time, diff/puser_time * 100.0;
                }
                if (diff / puser_time > 0.10) {
                    printf "ERROR (%d): user cpu: time and prospect ", NR;
                    printf "differ by %6.2f%%\n",
                        diff/puser_time * 100.0;
                    error++;
                }
            }
        }
    }
}

END {
    if (error) {
        printf "Check complete with %d errors\n", error;
    } else {
        printf "Check complete -> OK\n";
    }
    exit error;
}
 
