/* 
 * Prospect: a developer's system profiler.
 * System Tests: symbol discrimination.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Bob Montgomery, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: gen.c,v 1.3 2004/01/09 20:29:28 type2 Exp $ */

/* Generate the callers and subroutines for the syms test program.
 */

#include <stdio.h>
#include <stdlib.h>

void usage(char *prog)
{
    printf("usage: %s count\n", prog);
}

main(int argc, char **argv)
{
    int ii, count;

    if (argc != 2) {
       usage(argv[0]);
       exit(1);
    }
    count = strtol(argv[1], NULL, 0);

    /* generate function protos */
    for (ii=0; ii<count; ii++) {
        printf("long %s%03.3d(long data[], long iter);\n",
               (ii%2)?"Odd_":"Even_",ii);
    }

    /* generate data declarations */
    printf("#define ARRAYSIZE 64\n");
    printf("long even_data[ARRAYSIZE];\n");
    printf("long odd_data[ARRAYSIZE];\n");
    printf("long all_data[ARRAYSIZE];\n\n");


    /* generate callers */
    printf("long\ndo_evens(long scale, long iter)\n");
    printf("{\n\tlong ii, imax, sum;\n");
    printf("\timax = scale * 2;\n");
    printf("\tsum = 0;\n");
    printf("\tfor (ii=0; ii<ARRAYSIZE; ii++) {\n");
    printf("\t\teven_data[ii] = 1;\n\t}\n");
    printf("\tfor (ii=0; ii<imax; ii++) {\n");
    for (ii=0; ii<count; ii+=2) {
        printf("\t\tsum += Even_%03.3d(even_data, iter);\n", ii);
    }
    printf("\t}\n");
    printf("\treturn sum;\n");
    printf("}\n\n");

    printf("long\ndo_odds(long scale, long iter)\n");
    printf("{\n\tlong ii, imax, sum;\n");
    printf("\timax = scale * 2;\n");
    printf("\tsum = 0;\n");
    printf("\tfor (ii=0; ii<ARRAYSIZE; ii++) {\n");
    printf("\t\todd_data[ii] = 1;\n\t}\n");
    printf("\tfor (ii=0; ii<imax; ii++) {\n");
    for (ii=1; ii<count; ii+=2) {
        printf("\t\tsum += Odd_%03.3d(odd_data, iter);\n", ii);
    }
    printf("\t}\n");
    printf("\treturn sum;\n");
    printf("}\n\n");

    printf("long\ndo_all(long scale, long iter)\n");
    printf("{\n\tlong ii, imax, sum;\n");
    printf("\timax = scale;\n");
    printf("\tsum = 0;\n");
    printf("\tfor (ii=0; ii<ARRAYSIZE; ii++) {\n");
    printf("\t\tall_data[ii] = 1;\n\t}\n");
    printf("\tfor (ii=0; ii<imax; ii++) {\n");
    for (ii=0; ii<count; ii++) {
        printf("\t\tsum += %s%03.3d(all_data, iter);\n",
               (ii%2)?"Odd_":"Even_",ii);
    }
    printf("\t}\n");
    printf("\treturn sum;\n");
    printf("}\n\n");

    /* generate subroutines */
    for (ii=0; ii<count; ii++) {
        printf("long %s%03.3d(long data[], long iter)\n",
               (ii%2)?"Odd_":"Even_",ii);
        printf("{\n\tlong ii, sum = 0;\n");
        printf("\tfor (ii=0; ii<iter; ii++) {\n");
        printf("\t\tsum += data[ii%%ARRAYSIZE];\n");
        printf("\t}\n\treturn sum;\n}\n\n");
    }

    return 0;
}

