/****************************************************************************
** jabcommon.h - common classes and functions for handling Jabber data
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef JABTYPES_H
#define JABTYPES_H

#include<qstring.h>
#include<qstringlist.h>
#include<qptrlist.h>
#include<qdatetime.h>

#define STATUS_OFFLINE  0
#define STATUS_ONLINE   1
#define STATUS_AWAY     2
#define STATUS_XA       3
#define STATUS_DND      4

QString lineEncode(QString str);
QString lineDecode(const QString &str);
QString lineEncodeList(QStringList);
QStringList lineDecodeList(const QString &);

QString status2jabprestxt(int status);
int jabprestxt2status(const QString &str);

QString cleanJid(QString);
bool jidcmp(const QString &jid1, const QString &jid2);
bool jidIsAgent(const QString &);


#define JABMESSAGE_NORM     0
#define JABMESSAGE_CHAT     1
#define JABMESSAGE_ERROR    2
#define JABMESSAGE_HEADLINE 3


// handles Jabber ID's
class Jid
{
public:
	Jid();
	Jid(const QString &);
	void set(const QString &s);

	Jid & operator=(const QString &);

	const QString & user() const { return v_user; }
	const QString & host() const { return v_host; }
	const QString & resource() const { return v_resource; }
	const QString & full() const { return realJid; }
	const QString & s() const { return v_s; }
	bool isAgent() const { return v_isAgent; }

private:
	QString realJid;
	QString v_user, v_host, v_resource, v_s;
	bool v_isAgent;
};

// non-member operators
bool operator==(const Jid &j1, const Jid &j2);


struct JabMessage
{
	Jid to, from;

	QString body, subject;
	QString url, url_desc;
	int type;
	QDateTime timeStamp;
	bool originLocal;
	bool late;
};

class JabFormField
{
public:
	JabFormField();

	int type() { return v_type; }
	QString fieldName();
	QString realName();
	const QString & value() { return v_value; }
	void setType(int);
	bool setType(const QString &);
	void setValue(const QString &);

	enum { username, nick, password, name, first, last, email, address, city, state, zip, phone, url, date, misc };

private:
	int v_type;
	QString v_value;

	int str2type(const QString &);
};

class JabForm : public QPtrList<JabFormField>
{
public:
	JabForm();
	JabForm(const JabForm &from);
	JabForm & operator=(const JabForm &from);

	Jid jid;
	QString instructions, key;

	JabFormField *find(int type) const;
};

class JabResource
{
public:
	JabResource();

	QString name;
	int priority;

	int status;
	QString statusString;
	QDateTime timeStamp;

	// gabber song extension
	QString songTitle;
};

class JabResourceList : public QPtrList<JabResource>
{
public:
	JabResourceList();
	JabResourceList(const JabResourceList &from);
	JabResourceList & operator=(const JabResourceList &from);

	JabResource *find(const QString &) const;
	JabResource *local() const;
	JabResource *priority() const;
};

class JabRosterEntry
{
public:
	JabRosterEntry();
	~JabRosterEntry();

	bool isAvailable() const;
	JabResource *local() const;
	JabResource *priority() const;
	int localStatus() const;

	QString jid; // without resource
	//QString realjid; // raw, may contain a resource (read: transports)
	QString nick;
	QString sub;
	QStringList groups;
	JabResourceList res;
	QString unavailableStatusString;

	int ask;
	bool flagForDelete;
	bool push;

	// for agents only
	bool isRegisterable, isSearchable, isGCCapable, hasSubAgents, isTransport;

	// for search results only
	QString first, last, email;
};

class JabRoster
{
public:
	JabRoster();
	~JabRoster();
	JabRoster(const JabRoster &from);
	JabRoster & operator=(const JabRoster &from);

	int size();
	JabRosterEntry *first();
	JabRosterEntry *current();
	JabRosterEntry *next();

	JabRosterEntry *getFirst() const;

	JabRosterEntry *findByJid(const QString &jid);
	JabRosterEntry *findByNick(const QString &nick);

	void add(JabRosterEntry *entry);
	void remove(JabRosterEntry *entry);

	void clear();

	QPtrList<JabRosterEntry> list;
};


#include<qstring.h>
#include<qdom.h>

// --- VCard-temp 3.0 subset (from non-latest Gabber) ---
enum {	vFullname, vNickname, vBday, vEmail, vHomepage, vPhone,
	vStreet, vExt, vCity, vState, vPcode, vCountry,
	vOrgName, vOrgUnit, vTitle, vRole,
	vDesc };

#define NUM_VCARDFIELDS	17

class VCard
{
public:
	VCard();

	QDomElement toXml();
	bool fromXml(const QDomElement &);
	bool isIncomplete();

	QString tagContent(const QDomElement &e);
	QDomElement findSubTag(const QDomElement &e, const QString &name, bool *found);

	QString field[NUM_VCARDFIELDS];

	QDomDocument doc;
	QDomElement xml;

	QDomElement textTag(const QString &name, const QString &content);
};

#endif
