/****************************************************************************
** jabtasks.h - basic tasks for use with the JabIO task system
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef JABTASKS_H
#define JABTASKS_H

#include<qstring.h>
#include<qptrlist.h>
#include"jabio.h"


// subscription types
#define JABSUB_SUBSCRIBE        0
#define JABSUB_SUBSCRIBED       1
#define JABSUB_UNSUBSCRIBE      2
#define JABSUB_UNSUBSCRIBED     3


class JT_Auth : public JabTask
{
	Q_OBJECT
public:
	JT_Auth(JabTask *parent, const QString &user, const QString &pass, const QString &sid, const QString &resource, bool plain=FALSE);

	void go();

	bool take(const QDomElement &x);

private:
	QDomElement iq;
};

class JT_Register : public JabTask
{
	Q_OBJECT
public:
	JT_Register(JabTask *parent);

	void reg(const QString &user, const QString &pass);
	//void unreg(const QString &user, const QString &pass);

	void go();

	bool take(const QDomElement &x);

private:
	QDomElement iq;
};

class JT_Roster : public JabTask
{
	Q_OBJECT
public:
	JT_Roster(JabTask *parent);

	void get();
	void set(const QString &jid, const QString &nick, const QStringList &groups);
	void remove(const QString &jid);

	void go();
	QString toString();
	bool fromString(const QString &);

	bool take(const QDomElement &x);
	JabRoster roster;

	QString jid, nick;
	QStringList groups;

private:
	int type;
	QDomElement iq;
};

class JT_Presence : public JabTask
{
	Q_OBJECT
public:
	JT_Presence(JabTask *parent);

	void pres(int status, const QString &statusString, int priority);
	void sub(const Jid &to, int subType);

	void go();

	int status, priority;
	QString statusString;

signals:
	void receivePresence(int, const QString &);

private:
	QDomElement tag;
	int type;
};

class JT_Login : public JabTask
{
	Q_OBJECT
public:
	JT_Login(JabTask *);

	void login(const QString &user, const QString &pass, const QString &sid, const QString &resource, int, const QString &, int, bool plain=FALSE);
	void create(const QString &user, const QString &pass, const QString &sid, const QString &resource, int, const QString &, int, bool plain=FALSE);

	void go();
	void done(JabTask *);

	JT_Register *reg;
	JT_Auth *auth;
	JT_Roster *rost;
	JT_Presence *pres;
	int status, priority;
	QString statusString;
	QString user, pass, sid, resource;
	bool usePlain;

	int type;

signals:
	void stepChanged();
	void receiveAuth();
	void receiveRoster(JabRoster &);
	void receivePresence(int, const QString &);
};

class JT_PushPresence : public JabTask
{
	Q_OBJECT
public:
	JT_PushPresence(JabTask *parent);

	bool isDaemon() { return TRUE; }
	bool take(const QDomElement &);

	struct Info
	{
		Jid jid;
		int status, priority;
		QString statusString;
		QString songTitle;
		QDateTime timeStamp;
	};

signals:
	void presence(const JT_PushPresence::Info &);
	void subscription(const Jid &, int);
};

class JT_PushRoster : public JabTask
{
	Q_OBJECT
public:
	JT_PushRoster(JabTask *parent);

	bool isDaemon() { return TRUE; }
	bool take(const QDomElement &);

signals:
	void roster(JabRoster &);
};

class JT_Message : public JabTask
{
	Q_OBJECT
public:
	JT_Message(JabTask *parent, const JabMessage &);

	JabMessage jmsg;

	void go();
};

class JT_PushMessage : public JabTask
{
	Q_OBJECT
public:
	JT_PushMessage(JabTask *parent);

	bool isDaemon() { return TRUE; }
	bool take(const QDomElement &);

signals:
	void message(const JabMessage &);
};

// this will issue a bunch of JabTasks one by one in sequence
class JT_Queue : public JabTask
{
	Q_OBJECT
public:
	JT_Queue(JabTask *parent);

	void addTask(JabTask *);
	int count();

	void done(JabTask *);
	bool isClearable() { return FALSE; }

	void go();
	void stop();
	QString toString();
	bool fromString(const QString &);

signals:
	void countChanged();
	void itemDone(JabTask *);

private slots:
	void afterDone();

private:
	void doNext();
	JabTask *active;
	QPtrList<JabTask> list;
	bool going;
};

class JT_GetServices : public JabTask
{
	Q_OBJECT
public:
	JT_GetServices(JabTask *parent, const QString &host);

	void go();

	bool take(const QDomElement &x);

	JabRoster services;

private:
	QDomElement iq;
};

class JT_VCard : public JabTask
{
	Q_OBJECT
public:
	JT_VCard(JabTask *parent);

	void get(const QString &);
	void set(VCard &);

	void go();

	bool take(const QDomElement &x);

	QString jid;
	VCard vcard;
	int type;

private:
	QDomElement iq;
};

class JT_RegForm : public JabTask
{
	Q_OBJECT
public:
	JT_RegForm(JabTask *parent);

	void get(const QString &);
	void set(const JabForm &);

	void go();

	bool take(const QDomElement &x);

	QString jid;
	JabForm form;
	int type;

private:
	QDomElement iq;
};

class JT_Search : public JabTask
{
	Q_OBJECT
public:
	JT_Search(JabTask *parent);

	void get(const QString &);
	void set(const JabForm &);

	void go();

	bool take(const QDomElement &x);

	QString jid;
	JabForm form;
	JabRoster roster;
	int type;

private:
	QDomElement iq;
};

class JT_ClientVersion : public JabTask
{
	Q_OBJECT
public:
	JT_ClientVersion(JabTask *, const Jid &);

	void go();
	bool take(const QDomElement &);

	Jid j;
	QString name, version, os;

private:
	QDomElement iq;
};

class JT_ClientTime : public JabTask
{
	Q_OBJECT
public:
	JT_ClientTime(JabTask *, const Jid &);

	void go();
	bool take(const QDomElement &);

	Jid j;
	QDateTime utc;
	QString timezone, display;

private:
	QDomElement iq;
};

class JT_ServInfo : public JabTask
{
	Q_OBJECT
public:
	JT_ServInfo(JabTask *parent);

	bool isDaemon() { return TRUE; }
	bool take(const QDomElement &);
};

class JT_Gateway : public JabTask
{
	Q_OBJECT
public:
	JT_Gateway(JabTask *parent);

	void get(const QString &service);
	void set(const QString &service, const QString &prompt);

	void go();

	bool take(const QDomElement &x);

	QString jid, prompt, desc;
	int type;

private:
	QDomElement iq;
};

#endif
