/****************************************************************************
** userlist.cpp - higher-level version of JabRoster
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#include"userlist.h"
#include"common.h"


Account::Account()
{
}

QString Account::jid() const
{
	return QString("%1@%2").arg(user).arg(host);
}


UserListItem::UserListItem()
{
        jid = "";
        nick = "";
        group = "";
        state = STATUS_OFFLINE;
        inList = TRUE;
        isTransport = FALSE;
        //msgQueue.setAutoDelete(TRUE);
}

UserListItem::~UserListItem()
{
	//msgQueue.setAutoDelete(TRUE);
	//msgQueue.clear();
}


UserList::UserList()
{
        num = 0;
        list.clear();
        list.setAutoDelete(TRUE);
        it = 0;
}

UserList::~UserList()
{
        if(it) {
                delete it;
                it = 0;
        }
        list.clear();
}

int UserList::size()
{
        return num;
}

void UserList::add(UserListItem *item)
{
        list.append(item);
        ++num;
}

void UserList::remove(QString &jid)
{
        UserListItem *item = findAnyByJid(jid);
        if(item) {
                remove(item);
        }
}

void UserList::remove(UserListItem *item)
{
        list.remove(item);
}

UserListItem *UserList::findByJid(const QString &jid)
{
        UserListItem *item;

        QListIterator<UserListItem> it(list);
        for(; it.current(); ++it) {
                item = it.current();
                if(item->isTransport)
                        continue;

                if(jidcmp(item->jid,jid))
                        return item;
        }
        return 0;
}

UserListItem *UserList::findServiceByJid(const QString &jid)
{
        UserListItem *item;

        QListIterator<UserListItem> it(list);
        for(; it.current(); ++it) {
                item = it.current();
                if(!item->isTransport)
                        continue;

                if(jidcmp(item->jid,jid))
                        return item;
        }
        return 0;
}

UserListItem *UserList::findAnyByJid(const QString &jid)
{
        UserListItem *item;

        QListIterator<UserListItem> it(list);
        for(; it.current(); ++it) {
                item = it.current();
                if(jidcmp(item->jid,jid))
                        return item;
        }
        return 0;
}

void UserList::clear()
{
        list.clear();
}

/*int UserList::allQueuesEmpty()
{
        UserListItem *item;

        QListIterator<UserListItem> it(list);
        for(; it.current(); ++it) {
                item = it.current();
                if(item->msgQueue.count() > 0)
                        return 0;
        }

        return 1;
}*/

UserListItem *UserList::start(int type)
{
        searchtype = type;

        if(it) {
                delete it;
                it = 0;
        }
        it = new QListIterator<UserListItem>(list);
        advanceTo();

        return it->current();
}

UserListItem *UserList::next()
{
        ++(*it);
        advanceTo();

        return it->current();
}

void UserList::end()
{
        delete it;
        it = 0;
}

void UserList::advanceTo()
{
        int type;

        while(it->current()) {
                type = 0;
                if(!it->current()->isTransport)
                        type |= 1;
                if(it->current()->isTransport)
                        type |= 2;

                if(searchtype & type)
                        return;

                ++(*it);
        }
}
