# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: field.t,v 1.1 2000/11/23 23:36:17 muaddib Exp $

use strict;
use Test;
use Data::Dumper;
use Field;
use HTMLIO::Text;
use AtomicData;
use AtomicData::List;
use AtomicData::Text;
use AtomicData::AnyThing;
use AtomicData::USZip;

my $loops = 1;
my $ntests = 148;
plan tests => $loops*$ntests;

my ($field);

for (my $n=0; $n<$loops; $n++) 
{
 for my $field (AtomicData::Text->new(),
		AtomicData::List->new("AtomicData::Text")) {
   ok $field;
   ok !defined $field->value();
   ok !defined $field->orig_value();
   ok !$field->changed_p();
   ok !$field->set_value("hi");
   ok $field->value() eq "hi";
   ok $field->orig_value() eq "hi";
   ok !$field->changed_p();
   ok !$field->set_value("bye");
   ok $field->value() eq "bye";
   ok $field->orig_value() eq "hi";
   ok $field->changed_p();
   ok !$field->set_orig_value();
   ok $field->orig_value() eq "bye";
   ok !$field->changed_p();
   ok $field->value() eq "bye";
   ok $field->canonical_value() eq "bye";
   ok $field->formatted_value() eq "bye";
   ok !$field->set_value(" xi ");
   ok $field->changed_p();
   ok $field->value() eq " xi ";
   ok $field->canonicalize();
   ok $field->value() eq "xi";
   ok $field->orig_value() eq "bye";
   ok $field->canonical_value() eq "xi";
   ok $field->formatted_value() eq "xi";
   ok $field->orig_value() eq "bye";
   ok $field->changed_p();
 }

 ok $field = AtomicData::AnyThing->new();
 ok !defined $field->value();
 ok !$field->set_value(" xi ");
 ok !$field->changed_p();
 ok $field->value() eq " xi ";
 ok $field->canonicalize();
 ok $field->value() eq " xi ";
 ok !$field->changed_p();
 
 ok $field = AtomicData::List->new("AtomicData::AnyThing");
 ok !defined $field->value();
 ok !defined $field->orig_value();
 ok !$field->changed_p();
 ok !$field->set_value("hi","lo","sell","buy");
 ok $field->test_equality(["hi","lo","sell","buy"]);
 ok $field->orig_data_count() == 4;
 ok !$field->changed_p();
 ok !$field->set_value("bye");
 ok $field->value() eq "bye";
 ok $field->test_equality(["bye"]);
 ok $field->orig_value() eq "hi";
 ok $field->changed_p();
 ok !$field->set_orig_value();
 ok $field->orig_value() eq "bye";
 ok !$field->changed_p();
 ok $field->value() eq "bye";
 ok $field->canonical_value() eq "bye";
 ok $field->formatted_value() eq "bye";
 ok !$field->set_value(" xi ","try "," lie"," buy ");
 ok $field->changed_p();
 ok $field->test_equality([" xi ","try "," lie"," buy "]);
 ok $field->canonicalize();
 ok $field->test_equality([" xi ","try "," lie"," buy "]);
 ok $field->orig_value() eq "bye";
 ok join(",",$field->canonical_value()) eq " xi ,try , lie, buy ";
 ok join(",",$field->formatted_value()) eq " xi ,try , lie, buy ";
 ok $field->orig_value() eq "bye";
 ok $field->changed_p();

 ok $field = AtomicData::USZip->new();
 ok !defined $field->value();
 ok !defined $field->orig_value();
 ok !$field->changed_p();
 ok !$field->set_value(12345);
 ok $field->value() eq 12345;
 ok $field->orig_value() == 12345;
 ok !$field->changed_p();
 ok !$field->set_value("54321-1234");
 ok $field->value() eq "54321-1234";
 ok $field->orig_value() eq 12345;
 ok $field->changed_p();
 ok !$field->set_orig_value();
 ok $field->orig_value() eq "54321-1234";
 ok !$field->changed_p();
 ok $field->value() eq "54321-1234";
 ok $field->canonical_value() eq "54321-1234";
 ok $field->formatted_value() eq "54321-1234";
 ok !$field->set_value(" 34321 1234 ");
 ok $field->changed_p();
 ok $field->value() eq " 34321 1234 ";
 ok $field->canonicalize();
 ok $field->value() eq "34321-1234";
 ok $field->orig_value() eq "54321-1234";
 ok $field->canonical_value() eq "34321-1234";
 ok $field->formatted_value() eq "34321-1234";
 ok $field->orig_value() eq "54321-1234";
 ok $field->changed_p();

 ok $field = AtomicData::List->new("AtomicData::USZip");
 ok !defined $field->value();
 ok !defined $field->orig_value();
 ok !$field->changed_p();
 ok !$field->set_value("12345","54321","12345 1234","54321 - 4321");
 ok $field->test_equality(["12345","54321","12345 1234","54321 - 4321"]);
 ok $field->canonicalize();
 ok $field->test_equality(["12345","54321","12345-1234","54321-4321"]);
 ok $field->orig_data_count() == 4;
 ok !$field->changed_p();
 ok !$field->set_value("11111");
 ok $field->value() eq "11111";
 ok $field->test_equality(["11111"]);
 ok $field->orig_value() eq "12345";
 ok join(",",$field->orig_value()) eq "12345,54321,12345-1234,54321-4321";
 ok $field->changed_p();
 ok !$field->set_orig_value();
 ok $field->orig_value() eq "11111";
 ok !$field->changed_p();
 ok $field->value() eq "11111";
 ok $field->canonical_value() eq "11111";
 ok $field->formatted_value() eq "11111";
 ok !$field->changed_p();

 #ok $field = AtomicData::List->new("AtomicData::Text");
 ok $field = Field->new("hi","AtomicData::Text","HTMLIO::Text");

 #print Dumper($field);exit;
 
 $field->set_possible_hash({this=>"that"});
 $field->set_value("haha");

# for my $f (keys %{$field->{_atomic}}) {
#   delete $field->{_atomic}->{$f};
# }
# delete $field->{_atomic};

 ok !defined $field->free_internals();

 ok $field = Field->new("yo","AtomicData::Text","HTMLIO::Text","AtomicData::List");
 $field->set_possible_hash({this=>"that"});
 $field->set_value("haha","blah");
 
 #print Dumper($field);exit;

 ok !defined $field->free_internals();
}

