#!/usr/bin/env python2
# bytea.py -- script to test typecasting of PostgreSQL binary arrays
# 

from psycopg import *
DSN="dbname=test user=test"
o = connect(DSN)
c = o.cursor()

bin_string_list = ({'bin':r'\001\\002\003\004'},
                   {'bin':r'abcd'},
                   {'bin':r'1234'},
                   {'bin':r'0\000\049\134'},
                   {'bin':r'0\120\333c'})

try:
    print "Creating table bytea_test"
    c.execute('CREATE TABLE bytea_test (bin bytea)')
except ProgrammingError:
    print "Warning:  bytea_test already exists, dropping and re-creating"
    c.execute('DROP TABLE bytea_test')
    c.execute('CREATE TABLE bytea_test (bin bytea)')

o.commit()
try:
    print "Creating table bytea_img"
    c.execute('CREATE TABLE bytea_files (name text,file bytea)')
except ProgrammingError:
    print "Warning:  bytea_test already exists, dropping and re-creating"
    c.execute('DROP TABLE bytea_files')
    c.execute('CREATE TABLE bytea_files (name text,file bytea)')
o.commit()

c.executemany('INSERT INTO bytea_test VALUES(%(bin)s)', bin_string_list)

# open a file and put it in the table
f=open('bytea.py','r')
# convert file contents to binary object
buff=Binary(f.read())
f.close()
c.execute('INSERT INTO bytea_files VALUES(%s, %s)', ('bytea.py', buff))
o.commit()

# extract binary objects
c.execute('SELECT bin FROM bytea_test')
print "String Objects extracted from table bytea_test:\n"
res = c.fetchall()
for r in res:
    print "contents: %s, repr: %s\n" % (r[0], repr(r[0]))

# extract the file and save it under another name
c.execute('SELECT name, file FROM bytea_files')
res = c.fetchone()
filename = res[0]
file = res[1]
f = open('copy-from-db-of-'+filename, 'wb')
f.write(file)
f.close()

#Binary cursor should be faster as no conversion is done
c.execute('DECLARE curs BINARY CURSOR FOR SELECT bin FROM bytea_test FOR READ ONLY')
print "String Objects extracted from table bytea_test with bin cursor:\n"
c.execute('FETCH ALL from curs')
res = c.fetchall()
for r in res:
    print "contents: %s, repr: %s\n" % (r[0], repr(r[0]))

c.execute('DECLARE bc BINARY CURSOR FOR SELECT name, file FROM bytea_files FOR READ ONLY')
c.execute('FETCH ALL from bc')
res = c.fetchall()
print res
for filename, data in res:
    print filename
    f = open('bcopy-from-db-of-'+filename,'wb')
    f.write(data)
    f.close()

