use strict;
use warnings;

use Test::More tests => 5;
use File::pushd;
use Cwd qw(abs_path);

BEGIN {
    use_ok('Publican');
    use_ok('Publican::XmlClean');
}

diag("Testing Publican::XmlClean $Publican::XmlClean::VERSION");

my $dir = pushd("Test_Book") || die($@);
my $e;

my $publican = Publican->new(
    {   debug          => 1,
        configfile     => 'publican.cfg',
        common_config  => abs_path('../blib/datadir'),
        common_content => abs_path('../blib/datadir/Common_Content')
    }
);

my $cleaner = Publican::XmlClean->new( { clean_id => 1 } );

is($cleaner->print_known_tags(), undef, "print_known_tags");

is($cleaner->print_banned_tags(), undef,"print_banned_tags" );

## BUGBUG running this test before the others causes 'Tests out of sequence' errors
isa_ok( $cleaner, 'Publican::XmlClean', 'creating a Publican::XmlClean' );

$dir = undef;

