/*
 * puzzle.h
 *
 *
 * Part of PUZZLE 4.0.2 (April 1999)
 *
 * (c) 1995-1999 by Korbinian Strimmer and Arndt von Haeseler
 *
 * All parts of the source except where indicated are distributed under
 * the GNU public licence.  See http://www.opensource.org for details.
 */


#define VERSION    "4.0.2"
#define DATE       "April 1999"

#define INFILE     "infile"
#define OUTFILE    "outfile"
#define TREEFILE   "outtree"
#define INTREE     "intree"
#define DISTANCES  "outdist"
#define TRIANGLE   "outlm.eps"
#define UNRESOLVED "outqlist"
#define OUTPTLIST  "outpstep"


/* prototypes */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <ctype.h>
#include "util.h"
#include "ml.h"


/* tree structure */
typedef struct oneedge {
	/* pointer to other three edges */
	struct oneedge *up;
	struct oneedge *downleft;
	struct oneedge *downright;
	int numedge;    /* number of edge */
	uli edgeinfo;   /* value of this edge */
	int *edgemap;   /* pointer to the local edgemap */
} ONEEDGE;


/* variables */
EXTERN cmatrix biparts;      /* bipartitions of tree of current puzzling step */
EXTERN cmatrix consbiparts;  /* bipartitions of majority rule consensus tree */
EXTERN cmatrix seqchars;     /* characters contained in data set */
EXTERN cmatrix treepict;     /* picture of consensus tree */
EXTERN double minscore;      /* value of edgescore on minedge */
EXTERN double tstvf84;       /* F84 transition/transversion ratio */
EXTERN double tstvratio;     /* expected transition/transversion ratio */
EXTERN double yrtsratio;     /* expected pyrimidine/purine transition ratio */
EXTERN dvector ulkl;         /* log L of user trees */
EXTERN dmatrix allsites;     /* log L per sites of user trees */
EXTERN dvector ulklc;        /* log L of user trees (clock) */
EXTERN dmatrix allsitesc;    /* log L per sites of user trees (clock) */
EXTERN FILE *utfp;           /* pointer to user tree file */
EXTERN FILE *ofp;            /* pointer to output file */
EXTERN FILE *seqfp;          /* pointer to sequence input file */
EXTERN FILE *tfp;            /* pointer to tree file */
EXTERN FILE *dfp;            /* pointer to distance file */
EXTERN FILE *trifp;          /* pointer to triangle file */
EXTERN FILE *unresfp;        /* pointer to file with unresolved quartets */
EXTERN FILE *tmpfp;          /* pointer to temporary file */
EXTERN FILE *qptlist;        /* pointer to file with puzzling step trees */
EXTERN int SHcodon;          /* whether SH should be applied to 1st, 2nd codon positions */
EXTERN int utree_optn;       /* use first user tree for estimation */
EXTERN int listqptrees;      /* list puzzling step trees */
EXTERN int approxqp;         /* approximate QP quartets */
EXTERN int *edgeofleaf;      /* vector with edge number of all leaves */
EXTERN int codon_optn;       /* declares what positions in a codon should be used */
EXTERN int compclock;        /* computation of clocklike branch lengths */
EXTERN int chooseA;          /* leaf variable */
EXTERN int chooseB;          /* leaf variable */
EXTERN int clustA, clustB, clustC, clustD; /* number of members of LM clusters */
EXTERN int column;           /* used for breaking lines (writing tree to treefile) */
EXTERN int Frequ_optn;       /* use empirical base frequencies */
EXTERN int Maxbrnch;         /* 2*Maxspc - 3 */
EXTERN int Maxseqc;          /* number of sequence characters per taxum */
EXTERN int mflag;            /* flag used for correct printing of runtime messages */
EXTERN int minedge;          /* edge with minimum edgeinfo */
EXTERN int nextedge;         /* number of edges in the current tree */
EXTERN int nextleaf;         /* next leaf to add to tree */
EXTERN int numclust;         /* number of clusters in LM analysis */
EXTERN int outgroup;         /* outgroup */
EXTERN int puzzlemode;       /* computation of QP tree and/or ML distances */
EXTERN int rootsearch;       /* how location of root is found */
EXTERN int rhetmode;         /* model of rate heterogeneity */
EXTERN int splitlength;      /* length of one entry in splitpatterns */
EXTERN int *splitsizes;      /* size of all different splits of all trees */
EXTERN int show_optn;        /* show unresolved quartets                        */
EXTERN int sym_optn;         /* symmetrize doublet frequencies */
EXTERN int xsize;            /* depth of consensus tree picture */
EXTERN int ytaxcounter;      /* counter for establishing y-coordinates of all taxa */
EXTERN int numutrees;        /* number of users trees in input tree file */
EXTERN ivector clusterA, clusterB, clusterC, clusterD;  /* clusters for LM analysis */
EXTERN ivector consconfid;   /* confidence values of majority rule consensus tree */
EXTERN ivector conssizes;    /* partition sizes of majority rule consensus tree */
EXTERN ivector trueID;       /* leaf -> taxon on this leaf */
EXTERN ivector xcor;         /* x-coordinates of consensus tree nodes */
EXTERN ivector ycor;         /* y-coordinates of consensus tree nodes */
EXTERN ivector ycormax;      /* maximal y-coordinates of consensus tree nodes */
EXTERN ivector ycormin;      /* minimal y-coordinates of consensus tree nodes */
EXTERN ivector ycortax;      /* y-coordinates of all taxa */
EXTERN ONEEDGE *edge;        /* vector with all the edges of the tree */
EXTERN time_t Starttime;     /* start time */
EXTERN time_t Stoptime;      /* stop time */
EXTERN time_t time0;         /* timer variable */
EXTERN time_t time1;         /* yet another timer */
EXTERN time_t time2;         /* yet another timer */
EXTERN uli *splitcomp;       /* bipartition storage */
EXTERN uli *splitfreqs;      /* frequencies of all different splits of all trees */
EXTERN uli *splitpatterns;   /* all different splits of all trees */
EXTERN uli badqs;            /* number of bad quartets */
EXTERN uli consincluded;     /* number of included biparts in the consensus tree */
EXTERN uli Currtrial;        /* counter for puzzling steps */
EXTERN uli maxbiparts;       /* space is reserved for that many bipartitions */
EXTERN uli mininfo;          /* value of edgeinfo on minedge */
EXTERN uli numbiparts;       /* number of different bipartitions */
EXTERN uli Numquartets;      /* number of quartets */
EXTERN uli Numtrial;         /* number of puzzling steps */
EXTERN uli lmqts;            /* quartets investigated in LM analysis (0 = ALL) */
/* counter variables needed in likelihood mapping analysis */
EXTERN uli ar1, ar2, ar3;
EXTERN uli reg1, reg2, reg3, reg4, reg5, reg6, reg7;
EXTERN uli reg1l, reg1r, reg2u, reg2d, reg3u, reg3d,
 reg4u, reg4d, reg5l, reg5r, reg6u, reg6d;
EXTERN unsigned char *quartetinfo; /* place where quartets are stored */
EXTERN dvector qweight; /* for use in QP and LM analysis */
EXTERN dvector sqdiff;
EXTERN ivector qworder;
EXTERN ivector sqorder;


/* prototypes */
void makeF84model(void);
void compnumqts(void);
void setoptions(void);
void openfiletoread(FILE **, char[], char[]);
void openfiletowrite(FILE **, char[], char[]);
void closefile(FILE *);
void symdoublets(void);
void computeexpectations(void);
void putdistance(FILE *);
void findidenticals(FILE *);
double averagedist(void);
void initps(FILE *);
void plotlmpoint(FILE *, double, double);
void finishps(FILE *);
void makelmpoint(FILE *, double, double, double);
void printtreestats(FILE *);
void timestamp(FILE *);
void writeoutputfile(FILE *);
void writecutree(FILE *, int);
void starttimer(void);
void checktimer(uli);
void estimateparametersnotree(void);
void estimateparameterstree(void);
int main(void);
int ulicmp(const void *, const void *);
int intcmp(const void *, const void *);

void readid(FILE *, int);
char readnextcharacter(FILE *, int, int);
void skiprestofline(FILE *, int, int);
void skipcntrl(FILE *, int, int);
void getseqs(FILE *);
void initid(int);
void fputid10(FILE *, int);
int fputid(FILE *, int);
void getsizesites(FILE *);
void getdataset(FILE *);
int guessdatatype(void);
void translatedataset(void);
void estimatebasefreqs(void);
void guessmodel(void);
void inittree(void);
void addnextleaf(int);
void freetree(void);
void writeOTU(FILE *, int);
void writetree(FILE *);
void resetedgeinfo(void);
void incrementedgeinfo(int, int);
void minimumedgeinfo(void);
void initconsensus(void);
void makepart(int, int);
void computebiparts(void);
void printsplit(FILE *, uli);
void makenewsplitentries(void);
void copysplit(uli, int);
void makeconsensus(void);
void writenode(FILE *, int);
void writeconsensustree(FILE *);
void nodecoordinates(int);
void drawnode(int, int);
void plotconsensustree(FILE *);
void mallocquartets(int);
void freequartets(void);
unsigned char readquartet(int, int, int, int);
void writequartet(int, int, int, int, unsigned char);
void sort3doubles(dvector, ivector);
void computeallquartets(void);
void checkquartet(int, int, int, int);
