# File: msgeditbox.py
# Purpose: window with all associated crap for editing messages

import utils

from gtk import *
import GtkExtra

import os.path
import string
from addressbook import *
from pyneheaders import *
import time
import pynei18n
import boxtypes

class msgeditbox:
	"""
	Window with all associated crap for editing messages
	"""
	def toggle_view(self, _gtkobj, index):
		# Toggle show header
		if index in self.fields:
			self.fields.remove(index)
		else:
			self.fields.append(index)
		self.update_view_headers()
	
	def toggle_getreceipt(self, _gtkobj):
		# Add "Return-Receipt-To header
		if self.msg.headers.has_key("return-receipt-to"):
			del self.msg.headers["return-receipt-to"]
		else:
			self.msg.headers["return-receipt-to"] = self.msg.headers["from"]
	
	def change_send_folder(self, _gtkobj, uid):
		# change which folder we are sending with
		self.msg.senduid = uid

	def update_view_headers(self):
		# .show() objects as required
		for x in self.header_boxes.keys():
			label, entry, button = self.header_boxes[x]
			try:
				index = self.view_fields.index(x)
			except ValueError:
				print "weird"
				continue
			else:
				if index in self.fields:
					label.show()
					entry.show()
					if button != None:
						button.show()
				else:
					# not present. this header should be hidden
					label.hide()
					entry.hide()
					if button != None:
						button.hide()
		# contract if we hid some :-)
		self.win.queue_resize()

	def open_address_book(self, _button):
		AddressEditBox(self.user.addressbook, _button.gtkentry)

	def rot13_sel(self, _a=0, _b=0, _c=0):
		"""
		ROT13 'encode' the selected text.
		"""
		# Load font
		font = utils.get_font(self.user.bodyfont)
		# make colour
		col_text = utils.make_gdk_col(self.user.col_text)

		self.msg_text.freeze()
		start = self.msg_text.selection_start_pos
		end = self.msg_text.selection_end_pos
		if start > end:
			woo = end
			end = start
			start = woo
		text = self.msg_text.get_chars(start, end)
		text = utils.rot13(text)
		self.msg_text.delete_text(start, end)
		# dump into widget
		self.msg_text.insert(font, col_text, None, text)
		self.msg_text.thaw()
		
	def edit_cut(self, _a=0, _button=0, _b=0):
		self.msg_text.cut_clipboard()

	def edit_copy(self, _a=0, _button=0, _b=0):
		self.msg_text.copy_clipboard()

	def edit_paste(self, _a=0, _button=0, _b=0):
		self.msg_text.paste_clipboard()

	def insert_file(self, _a=0, _button=0, _b=0):
		filename = GtkExtra.file_sel_box(_("Insert file inline"))
		if filename == None:
			return
		try:
			file = open(filename, "r")
			text = file.read()
		except IOError:
			GtkExtra.message_box(_("Error"), _("Could not open %s") % filename, (_("Ok"),))
			return
		# Load font
		font = utils.get_font(self.user.bodyfont)
		# make colour
		col_text = utils.make_gdk_col(self.user.col_text)
		# dump into widget
		self.msg_text.insert(font, col_text, None, text)
	
	def __init__(self, msg, folder, user, is_new_msg=0):
		"""
		Folder will most likely be the outbox.
		"""
		# Store some shit
		self.msg = msg
		self.folder = folder
		self.user = user
		self.any_changes = 0

		if msg.headers.has_key("newsgroups"):
			self.view_fields = [ _("From"), _("Reply-To"), _("Newsgroups"), _("Subject"), _("Organization") ]
			self.fields = [ 0, 2, 3 ] # from, to, newsgroups
		else:
			self.view_fields = [ _("From"), _("Reply-To"), _("To"), _("Cc"), _("Bcc"), _("Subject"), _("Organization") ]
			self.fields = [ 0, 2, 5 ] # from, to, subject

		self.win = GtkWindow()
		self.win.set_default_size(600,440)
		self.win.set_title(_("Pyne - Message Composer"))

		box1 = GtkVBox()
		self.win.add(box1)
		box1.show()

		# menubar
		ag = GtkAccelGroup()
		itemf = GtkExtra.GtkItemFactory(GtkMenuBar, "<main>", ag)

		items = [
			("/_"+_("Message"), None, None, 0, "<Branch>"),
			("/_"+_("Message")+"/_"+_("Delete"), None, self.nuke_msg, 0, ""),
			("/_"+_("Message")+"/sep1", None, None, 0, "<Separator>"),
			("/_"+_("Message")+"/_"+_("Queue"), "<control>D", self.finish_edit, 0, ""),
			("/_"+_("Message")+"/_"+_("Send Now"), None, self.send_now, 0, ""),
			("/_"+_("Edit"), None, None, 0, "<Branch>"),
			("/_"+_("Edit")+"/_"+_("Cut"), "<control>X", self.edit_cut, 0, ""),
			("/_"+_("Edit")+"/_"+_("Copy"), "<control>C", self.edit_copy, 0, ""),
			("/_"+_("Edit")+"/_"+_("Paste"), "<control>V", self.edit_paste, 0, ""),
			("/_"+_("Edit")+"/sep1", None, None, 0, "<Separator>"),
			("/_"+_("Edit")+"/_"+_("ROT13 Selected"), None, self.rot13_sel, 0, ""),
			("/_"+_("Edit")+"/_"+_("Insert File"), None, self.insert_file, 0, "")
		]

		itemf.create_items(items)
		self.menubar = itemf.get_widget("<main>")
		box1.pack_start(self.menubar, expand=FALSE)
		self.win.add_accel_group(ag)
		self.menubar.show()

		# make headers submenu
		viewmenu = GtkMenuItem(_("View"))
		menu = GtkMenu()
		for i in range(0, len(self.view_fields)):
			menuitem = GtkCheckMenuItem(self.view_fields[i])
			# set state
			if i in self.fields:
				menuitem.set_active(TRUE)
			else:
				menuitem.set_active(FALSE)
			menuitem.connect("toggled", self.toggle_view, i)
			#menuitem.set_data("user_data", i)
			menu.append(menuitem)
			menuitem.show()
		menu.show()
		viewmenu.set_submenu(menu)
		self.menubar.append(viewmenu)
		viewmenu.show()

		# nessage options menu
		optsmenu = GtkMenuItem(_("Options"))
		menu = GtkMenu()
		
		menuitem = GtkCheckMenuItem(_("Confirm Delivery"))
		if msg.headers.has_key("return-receipt-to"):
			menuitem.set_active(TRUE)
		else:
			menuitem.set_active(FALSE)
		menuitem.connect("toggled", self.toggle_getreceipt)
		menu.append(menuitem)
		menuitem.show()
		menu.show()
		optsmenu.set_submenu(menu)
		self.menubar.append(optsmenu)
		optsmenu.show()

		# make 'send from' menu
		sendfrommenu = GtkMenuItem(_("Send With..."))
		menu = GtkMenu()
		# get folder we are sending 'with'
		send_folder = user.get_folder_by_uid(msg.senduid)
		# If it has been deleted we have to be smart...
		if send_folder == None:
			# News posting or email?
			if msg.headers.has_key("newsgroups"):
				good_class = boxtypes.nntpbox.nntpbox
			else:
				good_class = boxtypes.mailbox.mailbox
		else:
			good_class = send_folder.__class__
		# make list of suitable folders
		def _get_good_sendboxes(folder, good_class=good_class):
			# enforce same folder type
			if isinstance(folder, good_class):
				if folder.__dict__.has_key("send_type"):
					# disallow mailboxes with no send server
					if folder.send_type == 0:
						return
				return folder
		f_list = utils.recurse_apply(user.contents, _get_good_sendboxes)
		# Folder was deleted. change to using first folder found
		if send_folder == None and len(f_list) != 0:
			send_folder = f_list[0]
		# make a menu of them
		group = None
		for i in f_list:
			menuitem = GtkRadioMenuItem(group, i.name)
			menuitem.connect("toggled", self.change_send_folder, i.uid)
			group = menuitem
			menu.append(menuitem)
			menuitem.show()
			if i is send_folder:
				menuitem.set_active(TRUE)
		menu.show()
		sendfrommenu.set_submenu(menu)
		self.menubar.append(sendfrommenu)
		sendfrommenu.show()

		entry_box = GtkVBox()
		entry_box.set_border_width(5)
		box1.pack_start(entry_box, expand=FALSE)
		entry_box.show()
		
		entry_table = GtkTable(3, len(self.view_fields), FALSE)
		entry_table.set_row_spacings(5)
		entry_table.set_col_spacings(5)
		entry_box.pack_start(entry_table, expand=TRUE)
		entry_table.show()
	
		def get_to_address(_button, self=self):
			gtkentry = self.header_boxes[_("To")][1]
			addr_box = AddressEditBox(self.user.addressbook, gtkentry, append=1)

		def get_reply_to_address(_button, self=self):
			gtkentry = self.header_boxes[_("Reply-To")][1]
			addr_box = AddressEditBox(self.user.addressbook, gtkentry)

		def get_from_address(_button, self=self):
			gtkentry = self.header_boxes[_("From")][1]
			addr_box = AddressEditBox(self.user.addressbook, gtkentry)

		def get_cc_address(_button, self=self):
			gtkentry = self.header_boxes[_("Cc")][1]
			addr_box = AddressEditBox(self.user.addressbook, gtkentry, append=1)

		def get_bcc_address(_button, self=self):
			gtkentry = self.header_boxes[_("Bcc")][1]
			addr_box = AddressEditBox(self.user.addressbook, gtkentry, append=1)

		# stored in form { "header name": (gtkbox, gtklabel, gtkentry, gtkbutton) }
		self.header_boxes = {}
		for x in range(0, len(self.view_fields)):
			header = self.view_fields[x]

			label = GtkLabel(header+": ")
			entry_table.attach(label, 0,1, x,x+1, xoptions=SHRINK)

			entry = GtkEntry()
			if msg.headers.has_key(string.lower(header)):
				entry.set_text(msg.headers[string.lower(header)])

			# some headers access to the address book is appropriate
			if header==_("To") or header==_("From") or header==_("Reply-To") \
					or header==_("Cc") or header==_("Bcc"):
				button = GtkButton(" ... ")
				button.gtkentry = entry
				if header==_("To"):
					button.connect("clicked", get_to_address)
				if header==_("From"):
					button.connect("clicked", get_from_address)
				if header==_("Cc"):
					button.connect("clicked", get_cc_address)
				if header==_("Bcc"):
					button.connect("clicked", get_bcc_address)
				if header==_("Reply-To"):
					button.connect("clicked", get_reply_to_address)
				entry_table.attach(entry, 1,2, x,x+1, xoptions=EXPAND|FILL)
				entry_table.attach(button, 2,3, x,x+1, xoptions=SHRINK)
				self.header_boxes[header] = (label, entry, button)
			else:
				entry_table.attach(entry, 1,3, x,x+1, xoptions=EXPAND|FILL)
				self.header_boxes[header] = (label, entry, None)

		self.update_view_headers()

		# 'Notebook' for body and attachments.
		notebook = GtkNotebook()
		notebook.set_tab_pos(user.tab_pos)
		box1.pack_start(notebook)
		notebook.show()

		# text editty bit with crappy hacked up word wrap
		label = GtkLabel(_("Body"))

		table1 = GtkTable(2, 2)
		table1.set_row_spacing(0, 2)
		table1.set_col_spacing(0, 2)
		notebook.append_page(table1, label)
		table1.show()

		# Load font
		font = utils.get_font(user.bodyfont)
		# make colours
		col_text = utils.make_gdk_col(user.col_text)
		col_quote = utils.make_gdk_col(user.col_quote)

		def _do_wrap(_a, self=self, font=font, col_text=col_text):
			self.any_changes = 1
			# get text before the cursor
			text = self.msg_text.get_chars(0, self.msg_text.get_length())
			pos = self.msg_text.get_point()

			# find line with cursor on
			text_to = text[:pos]
			line = string.split(text_to, "\n")[-1]

			# insert newline if we exceed line length, and
			# have finished a word
			if len(line) > self.user.linewrap and text[pos-1] == " ":
				# delete space, then insert newline
				self.msg_text.delete_text(pos-1, pos)
				self.msg_text.insert(font, col_text, None, "\n")

		self.msg_text = GtkText()
		self.msg_text.set_editable(TRUE)
		table1.attach(self.msg_text, 0,1, 0,1)
		self.msg_text.connect("changed", _do_wrap)
		self.msg_text.show()
		
		vscrollbar = GtkVScrollbar(self.msg_text.get_vadjustment())
		table1.attach(vscrollbar, 1,2, 0,1, xoptions=FILL)
		vscrollbar.show()

		self.msg_text.freeze()
		# Dump it
		msg_lines = string.split(msg.parts_text[0], "\n")
		if msg_lines[len(msg_lines)-1] == "":
			del msg_lines[len(msg_lines)-1]
		for x in range (0, len(msg_lines)):
			# Quoted ([:1] == [0] w/o raising exception on "")
			if msg_lines[x][:1] == '>':
				# A bit ugly.. make sure text inserted around
				# this ends up 'col_text' not 'col_quote'
				self.msg_text.insert(font, col_text, None, ">")
				self.msg_text.insert(font, col_quote, None, msg_lines[x][1:])
				self.msg_text.insert(font, col_text, None, "\n")
				continue
			# Normal
			else:
				self.msg_text.insert(font, col_text, None, msg_lines[x]+"\n")
				continue
		# delete trailing \n we added
		self.msg_text.backward_delete(1)
		self.msg_text.thaw()

		# attachments bit
		box2 = GtkVBox()
		self.attach_label = GtkLabel(_("Attachments"))
		notebook.append_page(box2, self.attach_label)
		box2.show()

		self.attachment_list = GtkCList(3, [ _("Type"), _("Name"), _("Size") ])
		self.attachment_list.set_column_width(0,200)
		self.attachment_list.set_column_width(1,150)
		self.attachment_list.set_column_width(2,50)
		self.update_attachment_list()

		swin = GtkScrolledWindow()
		swin.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
		box2.pack_start(swin)
		swin.show()
		swin.add(self.attachment_list)
		self.attachment_list.show()

		box3 = GtkHBox(spacing=5)
		box3.set_border_width(5)
		box2.pack_start(box3, expand=FALSE)
		box3.show()

		button = GtkButton(" "+_("Delete")+" ")
		button.connect("clicked", self.del_attach)
		box3.pack_end(button, expand=FALSE)
		button.show()

		button = GtkButton(" "+_("Add")+" ")
		button.connect("clicked", self.add_attach)
		box3.pack_end(button, expand=FALSE)
		button.show()

		self.win.show()

		if is_new_msg == 1:
			self.win.connect("delete_event", self.nuke_msg, 1)
		else:
			self.win.connect("delete_event", self.finish_edit)

	def update_attachment_list(self):
		"""
		Update the attachment list.
		"""
		x = len(self.msg.parts_text)
		self.attachment_list.clear()

		for y in range(1, x):
			a = self.msg.get_attachment_info(y)
			self.attachment_list.append( [ a[0], a[1], a[2] ] )

		self.attach_label.set_text(_("Attachments")+" ("+str(len(self.msg.parts_text)-1)+")")

	def add_attach(self, _button):
		"""
		Get filename to save attachment.
		"""
		def do_it(filename, self=self):
			if filename == None:
				return
			if os.path.isfile(filename) == 0:
				return
			self.msg.add_attachment(filename)
			self.update_attachment_list()
		# Open file selection box
		utils.file_sel_box(_("Add attachment"), do_it)

	def del_attach(self, _button):
		"""
		View attachment.
		"""
		# No attachments
		if len(self.msg.parts_text) < 2:
			return
		selected = self.attachment_list.selection[0] + 1

		# Delete attachment
		del self.msg.parts_text[selected]
		del self.msg.parts_header[selected]

		self.update_attachment_list()

	def nuke_msg(self, _a=0, _b=0, save_if_changed=0):
		"""
		Remove the message we are editing.
		"""
		if self.any_changes==1 and save_if_changed==1:
			self.finish_edit()
			return
		self.folder.messages.remove(self.msg.headers["message-id"])
		self.folder.io.delete_article(self.msg.headers["message-id"])
		
		# Update message list
		self.folder.changed = 1
		self.user.update()

		self.win.destroy()

	def send_now(self, _a=0, _b=0, _c=0):
		import threading
		# save changes
		self.finish_edit()

		pager = utils.ProgressWindow(_("Sending message..."), hidetext=_("Show Logs"))
		outbox = self.user.get_folder_by_uid("outbox")
		
		# if the message isn't in the outbox move it there...
		if self.folder.uid != "outbox":
			msg_id = self.msg.headers["message-id"]
			outbox.messages.append(msg_id)
			outbox.io.save_article(self.msg)
			outbox.changed = 1
			
			self.folder.messages.remove(msg_id)
			self.folder.io.delete_article(msg_id)
			self.folder.changed = 1
		
		threading.Thread(target=outbox.send_one,args=(self.user,pager,self.msg.headers["message-id"])).start()

	def finish_edit(self, _a=0, _b=0, _c=0):
		"""
		Save changes to message.
		"""
		temp = self.msg_text.get_chars(0, self.msg_text.get_length())

		# Weird GtkText bugs appear unless a terminating "\n"
		# is present
		if temp[-1:] != "\n":
			temp = temp + "\n"
		if (len(self.msg.parts_text)==0):
			self.msg.parts_text.append(temp)
		else:
			self.msg.parts_text[0] = temp
		self.msg.body = temp

		# Collect edited headers:
		for x in self.view_fields:
			gtkentry = self.header_boxes[x][1]
			s = gtkentry.get_text()
			if s == "":
				if self.msg.headers.has_key(string.lower(x)):
					del self.msg.headers[string.lower(x)]
			else:
				self.msg.headers[string.lower(x)] = s
		
		# Some things are required XXX XXX XXX
		# subject, to
		if not self.msg.headers.has_key("subject"):
			self.msg.headers["subject"] = ""
		if _("Newsgroups") in self.view_fields:
			if not self.msg.headers.has_key("newsgroups"):
				self.msg.headers["newsgroups"] = ""
		else:
			if not self.msg.headers.has_key("to"):
				self.msg.headers["to"] = ""
	
		# 'Touch' the time flag
		self.msg.date = time.gmtime(time.time())

		# Create new body text
		self.msg.make_source()
		self.msg.opts = self.msg.opts | MSG_ISREAD
		self.folder.io.save_article(self.msg)

		# Update message list
		self.folder.changed = 1
		self.user.update()

		self.win.destroy()

