#
# Some stuff to make menus easier to create and sync state.
#

from gtk import *
import string

class method_set:
	def __init__(self):
		self.methods = {}
		self.enabled = {}
		
	def add_widget(self, key, widget):
		if self.methods.has_key(key):
			self.methods[key].append(widget)
			self.enabled[key] = TRUE
		else:
			self.methods[key] = [ widget, ]

	def set_enabled(self, key, bool_enabled):
		"""
		Turn a function on or off.
		"""
		for i in self.methods[key]:
			i.set_sensitive(bool_enabled)
		self.enabled[key] = bool_enabled
	
	def get_enabled(self, key):
		"""
		Is this set of widgets enabled?
		"""
		return self.enabled[key]

class MyGtkItemFactory(GtkItemFactory):
	def __init__(self, type=-1, path='', accel_group=None, _obj=None, \
			methodset=None, temporary=0):
		"""
		Set temporary = 1 if you don't want disabled options to show up.
		and don't want menu items to be added to the methodset.
		Useful for popup menus.
		"""
		self.temporary = temporary
		self.methodset = methodset
		GtkItemFactory.__init__(self, type, path, accel_group, _obj)
	
	def create_items(self, items):

		# keys are paths in menu. values are methodset keys.
		methods = {}
		_items = []
		for i in items:
			# extra argument for method_set key, optional
			if len(i) == 6:
				if self.temporary:
					try:
						# remove if disabled
						if self.methodset.get_enabled(i[5]) != 0:
							_items.append(i[:5])
					except KeyError:
						_items.append(i[:5])
				else:
					# do add to methodset. this isn't temporary
					methods[i[0]] = i[5]
					_items.append(i[:5])
				
			else:
				_items.append(i)
		GtkItemFactory.create_items(self, _items)
		# Add methods to method set.
		for i in methods.keys():
			# Gtk menu path seems to be sans underlines. use this vile,
			# break-tastic hack...
			self.methodset.add_widget(methods[i], self.get_widget(string.replace(i, "_", "")))

