# Various utility functions for pyne

from gtk import *
import string
import GtkExtra
import pynei18n

def split_address(sendstr):
	"""
	Parses the sender name such as:
	"Bob Bobson" <bob@somewhere.com>
	to tuple:
	("Bob Bobson", "<bob@somewhere.com>")
	"""
	email = ""
	
	temp = sendstr

	# Strip "'s
	temp = string.replace(temp, "\"", "")

	# Remove email addr
	x = string.find(temp, "<")
	if x >= 0:
		email = temp[x+1:-1]
		temp = temp[0:x]

	# Strip whitespace
	temp = string.strip(temp)

	# it's possible we have that silly "address@some.com (User Name)" format
	x = string.find(temp, "@")
	if x != -1 and string.find(temp, "(") != -1:
		temp = temp[ string.find(temp,"(")+1 : string.find(temp,")") ]
		email = sendstr[ 0: string.find(sendstr, "(")-1]

	# Email only types
	if temp == "":
		return (email, email)
	else:
		return (temp, email)

def rot13(s):
	new = ""
	for c in s:
		if (ord(c)>=ord('A') and ord(c)<=ord('Z')):
			ascii_val = ord(c)+13
			if ascii_val > ord('Z'):
				ascii_val = ascii_val - 26
		elif (ord(c)>=ord('a') and ord(c)<=ord('z')):
			ascii_val = ord(c)+13
			if ascii_val > ord('z'):
				ascii_val = ascii_val - 26
		else:
			ascii_val = ord(c)
		new = new + chr(ascii_val)
	return new

# Apply a function to a list of mailboxes, and any mailboxes
# they may contain.
# XXX Any !=None returns will be returned in a list
def recurse_apply(folders, function, returns=None):
	if returns == None:
		returns = []
	for x in folders:
		temp = function(x)
		if temp != None:
			returns.append(temp)
		if x.__dict__.has_key("contents"):
			recurse_apply(x.contents, function, returns)
	return returns

def file_sel_box(title, some_function):
	"""
	Nice non-modal file selector thingy. Gives 'none'
	so some_function if user clicks cancel.
	"""
	fileselector = GtkFileSelection(title)

	def _yay(_button, fileselector=fileselector, some_function=some_function):
		filename = fileselector.get_filename()
		fileselector.destroy()
		some_function(filename)
	def _boo(_button, fileselector=fileselector, some_function=some_function):
		fileselector.destroy()
		some_function(None)
	fileselector.ok_button.connect("clicked", _yay)
	fileselector.cancel_button.connect("clicked", _boo)
	fileselector.show()

def info_box(title, message, button_label="Ok"):
	"""
	Single button 'info' dialog box.
	"""
	win = GtkDialog()
	win.set_title(title)

	win.vbox.set_border_width(10)

	label = GtkLabel(message)
	win.vbox.pack_start(label)
	label.show()

	close_button = GtkButton(button_label)
	close_button.connect("clicked", win.destroy)
	win.action_area.pack_start(close_button)
	close_button.show()
	
	win.show()

def get_font(xfont_name):
	try:
		return load_font(xfont_name)
	except RuntimeError:
		# irritate the user
		info_box(_("Error"), _("The font \'%s\' cannot be found.\nChange font in Options->Preferences menu.") % xfont_name, "Ok")
		return None

class ProgressWindow:
	
 	def silence_output(self, _a):
 		# If threads continue to write stuff to the window
 		# after the user has closed it we segfault. Prevent this.
 		# There is probably a good way... like
 		# window->dont_let_user_close_me = 1...
 		self.window_closed = 1
 
	def toggle_text(self, _a):
		if self.text_hidden == 1:
			self.text_table.show()
			self.text_hidden = 0
		else:
			self.text_table.hide()
			self.text_hidden = 1
		# window should contract
		self.win.queue_resize()
 
	def __init__(self, title, hidetext=None):
		"""
		Set hidetext to the desired label of button to
		show/hide text widget.
		"""
		self.win = GtkDialog()
		self.win.set_title(title)
 		self.win.connect("destroy", self.silence_output)

		self.win.vbox.set_spacing(5)
		self.win.vbox.set_border_width(5)
 
		self.window_closed = 0

		self.win.action_area.set_border_width(0)
		button_box = GtkHBox(spacing=5)
		self.win.action_area.pack_start(button_box)
		button_box.show()
		
		self.close_button = GtkButton(" "+_("Close")+" ")
		self.close_button.connect("clicked", self.win.destroy)
		button_box.pack_end(self.close_button, expand=FALSE)
		self.close_button.show()

		self.text_table = GtkTable(2, 2)
		self.text_table.set_row_spacing(0, 2)
		self.text_table.set_col_spacing(0, 2)
		self.win.vbox.pack_end(self.text_table)

		if hidetext == None:
			self.text_table.show()
			self.text_hidden = 0
		else:
			self.details_button = GtkButton(" "+hidetext+" ")
			self.details_button.connect("clicked", self.toggle_text)
			button_box.pack_end(self.details_button, expand=FALSE)
			self.details_button.show()
			self.text_hidden = 1

		self.text = GtkText()
		self.text.set_editable(FALSE)
		self.text.set_word_wrap(TRUE)
		self.text_table.attach(self.text, 0,1, 0,1)
		self.text.show()

		vscrollbar = GtkVScrollbar(self.text.get_vadjustment())
		self.text_table.attach(vscrollbar, 1,2, 0,1, xoptions=FILL)
		vscrollbar.show()

		self.win.show()

		# XXX Strange bug(?) in gtk makes first line default colour
		# and therefore possibly invisible.
		self.msg_print("")

	def msg_print(self, message):
		"""
		Push a message onto the GtkText object.
		"""
		if not self.window_closed:
			self.text.insert_defaults(message+"\n")

	def get_progress_bar(self, thread=None):
		"""
		Returns a progress bar object. access it as you
		would normally and .destroy() it when done.
		If thread!=None a box will be available to
		kill the thread, too.
		This doesn't work. Threads can't be killed :-(
		"""
		bar = GtkProgressBar()
		bar.set_value(0.0)
		bar.set_format_string("")
		bar.set_show_text(1)
		if thread == None:
			self.win.vbox.pack_start(bar, expand=FALSE)
		else:
			def _kill_me(_button, thread=thread, bar=bar):
				print "Killing ", `thread`
				bar.destroy()
				thread.exit()
				# this is not how it's done ^^^^
				raise OOoopException
			hbox = GtkHBox(spacing=5)
			button = GtkButton(" X ")
			button.connect("clicked", _kill_me)
			hbox.pack_start(bar)
			hbox.pack_start(button, expand=FALSE)
			button.show()
			hbox.show()
			self.win.vbox.pack_start(hbox, expand=FALSE)
		bar.show()
		return bar


class UserChooseBox:
	def __init__(self, user, compare_func, ok_func, title=_("Select a mailbox")):
		"""
		Allow the user to select from all boxes that return
		match when examined with 'compare_func'. Function 'ok_func'
		will be called when one is selected with argument:
		selected box.
		"""
		win = GtkWindow()
		win.set_title(title)

		box1 = GtkVBox(spacing=5)
		box1.set_border_width(5)
		win.add(box1)
		box1.show()

		# make list of outbox name, uid
		def _get_mailboxes(folder, cmp=compare_func):
			if cmp(folder):
				return (folder.name, folder.uid)
			#if isinstance(folder, mailbox):
			#	if folder.send_type != mail_send.MAIL_SEND_NONE:
			#		# only mailboxes with smtp server.
			#		return (folder.name, folder.uid)
		outboxes = recurse_apply(user.contents, _get_mailboxes)
					
		if len(outboxes) == 0:
			GtkExtra.message_box(_("Error"), _("You need to have a mailbox\nto send mail :-)"), (_("Ok"),))
			return
			
		# just one mailbox. use it.
		if len(outboxes) == 1:
			from_folder = user.get_folder_by_uid(outboxes[0][1])
			win.destroy()
			ok_func(from_folder)
			return

		clist = GtkCList(1, [ _("Send using mailbox:") ])
	
		for x in range (0, len(outboxes)):
			clist.append([outboxes[x][0]])

		def _select_outbox(widget, event,  ok_func=ok_func, win=win, \
				clist=clist, outboxes=outboxes, user=user):
			if event.type == GDK._2BUTTON_PRESS:
				folder = user.get_folder_by_uid(outboxes[clist.selection[0]][1])
				win.destroy()
				ok_func(folder)

		clist.connect("button_press_event", _select_outbox)
		box1.pack_start(clist)
		clist.show()

		def _ok_func(_button, ok_func=ok_func, win=win, \
				clist=clist, outboxes=outboxes, user=user):
			if len(clist.selection) == 0:
				# please pick one...
				return
			folder = user.get_folder_by_uid(outboxes[clist.selection[0]][1])
			win.destroy()
			ok_func(folder)

		buttonbox = GtkHBox(spacing=5)
		box1.pack_start(buttonbox, expand=FALSE)
		buttonbox.show()

		button = GtkButton(_(" Cancel "))
		button.connect("clicked", win.destroy)
		buttonbox.pack_end(button, expand=FALSE)
		button.show()

		button = GtkButton(_(" Ok "))
		button.connect("clicked", _ok_func)
		buttonbox.pack_end(button, expand=FALSE)
		button.show()

		win.show()

def make_gdk_col(rgb):
	"""
	Take float arguments and return a GdkColor
	"""
	red   = rgb[0]*65535
	green = rgb[1]*65535
	blue  = rgb[2]*65535

	# if colours are screwed delete this:
	# workaround for possible pygtk bug
	if red > 32767:
		red = -65536 + red
	if green > 32767:
		green = -65536 + green
	if blue > 32767:
		blue = -65536 + blue
	#####################################

	return GdkColor(red, green, blue)

