# -*- coding: utf-8 -*-
#
# Author: Ingelrest François (Athropos@gmail.com)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

import consts
import os.path
import gtk.glade

class DlgBase :

    def __init__(self, parent, dlgName, widgets=[]) :
        gtk.glade.set_custom_handler(self.getCustomHandler)

        self.wTree = gtk.glade.XML(os.path.join(consts.dirRes, dlgName + '.glade'), domain=consts.appNameShort)
        self.mDlg  = self.wTree.get_widget(dlgName)

        self.mDlg.set_modal(True)
        self.mDlg.set_transient_for(parent)
        self.mDlg.connect('response', self.onResponse)

        for w in widgets :
            self.__dict__[w] = self.wTree.get_widget(w)


    def onResponse(self, dialog, response, *args) :
        self.mDlg.hide()


    def getCustomHandler(self, glade, function_name, widget_name, str1, str2, int1, int2) :
        pass


    def show(self) :
        return self.mDlg.run()
