# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobResponse(Model):
    """The properties describing a Job Response.

    :param job_id: The job identifier.
    :type job_id: str
    :param start_time_utc: Start time of the Job.
    :type start_time_utc: datetime
    :param end_time_utc: Represents the time the job stopped processing.
    :type end_time_utc: datetime
    :param type: The type of job to execute. Possible values include:
     'unknown', 'export', 'import', 'backup', 'readDeviceProperties',
     'writeDeviceProperties', 'updateDeviceConfiguration', 'rebootDevice',
     'factoryResetDevice', 'firmwareUpdate'
    :type type: str or :class:`JobType <azure.mgmt.iothub.models.JobType>`
    :param status: Status of the Job. Possible values include: 'unknown',
     'enqueued', 'running', 'completed', 'failed', 'cancelled'
    :type status: str or :class:`JobStatus
     <azure.mgmt.iothub.models.JobStatus>`
    :param failure_reason: If status == failure, this represents a string
     containing the reason.
    :type failure_reason: str
    :param status_message: The status message for the job.
    :type status_message: str
    :param device_id: The deviceId related to this response.
    :type device_id: str
    :param parent_job_id: The jobId of the parent job, if any.
    :type parent_job_id: str
    """ 

    _attribute_map = {
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'iso-8601'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'iso-8601'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'JobStatus'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'parent_job_id': {'key': 'parentJobId', 'type': 'str'},
    }

    def __init__(self, job_id=None, start_time_utc=None, end_time_utc=None, type=None, status=None, failure_reason=None, status_message=None, device_id=None, parent_job_id=None):
        self.job_id = job_id
        self.start_time_utc = start_time_utc
        self.end_time_utc = end_time_utc
        self.type = type
        self.status = status
        self.failure_reason = failure_reason
        self.status_message = status_message
        self.device_id = device_id
        self.parent_job_id = parent_job_id
