# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MongoDbObjectInfo(Model):
    """Describes a database or collection within a MongoDB data source.

    All required parameters must be populated in order to send to Azure.

    :param average_document_size: Required. The average document size, or -1
     if the average size is unknown
    :type average_document_size: long
    :param data_size: Required. The estimated total data size, in bytes, or -1
     if the size is unknown.
    :type data_size: long
    :param document_count: Required. The estimated total number of documents,
     or -1 if the document count is unknown
    :type document_count: long
    :param name: Required. The unqualified name of the database or collection
    :type name: str
    :param qualified_name: Required. The qualified name of the database or
     collection. For a collection, this is the database-qualified name.
    :type qualified_name: str
    """

    _validation = {
        'average_document_size': {'required': True},
        'data_size': {'required': True},
        'document_count': {'required': True},
        'name': {'required': True},
        'qualified_name': {'required': True},
    }

    _attribute_map = {
        'average_document_size': {'key': 'averageDocumentSize', 'type': 'long'},
        'data_size': {'key': 'dataSize', 'type': 'long'},
        'document_count': {'key': 'documentCount', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'qualified_name': {'key': 'qualifiedName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MongoDbObjectInfo, self).__init__(**kwargs)
        self.average_document_size = kwargs.get('average_document_size', None)
        self.data_size = kwargs.get('data_size', None)
        self.document_count = kwargs.get('document_count', None)
        self.name = kwargs.get('name', None)
        self.qualified_name = kwargs.get('qualified_name', None)
