# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .operation_result_info_base_py3 import OperationResultInfoBase


class ExportJobsOperationResultInfo(OperationResultInfoBase):
    """This class is used to send blob details after exporting jobs.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param blob_url: URL of the blob into which the serialized string of list
     of jobs is exported.
    :type blob_url: str
    :param blob_sas_key: SAS key to access the blob. It expires in 15 mins.
    :type blob_sas_key: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'blob_url': {'key': 'blobUrl', 'type': 'str'},
        'blob_sas_key': {'key': 'blobSasKey', 'type': 'str'},
    }

    def __init__(self, *, blob_url: str=None, blob_sas_key: str=None, **kwargs) -> None:
        super(ExportJobsOperationResultInfo, self).__init__(**kwargs)
        self.blob_url = blob_url
        self.blob_sas_key = blob_sas_key
        self.object_type = 'ExportJobsOperationResultInfo'
