# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class SecurityContact(Resource):
    """Contact details for security issues.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param email: Required. The email of this security contact
    :type email: str
    :param phone: Required. The phone number of this security contact
    :type phone: str
    :param alert_notifications: Required. Whether to send security alerts
     notifications to the security contact. Possible values include: 'On',
     'Off'
    :type alert_notifications: str or
     ~azure.mgmt.security.models.AlertNotifications
    :param alerts_to_admins: Required. Whether to send security alerts
     notifications to subscription admins. Possible values include: 'On', 'Off'
    :type alerts_to_admins: str or ~azure.mgmt.security.models.AlertsToAdmins
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'email': {'required': True},
        'phone': {'required': True},
        'alert_notifications': {'required': True},
        'alerts_to_admins': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'email': {'key': 'properties.email', 'type': 'str'},
        'phone': {'key': 'properties.phone', 'type': 'str'},
        'alert_notifications': {'key': 'properties.alertNotifications', 'type': 'str'},
        'alerts_to_admins': {'key': 'properties.alertsToAdmins', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SecurityContact, self).__init__(**kwargs)
        self.email = kwargs.get('email', None)
        self.phone = kwargs.get('phone', None)
        self.alert_notifications = kwargs.get('alert_notifications', None)
        self.alerts_to_admins = kwargs.get('alerts_to_admins', None)
