# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VulnerabilityAssessmentRecurringScansProperties(Model):
    """Properties of a Vulnerability Assessment recurring scans.

    :param is_enabled: Recurring scans state.
    :type is_enabled: bool
    :param email_subscription_admins: Specifies that the schedule scan
     notification will be is sent to the subscription administrators. Default
     value: True .
    :type email_subscription_admins: bool
    :param emails: Specifies an array of e-mail addresses to which the scan
     notification is sent.
    :type emails: list[str]
    """

    _attribute_map = {
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
        'email_subscription_admins': {'key': 'emailSubscriptionAdmins', 'type': 'bool'},
        'emails': {'key': 'emails', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VulnerabilityAssessmentRecurringScansProperties, self).__init__(**kwargs)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.email_subscription_admins = kwargs.get('email_subscription_admins', True)
        self.emails = kwargs.get('emails', None)
