# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._dev_test_labs_client_enums import *


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicableSchedule(Resource):
    """Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param lab_vms_shutdown: The auto-shutdown schedule, if one has been set at the lab or lab
     resource level.
    :type lab_vms_shutdown: ~azure.mgmt.devtestlabs.models.Schedule
    :param lab_vms_startup: The auto-startup schedule, if one has been set at the lab or lab
     resource level.
    :type lab_vms_startup: ~azure.mgmt.devtestlabs.models.Schedule
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'lab_vms_shutdown': {'key': 'properties.labVmsShutdown', 'type': 'Schedule'},
        'lab_vms_startup': {'key': 'properties.labVmsStartup', 'type': 'Schedule'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        lab_vms_shutdown: Optional["Schedule"] = None,
        lab_vms_startup: Optional["Schedule"] = None,
        **kwargs
    ):
        super(ApplicableSchedule, self).__init__(location=location, tags=tags, **kwargs)
        self.lab_vms_shutdown = lab_vms_shutdown
        self.lab_vms_startup = lab_vms_startup


class UpdateResource(msrest.serialization.Model):
    """Represents an update resource.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(UpdateResource, self).__init__(**kwargs)
        self.tags = tags


class ApplicableScheduleFragment(UpdateResource):
    """Schedules applicable to a virtual machine. The schedules may have been defined on a VM or on lab level.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param lab_vms_shutdown: The auto-shutdown schedule, if one has been set at the lab or lab
     resource level.
    :type lab_vms_shutdown: ~azure.mgmt.devtestlabs.models.ScheduleFragment
    :param lab_vms_startup: The auto-startup schedule, if one has been set at the lab or lab
     resource level.
    :type lab_vms_startup: ~azure.mgmt.devtestlabs.models.ScheduleFragment
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'lab_vms_shutdown': {'key': 'properties.labVmsShutdown', 'type': 'ScheduleFragment'},
        'lab_vms_startup': {'key': 'properties.labVmsStartup', 'type': 'ScheduleFragment'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        lab_vms_shutdown: Optional["ScheduleFragment"] = None,
        lab_vms_startup: Optional["ScheduleFragment"] = None,
        **kwargs
    ):
        super(ApplicableScheduleFragment, self).__init__(tags=tags, **kwargs)
        self.lab_vms_shutdown = lab_vms_shutdown
        self.lab_vms_startup = lab_vms_startup


class ApplyArtifactsRequest(msrest.serialization.Model):
    """Request body for applying artifacts to a virtual machine.

    :param artifacts: The list of artifacts to apply.
    :type artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
    """

    _attribute_map = {
        'artifacts': {'key': 'artifacts', 'type': '[ArtifactInstallProperties]'},
    }

    def __init__(
        self,
        *,
        artifacts: Optional[List["ArtifactInstallProperties"]] = None,
        **kwargs
    ):
        super(ApplyArtifactsRequest, self).__init__(**kwargs)
        self.artifacts = artifacts


class ArmTemplate(Resource):
    """An Azure Resource Manager template.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar display_name: The display name of the ARM template.
    :vartype display_name: str
    :ivar description: The description of the ARM template.
    :vartype description: str
    :ivar publisher: The publisher of the ARM template.
    :vartype publisher: str
    :ivar icon: The URI to the icon of the ARM template.
    :vartype icon: str
    :ivar contents: The contents of the ARM template.
    :vartype contents: object
    :ivar created_date: The creation date of the armTemplate.
    :vartype created_date: ~datetime.datetime
    :ivar parameters_value_files_info: File name and parameter values information from all
     azuredeploy.*.parameters.json for the ARM template.
    :vartype parameters_value_files_info:
     list[~azure.mgmt.devtestlabs.models.ParametersValueFileInfo]
    :ivar enabled: Whether or not ARM template is enabled for use by lab user.
    :vartype enabled: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'display_name': {'readonly': True},
        'description': {'readonly': True},
        'publisher': {'readonly': True},
        'icon': {'readonly': True},
        'contents': {'readonly': True},
        'created_date': {'readonly': True},
        'parameters_value_files_info': {'readonly': True},
        'enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'contents': {'key': 'properties.contents', 'type': 'object'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'parameters_value_files_info': {'key': 'properties.parametersValueFilesInfo', 'type': '[ParametersValueFileInfo]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ArmTemplate, self).__init__(location=location, tags=tags, **kwargs)
        self.display_name = None
        self.description = None
        self.publisher = None
        self.icon = None
        self.contents = None
        self.created_date = None
        self.parameters_value_files_info = None
        self.enabled = None


class ArmTemplateInfo(msrest.serialization.Model):
    """Information about a generated ARM template.

    :param template: The template's contents.
    :type template: object
    :param parameters: The parameters of the ARM template.
    :type parameters: object
    """

    _attribute_map = {
        'template': {'key': 'template', 'type': 'object'},
        'parameters': {'key': 'parameters', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        template: Optional[object] = None,
        parameters: Optional[object] = None,
        **kwargs
    ):
        super(ArmTemplateInfo, self).__init__(**kwargs)
        self.template = template
        self.parameters = parameters


class ArmTemplateList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.ArmTemplate]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ArmTemplate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ArmTemplate"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ArmTemplateList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ArmTemplateParameterProperties(msrest.serialization.Model):
    """Properties of an Azure Resource Manager template parameter.

    :param name: The name of the template parameter.
    :type name: str
    :param value: The value of the template parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ArmTemplateParameterProperties, self).__init__(**kwargs)
        self.name = name
        self.value = value


class ArmTemplateParameterPropertiesFragment(msrest.serialization.Model):
    """Properties of an Azure Resource Manager template parameter.

    :param name: The name of the template parameter.
    :type name: str
    :param value: The value of the template parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ArmTemplateParameterPropertiesFragment, self).__init__(**kwargs)
        self.name = name
        self.value = value


class Artifact(Resource):
    """An artifact.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar title: The artifact's title.
    :vartype title: str
    :ivar description: The artifact's description.
    :vartype description: str
    :ivar publisher: The artifact's publisher.
    :vartype publisher: str
    :ivar file_path: The file path to the artifact.
    :vartype file_path: str
    :ivar icon: The URI to the artifact icon.
    :vartype icon: str
    :ivar target_os_type: The artifact's target OS.
    :vartype target_os_type: str
    :ivar parameters: The artifact's parameters.
    :vartype parameters: object
    :ivar created_date: The artifact's creation date.
    :vartype created_date: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'title': {'readonly': True},
        'description': {'readonly': True},
        'publisher': {'readonly': True},
        'file_path': {'readonly': True},
        'icon': {'readonly': True},
        'target_os_type': {'readonly': True},
        'parameters': {'readonly': True},
        'created_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'file_path': {'key': 'properties.filePath', 'type': 'str'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'target_os_type': {'key': 'properties.targetOsType', 'type': 'str'},
        'parameters': {'key': 'properties.parameters', 'type': 'object'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Artifact, self).__init__(location=location, tags=tags, **kwargs)
        self.title = None
        self.description = None
        self.publisher = None
        self.file_path = None
        self.icon = None
        self.target_os_type = None
        self.parameters = None
        self.created_date = None


class ArtifactDeploymentStatusProperties(msrest.serialization.Model):
    """Properties of an artifact deployment.

    :param deployment_status: The deployment status of the artifact.
    :type deployment_status: str
    :param artifacts_applied: The total count of the artifacts that were successfully applied.
    :type artifacts_applied: int
    :param total_artifacts: The total count of the artifacts that were tentatively applied.
    :type total_artifacts: int
    """

    _attribute_map = {
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'artifacts_applied': {'key': 'artifactsApplied', 'type': 'int'},
        'total_artifacts': {'key': 'totalArtifacts', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        deployment_status: Optional[str] = None,
        artifacts_applied: Optional[int] = None,
        total_artifacts: Optional[int] = None,
        **kwargs
    ):
        super(ArtifactDeploymentStatusProperties, self).__init__(**kwargs)
        self.deployment_status = deployment_status
        self.artifacts_applied = artifacts_applied
        self.total_artifacts = total_artifacts


class ArtifactDeploymentStatusPropertiesFragment(msrest.serialization.Model):
    """Properties of an artifact deployment.

    :param deployment_status: The deployment status of the artifact.
    :type deployment_status: str
    :param artifacts_applied: The total count of the artifacts that were successfully applied.
    :type artifacts_applied: int
    :param total_artifacts: The total count of the artifacts that were tentatively applied.
    :type total_artifacts: int
    """

    _attribute_map = {
        'deployment_status': {'key': 'deploymentStatus', 'type': 'str'},
        'artifacts_applied': {'key': 'artifactsApplied', 'type': 'int'},
        'total_artifacts': {'key': 'totalArtifacts', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        deployment_status: Optional[str] = None,
        artifacts_applied: Optional[int] = None,
        total_artifacts: Optional[int] = None,
        **kwargs
    ):
        super(ArtifactDeploymentStatusPropertiesFragment, self).__init__(**kwargs)
        self.deployment_status = deployment_status
        self.artifacts_applied = artifacts_applied
        self.total_artifacts = total_artifacts


class ArtifactInstallProperties(msrest.serialization.Model):
    """Properties of an artifact.

    :param artifact_id: The artifact's identifier.
    :type artifact_id: str
    :param artifact_title: The artifact's title.
    :type artifact_title: str
    :param parameters: The parameters of the artifact.
    :type parameters: list[~azure.mgmt.devtestlabs.models.ArtifactParameterProperties]
    :param status: The status of the artifact.
    :type status: str
    :param deployment_status_message: The status message from the deployment.
    :type deployment_status_message: str
    :param vm_extension_status_message: The status message from the virtual machine extension.
    :type vm_extension_status_message: str
    :param install_time: The time that the artifact starts to install on the virtual machine.
    :type install_time: ~datetime.datetime
    """

    _attribute_map = {
        'artifact_id': {'key': 'artifactId', 'type': 'str'},
        'artifact_title': {'key': 'artifactTitle', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ArtifactParameterProperties]'},
        'status': {'key': 'status', 'type': 'str'},
        'deployment_status_message': {'key': 'deploymentStatusMessage', 'type': 'str'},
        'vm_extension_status_message': {'key': 'vmExtensionStatusMessage', 'type': 'str'},
        'install_time': {'key': 'installTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        artifact_id: Optional[str] = None,
        artifact_title: Optional[str] = None,
        parameters: Optional[List["ArtifactParameterProperties"]] = None,
        status: Optional[str] = None,
        deployment_status_message: Optional[str] = None,
        vm_extension_status_message: Optional[str] = None,
        install_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(ArtifactInstallProperties, self).__init__(**kwargs)
        self.artifact_id = artifact_id
        self.artifact_title = artifact_title
        self.parameters = parameters
        self.status = status
        self.deployment_status_message = deployment_status_message
        self.vm_extension_status_message = vm_extension_status_message
        self.install_time = install_time


class ArtifactInstallPropertiesFragment(msrest.serialization.Model):
    """Properties of an artifact.

    :param artifact_id: The artifact's identifier.
    :type artifact_id: str
    :param artifact_title: The artifact's title.
    :type artifact_title: str
    :param parameters: The parameters of the artifact.
    :type parameters: list[~azure.mgmt.devtestlabs.models.ArtifactParameterPropertiesFragment]
    :param status: The status of the artifact.
    :type status: str
    :param deployment_status_message: The status message from the deployment.
    :type deployment_status_message: str
    :param vm_extension_status_message: The status message from the virtual machine extension.
    :type vm_extension_status_message: str
    :param install_time: The time that the artifact starts to install on the virtual machine.
    :type install_time: ~datetime.datetime
    """

    _attribute_map = {
        'artifact_id': {'key': 'artifactId', 'type': 'str'},
        'artifact_title': {'key': 'artifactTitle', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ArtifactParameterPropertiesFragment]'},
        'status': {'key': 'status', 'type': 'str'},
        'deployment_status_message': {'key': 'deploymentStatusMessage', 'type': 'str'},
        'vm_extension_status_message': {'key': 'vmExtensionStatusMessage', 'type': 'str'},
        'install_time': {'key': 'installTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        artifact_id: Optional[str] = None,
        artifact_title: Optional[str] = None,
        parameters: Optional[List["ArtifactParameterPropertiesFragment"]] = None,
        status: Optional[str] = None,
        deployment_status_message: Optional[str] = None,
        vm_extension_status_message: Optional[str] = None,
        install_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(ArtifactInstallPropertiesFragment, self).__init__(**kwargs)
        self.artifact_id = artifact_id
        self.artifact_title = artifact_title
        self.parameters = parameters
        self.status = status
        self.deployment_status_message = deployment_status_message
        self.vm_extension_status_message = vm_extension_status_message
        self.install_time = install_time


class ArtifactList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.Artifact]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Artifact]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Artifact"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ArtifactList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ArtifactParameterProperties(msrest.serialization.Model):
    """Properties of an artifact parameter.

    :param name: The name of the artifact parameter.
    :type name: str
    :param value: The value of the artifact parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ArtifactParameterProperties, self).__init__(**kwargs)
        self.name = name
        self.value = value


class ArtifactParameterPropertiesFragment(msrest.serialization.Model):
    """Properties of an artifact parameter.

    :param name: The name of the artifact parameter.
    :type name: str
    :param value: The value of the artifact parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ArtifactParameterPropertiesFragment, self).__init__(**kwargs)
        self.name = name
        self.value = value


class ArtifactSource(Resource):
    """Properties of an artifact source.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param display_name: The artifact source's display name.
    :type display_name: str
    :param uri: The artifact source's URI.
    :type uri: str
    :param source_type: The artifact source's type. Possible values include: "VsoGit", "GitHub".
    :type source_type: str or ~azure.mgmt.devtestlabs.models.SourceControlType
    :param folder_path: The folder containing artifacts.
    :type folder_path: str
    :param arm_template_folder_path: The folder containing Azure Resource Manager templates.
    :type arm_template_folder_path: str
    :param branch_ref: The artifact source's branch reference.
    :type branch_ref: str
    :param security_token: The security token to authenticate to the artifact source.
    :type security_token: str
    :param status: Indicates if the artifact source is enabled (values: Enabled, Disabled).
     Possible values include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :ivar created_date: The artifact source's creation date.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'arm_template_folder_path': {'key': 'properties.armTemplateFolderPath', 'type': 'str'},
        'branch_ref': {'key': 'properties.branchRef', 'type': 'str'},
        'security_token': {'key': 'properties.securityToken', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        uri: Optional[str] = None,
        source_type: Optional[Union[str, "SourceControlType"]] = None,
        folder_path: Optional[str] = None,
        arm_template_folder_path: Optional[str] = None,
        branch_ref: Optional[str] = None,
        security_token: Optional[str] = None,
        status: Optional[Union[str, "EnableStatus"]] = None,
        **kwargs
    ):
        super(ArtifactSource, self).__init__(location=location, tags=tags, **kwargs)
        self.display_name = display_name
        self.uri = uri
        self.source_type = source_type
        self.folder_path = folder_path
        self.arm_template_folder_path = arm_template_folder_path
        self.branch_ref = branch_ref
        self.security_token = security_token
        self.status = status
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class ArtifactSourceFragment(UpdateResource):
    """Properties of an artifact source.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param display_name: The artifact source's display name.
    :type display_name: str
    :param uri: The artifact source's URI.
    :type uri: str
    :param source_type: The artifact source's type. Possible values include: "VsoGit", "GitHub".
    :type source_type: str or ~azure.mgmt.devtestlabs.models.SourceControlType
    :param folder_path: The folder containing artifacts.
    :type folder_path: str
    :param arm_template_folder_path: The folder containing Azure Resource Manager templates.
    :type arm_template_folder_path: str
    :param branch_ref: The artifact source's branch reference.
    :type branch_ref: str
    :param security_token: The security token to authenticate to the artifact source.
    :type security_token: str
    :param status: Indicates if the artifact source is enabled (values: Enabled, Disabled).
     Possible values include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'folder_path': {'key': 'properties.folderPath', 'type': 'str'},
        'arm_template_folder_path': {'key': 'properties.armTemplateFolderPath', 'type': 'str'},
        'branch_ref': {'key': 'properties.branchRef', 'type': 'str'},
        'security_token': {'key': 'properties.securityToken', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        uri: Optional[str] = None,
        source_type: Optional[Union[str, "SourceControlType"]] = None,
        folder_path: Optional[str] = None,
        arm_template_folder_path: Optional[str] = None,
        branch_ref: Optional[str] = None,
        security_token: Optional[str] = None,
        status: Optional[Union[str, "EnableStatus"]] = None,
        **kwargs
    ):
        super(ArtifactSourceFragment, self).__init__(tags=tags, **kwargs)
        self.display_name = display_name
        self.uri = uri
        self.source_type = source_type
        self.folder_path = folder_path
        self.arm_template_folder_path = arm_template_folder_path
        self.branch_ref = branch_ref
        self.security_token = security_token
        self.status = status


class ArtifactSourceList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.ArtifactSource]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ArtifactSource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ArtifactSource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ArtifactSourceList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AttachDiskProperties(msrest.serialization.Model):
    """Properties of the disk to attach.

    :param leased_by_lab_vm_id: The resource ID of the Lab virtual machine to which the disk is
     attached.
    :type leased_by_lab_vm_id: str
    """

    _attribute_map = {
        'leased_by_lab_vm_id': {'key': 'leasedByLabVmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        leased_by_lab_vm_id: Optional[str] = None,
        **kwargs
    ):
        super(AttachDiskProperties, self).__init__(**kwargs)
        self.leased_by_lab_vm_id = leased_by_lab_vm_id


class AttachNewDataDiskOptions(msrest.serialization.Model):
    """Properties to attach new disk to the Virtual Machine.

    :param disk_size_gi_b: Size of the disk to be attached in GibiBytes.
    :type disk_size_gi_b: int
    :param disk_name: The name of the disk to be attached.
    :type disk_name: str
    :param disk_type: The storage type for the disk (i.e. Standard, Premium). Possible values
     include: "Standard", "Premium", "StandardSSD".
    :type disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        'disk_size_gi_b': {'key': 'diskSizeGiB', 'type': 'int'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_size_gi_b: Optional[int] = None,
        disk_name: Optional[str] = None,
        disk_type: Optional[Union[str, "StorageType"]] = None,
        **kwargs
    ):
        super(AttachNewDataDiskOptions, self).__init__(**kwargs)
        self.disk_size_gi_b = disk_size_gi_b
        self.disk_name = disk_name
        self.disk_type = disk_type


class AttachNewDataDiskOptionsFragment(msrest.serialization.Model):
    """Properties to attach new disk to the Virtual Machine.

    :param disk_size_gi_b: Size of the disk to be attached in GibiBytes.
    :type disk_size_gi_b: int
    :param disk_name: The name of the disk to be attached.
    :type disk_name: str
    :param disk_type: The storage type for the disk (i.e. Standard, Premium). Possible values
     include: "Standard", "Premium", "StandardSSD".
    :type disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        'disk_size_gi_b': {'key': 'diskSizeGiB', 'type': 'int'},
        'disk_name': {'key': 'diskName', 'type': 'str'},
        'disk_type': {'key': 'diskType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_size_gi_b: Optional[int] = None,
        disk_name: Optional[str] = None,
        disk_type: Optional[Union[str, "StorageType"]] = None,
        **kwargs
    ):
        super(AttachNewDataDiskOptionsFragment, self).__init__(**kwargs)
        self.disk_size_gi_b = disk_size_gi_b
        self.disk_name = disk_name
        self.disk_type = disk_type


class BulkCreationParameters(msrest.serialization.Model):
    """Parameters for creating multiple virtual machines as a single action.

    :param instance_count: The number of virtual machine instances to create.
    :type instance_count: int
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        instance_count: Optional[int] = None,
        **kwargs
    ):
        super(BulkCreationParameters, self).__init__(**kwargs)
        self.instance_count = instance_count


class BulkCreationParametersFragment(msrest.serialization.Model):
    """Parameters for creating multiple virtual machines as a single action.

    :param instance_count: The number of virtual machine instances to create.
    :type instance_count: int
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        instance_count: Optional[int] = None,
        **kwargs
    ):
        super(BulkCreationParametersFragment, self).__init__(**kwargs)
        self.instance_count = instance_count


class CloudErrorBody(msrest.serialization.Model):
    """Body of an error from a REST request.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    :param target: The error target.
    :type target: str
    :param details: Inner errors.
    :type details: list[~azure.mgmt.devtestlabs.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ComputeDataDisk(msrest.serialization.Model):
    """A data disks attached to a virtual machine.

    :param name: Gets data disk name.
    :type name: str
    :param disk_uri: When backed by a blob, the URI of underlying blob.
    :type disk_uri: str
    :param managed_disk_id: When backed by managed disk, this is the ID of the compute disk
     resource.
    :type managed_disk_id: str
    :param disk_size_gi_b: Gets data disk size in GiB.
    :type disk_size_gi_b: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'disk_uri': {'key': 'diskUri', 'type': 'str'},
        'managed_disk_id': {'key': 'managedDiskId', 'type': 'str'},
        'disk_size_gi_b': {'key': 'diskSizeGiB', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disk_uri: Optional[str] = None,
        managed_disk_id: Optional[str] = None,
        disk_size_gi_b: Optional[int] = None,
        **kwargs
    ):
        super(ComputeDataDisk, self).__init__(**kwargs)
        self.name = name
        self.disk_uri = disk_uri
        self.managed_disk_id = managed_disk_id
        self.disk_size_gi_b = disk_size_gi_b


class ComputeDataDiskFragment(msrest.serialization.Model):
    """A data disks attached to a virtual machine.

    :param name: Gets data disk name.
    :type name: str
    :param disk_uri: When backed by a blob, the URI of underlying blob.
    :type disk_uri: str
    :param managed_disk_id: When backed by managed disk, this is the ID of the compute disk
     resource.
    :type managed_disk_id: str
    :param disk_size_gi_b: Gets data disk size in GiB.
    :type disk_size_gi_b: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'disk_uri': {'key': 'diskUri', 'type': 'str'},
        'managed_disk_id': {'key': 'managedDiskId', 'type': 'str'},
        'disk_size_gi_b': {'key': 'diskSizeGiB', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        disk_uri: Optional[str] = None,
        managed_disk_id: Optional[str] = None,
        disk_size_gi_b: Optional[int] = None,
        **kwargs
    ):
        super(ComputeDataDiskFragment, self).__init__(**kwargs)
        self.name = name
        self.disk_uri = disk_uri
        self.managed_disk_id = managed_disk_id
        self.disk_size_gi_b = disk_size_gi_b


class ComputeVmInstanceViewStatus(msrest.serialization.Model):
    """Status information about a virtual machine.

    :param code: Gets the status Code.
    :type code: str
    :param display_status: Gets the short localizable label for the status.
    :type display_status: str
    :param message: Gets the message associated with the status.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ComputeVmInstanceViewStatus, self).__init__(**kwargs)
        self.code = code
        self.display_status = display_status
        self.message = message


class ComputeVmInstanceViewStatusFragment(msrest.serialization.Model):
    """Status information about a virtual machine.

    :param code: Gets the status Code.
    :type code: str
    :param display_status: Gets the short localizable label for the status.
    :type display_status: str
    :param message: Gets the message associated with the status.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ComputeVmInstanceViewStatusFragment, self).__init__(**kwargs)
        self.code = code
        self.display_status = display_status
        self.message = message


class ComputeVmProperties(msrest.serialization.Model):
    """Properties of a virtual machine returned by the Microsoft.Compute API.

    :param statuses: Gets the statuses of the virtual machine.
    :type statuses: list[~azure.mgmt.devtestlabs.models.ComputeVmInstanceViewStatus]
    :param os_type: Gets the OS type of the virtual machine.
    :type os_type: str
    :param vm_size: Gets the size of the virtual machine.
    :type vm_size: str
    :param network_interface_id: Gets the network interface ID of the virtual machine.
    :type network_interface_id: str
    :param os_disk_id: Gets OS disk blob uri for the virtual machine.
    :type os_disk_id: str
    :param data_disk_ids: Gets data disks blob uri for the virtual machine.
    :type data_disk_ids: list[str]
    :param data_disks: Gets all data disks attached to the virtual machine.
    :type data_disks: list[~azure.mgmt.devtestlabs.models.ComputeDataDisk]
    """

    _attribute_map = {
        'statuses': {'key': 'statuses', 'type': '[ComputeVmInstanceViewStatus]'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'network_interface_id': {'key': 'networkInterfaceId', 'type': 'str'},
        'os_disk_id': {'key': 'osDiskId', 'type': 'str'},
        'data_disk_ids': {'key': 'dataDiskIds', 'type': '[str]'},
        'data_disks': {'key': 'dataDisks', 'type': '[ComputeDataDisk]'},
    }

    def __init__(
        self,
        *,
        statuses: Optional[List["ComputeVmInstanceViewStatus"]] = None,
        os_type: Optional[str] = None,
        vm_size: Optional[str] = None,
        network_interface_id: Optional[str] = None,
        os_disk_id: Optional[str] = None,
        data_disk_ids: Optional[List[str]] = None,
        data_disks: Optional[List["ComputeDataDisk"]] = None,
        **kwargs
    ):
        super(ComputeVmProperties, self).__init__(**kwargs)
        self.statuses = statuses
        self.os_type = os_type
        self.vm_size = vm_size
        self.network_interface_id = network_interface_id
        self.os_disk_id = os_disk_id
        self.data_disk_ids = data_disk_ids
        self.data_disks = data_disks


class ComputeVmPropertiesFragment(msrest.serialization.Model):
    """Properties of a virtual machine returned by the Microsoft.Compute API.

    :param statuses: Gets the statuses of the virtual machine.
    :type statuses: list[~azure.mgmt.devtestlabs.models.ComputeVmInstanceViewStatusFragment]
    :param os_type: Gets the OS type of the virtual machine.
    :type os_type: str
    :param vm_size: Gets the size of the virtual machine.
    :type vm_size: str
    :param network_interface_id: Gets the network interface ID of the virtual machine.
    :type network_interface_id: str
    :param os_disk_id: Gets OS disk blob uri for the virtual machine.
    :type os_disk_id: str
    :param data_disk_ids: Gets data disks blob uri for the virtual machine.
    :type data_disk_ids: list[str]
    :param data_disks: Gets all data disks attached to the virtual machine.
    :type data_disks: list[~azure.mgmt.devtestlabs.models.ComputeDataDiskFragment]
    """

    _attribute_map = {
        'statuses': {'key': 'statuses', 'type': '[ComputeVmInstanceViewStatusFragment]'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'network_interface_id': {'key': 'networkInterfaceId', 'type': 'str'},
        'os_disk_id': {'key': 'osDiskId', 'type': 'str'},
        'data_disk_ids': {'key': 'dataDiskIds', 'type': '[str]'},
        'data_disks': {'key': 'dataDisks', 'type': '[ComputeDataDiskFragment]'},
    }

    def __init__(
        self,
        *,
        statuses: Optional[List["ComputeVmInstanceViewStatusFragment"]] = None,
        os_type: Optional[str] = None,
        vm_size: Optional[str] = None,
        network_interface_id: Optional[str] = None,
        os_disk_id: Optional[str] = None,
        data_disk_ids: Optional[List[str]] = None,
        data_disks: Optional[List["ComputeDataDiskFragment"]] = None,
        **kwargs
    ):
        super(ComputeVmPropertiesFragment, self).__init__(**kwargs)
        self.statuses = statuses
        self.os_type = os_type
        self.vm_size = vm_size
        self.network_interface_id = network_interface_id
        self.os_disk_id = os_disk_id
        self.data_disk_ids = data_disk_ids
        self.data_disks = data_disks


class CostThresholdProperties(msrest.serialization.Model):
    """Properties of a cost threshold item.

    :param threshold_id: The ID of the cost threshold item.
    :type threshold_id: str
    :param percentage_threshold: The value of the percentage cost threshold.
    :type percentage_threshold: ~azure.mgmt.devtestlabs.models.PercentageCostThresholdProperties
    :param display_on_chart: Indicates whether this threshold will be displayed on cost charts.
     Possible values include: "Enabled", "Disabled".
    :type display_on_chart: str or ~azure.mgmt.devtestlabs.models.CostThresholdStatus
    :param send_notification_when_exceeded: Indicates whether notifications will be sent when this
     threshold is exceeded. Possible values include: "Enabled", "Disabled".
    :type send_notification_when_exceeded: str or
     ~azure.mgmt.devtestlabs.models.CostThresholdStatus
    :param notification_sent: Indicates the datetime when notifications were last sent for this
     threshold.
    :type notification_sent: str
    """

    _attribute_map = {
        'threshold_id': {'key': 'thresholdId', 'type': 'str'},
        'percentage_threshold': {'key': 'percentageThreshold', 'type': 'PercentageCostThresholdProperties'},
        'display_on_chart': {'key': 'displayOnChart', 'type': 'str'},
        'send_notification_when_exceeded': {'key': 'sendNotificationWhenExceeded', 'type': 'str'},
        'notification_sent': {'key': 'notificationSent', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        threshold_id: Optional[str] = None,
        percentage_threshold: Optional["PercentageCostThresholdProperties"] = None,
        display_on_chart: Optional[Union[str, "CostThresholdStatus"]] = None,
        send_notification_when_exceeded: Optional[Union[str, "CostThresholdStatus"]] = None,
        notification_sent: Optional[str] = None,
        **kwargs
    ):
        super(CostThresholdProperties, self).__init__(**kwargs)
        self.threshold_id = threshold_id
        self.percentage_threshold = percentage_threshold
        self.display_on_chart = display_on_chart
        self.send_notification_when_exceeded = send_notification_when_exceeded
        self.notification_sent = notification_sent


class CustomImage(Resource):
    """A custom image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param vm: The virtual machine from which the image is to be created.
    :type vm: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromVm
    :param vhd: The VHD from which the image is to be created.
    :type vhd: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesCustom
    :param description: The description of the custom image.
    :type description: str
    :param author: The author of the custom image.
    :type author: str
    :ivar creation_date: The creation date of the custom image.
    :vartype creation_date: ~datetime.datetime
    :param managed_image_id: The Managed Image Id backing the custom image.
    :type managed_image_id: str
    :param managed_snapshot_id: The Managed Snapshot Id backing the custom image.
    :type managed_snapshot_id: str
    :param data_disk_storage_info: Storage information about the data disks present in the custom
     image.
    :type data_disk_storage_info: list[~azure.mgmt.devtestlabs.models.DataDiskStorageTypeInfo]
    :param custom_image_plan: Storage information about the plan related to this custom image.
    :type custom_image_plan: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromPlan
    :param is_plan_authorized: Whether or not the custom images underlying offer/plan has been
     enabled for programmatic deployment.
    :type is_plan_authorized: bool
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'vm': {'key': 'properties.vm', 'type': 'CustomImagePropertiesFromVm'},
        'vhd': {'key': 'properties.vhd', 'type': 'CustomImagePropertiesCustom'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'managed_image_id': {'key': 'properties.managedImageId', 'type': 'str'},
        'managed_snapshot_id': {'key': 'properties.managedSnapshotId', 'type': 'str'},
        'data_disk_storage_info': {'key': 'properties.dataDiskStorageInfo', 'type': '[DataDiskStorageTypeInfo]'},
        'custom_image_plan': {'key': 'properties.customImagePlan', 'type': 'CustomImagePropertiesFromPlan'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        vm: Optional["CustomImagePropertiesFromVm"] = None,
        vhd: Optional["CustomImagePropertiesCustom"] = None,
        description: Optional[str] = None,
        author: Optional[str] = None,
        managed_image_id: Optional[str] = None,
        managed_snapshot_id: Optional[str] = None,
        data_disk_storage_info: Optional[List["DataDiskStorageTypeInfo"]] = None,
        custom_image_plan: Optional["CustomImagePropertiesFromPlan"] = None,
        is_plan_authorized: Optional[bool] = None,
        **kwargs
    ):
        super(CustomImage, self).__init__(location=location, tags=tags, **kwargs)
        self.vm = vm
        self.vhd = vhd
        self.description = description
        self.author = author
        self.creation_date = None
        self.managed_image_id = managed_image_id
        self.managed_snapshot_id = managed_snapshot_id
        self.data_disk_storage_info = data_disk_storage_info
        self.custom_image_plan = custom_image_plan
        self.is_plan_authorized = is_plan_authorized
        self.provisioning_state = None
        self.unique_identifier = None


class CustomImageFragment(UpdateResource):
    """A custom image.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param vm: The virtual machine from which the image is to be created.
    :type vm: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromVmFragment
    :param vhd: The VHD from which the image is to be created.
    :type vhd: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesCustomFragment
    :param description: The description of the custom image.
    :type description: str
    :param author: The author of the custom image.
    :type author: str
    :param managed_image_id: The Managed Image Id backing the custom image.
    :type managed_image_id: str
    :param managed_snapshot_id: The Managed Snapshot Id backing the custom image.
    :type managed_snapshot_id: str
    :param data_disk_storage_info: Storage information about the data disks present in the custom
     image.
    :type data_disk_storage_info:
     list[~azure.mgmt.devtestlabs.models.DataDiskStorageTypeInfoFragment]
    :param custom_image_plan: Storage information about the plan related to this custom image.
    :type custom_image_plan: ~azure.mgmt.devtestlabs.models.CustomImagePropertiesFromPlanFragment
    :param is_plan_authorized: Whether or not the custom images underlying offer/plan has been
     enabled for programmatic deployment.
    :type is_plan_authorized: bool
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'vm': {'key': 'properties.vm', 'type': 'CustomImagePropertiesFromVmFragment'},
        'vhd': {'key': 'properties.vhd', 'type': 'CustomImagePropertiesCustomFragment'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'managed_image_id': {'key': 'properties.managedImageId', 'type': 'str'},
        'managed_snapshot_id': {'key': 'properties.managedSnapshotId', 'type': 'str'},
        'data_disk_storage_info': {'key': 'properties.dataDiskStorageInfo', 'type': '[DataDiskStorageTypeInfoFragment]'},
        'custom_image_plan': {'key': 'properties.customImagePlan', 'type': 'CustomImagePropertiesFromPlanFragment'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        vm: Optional["CustomImagePropertiesFromVmFragment"] = None,
        vhd: Optional["CustomImagePropertiesCustomFragment"] = None,
        description: Optional[str] = None,
        author: Optional[str] = None,
        managed_image_id: Optional[str] = None,
        managed_snapshot_id: Optional[str] = None,
        data_disk_storage_info: Optional[List["DataDiskStorageTypeInfoFragment"]] = None,
        custom_image_plan: Optional["CustomImagePropertiesFromPlanFragment"] = None,
        is_plan_authorized: Optional[bool] = None,
        **kwargs
    ):
        super(CustomImageFragment, self).__init__(tags=tags, **kwargs)
        self.vm = vm
        self.vhd = vhd
        self.description = description
        self.author = author
        self.managed_image_id = managed_image_id
        self.managed_snapshot_id = managed_snapshot_id
        self.data_disk_storage_info = data_disk_storage_info
        self.custom_image_plan = custom_image_plan
        self.is_plan_authorized = is_plan_authorized


class CustomImageList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.CustomImage]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CustomImage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["CustomImage"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CustomImageList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CustomImagePropertiesCustom(msrest.serialization.Model):
    """Properties for creating a custom image from a VHD.

    All required parameters must be populated in order to send to Azure.

    :param image_name: The image name.
    :type image_name: str
    :param sys_prep: Indicates whether sysprep has been run on the VHD.
    :type sys_prep: bool
    :param os_type: Required. The OS type of the custom image (i.e. Windows, Linux). Possible
     values include: "Windows", "Linux", "None".
    :type os_type: str or ~azure.mgmt.devtestlabs.models.CustomImageOsType
    """

    _validation = {
        'os_type': {'required': True},
    }

    _attribute_map = {
        'image_name': {'key': 'imageName', 'type': 'str'},
        'sys_prep': {'key': 'sysPrep', 'type': 'bool'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "CustomImageOsType"],
        image_name: Optional[str] = None,
        sys_prep: Optional[bool] = None,
        **kwargs
    ):
        super(CustomImagePropertiesCustom, self).__init__(**kwargs)
        self.image_name = image_name
        self.sys_prep = sys_prep
        self.os_type = os_type


class CustomImagePropertiesCustomFragment(msrest.serialization.Model):
    """Properties for creating a custom image from a VHD.

    :param image_name: The image name.
    :type image_name: str
    :param sys_prep: Indicates whether sysprep has been run on the VHD.
    :type sys_prep: bool
    :param os_type: The OS type of the custom image (i.e. Windows, Linux). Possible values include:
     "Windows", "Linux", "None".
    :type os_type: str or ~azure.mgmt.devtestlabs.models.CustomImageOsType
    """

    _attribute_map = {
        'image_name': {'key': 'imageName', 'type': 'str'},
        'sys_prep': {'key': 'sysPrep', 'type': 'bool'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        image_name: Optional[str] = None,
        sys_prep: Optional[bool] = None,
        os_type: Optional[Union[str, "CustomImageOsType"]] = None,
        **kwargs
    ):
        super(CustomImagePropertiesCustomFragment, self).__init__(**kwargs)
        self.image_name = image_name
        self.sys_prep = sys_prep
        self.os_type = os_type


class CustomImagePropertiesFromPlan(msrest.serialization.Model):
    """Properties for plan on a custom image.

    :param id: The id of the plan, equivalent to name of the plan.
    :type id: str
    :param publisher: The publisher for the plan from the marketplace image the custom image is
     derived from.
    :type publisher: str
    :param offer: The offer for the plan from the marketplace image the custom image is derived
     from.
    :type offer: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        **kwargs
    ):
        super(CustomImagePropertiesFromPlan, self).__init__(**kwargs)
        self.id = id
        self.publisher = publisher
        self.offer = offer


class CustomImagePropertiesFromPlanFragment(msrest.serialization.Model):
    """Properties for plan on a custom image.

    :param id: The id of the plan, equivalent to name of the plan.
    :type id: str
    :param publisher: The publisher for the plan from the marketplace image the custom image is
     derived from.
    :type publisher: str
    :param offer: The offer for the plan from the marketplace image the custom image is derived
     from.
    :type offer: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        **kwargs
    ):
        super(CustomImagePropertiesFromPlanFragment, self).__init__(**kwargs)
        self.id = id
        self.publisher = publisher
        self.offer = offer


class CustomImagePropertiesFromVm(msrest.serialization.Model):
    """Properties for creating a custom image from a virtual machine.

    :param source_vm_id: The source vm identifier.
    :type source_vm_id: str
    :param windows_os_info: The Windows OS information of the VM.
    :type windows_os_info: ~azure.mgmt.devtestlabs.models.WindowsOsInfo
    :param linux_os_info: The Linux OS information of the VM.
    :type linux_os_info: ~azure.mgmt.devtestlabs.models.LinuxOsInfo
    """

    _attribute_map = {
        'source_vm_id': {'key': 'sourceVmId', 'type': 'str'},
        'windows_os_info': {'key': 'windowsOsInfo', 'type': 'WindowsOsInfo'},
        'linux_os_info': {'key': 'linuxOsInfo', 'type': 'LinuxOsInfo'},
    }

    def __init__(
        self,
        *,
        source_vm_id: Optional[str] = None,
        windows_os_info: Optional["WindowsOsInfo"] = None,
        linux_os_info: Optional["LinuxOsInfo"] = None,
        **kwargs
    ):
        super(CustomImagePropertiesFromVm, self).__init__(**kwargs)
        self.source_vm_id = source_vm_id
        self.windows_os_info = windows_os_info
        self.linux_os_info = linux_os_info


class CustomImagePropertiesFromVmFragment(msrest.serialization.Model):
    """Properties for creating a custom image from a virtual machine.

    :param source_vm_id: The source vm identifier.
    :type source_vm_id: str
    :param windows_os_info: The Windows OS information of the VM.
    :type windows_os_info: ~azure.mgmt.devtestlabs.models.WindowsOsInfoFragment
    :param linux_os_info: The Linux OS information of the VM.
    :type linux_os_info: ~azure.mgmt.devtestlabs.models.LinuxOsInfoFragment
    """

    _attribute_map = {
        'source_vm_id': {'key': 'sourceVmId', 'type': 'str'},
        'windows_os_info': {'key': 'windowsOsInfo', 'type': 'WindowsOsInfoFragment'},
        'linux_os_info': {'key': 'linuxOsInfo', 'type': 'LinuxOsInfoFragment'},
    }

    def __init__(
        self,
        *,
        source_vm_id: Optional[str] = None,
        windows_os_info: Optional["WindowsOsInfoFragment"] = None,
        linux_os_info: Optional["LinuxOsInfoFragment"] = None,
        **kwargs
    ):
        super(CustomImagePropertiesFromVmFragment, self).__init__(**kwargs)
        self.source_vm_id = source_vm_id
        self.windows_os_info = windows_os_info
        self.linux_os_info = linux_os_info


class DataDiskProperties(msrest.serialization.Model):
    """Request body for adding a new or existing data disk to a virtual machine.

    :param attach_new_data_disk_options: Specifies options to attach a new disk to the virtual
     machine.
    :type attach_new_data_disk_options: ~azure.mgmt.devtestlabs.models.AttachNewDataDiskOptions
    :param existing_lab_disk_id: Specifies the existing lab disk id to attach to virtual machine.
    :type existing_lab_disk_id: str
    :param host_caching: Caching option for a data disk (i.e. None, ReadOnly, ReadWrite). Possible
     values include: "None", "ReadOnly", "ReadWrite".
    :type host_caching: str or ~azure.mgmt.devtestlabs.models.HostCachingOptions
    """

    _attribute_map = {
        'attach_new_data_disk_options': {'key': 'attachNewDataDiskOptions', 'type': 'AttachNewDataDiskOptions'},
        'existing_lab_disk_id': {'key': 'existingLabDiskId', 'type': 'str'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        attach_new_data_disk_options: Optional["AttachNewDataDiskOptions"] = None,
        existing_lab_disk_id: Optional[str] = None,
        host_caching: Optional[Union[str, "HostCachingOptions"]] = None,
        **kwargs
    ):
        super(DataDiskProperties, self).__init__(**kwargs)
        self.attach_new_data_disk_options = attach_new_data_disk_options
        self.existing_lab_disk_id = existing_lab_disk_id
        self.host_caching = host_caching


class DataDiskPropertiesFragment(msrest.serialization.Model):
    """Request body for adding a new or existing data disk to a virtual machine.

    :param attach_new_data_disk_options: Specifies options to attach a new disk to the virtual
     machine.
    :type attach_new_data_disk_options:
     ~azure.mgmt.devtestlabs.models.AttachNewDataDiskOptionsFragment
    :param existing_lab_disk_id: Specifies the existing lab disk id to attach to virtual machine.
    :type existing_lab_disk_id: str
    :param host_caching: Caching option for a data disk (i.e. None, ReadOnly, ReadWrite). Possible
     values include: "None", "ReadOnly", "ReadWrite".
    :type host_caching: str or ~azure.mgmt.devtestlabs.models.HostCachingOptions
    """

    _attribute_map = {
        'attach_new_data_disk_options': {'key': 'attachNewDataDiskOptions', 'type': 'AttachNewDataDiskOptionsFragment'},
        'existing_lab_disk_id': {'key': 'existingLabDiskId', 'type': 'str'},
        'host_caching': {'key': 'hostCaching', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        attach_new_data_disk_options: Optional["AttachNewDataDiskOptionsFragment"] = None,
        existing_lab_disk_id: Optional[str] = None,
        host_caching: Optional[Union[str, "HostCachingOptions"]] = None,
        **kwargs
    ):
        super(DataDiskPropertiesFragment, self).__init__(**kwargs)
        self.attach_new_data_disk_options = attach_new_data_disk_options
        self.existing_lab_disk_id = existing_lab_disk_id
        self.host_caching = host_caching


class DataDiskStorageTypeInfo(msrest.serialization.Model):
    """Storage information about the data disks present in the custom image.

    :param lun: Disk Lun.
    :type lun: str
    :param storage_type: Disk Storage Type. Possible values include: "Standard", "Premium",
     "StandardSSD".
    :type storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'str'},
        'storage_type': {'key': 'storageType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lun: Optional[str] = None,
        storage_type: Optional[Union[str, "StorageType"]] = None,
        **kwargs
    ):
        super(DataDiskStorageTypeInfo, self).__init__(**kwargs)
        self.lun = lun
        self.storage_type = storage_type


class DataDiskStorageTypeInfoFragment(msrest.serialization.Model):
    """Storage information about the data disks present in the custom image.

    :param lun: Disk Lun.
    :type lun: str
    :param storage_type: Disk Storage Type. Possible values include: "Standard", "Premium",
     "StandardSSD".
    :type storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    """

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'str'},
        'storage_type': {'key': 'storageType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lun: Optional[str] = None,
        storage_type: Optional[Union[str, "StorageType"]] = None,
        **kwargs
    ):
        super(DataDiskStorageTypeInfoFragment, self).__init__(**kwargs)
        self.lun = lun
        self.storage_type = storage_type


class DayDetails(msrest.serialization.Model):
    """Properties of a daily schedule.

    :param time: The time of day the schedule will occur.
    :type time: str
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time: Optional[str] = None,
        **kwargs
    ):
        super(DayDetails, self).__init__(**kwargs)
        self.time = time


class DayDetailsFragment(msrest.serialization.Model):
    """Properties of a daily schedule.

    :param time: The time of day the schedule will occur.
    :type time: str
    """

    _attribute_map = {
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        time: Optional[str] = None,
        **kwargs
    ):
        super(DayDetailsFragment, self).__init__(**kwargs)
        self.time = time


class DetachDataDiskProperties(msrest.serialization.Model):
    """Request body for detaching data disk from a virtual machine.

    :param existing_lab_disk_id: Specifies the disk resource ID to detach from virtual machine.
    :type existing_lab_disk_id: str
    """

    _attribute_map = {
        'existing_lab_disk_id': {'key': 'existingLabDiskId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        existing_lab_disk_id: Optional[str] = None,
        **kwargs
    ):
        super(DetachDataDiskProperties, self).__init__(**kwargs)
        self.existing_lab_disk_id = existing_lab_disk_id


class DetachDiskProperties(msrest.serialization.Model):
    """Properties of the disk to detach.

    :param leased_by_lab_vm_id: The resource ID of the Lab VM to which the disk is attached.
    :type leased_by_lab_vm_id: str
    """

    _attribute_map = {
        'leased_by_lab_vm_id': {'key': 'leasedByLabVmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        leased_by_lab_vm_id: Optional[str] = None,
        **kwargs
    ):
        super(DetachDiskProperties, self).__init__(**kwargs)
        self.leased_by_lab_vm_id = leased_by_lab_vm_id


class Disk(Resource):
    """A Disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param disk_type: The storage type for the disk (i.e. Standard, Premium). Possible values
     include: "Standard", "Premium", "StandardSSD".
    :type disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :param disk_size_gi_b: The size of the disk in GibiBytes.
    :type disk_size_gi_b: int
    :param leased_by_lab_vm_id: The resource ID of the VM to which this disk is leased.
    :type leased_by_lab_vm_id: str
    :param disk_blob_name: When backed by a blob, the name of the VHD blob without extension.
    :type disk_blob_name: str
    :param disk_uri: When backed by a blob, the URI of underlying blob.
    :type disk_uri: str
    :ivar created_date: The creation date of the disk.
    :vartype created_date: ~datetime.datetime
    :param host_caching: The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
    :type host_caching: str
    :param managed_disk_id: When backed by managed disk, this is the ID of the compute disk
     resource.
    :type managed_disk_id: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'disk_type': {'key': 'properties.diskType', 'type': 'str'},
        'disk_size_gi_b': {'key': 'properties.diskSizeGiB', 'type': 'int'},
        'leased_by_lab_vm_id': {'key': 'properties.leasedByLabVmId', 'type': 'str'},
        'disk_blob_name': {'key': 'properties.diskBlobName', 'type': 'str'},
        'disk_uri': {'key': 'properties.diskUri', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'host_caching': {'key': 'properties.hostCaching', 'type': 'str'},
        'managed_disk_id': {'key': 'properties.managedDiskId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        disk_type: Optional[Union[str, "StorageType"]] = None,
        disk_size_gi_b: Optional[int] = None,
        leased_by_lab_vm_id: Optional[str] = None,
        disk_blob_name: Optional[str] = None,
        disk_uri: Optional[str] = None,
        host_caching: Optional[str] = None,
        managed_disk_id: Optional[str] = None,
        **kwargs
    ):
        super(Disk, self).__init__(location=location, tags=tags, **kwargs)
        self.disk_type = disk_type
        self.disk_size_gi_b = disk_size_gi_b
        self.leased_by_lab_vm_id = leased_by_lab_vm_id
        self.disk_blob_name = disk_blob_name
        self.disk_uri = disk_uri
        self.created_date = None
        self.host_caching = host_caching
        self.managed_disk_id = managed_disk_id
        self.provisioning_state = None
        self.unique_identifier = None


class DiskFragment(UpdateResource):
    """A Disk.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param disk_type: The storage type for the disk (i.e. Standard, Premium). Possible values
     include: "Standard", "Premium", "StandardSSD".
    :type disk_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :param disk_size_gi_b: The size of the disk in GibiBytes.
    :type disk_size_gi_b: int
    :param leased_by_lab_vm_id: The resource ID of the VM to which this disk is leased.
    :type leased_by_lab_vm_id: str
    :param disk_blob_name: When backed by a blob, the name of the VHD blob without extension.
    :type disk_blob_name: str
    :param disk_uri: When backed by a blob, the URI of underlying blob.
    :type disk_uri: str
    :param host_caching: The host caching policy of the disk (i.e. None, ReadOnly, ReadWrite).
    :type host_caching: str
    :param managed_disk_id: When backed by managed disk, this is the ID of the compute disk
     resource.
    :type managed_disk_id: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'disk_type': {'key': 'properties.diskType', 'type': 'str'},
        'disk_size_gi_b': {'key': 'properties.diskSizeGiB', 'type': 'int'},
        'leased_by_lab_vm_id': {'key': 'properties.leasedByLabVmId', 'type': 'str'},
        'disk_blob_name': {'key': 'properties.diskBlobName', 'type': 'str'},
        'disk_uri': {'key': 'properties.diskUri', 'type': 'str'},
        'host_caching': {'key': 'properties.hostCaching', 'type': 'str'},
        'managed_disk_id': {'key': 'properties.managedDiskId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        disk_type: Optional[Union[str, "StorageType"]] = None,
        disk_size_gi_b: Optional[int] = None,
        leased_by_lab_vm_id: Optional[str] = None,
        disk_blob_name: Optional[str] = None,
        disk_uri: Optional[str] = None,
        host_caching: Optional[str] = None,
        managed_disk_id: Optional[str] = None,
        **kwargs
    ):
        super(DiskFragment, self).__init__(tags=tags, **kwargs)
        self.disk_type = disk_type
        self.disk_size_gi_b = disk_size_gi_b
        self.leased_by_lab_vm_id = leased_by_lab_vm_id
        self.disk_blob_name = disk_blob_name
        self.disk_uri = disk_uri
        self.host_caching = host_caching
        self.managed_disk_id = managed_disk_id


class DiskList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.Disk]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Disk]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Disk"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DiskList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DtlEnvironment(Resource):
    """An environment, which is essentially an ARM template deployment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param deployment_properties: The deployment properties of the environment.
    :type deployment_properties: ~azure.mgmt.devtestlabs.models.EnvironmentDeploymentProperties
    :param arm_template_display_name: The display name of the Azure Resource Manager template that
     produced the environment.
    :type arm_template_display_name: str
    :ivar resource_group_id: The identifier of the resource group containing the environment's
     resources.
    :vartype resource_group_id: str
    :ivar created_by_user: The creator of the environment.
    :vartype created_by_user: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_group_id': {'readonly': True},
        'created_by_user': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'deployment_properties': {'key': 'properties.deploymentProperties', 'type': 'EnvironmentDeploymentProperties'},
        'arm_template_display_name': {'key': 'properties.armTemplateDisplayName', 'type': 'str'},
        'resource_group_id': {'key': 'properties.resourceGroupId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        deployment_properties: Optional["EnvironmentDeploymentProperties"] = None,
        arm_template_display_name: Optional[str] = None,
        **kwargs
    ):
        super(DtlEnvironment, self).__init__(location=location, tags=tags, **kwargs)
        self.deployment_properties = deployment_properties
        self.arm_template_display_name = arm_template_display_name
        self.resource_group_id = None
        self.created_by_user = None
        self.provisioning_state = None
        self.unique_identifier = None


class DtlEnvironmentFragment(UpdateResource):
    """An environment, which is essentially an ARM template deployment.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param deployment_properties: The deployment properties of the environment.
    :type deployment_properties:
     ~azure.mgmt.devtestlabs.models.EnvironmentDeploymentPropertiesFragment
    :param arm_template_display_name: The display name of the Azure Resource Manager template that
     produced the environment.
    :type arm_template_display_name: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'deployment_properties': {'key': 'properties.deploymentProperties', 'type': 'EnvironmentDeploymentPropertiesFragment'},
        'arm_template_display_name': {'key': 'properties.armTemplateDisplayName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        deployment_properties: Optional["EnvironmentDeploymentPropertiesFragment"] = None,
        arm_template_display_name: Optional[str] = None,
        **kwargs
    ):
        super(DtlEnvironmentFragment, self).__init__(tags=tags, **kwargs)
        self.deployment_properties = deployment_properties
        self.arm_template_display_name = arm_template_display_name


class DtlEnvironmentList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.DtlEnvironment]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DtlEnvironment]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DtlEnvironment"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DtlEnvironmentList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EnvironmentDeploymentProperties(msrest.serialization.Model):
    """Properties of an environment deployment.

    :param arm_template_id: The Azure Resource Manager template's identifier.
    :type arm_template_id: str
    :param parameters: The parameters of the Azure Resource Manager template.
    :type parameters: list[~azure.mgmt.devtestlabs.models.ArmTemplateParameterProperties]
    """

    _attribute_map = {
        'arm_template_id': {'key': 'armTemplateId', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ArmTemplateParameterProperties]'},
    }

    def __init__(
        self,
        *,
        arm_template_id: Optional[str] = None,
        parameters: Optional[List["ArmTemplateParameterProperties"]] = None,
        **kwargs
    ):
        super(EnvironmentDeploymentProperties, self).__init__(**kwargs)
        self.arm_template_id = arm_template_id
        self.parameters = parameters


class EnvironmentDeploymentPropertiesFragment(msrest.serialization.Model):
    """Properties of an environment deployment.

    :param arm_template_id: The Azure Resource Manager template's identifier.
    :type arm_template_id: str
    :param parameters: The parameters of the Azure Resource Manager template.
    :type parameters: list[~azure.mgmt.devtestlabs.models.ArmTemplateParameterPropertiesFragment]
    """

    _attribute_map = {
        'arm_template_id': {'key': 'armTemplateId', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ArmTemplateParameterPropertiesFragment]'},
    }

    def __init__(
        self,
        *,
        arm_template_id: Optional[str] = None,
        parameters: Optional[List["ArmTemplateParameterPropertiesFragment"]] = None,
        **kwargs
    ):
        super(EnvironmentDeploymentPropertiesFragment, self).__init__(**kwargs)
        self.arm_template_id = arm_template_id
        self.parameters = parameters


class EvaluatePoliciesProperties(msrest.serialization.Model):
    """Properties for evaluating a policy set.

    :param fact_name: The fact name.
    :type fact_name: str
    :param fact_data: The fact data.
    :type fact_data: str
    :param value_offset: The value offset.
    :type value_offset: str
    :param user_object_id: The user for which policies will be evaluated.
    :type user_object_id: str
    """

    _attribute_map = {
        'fact_name': {'key': 'factName', 'type': 'str'},
        'fact_data': {'key': 'factData', 'type': 'str'},
        'value_offset': {'key': 'valueOffset', 'type': 'str'},
        'user_object_id': {'key': 'userObjectId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        fact_name: Optional[str] = None,
        fact_data: Optional[str] = None,
        value_offset: Optional[str] = None,
        user_object_id: Optional[str] = None,
        **kwargs
    ):
        super(EvaluatePoliciesProperties, self).__init__(**kwargs)
        self.fact_name = fact_name
        self.fact_data = fact_data
        self.value_offset = value_offset
        self.user_object_id = user_object_id


class EvaluatePoliciesRequest(msrest.serialization.Model):
    """Request body for evaluating a policy set.

    :param policies: Policies to evaluate.
    :type policies: list[~azure.mgmt.devtestlabs.models.EvaluatePoliciesProperties]
    """

    _attribute_map = {
        'policies': {'key': 'policies', 'type': '[EvaluatePoliciesProperties]'},
    }

    def __init__(
        self,
        *,
        policies: Optional[List["EvaluatePoliciesProperties"]] = None,
        **kwargs
    ):
        super(EvaluatePoliciesRequest, self).__init__(**kwargs)
        self.policies = policies


class EvaluatePoliciesResponse(msrest.serialization.Model):
    """Response body for evaluating a policy set.

    :param results: Results of evaluating a policy set.
    :type results: list[~azure.mgmt.devtestlabs.models.PolicySetResult]
    """

    _attribute_map = {
        'results': {'key': 'results', 'type': '[PolicySetResult]'},
    }

    def __init__(
        self,
        *,
        results: Optional[List["PolicySetResult"]] = None,
        **kwargs
    ):
        super(EvaluatePoliciesResponse, self).__init__(**kwargs)
        self.results = results


class Event(msrest.serialization.Model):
    """An event to be notified for.

    :param event_name: The event type for which this notification is enabled (i.e. AutoShutdown,
     Cost). Possible values include: "AutoShutdown", "Cost".
    :type event_name: str or ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
    """

    _attribute_map = {
        'event_name': {'key': 'eventName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_name: Optional[Union[str, "NotificationChannelEventType"]] = None,
        **kwargs
    ):
        super(Event, self).__init__(**kwargs)
        self.event_name = event_name


class EventFragment(msrest.serialization.Model):
    """An event to be notified for.

    :param event_name: The event type for which this notification is enabled (i.e. AutoShutdown,
     Cost). Possible values include: "AutoShutdown", "Cost".
    :type event_name: str or ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
    """

    _attribute_map = {
        'event_name': {'key': 'eventName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_name: Optional[Union[str, "NotificationChannelEventType"]] = None,
        **kwargs
    ):
        super(EventFragment, self).__init__(**kwargs)
        self.event_name = event_name


class ExportResourceUsageParameters(msrest.serialization.Model):
    """The parameters of the export operation.

    :param blob_storage_absolute_sas_uri: The blob storage absolute sas uri with write permission
     to the container which the usage data needs to be uploaded to.
    :type blob_storage_absolute_sas_uri: str
    :param usage_start_date: The start time of the usage. If not provided, usage will be reported
     since the beginning of data collection.
    :type usage_start_date: ~datetime.datetime
    """

    _attribute_map = {
        'blob_storage_absolute_sas_uri': {'key': 'blobStorageAbsoluteSasUri', 'type': 'str'},
        'usage_start_date': {'key': 'usageStartDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        blob_storage_absolute_sas_uri: Optional[str] = None,
        usage_start_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(ExportResourceUsageParameters, self).__init__(**kwargs)
        self.blob_storage_absolute_sas_uri = blob_storage_absolute_sas_uri
        self.usage_start_date = usage_start_date


class ExternalSubnet(msrest.serialization.Model):
    """Subnet information as returned by the Microsoft.Network API.

    :param id: Gets or sets the identifier.
    :type id: str
    :param name: Gets or sets the name.
    :type name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ExternalSubnet, self).__init__(**kwargs)
        self.id = id
        self.name = name


class ExternalSubnetFragment(msrest.serialization.Model):
    """Subnet information as returned by the Microsoft.Network API.

    :param id: Gets or sets the identifier.
    :type id: str
    :param name: Gets or sets the name.
    :type name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ExternalSubnetFragment, self).__init__(**kwargs)
        self.id = id
        self.name = name


class Formula(Resource):
    """A formula for creating a VM, specifying an image base and other parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param description: The description of the formula.
    :type description: str
    :param author: The author of the formula.
    :type author: str
    :param os_type: The OS type of the formula.
    :type os_type: str
    :ivar creation_date: The creation date of the formula.
    :vartype creation_date: ~datetime.datetime
    :param formula_content: The content of the formula.
    :type formula_content: ~azure.mgmt.devtestlabs.models.LabVirtualMachineCreationParameter
    :param vm: Information about a VM from which a formula is to be created.
    :type vm: ~azure.mgmt.devtestlabs.models.FormulaPropertiesFromVm
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'formula_content': {'key': 'properties.formulaContent', 'type': 'LabVirtualMachineCreationParameter'},
        'vm': {'key': 'properties.vm', 'type': 'FormulaPropertiesFromVm'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        author: Optional[str] = None,
        os_type: Optional[str] = None,
        formula_content: Optional["LabVirtualMachineCreationParameter"] = None,
        vm: Optional["FormulaPropertiesFromVm"] = None,
        **kwargs
    ):
        super(Formula, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.author = author
        self.os_type = os_type
        self.creation_date = None
        self.formula_content = formula_content
        self.vm = vm
        self.provisioning_state = None
        self.unique_identifier = None


class FormulaFragment(UpdateResource):
    """A formula for creating a VM, specifying an image base and other parameters.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param description: The description of the formula.
    :type description: str
    :param author: The author of the formula.
    :type author: str
    :param os_type: The OS type of the formula.
    :type os_type: str
    :param formula_content: The content of the formula.
    :type formula_content:
     ~azure.mgmt.devtestlabs.models.LabVirtualMachineCreationParameterFragment
    :param vm: Information about a VM from which a formula is to be created.
    :type vm: ~azure.mgmt.devtestlabs.models.FormulaPropertiesFromVmFragment
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'formula_content': {'key': 'properties.formulaContent', 'type': 'LabVirtualMachineCreationParameterFragment'},
        'vm': {'key': 'properties.vm', 'type': 'FormulaPropertiesFromVmFragment'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        author: Optional[str] = None,
        os_type: Optional[str] = None,
        formula_content: Optional["LabVirtualMachineCreationParameterFragment"] = None,
        vm: Optional["FormulaPropertiesFromVmFragment"] = None,
        **kwargs
    ):
        super(FormulaFragment, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.author = author
        self.os_type = os_type
        self.formula_content = formula_content
        self.vm = vm


class FormulaList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.Formula]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Formula]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Formula"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(FormulaList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FormulaPropertiesFromVm(msrest.serialization.Model):
    """Information about a VM from which a formula is to be created.

    :param lab_vm_id: The identifier of the VM from which a formula is to be created.
    :type lab_vm_id: str
    """

    _attribute_map = {
        'lab_vm_id': {'key': 'labVmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lab_vm_id: Optional[str] = None,
        **kwargs
    ):
        super(FormulaPropertiesFromVm, self).__init__(**kwargs)
        self.lab_vm_id = lab_vm_id


class FormulaPropertiesFromVmFragment(msrest.serialization.Model):
    """Information about a VM from which a formula is to be created.

    :param lab_vm_id: The identifier of the VM from which a formula is to be created.
    :type lab_vm_id: str
    """

    _attribute_map = {
        'lab_vm_id': {'key': 'labVmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lab_vm_id: Optional[str] = None,
        **kwargs
    ):
        super(FormulaPropertiesFromVmFragment, self).__init__(**kwargs)
        self.lab_vm_id = lab_vm_id


class GalleryImage(Resource):
    """A gallery image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param author: The author of the gallery image.
    :type author: str
    :ivar created_date: The creation date of the gallery image.
    :vartype created_date: ~datetime.datetime
    :param description: The description of the gallery image.
    :type description: str
    :param image_reference: The image reference of the gallery image.
    :type image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReference
    :param icon: The icon of the gallery image.
    :type icon: str
    :param enabled: Indicates whether this gallery image is enabled.
    :type enabled: bool
    :param plan_id: The third party plan that applies to this image.
    :type plan_id: str
    :param is_plan_authorized: Indicates if the plan has been authorized for programmatic
     deployment.
    :type is_plan_authorized: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'author': {'key': 'properties.author', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'image_reference': {'key': 'properties.imageReference', 'type': 'GalleryImageReference'},
        'icon': {'key': 'properties.icon', 'type': 'str'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'is_plan_authorized': {'key': 'properties.isPlanAuthorized', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        author: Optional[str] = None,
        description: Optional[str] = None,
        image_reference: Optional["GalleryImageReference"] = None,
        icon: Optional[str] = None,
        enabled: Optional[bool] = None,
        plan_id: Optional[str] = None,
        is_plan_authorized: Optional[bool] = None,
        **kwargs
    ):
        super(GalleryImage, self).__init__(location=location, tags=tags, **kwargs)
        self.author = author
        self.created_date = None
        self.description = description
        self.image_reference = image_reference
        self.icon = icon
        self.enabled = enabled
        self.plan_id = plan_id
        self.is_plan_authorized = is_plan_authorized


class GalleryImageList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.GalleryImage]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GalleryImage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["GalleryImage"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(GalleryImageList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GalleryImageReference(msrest.serialization.Model):
    """The reference information for an Azure Marketplace image.

    :param offer: The offer of the gallery image.
    :type offer: str
    :param publisher: The publisher of the gallery image.
    :type publisher: str
    :param sku: The SKU of the gallery image.
    :type sku: str
    :param os_type: The OS type of the gallery image.
    :type os_type: str
    :param version: The version of the gallery image.
    :type version: str
    """

    _attribute_map = {
        'offer': {'key': 'offer', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        offer: Optional[str] = None,
        publisher: Optional[str] = None,
        sku: Optional[str] = None,
        os_type: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(GalleryImageReference, self).__init__(**kwargs)
        self.offer = offer
        self.publisher = publisher
        self.sku = sku
        self.os_type = os_type
        self.version = version


class GalleryImageReferenceFragment(msrest.serialization.Model):
    """The reference information for an Azure Marketplace image.

    :param offer: The offer of the gallery image.
    :type offer: str
    :param publisher: The publisher of the gallery image.
    :type publisher: str
    :param sku: The SKU of the gallery image.
    :type sku: str
    :param os_type: The OS type of the gallery image.
    :type os_type: str
    :param version: The version of the gallery image.
    :type version: str
    """

    _attribute_map = {
        'offer': {'key': 'offer', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        offer: Optional[str] = None,
        publisher: Optional[str] = None,
        sku: Optional[str] = None,
        os_type: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(GalleryImageReferenceFragment, self).__init__(**kwargs)
        self.offer = offer
        self.publisher = publisher
        self.sku = sku
        self.os_type = os_type
        self.version = version


class GenerateArmTemplateRequest(msrest.serialization.Model):
    """Parameters for generating an ARM template for deploying artifacts.

    :param virtual_machine_name: The resource name of the virtual machine.
    :type virtual_machine_name: str
    :param parameters: The parameters of the ARM template.
    :type parameters: list[~azure.mgmt.devtestlabs.models.ParameterInfo]
    :param location: The location of the virtual machine.
    :type location: str
    :param file_upload_options: Options for uploading the files for the artifact.
     UploadFilesAndGenerateSasTokens is the default value. Possible values include:
     "UploadFilesAndGenerateSasTokens", "None".
    :type file_upload_options: str or ~azure.mgmt.devtestlabs.models.FileUploadOptions
    """

    _attribute_map = {
        'virtual_machine_name': {'key': 'virtualMachineName', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '[ParameterInfo]'},
        'location': {'key': 'location', 'type': 'str'},
        'file_upload_options': {'key': 'fileUploadOptions', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_machine_name: Optional[str] = None,
        parameters: Optional[List["ParameterInfo"]] = None,
        location: Optional[str] = None,
        file_upload_options: Optional[Union[str, "FileUploadOptions"]] = None,
        **kwargs
    ):
        super(GenerateArmTemplateRequest, self).__init__(**kwargs)
        self.virtual_machine_name = virtual_machine_name
        self.parameters = parameters
        self.location = location
        self.file_upload_options = file_upload_options


class GenerateUploadUriParameter(msrest.serialization.Model):
    """Properties for generating an upload URI.

    :param blob_name: The blob name of the upload URI.
    :type blob_name: str
    """

    _attribute_map = {
        'blob_name': {'key': 'blobName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        blob_name: Optional[str] = None,
        **kwargs
    ):
        super(GenerateUploadUriParameter, self).__init__(**kwargs)
        self.blob_name = blob_name


class GenerateUploadUriResponse(msrest.serialization.Model):
    """Response body for generating an upload URI.

    :param upload_uri: The upload URI for the VHD.
    :type upload_uri: str
    """

    _attribute_map = {
        'upload_uri': {'key': 'uploadUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        upload_uri: Optional[str] = None,
        **kwargs
    ):
        super(GenerateUploadUriResponse, self).__init__(**kwargs)
        self.upload_uri = upload_uri


class HourDetails(msrest.serialization.Model):
    """Properties of an hourly schedule.

    :param minute: Minutes of the hour the schedule will run.
    :type minute: int
    """

    _attribute_map = {
        'minute': {'key': 'minute', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        minute: Optional[int] = None,
        **kwargs
    ):
        super(HourDetails, self).__init__(**kwargs)
        self.minute = minute


class HourDetailsFragment(msrest.serialization.Model):
    """Properties of an hourly schedule.

    :param minute: Minutes of the hour the schedule will run.
    :type minute: int
    """

    _attribute_map = {
        'minute': {'key': 'minute', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        minute: Optional[int] = None,
        **kwargs
    ):
        super(HourDetailsFragment, self).__init__(**kwargs)
        self.minute = minute


class IdentityProperties(msrest.serialization.Model):
    """Properties of a managed identity.

    :param type: Managed identity.
    :type type: str
    :param principal_id: The principal id of resource identity.
    :type principal_id: str
    :param tenant_id: The tenant identifier of resource.
    :type tenant_id: str
    :param client_secret_url: The client secret URL of the identity.
    :type client_secret_url: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'client_secret_url': {'key': 'clientSecretUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        client_secret_url: Optional[str] = None,
        **kwargs
    ):
        super(IdentityProperties, self).__init__(**kwargs)
        self.type = type
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.client_secret_url = client_secret_url


class ImportLabVirtualMachineRequest(msrest.serialization.Model):
    """This represents the payload required to import a virtual machine from a different lab into the current one.

    :param source_virtual_machine_resource_id: The full resource ID of the virtual machine to be
     imported.
    :type source_virtual_machine_resource_id: str
    :param destination_virtual_machine_name: The name of the virtual machine in the destination
     lab.
    :type destination_virtual_machine_name: str
    """

    _attribute_map = {
        'source_virtual_machine_resource_id': {'key': 'sourceVirtualMachineResourceId', 'type': 'str'},
        'destination_virtual_machine_name': {'key': 'destinationVirtualMachineName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_virtual_machine_resource_id: Optional[str] = None,
        destination_virtual_machine_name: Optional[str] = None,
        **kwargs
    ):
        super(ImportLabVirtualMachineRequest, self).__init__(**kwargs)
        self.source_virtual_machine_resource_id = source_virtual_machine_resource_id
        self.destination_virtual_machine_name = destination_virtual_machine_name


class InboundNatRule(msrest.serialization.Model):
    """A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load balancer.

    :param transport_protocol: The transport protocol for the endpoint. Possible values include:
     "Tcp", "Udp".
    :type transport_protocol: str or ~azure.mgmt.devtestlabs.models.TransportProtocol
    :param frontend_port: The external endpoint port of the inbound connection. Possible values
     range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
    :type frontend_port: int
    :param backend_port: The port to which the external traffic will be redirected.
    :type backend_port: int
    """

    _attribute_map = {
        'transport_protocol': {'key': 'transportProtocol', 'type': 'str'},
        'frontend_port': {'key': 'frontendPort', 'type': 'int'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        transport_protocol: Optional[Union[str, "TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        **kwargs
    ):
        super(InboundNatRule, self).__init__(**kwargs)
        self.transport_protocol = transport_protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port


class InboundNatRuleFragment(msrest.serialization.Model):
    """A rule for NAT - exposing a VM's port (backendPort) on the public IP address using a load balancer.

    :param transport_protocol: The transport protocol for the endpoint. Possible values include:
     "Tcp", "Udp".
    :type transport_protocol: str or ~azure.mgmt.devtestlabs.models.TransportProtocol
    :param frontend_port: The external endpoint port of the inbound connection. Possible values
     range between 1 and 65535, inclusive. If unspecified, a value will be allocated automatically.
    :type frontend_port: int
    :param backend_port: The port to which the external traffic will be redirected.
    :type backend_port: int
    """

    _attribute_map = {
        'transport_protocol': {'key': 'transportProtocol', 'type': 'str'},
        'frontend_port': {'key': 'frontendPort', 'type': 'int'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        transport_protocol: Optional[Union[str, "TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        **kwargs
    ):
        super(InboundNatRuleFragment, self).__init__(**kwargs)
        self.transport_protocol = transport_protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port


class Lab(Resource):
    """A lab.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :ivar default_storage_account: The lab's default storage account.
    :vartype default_storage_account: str
    :ivar default_premium_storage_account: The lab's default premium storage account.
    :vartype default_premium_storage_account: str
    :ivar artifacts_storage_account: The lab's artifact storage account.
    :vartype artifacts_storage_account: str
    :ivar premium_data_disk_storage_account: The lab's premium data disk storage account.
    :vartype premium_data_disk_storage_account: str
    :ivar vault_name: The lab's Key vault.
    :vartype vault_name: str
    :param lab_storage_type: Type of storage used by the lab. It can be either Premium or Standard.
     Default is Premium. Possible values include: "Standard", "Premium", "StandardSSD".
    :type lab_storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :param mandatory_artifacts_resource_ids_linux: The ordered list of artifact resource IDs that
     should be applied on all Linux VM creations by default, prior to the artifacts specified by the
     user.
    :type mandatory_artifacts_resource_ids_linux: list[str]
    :param mandatory_artifacts_resource_ids_windows: The ordered list of artifact resource IDs that
     should be applied on all Windows VM creations by default, prior to the artifacts specified by
     the user.
    :type mandatory_artifacts_resource_ids_windows: list[str]
    :ivar created_date: The creation date of the lab.
    :vartype created_date: ~datetime.datetime
    :param premium_data_disks: The setting to enable usage of premium data disks.
     When its value is 'Enabled', creation of standard or premium data disks is allowed.
     When its value is 'Disabled', only creation of standard data disks is allowed. Possible values
     include: "Disabled", "Enabled".
    :type premium_data_disks: str or ~azure.mgmt.devtestlabs.models.PremiumDataDisk
    :param environment_permission: The access rights to be granted to the user when provisioning an
     environment. Possible values include: "Reader", "Contributor".
    :type environment_permission: str or ~azure.mgmt.devtestlabs.models.EnvironmentPermission
    :param announcement: The properties of any lab announcement associated with this lab.
    :type announcement: ~azure.mgmt.devtestlabs.models.LabAnnouncementProperties
    :param support: The properties of any lab support message associated with this lab.
    :type support: ~azure.mgmt.devtestlabs.models.LabSupportProperties
    :ivar vm_creation_resource_group: The resource group in which all new lab virtual machines will
     be created. To let DevTest Labs manage resource group creation, set this value to null.
    :vartype vm_creation_resource_group: str
    :ivar public_ip_id: The public IP address for the lab's load balancer.
    :vartype public_ip_id: str
    :ivar load_balancer_id: The load balancer used to for lab VMs that use shared IP address.
    :vartype load_balancer_id: str
    :ivar network_security_group_id: The Network Security Group attached to the lab VMs Network
     interfaces to restrict open ports.
    :vartype network_security_group_id: str
    :param extended_properties: Extended properties of the lab used for experimental features.
    :type extended_properties: dict[str, str]
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'default_storage_account': {'readonly': True},
        'default_premium_storage_account': {'readonly': True},
        'artifacts_storage_account': {'readonly': True},
        'premium_data_disk_storage_account': {'readonly': True},
        'vault_name': {'readonly': True},
        'created_date': {'readonly': True},
        'vm_creation_resource_group': {'readonly': True},
        'public_ip_id': {'readonly': True},
        'load_balancer_id': {'readonly': True},
        'network_security_group_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'default_storage_account': {'key': 'properties.defaultStorageAccount', 'type': 'str'},
        'default_premium_storage_account': {'key': 'properties.defaultPremiumStorageAccount', 'type': 'str'},
        'artifacts_storage_account': {'key': 'properties.artifactsStorageAccount', 'type': 'str'},
        'premium_data_disk_storage_account': {'key': 'properties.premiumDataDiskStorageAccount', 'type': 'str'},
        'vault_name': {'key': 'properties.vaultName', 'type': 'str'},
        'lab_storage_type': {'key': 'properties.labStorageType', 'type': 'str'},
        'mandatory_artifacts_resource_ids_linux': {'key': 'properties.mandatoryArtifactsResourceIdsLinux', 'type': '[str]'},
        'mandatory_artifacts_resource_ids_windows': {'key': 'properties.mandatoryArtifactsResourceIdsWindows', 'type': '[str]'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'premium_data_disks': {'key': 'properties.premiumDataDisks', 'type': 'str'},
        'environment_permission': {'key': 'properties.environmentPermission', 'type': 'str'},
        'announcement': {'key': 'properties.announcement', 'type': 'LabAnnouncementProperties'},
        'support': {'key': 'properties.support', 'type': 'LabSupportProperties'},
        'vm_creation_resource_group': {'key': 'properties.vmCreationResourceGroup', 'type': 'str'},
        'public_ip_id': {'key': 'properties.publicIpId', 'type': 'str'},
        'load_balancer_id': {'key': 'properties.loadBalancerId', 'type': 'str'},
        'network_security_group_id': {'key': 'properties.networkSecurityGroupId', 'type': 'str'},
        'extended_properties': {'key': 'properties.extendedProperties', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        lab_storage_type: Optional[Union[str, "StorageType"]] = None,
        mandatory_artifacts_resource_ids_linux: Optional[List[str]] = None,
        mandatory_artifacts_resource_ids_windows: Optional[List[str]] = None,
        premium_data_disks: Optional[Union[str, "PremiumDataDisk"]] = None,
        environment_permission: Optional[Union[str, "EnvironmentPermission"]] = None,
        announcement: Optional["LabAnnouncementProperties"] = None,
        support: Optional["LabSupportProperties"] = None,
        extended_properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Lab, self).__init__(location=location, tags=tags, **kwargs)
        self.default_storage_account = None
        self.default_premium_storage_account = None
        self.artifacts_storage_account = None
        self.premium_data_disk_storage_account = None
        self.vault_name = None
        self.lab_storage_type = lab_storage_type
        self.mandatory_artifacts_resource_ids_linux = mandatory_artifacts_resource_ids_linux
        self.mandatory_artifacts_resource_ids_windows = mandatory_artifacts_resource_ids_windows
        self.created_date = None
        self.premium_data_disks = premium_data_disks
        self.environment_permission = environment_permission
        self.announcement = announcement
        self.support = support
        self.vm_creation_resource_group = None
        self.public_ip_id = None
        self.load_balancer_id = None
        self.network_security_group_id = None
        self.extended_properties = extended_properties
        self.provisioning_state = None
        self.unique_identifier = None


class LabAnnouncementProperties(msrest.serialization.Model):
    """Properties of a lab's announcement banner.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param title: The plain text title for the lab announcement.
    :type title: str
    :param markdown: The markdown text (if any) that this lab displays in the UI. If left
     empty/null, nothing will be shown.
    :type markdown: str
    :param enabled: Is the lab announcement active/enabled at this time?. Possible values include:
     "Enabled", "Disabled".
    :type enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param expiration_date: The time at which the announcement expires (null for never).
    :type expiration_date: ~datetime.datetime
    :param expired: Has this announcement expired?.
    :type expired: bool
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'markdown': {'key': 'markdown', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'expired': {'key': 'expired', 'type': 'bool'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        markdown: Optional[str] = None,
        enabled: Optional[Union[str, "EnableStatus"]] = None,
        expiration_date: Optional[datetime.datetime] = None,
        expired: Optional[bool] = None,
        **kwargs
    ):
        super(LabAnnouncementProperties, self).__init__(**kwargs)
        self.title = title
        self.markdown = markdown
        self.enabled = enabled
        self.expiration_date = expiration_date
        self.expired = expired
        self.provisioning_state = None
        self.unique_identifier = None


class LabAnnouncementPropertiesFragment(msrest.serialization.Model):
    """Properties of a lab's announcement banner.

    :param title: The plain text title for the lab announcement.
    :type title: str
    :param markdown: The markdown text (if any) that this lab displays in the UI. If left
     empty/null, nothing will be shown.
    :type markdown: str
    :param enabled: Is the lab announcement active/enabled at this time?. Possible values include:
     "Enabled", "Disabled".
    :type enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param expiration_date: The time at which the announcement expires (null for never).
    :type expiration_date: ~datetime.datetime
    :param expired: Has this announcement expired?.
    :type expired: bool
    """

    _attribute_map = {
        'title': {'key': 'title', 'type': 'str'},
        'markdown': {'key': 'markdown', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'str'},
        'expiration_date': {'key': 'expirationDate', 'type': 'iso-8601'},
        'expired': {'key': 'expired', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        title: Optional[str] = None,
        markdown: Optional[str] = None,
        enabled: Optional[Union[str, "EnableStatus"]] = None,
        expiration_date: Optional[datetime.datetime] = None,
        expired: Optional[bool] = None,
        **kwargs
    ):
        super(LabAnnouncementPropertiesFragment, self).__init__(**kwargs)
        self.title = title
        self.markdown = markdown
        self.enabled = enabled
        self.expiration_date = expiration_date
        self.expired = expired


class LabCost(Resource):
    """A cost item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param target_cost: The target cost properties.
    :type target_cost: ~azure.mgmt.devtestlabs.models.TargetCostProperties
    :ivar lab_cost_summary: The lab cost summary component of the cost data.
    :vartype lab_cost_summary: ~azure.mgmt.devtestlabs.models.LabCostSummaryProperties
    :ivar lab_cost_details: The lab cost details component of the cost data.
    :vartype lab_cost_details: list[~azure.mgmt.devtestlabs.models.LabCostDetailsProperties]
    :ivar resource_costs: The resource cost component of the cost data.
    :vartype resource_costs: list[~azure.mgmt.devtestlabs.models.LabResourceCostProperties]
    :param currency_code: The currency code of the cost.
    :type currency_code: str
    :param start_date_time: The start time of the cost data.
    :type start_date_time: ~datetime.datetime
    :param end_date_time: The end time of the cost data.
    :type end_date_time: ~datetime.datetime
    :param created_date: The creation date of the cost.
    :type created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'lab_cost_summary': {'readonly': True},
        'lab_cost_details': {'readonly': True},
        'resource_costs': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'target_cost': {'key': 'properties.targetCost', 'type': 'TargetCostProperties'},
        'lab_cost_summary': {'key': 'properties.labCostSummary', 'type': 'LabCostSummaryProperties'},
        'lab_cost_details': {'key': 'properties.labCostDetails', 'type': '[LabCostDetailsProperties]'},
        'resource_costs': {'key': 'properties.resourceCosts', 'type': '[LabResourceCostProperties]'},
        'currency_code': {'key': 'properties.currencyCode', 'type': 'str'},
        'start_date_time': {'key': 'properties.startDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'properties.endDateTime', 'type': 'iso-8601'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        target_cost: Optional["TargetCostProperties"] = None,
        currency_code: Optional[str] = None,
        start_date_time: Optional[datetime.datetime] = None,
        end_date_time: Optional[datetime.datetime] = None,
        created_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(LabCost, self).__init__(location=location, tags=tags, **kwargs)
        self.target_cost = target_cost
        self.lab_cost_summary = None
        self.lab_cost_details = None
        self.resource_costs = None
        self.currency_code = currency_code
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.created_date = created_date
        self.provisioning_state = None
        self.unique_identifier = None


class LabCostDetailsProperties(msrest.serialization.Model):
    """The properties of a lab cost item.

    :param date: The date of the cost item.
    :type date: ~datetime.datetime
    :param cost: The cost component of the cost item.
    :type cost: float
    :param cost_type: The type of the cost. Possible values include: "Unavailable", "Reported",
     "Projected".
    :type cost_type: str or ~azure.mgmt.devtestlabs.models.CostType
    """

    _attribute_map = {
        'date': {'key': 'date', 'type': 'iso-8601'},
        'cost': {'key': 'cost', 'type': 'float'},
        'cost_type': {'key': 'costType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        date: Optional[datetime.datetime] = None,
        cost: Optional[float] = None,
        cost_type: Optional[Union[str, "CostType"]] = None,
        **kwargs
    ):
        super(LabCostDetailsProperties, self).__init__(**kwargs)
        self.date = date
        self.cost = cost
        self.cost_type = cost_type


class LabCostSummaryProperties(msrest.serialization.Model):
    """The properties of the cost summary.

    :param estimated_lab_cost: The cost component of the cost item.
    :type estimated_lab_cost: float
    """

    _attribute_map = {
        'estimated_lab_cost': {'key': 'estimatedLabCost', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        estimated_lab_cost: Optional[float] = None,
        **kwargs
    ):
        super(LabCostSummaryProperties, self).__init__(**kwargs)
        self.estimated_lab_cost = estimated_lab_cost


class LabFragment(UpdateResource):
    """A lab.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param lab_storage_type: Type of storage used by the lab. It can be either Premium or Standard.
     Default is Premium. Possible values include: "Standard", "Premium", "StandardSSD".
    :type lab_storage_type: str or ~azure.mgmt.devtestlabs.models.StorageType
    :param mandatory_artifacts_resource_ids_linux: The ordered list of artifact resource IDs that
     should be applied on all Linux VM creations by default, prior to the artifacts specified by the
     user.
    :type mandatory_artifacts_resource_ids_linux: list[str]
    :param mandatory_artifacts_resource_ids_windows: The ordered list of artifact resource IDs that
     should be applied on all Windows VM creations by default, prior to the artifacts specified by
     the user.
    :type mandatory_artifacts_resource_ids_windows: list[str]
    :param premium_data_disks: The setting to enable usage of premium data disks.
     When its value is 'Enabled', creation of standard or premium data disks is allowed.
     When its value is 'Disabled', only creation of standard data disks is allowed. Possible values
     include: "Disabled", "Enabled".
    :type premium_data_disks: str or ~azure.mgmt.devtestlabs.models.PremiumDataDisk
    :param environment_permission: The access rights to be granted to the user when provisioning an
     environment. Possible values include: "Reader", "Contributor".
    :type environment_permission: str or ~azure.mgmt.devtestlabs.models.EnvironmentPermission
    :param announcement: The properties of any lab announcement associated with this lab.
    :type announcement: ~azure.mgmt.devtestlabs.models.LabAnnouncementPropertiesFragment
    :param support: The properties of any lab support message associated with this lab.
    :type support: ~azure.mgmt.devtestlabs.models.LabSupportPropertiesFragment
    :param extended_properties: Extended properties of the lab used for experimental features.
    :type extended_properties: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'lab_storage_type': {'key': 'properties.labStorageType', 'type': 'str'},
        'mandatory_artifacts_resource_ids_linux': {'key': 'properties.mandatoryArtifactsResourceIdsLinux', 'type': '[str]'},
        'mandatory_artifacts_resource_ids_windows': {'key': 'properties.mandatoryArtifactsResourceIdsWindows', 'type': '[str]'},
        'premium_data_disks': {'key': 'properties.premiumDataDisks', 'type': 'str'},
        'environment_permission': {'key': 'properties.environmentPermission', 'type': 'str'},
        'announcement': {'key': 'properties.announcement', 'type': 'LabAnnouncementPropertiesFragment'},
        'support': {'key': 'properties.support', 'type': 'LabSupportPropertiesFragment'},
        'extended_properties': {'key': 'properties.extendedProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        lab_storage_type: Optional[Union[str, "StorageType"]] = None,
        mandatory_artifacts_resource_ids_linux: Optional[List[str]] = None,
        mandatory_artifacts_resource_ids_windows: Optional[List[str]] = None,
        premium_data_disks: Optional[Union[str, "PremiumDataDisk"]] = None,
        environment_permission: Optional[Union[str, "EnvironmentPermission"]] = None,
        announcement: Optional["LabAnnouncementPropertiesFragment"] = None,
        support: Optional["LabSupportPropertiesFragment"] = None,
        extended_properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(LabFragment, self).__init__(tags=tags, **kwargs)
        self.lab_storage_type = lab_storage_type
        self.mandatory_artifacts_resource_ids_linux = mandatory_artifacts_resource_ids_linux
        self.mandatory_artifacts_resource_ids_windows = mandatory_artifacts_resource_ids_windows
        self.premium_data_disks = premium_data_disks
        self.environment_permission = environment_permission
        self.announcement = announcement
        self.support = support
        self.extended_properties = extended_properties


class LabList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.Lab]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Lab]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Lab"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(LabList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LabResourceCostProperties(msrest.serialization.Model):
    """The properties of a resource cost item.

    :param resourcename: The name of the resource.
    :type resourcename: str
    :param resource_u_id: The unique identifier of the resource.
    :type resource_u_id: str
    :param resource_cost: The cost component of the resource cost item.
    :type resource_cost: float
    :param resource_type: The logical resource type (ex. virtualmachine, storageaccount).
    :type resource_type: str
    :param resource_owner: The owner of the resource (ex. janedoe@microsoft.com).
    :type resource_owner: str
    :param resource_pricing_tier: The category of the resource (ex. Premium_LRS, Standard_DS1).
    :type resource_pricing_tier: str
    :param resource_status: The status of the resource (ex. Active).
    :type resource_status: str
    :param resource_id: The ID of the resource.
    :type resource_id: str
    :param external_resource_id: The ID of the external resource.
    :type external_resource_id: str
    """

    _attribute_map = {
        'resourcename': {'key': 'resourcename', 'type': 'str'},
        'resource_u_id': {'key': 'resourceUId', 'type': 'str'},
        'resource_cost': {'key': 'resourceCost', 'type': 'float'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_owner': {'key': 'resourceOwner', 'type': 'str'},
        'resource_pricing_tier': {'key': 'resourcePricingTier', 'type': 'str'},
        'resource_status': {'key': 'resourceStatus', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'external_resource_id': {'key': 'externalResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resourcename: Optional[str] = None,
        resource_u_id: Optional[str] = None,
        resource_cost: Optional[float] = None,
        resource_type: Optional[str] = None,
        resource_owner: Optional[str] = None,
        resource_pricing_tier: Optional[str] = None,
        resource_status: Optional[str] = None,
        resource_id: Optional[str] = None,
        external_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(LabResourceCostProperties, self).__init__(**kwargs)
        self.resourcename = resourcename
        self.resource_u_id = resource_u_id
        self.resource_cost = resource_cost
        self.resource_type = resource_type
        self.resource_owner = resource_owner
        self.resource_pricing_tier = resource_pricing_tier
        self.resource_status = resource_status
        self.resource_id = resource_id
        self.external_resource_id = external_resource_id


class LabSupportProperties(msrest.serialization.Model):
    """Properties of a lab's support banner.

    :param enabled: Is the lab support banner active/enabled at this time?. Possible values
     include: "Enabled", "Disabled".
    :type enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param markdown: The markdown text (if any) that this lab displays in the UI. If left
     empty/null, nothing will be shown.
    :type markdown: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'str'},
        'markdown': {'key': 'markdown', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[Union[str, "EnableStatus"]] = None,
        markdown: Optional[str] = None,
        **kwargs
    ):
        super(LabSupportProperties, self).__init__(**kwargs)
        self.enabled = enabled
        self.markdown = markdown


class LabSupportPropertiesFragment(msrest.serialization.Model):
    """Properties of a lab's support banner.

    :param enabled: Is the lab support banner active/enabled at this time?. Possible values
     include: "Enabled", "Disabled".
    :type enabled: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param markdown: The markdown text (if any) that this lab displays in the UI. If left
     empty/null, nothing will be shown.
    :type markdown: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'str'},
        'markdown': {'key': 'markdown', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[Union[str, "EnableStatus"]] = None,
        markdown: Optional[str] = None,
        **kwargs
    ):
        super(LabSupportPropertiesFragment, self).__init__(**kwargs)
        self.enabled = enabled
        self.markdown = markdown


class LabVhd(msrest.serialization.Model):
    """Properties of a VHD in the lab.

    :param id: The URI to the VHD.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(LabVhd, self).__init__(**kwargs)
        self.id = id


class LabVhdList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.LabVhd]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LabVhd]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LabVhd"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(LabVhdList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LabVirtualMachine(Resource):
    """A virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param notes: The notes of the virtual machine.
    :type notes: str
    :param owner_object_id: The object identifier of the owner of the virtual machine.
    :type owner_object_id: str
    :param owner_user_principal_name: The user principal name of the virtual machine owner.
    :type owner_user_principal_name: str
    :param created_by_user_id: The object identifier of the creator of the virtual machine.
    :type created_by_user_id: str
    :param created_by_user: The email address of creator of the virtual machine.
    :type created_by_user: str
    :param created_date: The creation date of the virtual machine.
    :type created_date: ~datetime.datetime
    :param compute_id: The resource identifier (Microsoft.Compute) of the virtual machine.
    :type compute_id: str
    :param custom_image_id: The custom image identifier of the virtual machine.
    :type custom_image_id: str
    :param os_type: The OS type of the virtual machine.
    :type os_type: str
    :param size: The size of the virtual machine.
    :type size: str
    :param user_name: The user name of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine administrator.
    :type password: str
    :param ssh_key: The SSH key of the virtual machine administrator.
    :type ssh_key: str
    :param is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key
     for authentication.
    :type is_authentication_with_ssh_key: bool
    :param fqdn: The fully-qualified domain name of the virtual machine.
    :type fqdn: str
    :param lab_subnet_name: The lab subnet name of the virtual machine.
    :type lab_subnet_name: str
    :param lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
    :type lab_virtual_network_id: str
    :param disallow_public_ip_address: Indicates whether the virtual machine is to be created
     without a public IP address.
    :type disallow_public_ip_address: bool
    :param artifacts: The artifacts to be installed on the virtual machine.
    :type artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
    :param artifact_deployment_status: The artifact deployment status for the virtual machine.
    :type artifact_deployment_status:
     ~azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusProperties
    :param gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual
     machine.
    :type gallery_image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReference
    :param plan_id: The id of the plan associated with the virtual machine image.
    :type plan_id: str
    :ivar compute_vm: The compute virtual machine properties.
    :vartype compute_vm: ~azure.mgmt.devtestlabs.models.ComputeVmProperties
    :param network_interface: The network interface properties.
    :type network_interface: ~azure.mgmt.devtestlabs.models.NetworkInterfaceProperties
    :ivar applicable_schedule: The applicable schedule for the virtual machine.
    :vartype applicable_schedule: ~azure.mgmt.devtestlabs.models.ApplicableSchedule
    :param expiration_date: The expiration date for VM.
    :type expiration_date: ~datetime.datetime
    :param allow_claim: Indicates whether another user can take ownership of the virtual machine.
    :type allow_claim: bool
    :param storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
    :type storage_type: str
    :param virtual_machine_creation_source: Tells source of creation of lab virtual machine. Output
     property only. Possible values include: "FromCustomImage", "FromGalleryImage",
     "FromSharedGalleryImage".
    :type virtual_machine_creation_source: str or
     ~azure.mgmt.devtestlabs.models.VirtualMachineCreationSource
    :param environment_id: The resource ID of the environment that contains this virtual machine,
     if any.
    :type environment_id: str
    :param data_disk_parameters: New or existing data disks to attach to the virtual machine after
     creation.
    :type data_disk_parameters: list[~azure.mgmt.devtestlabs.models.DataDiskProperties]
    :param schedule_parameters: Virtual Machine schedules to be created.
    :type schedule_parameters: list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameter]
    :param last_known_power_state: Last known compute power state captured in DTL.
    :type last_known_power_state: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'compute_vm': {'readonly': True},
        'applicable_schedule': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'owner_object_id': {'key': 'properties.ownerObjectId', 'type': 'str'},
        'owner_user_principal_name': {'key': 'properties.ownerUserPrincipalName', 'type': 'str'},
        'created_by_user_id': {'key': 'properties.createdByUserId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'compute_id': {'key': 'properties.computeId', 'type': 'str'},
        'custom_image_id': {'key': 'properties.customImageId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'ssh_key': {'key': 'properties.sshKey', 'type': 'str'},
        'is_authentication_with_ssh_key': {'key': 'properties.isAuthenticationWithSshKey', 'type': 'bool'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'lab_subnet_name': {'key': 'properties.labSubnetName', 'type': 'str'},
        'lab_virtual_network_id': {'key': 'properties.labVirtualNetworkId', 'type': 'str'},
        'disallow_public_ip_address': {'key': 'properties.disallowPublicIpAddress', 'type': 'bool'},
        'artifacts': {'key': 'properties.artifacts', 'type': '[ArtifactInstallProperties]'},
        'artifact_deployment_status': {'key': 'properties.artifactDeploymentStatus', 'type': 'ArtifactDeploymentStatusProperties'},
        'gallery_image_reference': {'key': 'properties.galleryImageReference', 'type': 'GalleryImageReference'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'compute_vm': {'key': 'properties.computeVm', 'type': 'ComputeVmProperties'},
        'network_interface': {'key': 'properties.networkInterface', 'type': 'NetworkInterfaceProperties'},
        'applicable_schedule': {'key': 'properties.applicableSchedule', 'type': 'ApplicableSchedule'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'allow_claim': {'key': 'properties.allowClaim', 'type': 'bool'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'virtual_machine_creation_source': {'key': 'properties.virtualMachineCreationSource', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'data_disk_parameters': {'key': 'properties.dataDiskParameters', 'type': '[DataDiskProperties]'},
        'schedule_parameters': {'key': 'properties.scheduleParameters', 'type': '[ScheduleCreationParameter]'},
        'last_known_power_state': {'key': 'properties.lastKnownPowerState', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        notes: Optional[str] = None,
        owner_object_id: Optional[str] = None,
        owner_user_principal_name: Optional[str] = None,
        created_by_user_id: Optional[str] = None,
        created_by_user: Optional[str] = None,
        created_date: Optional[datetime.datetime] = None,
        compute_id: Optional[str] = None,
        custom_image_id: Optional[str] = None,
        os_type: Optional[str] = None,
        size: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        ssh_key: Optional[str] = None,
        is_authentication_with_ssh_key: Optional[bool] = None,
        fqdn: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        lab_virtual_network_id: Optional[str] = None,
        disallow_public_ip_address: Optional[bool] = None,
        artifacts: Optional[List["ArtifactInstallProperties"]] = None,
        artifact_deployment_status: Optional["ArtifactDeploymentStatusProperties"] = None,
        gallery_image_reference: Optional["GalleryImageReference"] = None,
        plan_id: Optional[str] = None,
        network_interface: Optional["NetworkInterfaceProperties"] = None,
        expiration_date: Optional[datetime.datetime] = None,
        allow_claim: Optional[bool] = None,
        storage_type: Optional[str] = None,
        virtual_machine_creation_source: Optional[Union[str, "VirtualMachineCreationSource"]] = None,
        environment_id: Optional[str] = None,
        data_disk_parameters: Optional[List["DataDiskProperties"]] = None,
        schedule_parameters: Optional[List["ScheduleCreationParameter"]] = None,
        last_known_power_state: Optional[str] = None,
        **kwargs
    ):
        super(LabVirtualMachine, self).__init__(location=location, tags=tags, **kwargs)
        self.notes = notes
        self.owner_object_id = owner_object_id
        self.owner_user_principal_name = owner_user_principal_name
        self.created_by_user_id = created_by_user_id
        self.created_by_user = created_by_user
        self.created_date = created_date
        self.compute_id = compute_id
        self.custom_image_id = custom_image_id
        self.os_type = os_type
        self.size = size
        self.user_name = user_name
        self.password = password
        self.ssh_key = ssh_key
        self.is_authentication_with_ssh_key = is_authentication_with_ssh_key
        self.fqdn = fqdn
        self.lab_subnet_name = lab_subnet_name
        self.lab_virtual_network_id = lab_virtual_network_id
        self.disallow_public_ip_address = disallow_public_ip_address
        self.artifacts = artifacts
        self.artifact_deployment_status = artifact_deployment_status
        self.gallery_image_reference = gallery_image_reference
        self.plan_id = plan_id
        self.compute_vm = None
        self.network_interface = network_interface
        self.applicable_schedule = None
        self.expiration_date = expiration_date
        self.allow_claim = allow_claim
        self.storage_type = storage_type
        self.virtual_machine_creation_source = virtual_machine_creation_source
        self.environment_id = environment_id
        self.data_disk_parameters = data_disk_parameters
        self.schedule_parameters = schedule_parameters
        self.last_known_power_state = last_known_power_state
        self.provisioning_state = None
        self.unique_identifier = None


class LabVirtualMachineCreationParameter(msrest.serialization.Model):
    """Properties for creating a virtual machine.

    :param name: The name of the virtual machine or environment.
    :type name: str
    :param location: The location of the new virtual machine or environment.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param bulk_creation_parameters: The number of virtual machine instances to create.
    :type bulk_creation_parameters: ~azure.mgmt.devtestlabs.models.BulkCreationParameters
    :param notes: The notes of the virtual machine.
    :type notes: str
    :param owner_object_id: The object identifier of the owner of the virtual machine.
    :type owner_object_id: str
    :param owner_user_principal_name: The user principal name of the virtual machine owner.
    :type owner_user_principal_name: str
    :param created_by_user_id: The object identifier of the creator of the virtual machine.
    :type created_by_user_id: str
    :param created_by_user: The email address of creator of the virtual machine.
    :type created_by_user: str
    :param created_date: The creation date of the virtual machine.
    :type created_date: ~datetime.datetime
    :param compute_id: The resource identifier (Microsoft.Compute) of the virtual machine.
    :type compute_id: str
    :param custom_image_id: The custom image identifier of the virtual machine.
    :type custom_image_id: str
    :param os_type: The OS type of the virtual machine.
    :type os_type: str
    :param size: The size of the virtual machine.
    :type size: str
    :param user_name: The user name of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine administrator.
    :type password: str
    :param ssh_key: The SSH key of the virtual machine administrator.
    :type ssh_key: str
    :param is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key
     for authentication.
    :type is_authentication_with_ssh_key: bool
    :param fqdn: The fully-qualified domain name of the virtual machine.
    :type fqdn: str
    :param lab_subnet_name: The lab subnet name of the virtual machine.
    :type lab_subnet_name: str
    :param lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
    :type lab_virtual_network_id: str
    :param disallow_public_ip_address: Indicates whether the virtual machine is to be created
     without a public IP address.
    :type disallow_public_ip_address: bool
    :param artifacts: The artifacts to be installed on the virtual machine.
    :type artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallProperties]
    :param artifact_deployment_status: The artifact deployment status for the virtual machine.
    :type artifact_deployment_status:
     ~azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusProperties
    :param gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual
     machine.
    :type gallery_image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReference
    :param plan_id: The id of the plan associated with the virtual machine image.
    :type plan_id: str
    :param network_interface: The network interface properties.
    :type network_interface: ~azure.mgmt.devtestlabs.models.NetworkInterfaceProperties
    :param expiration_date: The expiration date for VM.
    :type expiration_date: ~datetime.datetime
    :param allow_claim: Indicates whether another user can take ownership of the virtual machine.
    :type allow_claim: bool
    :param storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
    :type storage_type: str
    :param virtual_machine_creation_source: Tells source of creation of lab virtual machine. Output
     property only. Possible values include: "FromCustomImage", "FromGalleryImage",
     "FromSharedGalleryImage".
    :type virtual_machine_creation_source: str or
     ~azure.mgmt.devtestlabs.models.VirtualMachineCreationSource
    :param environment_id: The resource ID of the environment that contains this virtual machine,
     if any.
    :type environment_id: str
    :param data_disk_parameters: New or existing data disks to attach to the virtual machine after
     creation.
    :type data_disk_parameters: list[~azure.mgmt.devtestlabs.models.DataDiskProperties]
    :param schedule_parameters: Virtual Machine schedules to be created.
    :type schedule_parameters: list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameter]
    :param last_known_power_state: Last known compute power state captured in DTL.
    :type last_known_power_state: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'bulk_creation_parameters': {'key': 'properties.bulkCreationParameters', 'type': 'BulkCreationParameters'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'owner_object_id': {'key': 'properties.ownerObjectId', 'type': 'str'},
        'owner_user_principal_name': {'key': 'properties.ownerUserPrincipalName', 'type': 'str'},
        'created_by_user_id': {'key': 'properties.createdByUserId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'compute_id': {'key': 'properties.computeId', 'type': 'str'},
        'custom_image_id': {'key': 'properties.customImageId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'ssh_key': {'key': 'properties.sshKey', 'type': 'str'},
        'is_authentication_with_ssh_key': {'key': 'properties.isAuthenticationWithSshKey', 'type': 'bool'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'lab_subnet_name': {'key': 'properties.labSubnetName', 'type': 'str'},
        'lab_virtual_network_id': {'key': 'properties.labVirtualNetworkId', 'type': 'str'},
        'disallow_public_ip_address': {'key': 'properties.disallowPublicIpAddress', 'type': 'bool'},
        'artifacts': {'key': 'properties.artifacts', 'type': '[ArtifactInstallProperties]'},
        'artifact_deployment_status': {'key': 'properties.artifactDeploymentStatus', 'type': 'ArtifactDeploymentStatusProperties'},
        'gallery_image_reference': {'key': 'properties.galleryImageReference', 'type': 'GalleryImageReference'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'network_interface': {'key': 'properties.networkInterface', 'type': 'NetworkInterfaceProperties'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'allow_claim': {'key': 'properties.allowClaim', 'type': 'bool'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'virtual_machine_creation_source': {'key': 'properties.virtualMachineCreationSource', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'data_disk_parameters': {'key': 'properties.dataDiskParameters', 'type': '[DataDiskProperties]'},
        'schedule_parameters': {'key': 'properties.scheduleParameters', 'type': '[ScheduleCreationParameter]'},
        'last_known_power_state': {'key': 'properties.lastKnownPowerState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        bulk_creation_parameters: Optional["BulkCreationParameters"] = None,
        notes: Optional[str] = None,
        owner_object_id: Optional[str] = None,
        owner_user_principal_name: Optional[str] = None,
        created_by_user_id: Optional[str] = None,
        created_by_user: Optional[str] = None,
        created_date: Optional[datetime.datetime] = None,
        compute_id: Optional[str] = None,
        custom_image_id: Optional[str] = None,
        os_type: Optional[str] = None,
        size: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        ssh_key: Optional[str] = None,
        is_authentication_with_ssh_key: Optional[bool] = None,
        fqdn: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        lab_virtual_network_id: Optional[str] = None,
        disallow_public_ip_address: Optional[bool] = None,
        artifacts: Optional[List["ArtifactInstallProperties"]] = None,
        artifact_deployment_status: Optional["ArtifactDeploymentStatusProperties"] = None,
        gallery_image_reference: Optional["GalleryImageReference"] = None,
        plan_id: Optional[str] = None,
        network_interface: Optional["NetworkInterfaceProperties"] = None,
        expiration_date: Optional[datetime.datetime] = None,
        allow_claim: Optional[bool] = None,
        storage_type: Optional[str] = None,
        virtual_machine_creation_source: Optional[Union[str, "VirtualMachineCreationSource"]] = None,
        environment_id: Optional[str] = None,
        data_disk_parameters: Optional[List["DataDiskProperties"]] = None,
        schedule_parameters: Optional[List["ScheduleCreationParameter"]] = None,
        last_known_power_state: Optional[str] = None,
        **kwargs
    ):
        super(LabVirtualMachineCreationParameter, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.bulk_creation_parameters = bulk_creation_parameters
        self.notes = notes
        self.owner_object_id = owner_object_id
        self.owner_user_principal_name = owner_user_principal_name
        self.created_by_user_id = created_by_user_id
        self.created_by_user = created_by_user
        self.created_date = created_date
        self.compute_id = compute_id
        self.custom_image_id = custom_image_id
        self.os_type = os_type
        self.size = size
        self.user_name = user_name
        self.password = password
        self.ssh_key = ssh_key
        self.is_authentication_with_ssh_key = is_authentication_with_ssh_key
        self.fqdn = fqdn
        self.lab_subnet_name = lab_subnet_name
        self.lab_virtual_network_id = lab_virtual_network_id
        self.disallow_public_ip_address = disallow_public_ip_address
        self.artifacts = artifacts
        self.artifact_deployment_status = artifact_deployment_status
        self.gallery_image_reference = gallery_image_reference
        self.plan_id = plan_id
        self.network_interface = network_interface
        self.expiration_date = expiration_date
        self.allow_claim = allow_claim
        self.storage_type = storage_type
        self.virtual_machine_creation_source = virtual_machine_creation_source
        self.environment_id = environment_id
        self.data_disk_parameters = data_disk_parameters
        self.schedule_parameters = schedule_parameters
        self.last_known_power_state = last_known_power_state


class LabVirtualMachineCreationParameterFragment(msrest.serialization.Model):
    """Properties for creating a virtual machine.

    :param name: The name of the virtual machine or environment.
    :type name: str
    :param location: The location of the new virtual machine or environment.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param bulk_creation_parameters: The number of virtual machine instances to create.
    :type bulk_creation_parameters: ~azure.mgmt.devtestlabs.models.BulkCreationParametersFragment
    :param notes: The notes of the virtual machine.
    :type notes: str
    :param owner_object_id: The object identifier of the owner of the virtual machine.
    :type owner_object_id: str
    :param owner_user_principal_name: The user principal name of the virtual machine owner.
    :type owner_user_principal_name: str
    :param created_by_user_id: The object identifier of the creator of the virtual machine.
    :type created_by_user_id: str
    :param created_by_user: The email address of creator of the virtual machine.
    :type created_by_user: str
    :param created_date: The creation date of the virtual machine.
    :type created_date: ~datetime.datetime
    :param compute_id: The resource identifier (Microsoft.Compute) of the virtual machine.
    :type compute_id: str
    :param custom_image_id: The custom image identifier of the virtual machine.
    :type custom_image_id: str
    :param os_type: The OS type of the virtual machine.
    :type os_type: str
    :param size: The size of the virtual machine.
    :type size: str
    :param user_name: The user name of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine administrator.
    :type password: str
    :param ssh_key: The SSH key of the virtual machine administrator.
    :type ssh_key: str
    :param is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key
     for authentication.
    :type is_authentication_with_ssh_key: bool
    :param fqdn: The fully-qualified domain name of the virtual machine.
    :type fqdn: str
    :param lab_subnet_name: The lab subnet name of the virtual machine.
    :type lab_subnet_name: str
    :param lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
    :type lab_virtual_network_id: str
    :param disallow_public_ip_address: Indicates whether the virtual machine is to be created
     without a public IP address.
    :type disallow_public_ip_address: bool
    :param artifacts: The artifacts to be installed on the virtual machine.
    :type artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallPropertiesFragment]
    :param artifact_deployment_status: The artifact deployment status for the virtual machine.
    :type artifact_deployment_status:
     ~azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusPropertiesFragment
    :param gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual
     machine.
    :type gallery_image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReferenceFragment
    :param plan_id: The id of the plan associated with the virtual machine image.
    :type plan_id: str
    :param network_interface: The network interface properties.
    :type network_interface: ~azure.mgmt.devtestlabs.models.NetworkInterfacePropertiesFragment
    :param expiration_date: The expiration date for VM.
    :type expiration_date: ~datetime.datetime
    :param allow_claim: Indicates whether another user can take ownership of the virtual machine.
    :type allow_claim: bool
    :param storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
    :type storage_type: str
    :param virtual_machine_creation_source: Tells source of creation of lab virtual machine. Output
     property only. Possible values include: "FromCustomImage", "FromGalleryImage",
     "FromSharedGalleryImage".
    :type virtual_machine_creation_source: str or
     ~azure.mgmt.devtestlabs.models.VirtualMachineCreationSource
    :param environment_id: The resource ID of the environment that contains this virtual machine,
     if any.
    :type environment_id: str
    :param data_disk_parameters: New or existing data disks to attach to the virtual machine after
     creation.
    :type data_disk_parameters: list[~azure.mgmt.devtestlabs.models.DataDiskPropertiesFragment]
    :param schedule_parameters: Virtual Machine schedules to be created.
    :type schedule_parameters:
     list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameterFragment]
    :param last_known_power_state: Last known compute power state captured in DTL.
    :type last_known_power_state: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'bulk_creation_parameters': {'key': 'properties.bulkCreationParameters', 'type': 'BulkCreationParametersFragment'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'owner_object_id': {'key': 'properties.ownerObjectId', 'type': 'str'},
        'owner_user_principal_name': {'key': 'properties.ownerUserPrincipalName', 'type': 'str'},
        'created_by_user_id': {'key': 'properties.createdByUserId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'compute_id': {'key': 'properties.computeId', 'type': 'str'},
        'custom_image_id': {'key': 'properties.customImageId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'ssh_key': {'key': 'properties.sshKey', 'type': 'str'},
        'is_authentication_with_ssh_key': {'key': 'properties.isAuthenticationWithSshKey', 'type': 'bool'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'lab_subnet_name': {'key': 'properties.labSubnetName', 'type': 'str'},
        'lab_virtual_network_id': {'key': 'properties.labVirtualNetworkId', 'type': 'str'},
        'disallow_public_ip_address': {'key': 'properties.disallowPublicIpAddress', 'type': 'bool'},
        'artifacts': {'key': 'properties.artifacts', 'type': '[ArtifactInstallPropertiesFragment]'},
        'artifact_deployment_status': {'key': 'properties.artifactDeploymentStatus', 'type': 'ArtifactDeploymentStatusPropertiesFragment'},
        'gallery_image_reference': {'key': 'properties.galleryImageReference', 'type': 'GalleryImageReferenceFragment'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'network_interface': {'key': 'properties.networkInterface', 'type': 'NetworkInterfacePropertiesFragment'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'allow_claim': {'key': 'properties.allowClaim', 'type': 'bool'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'virtual_machine_creation_source': {'key': 'properties.virtualMachineCreationSource', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'data_disk_parameters': {'key': 'properties.dataDiskParameters', 'type': '[DataDiskPropertiesFragment]'},
        'schedule_parameters': {'key': 'properties.scheduleParameters', 'type': '[ScheduleCreationParameterFragment]'},
        'last_known_power_state': {'key': 'properties.lastKnownPowerState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        bulk_creation_parameters: Optional["BulkCreationParametersFragment"] = None,
        notes: Optional[str] = None,
        owner_object_id: Optional[str] = None,
        owner_user_principal_name: Optional[str] = None,
        created_by_user_id: Optional[str] = None,
        created_by_user: Optional[str] = None,
        created_date: Optional[datetime.datetime] = None,
        compute_id: Optional[str] = None,
        custom_image_id: Optional[str] = None,
        os_type: Optional[str] = None,
        size: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        ssh_key: Optional[str] = None,
        is_authentication_with_ssh_key: Optional[bool] = None,
        fqdn: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        lab_virtual_network_id: Optional[str] = None,
        disallow_public_ip_address: Optional[bool] = None,
        artifacts: Optional[List["ArtifactInstallPropertiesFragment"]] = None,
        artifact_deployment_status: Optional["ArtifactDeploymentStatusPropertiesFragment"] = None,
        gallery_image_reference: Optional["GalleryImageReferenceFragment"] = None,
        plan_id: Optional[str] = None,
        network_interface: Optional["NetworkInterfacePropertiesFragment"] = None,
        expiration_date: Optional[datetime.datetime] = None,
        allow_claim: Optional[bool] = None,
        storage_type: Optional[str] = None,
        virtual_machine_creation_source: Optional[Union[str, "VirtualMachineCreationSource"]] = None,
        environment_id: Optional[str] = None,
        data_disk_parameters: Optional[List["DataDiskPropertiesFragment"]] = None,
        schedule_parameters: Optional[List["ScheduleCreationParameterFragment"]] = None,
        last_known_power_state: Optional[str] = None,
        **kwargs
    ):
        super(LabVirtualMachineCreationParameterFragment, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.bulk_creation_parameters = bulk_creation_parameters
        self.notes = notes
        self.owner_object_id = owner_object_id
        self.owner_user_principal_name = owner_user_principal_name
        self.created_by_user_id = created_by_user_id
        self.created_by_user = created_by_user
        self.created_date = created_date
        self.compute_id = compute_id
        self.custom_image_id = custom_image_id
        self.os_type = os_type
        self.size = size
        self.user_name = user_name
        self.password = password
        self.ssh_key = ssh_key
        self.is_authentication_with_ssh_key = is_authentication_with_ssh_key
        self.fqdn = fqdn
        self.lab_subnet_name = lab_subnet_name
        self.lab_virtual_network_id = lab_virtual_network_id
        self.disallow_public_ip_address = disallow_public_ip_address
        self.artifacts = artifacts
        self.artifact_deployment_status = artifact_deployment_status
        self.gallery_image_reference = gallery_image_reference
        self.plan_id = plan_id
        self.network_interface = network_interface
        self.expiration_date = expiration_date
        self.allow_claim = allow_claim
        self.storage_type = storage_type
        self.virtual_machine_creation_source = virtual_machine_creation_source
        self.environment_id = environment_id
        self.data_disk_parameters = data_disk_parameters
        self.schedule_parameters = schedule_parameters
        self.last_known_power_state = last_known_power_state


class LabVirtualMachineFragment(UpdateResource):
    """A virtual machine.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param notes: The notes of the virtual machine.
    :type notes: str
    :param owner_object_id: The object identifier of the owner of the virtual machine.
    :type owner_object_id: str
    :param owner_user_principal_name: The user principal name of the virtual machine owner.
    :type owner_user_principal_name: str
    :param created_by_user_id: The object identifier of the creator of the virtual machine.
    :type created_by_user_id: str
    :param created_by_user: The email address of creator of the virtual machine.
    :type created_by_user: str
    :param created_date: The creation date of the virtual machine.
    :type created_date: ~datetime.datetime
    :param compute_id: The resource identifier (Microsoft.Compute) of the virtual machine.
    :type compute_id: str
    :param custom_image_id: The custom image identifier of the virtual machine.
    :type custom_image_id: str
    :param os_type: The OS type of the virtual machine.
    :type os_type: str
    :param size: The size of the virtual machine.
    :type size: str
    :param user_name: The user name of the virtual machine.
    :type user_name: str
    :param password: The password of the virtual machine administrator.
    :type password: str
    :param ssh_key: The SSH key of the virtual machine administrator.
    :type ssh_key: str
    :param is_authentication_with_ssh_key: Indicates whether this virtual machine uses an SSH key
     for authentication.
    :type is_authentication_with_ssh_key: bool
    :param fqdn: The fully-qualified domain name of the virtual machine.
    :type fqdn: str
    :param lab_subnet_name: The lab subnet name of the virtual machine.
    :type lab_subnet_name: str
    :param lab_virtual_network_id: The lab virtual network identifier of the virtual machine.
    :type lab_virtual_network_id: str
    :param disallow_public_ip_address: Indicates whether the virtual machine is to be created
     without a public IP address.
    :type disallow_public_ip_address: bool
    :param artifacts: The artifacts to be installed on the virtual machine.
    :type artifacts: list[~azure.mgmt.devtestlabs.models.ArtifactInstallPropertiesFragment]
    :param artifact_deployment_status: The artifact deployment status for the virtual machine.
    :type artifact_deployment_status:
     ~azure.mgmt.devtestlabs.models.ArtifactDeploymentStatusPropertiesFragment
    :param gallery_image_reference: The Microsoft Azure Marketplace image reference of the virtual
     machine.
    :type gallery_image_reference: ~azure.mgmt.devtestlabs.models.GalleryImageReferenceFragment
    :param plan_id: The id of the plan associated with the virtual machine image.
    :type plan_id: str
    :param network_interface: The network interface properties.
    :type network_interface: ~azure.mgmt.devtestlabs.models.NetworkInterfacePropertiesFragment
    :param expiration_date: The expiration date for VM.
    :type expiration_date: ~datetime.datetime
    :param allow_claim: Indicates whether another user can take ownership of the virtual machine.
    :type allow_claim: bool
    :param storage_type: Storage type to use for virtual machine (i.e. Standard, Premium).
    :type storage_type: str
    :param virtual_machine_creation_source: Tells source of creation of lab virtual machine. Output
     property only. Possible values include: "FromCustomImage", "FromGalleryImage",
     "FromSharedGalleryImage".
    :type virtual_machine_creation_source: str or
     ~azure.mgmt.devtestlabs.models.VirtualMachineCreationSource
    :param environment_id: The resource ID of the environment that contains this virtual machine,
     if any.
    :type environment_id: str
    :param data_disk_parameters: New or existing data disks to attach to the virtual machine after
     creation.
    :type data_disk_parameters: list[~azure.mgmt.devtestlabs.models.DataDiskPropertiesFragment]
    :param schedule_parameters: Virtual Machine schedules to be created.
    :type schedule_parameters:
     list[~azure.mgmt.devtestlabs.models.ScheduleCreationParameterFragment]
    :param last_known_power_state: Last known compute power state captured in DTL.
    :type last_known_power_state: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'owner_object_id': {'key': 'properties.ownerObjectId', 'type': 'str'},
        'owner_user_principal_name': {'key': 'properties.ownerUserPrincipalName', 'type': 'str'},
        'created_by_user_id': {'key': 'properties.createdByUserId', 'type': 'str'},
        'created_by_user': {'key': 'properties.createdByUser', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'compute_id': {'key': 'properties.computeId', 'type': 'str'},
        'custom_image_id': {'key': 'properties.customImageId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'size': {'key': 'properties.size', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
        'ssh_key': {'key': 'properties.sshKey', 'type': 'str'},
        'is_authentication_with_ssh_key': {'key': 'properties.isAuthenticationWithSshKey', 'type': 'bool'},
        'fqdn': {'key': 'properties.fqdn', 'type': 'str'},
        'lab_subnet_name': {'key': 'properties.labSubnetName', 'type': 'str'},
        'lab_virtual_network_id': {'key': 'properties.labVirtualNetworkId', 'type': 'str'},
        'disallow_public_ip_address': {'key': 'properties.disallowPublicIpAddress', 'type': 'bool'},
        'artifacts': {'key': 'properties.artifacts', 'type': '[ArtifactInstallPropertiesFragment]'},
        'artifact_deployment_status': {'key': 'properties.artifactDeploymentStatus', 'type': 'ArtifactDeploymentStatusPropertiesFragment'},
        'gallery_image_reference': {'key': 'properties.galleryImageReference', 'type': 'GalleryImageReferenceFragment'},
        'plan_id': {'key': 'properties.planId', 'type': 'str'},
        'network_interface': {'key': 'properties.networkInterface', 'type': 'NetworkInterfacePropertiesFragment'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'allow_claim': {'key': 'properties.allowClaim', 'type': 'bool'},
        'storage_type': {'key': 'properties.storageType', 'type': 'str'},
        'virtual_machine_creation_source': {'key': 'properties.virtualMachineCreationSource', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'data_disk_parameters': {'key': 'properties.dataDiskParameters', 'type': '[DataDiskPropertiesFragment]'},
        'schedule_parameters': {'key': 'properties.scheduleParameters', 'type': '[ScheduleCreationParameterFragment]'},
        'last_known_power_state': {'key': 'properties.lastKnownPowerState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        notes: Optional[str] = None,
        owner_object_id: Optional[str] = None,
        owner_user_principal_name: Optional[str] = None,
        created_by_user_id: Optional[str] = None,
        created_by_user: Optional[str] = None,
        created_date: Optional[datetime.datetime] = None,
        compute_id: Optional[str] = None,
        custom_image_id: Optional[str] = None,
        os_type: Optional[str] = None,
        size: Optional[str] = None,
        user_name: Optional[str] = None,
        password: Optional[str] = None,
        ssh_key: Optional[str] = None,
        is_authentication_with_ssh_key: Optional[bool] = None,
        fqdn: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        lab_virtual_network_id: Optional[str] = None,
        disallow_public_ip_address: Optional[bool] = None,
        artifacts: Optional[List["ArtifactInstallPropertiesFragment"]] = None,
        artifact_deployment_status: Optional["ArtifactDeploymentStatusPropertiesFragment"] = None,
        gallery_image_reference: Optional["GalleryImageReferenceFragment"] = None,
        plan_id: Optional[str] = None,
        network_interface: Optional["NetworkInterfacePropertiesFragment"] = None,
        expiration_date: Optional[datetime.datetime] = None,
        allow_claim: Optional[bool] = None,
        storage_type: Optional[str] = None,
        virtual_machine_creation_source: Optional[Union[str, "VirtualMachineCreationSource"]] = None,
        environment_id: Optional[str] = None,
        data_disk_parameters: Optional[List["DataDiskPropertiesFragment"]] = None,
        schedule_parameters: Optional[List["ScheduleCreationParameterFragment"]] = None,
        last_known_power_state: Optional[str] = None,
        **kwargs
    ):
        super(LabVirtualMachineFragment, self).__init__(tags=tags, **kwargs)
        self.notes = notes
        self.owner_object_id = owner_object_id
        self.owner_user_principal_name = owner_user_principal_name
        self.created_by_user_id = created_by_user_id
        self.created_by_user = created_by_user
        self.created_date = created_date
        self.compute_id = compute_id
        self.custom_image_id = custom_image_id
        self.os_type = os_type
        self.size = size
        self.user_name = user_name
        self.password = password
        self.ssh_key = ssh_key
        self.is_authentication_with_ssh_key = is_authentication_with_ssh_key
        self.fqdn = fqdn
        self.lab_subnet_name = lab_subnet_name
        self.lab_virtual_network_id = lab_virtual_network_id
        self.disallow_public_ip_address = disallow_public_ip_address
        self.artifacts = artifacts
        self.artifact_deployment_status = artifact_deployment_status
        self.gallery_image_reference = gallery_image_reference
        self.plan_id = plan_id
        self.network_interface = network_interface
        self.expiration_date = expiration_date
        self.allow_claim = allow_claim
        self.storage_type = storage_type
        self.virtual_machine_creation_source = virtual_machine_creation_source
        self.environment_id = environment_id
        self.data_disk_parameters = data_disk_parameters
        self.schedule_parameters = schedule_parameters
        self.last_known_power_state = last_known_power_state


class LabVirtualMachineList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.LabVirtualMachine]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LabVirtualMachine]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["LabVirtualMachine"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(LabVirtualMachineList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LinuxOsInfo(msrest.serialization.Model):
    """Information about a Linux OS.

    :param linux_os_state: The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested,
     DeprovisionApplied). Possible values include: "NonDeprovisioned", "DeprovisionRequested",
     "DeprovisionApplied".
    :type linux_os_state: str or ~azure.mgmt.devtestlabs.models.LinuxOsState
    """

    _attribute_map = {
        'linux_os_state': {'key': 'linuxOsState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        linux_os_state: Optional[Union[str, "LinuxOsState"]] = None,
        **kwargs
    ):
        super(LinuxOsInfo, self).__init__(**kwargs)
        self.linux_os_state = linux_os_state


class LinuxOsInfoFragment(msrest.serialization.Model):
    """Information about a Linux OS.

    :param linux_os_state: The state of the Linux OS (i.e. NonDeprovisioned, DeprovisionRequested,
     DeprovisionApplied). Possible values include: "NonDeprovisioned", "DeprovisionRequested",
     "DeprovisionApplied".
    :type linux_os_state: str or ~azure.mgmt.devtestlabs.models.LinuxOsState
    """

    _attribute_map = {
        'linux_os_state': {'key': 'linuxOsState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        linux_os_state: Optional[Union[str, "LinuxOsState"]] = None,
        **kwargs
    ):
        super(LinuxOsInfoFragment, self).__init__(**kwargs)
        self.linux_os_state = linux_os_state


class NetworkInterfaceProperties(msrest.serialization.Model):
    """Properties of a network interface.

    :param virtual_network_id: The resource ID of the virtual network.
    :type virtual_network_id: str
    :param subnet_id: The resource ID of the sub net.
    :type subnet_id: str
    :param public_ip_address_id: The resource ID of the public IP address.
    :type public_ip_address_id: str
    :param public_ip_address: The public IP address.
    :type public_ip_address: str
    :param private_ip_address: The private IP address.
    :type private_ip_address: str
    :param dns_name: The DNS name.
    :type dns_name: str
    :param rdp_authority: The RdpAuthority property is a server DNS host name or IP address
     followed by the service port number for RDP (Remote Desktop Protocol).
    :type rdp_authority: str
    :param ssh_authority: The SshAuthority property is a server DNS host name or IP address
     followed by the service port number for SSH.
    :type ssh_authority: str
    :param shared_public_ip_address_configuration: The configuration for sharing a public IP
     address across multiple virtual machines.
    :type shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SharedPublicIpAddressConfiguration
    """

    _attribute_map = {
        'virtual_network_id': {'key': 'virtualNetworkId', 'type': 'str'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'public_ip_address_id': {'key': 'publicIpAddressId', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'dns_name': {'key': 'dnsName', 'type': 'str'},
        'rdp_authority': {'key': 'rdpAuthority', 'type': 'str'},
        'ssh_authority': {'key': 'sshAuthority', 'type': 'str'},
        'shared_public_ip_address_configuration': {'key': 'sharedPublicIpAddressConfiguration', 'type': 'SharedPublicIpAddressConfiguration'},
    }

    def __init__(
        self,
        *,
        virtual_network_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        public_ip_address_id: Optional[str] = None,
        public_ip_address: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        dns_name: Optional[str] = None,
        rdp_authority: Optional[str] = None,
        ssh_authority: Optional[str] = None,
        shared_public_ip_address_configuration: Optional["SharedPublicIpAddressConfiguration"] = None,
        **kwargs
    ):
        super(NetworkInterfaceProperties, self).__init__(**kwargs)
        self.virtual_network_id = virtual_network_id
        self.subnet_id = subnet_id
        self.public_ip_address_id = public_ip_address_id
        self.public_ip_address = public_ip_address
        self.private_ip_address = private_ip_address
        self.dns_name = dns_name
        self.rdp_authority = rdp_authority
        self.ssh_authority = ssh_authority
        self.shared_public_ip_address_configuration = shared_public_ip_address_configuration


class NetworkInterfacePropertiesFragment(msrest.serialization.Model):
    """Properties of a network interface.

    :param virtual_network_id: The resource ID of the virtual network.
    :type virtual_network_id: str
    :param subnet_id: The resource ID of the sub net.
    :type subnet_id: str
    :param public_ip_address_id: The resource ID of the public IP address.
    :type public_ip_address_id: str
    :param public_ip_address: The public IP address.
    :type public_ip_address: str
    :param private_ip_address: The private IP address.
    :type private_ip_address: str
    :param dns_name: The DNS name.
    :type dns_name: str
    :param rdp_authority: The RdpAuthority property is a server DNS host name or IP address
     followed by the service port number for RDP (Remote Desktop Protocol).
    :type rdp_authority: str
    :param ssh_authority: The SshAuthority property is a server DNS host name or IP address
     followed by the service port number for SSH.
    :type ssh_authority: str
    :param shared_public_ip_address_configuration: The configuration for sharing a public IP
     address across multiple virtual machines.
    :type shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SharedPublicIpAddressConfigurationFragment
    """

    _attribute_map = {
        'virtual_network_id': {'key': 'virtualNetworkId', 'type': 'str'},
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'public_ip_address_id': {'key': 'publicIpAddressId', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'dns_name': {'key': 'dnsName', 'type': 'str'},
        'rdp_authority': {'key': 'rdpAuthority', 'type': 'str'},
        'ssh_authority': {'key': 'sshAuthority', 'type': 'str'},
        'shared_public_ip_address_configuration': {'key': 'sharedPublicIpAddressConfiguration', 'type': 'SharedPublicIpAddressConfigurationFragment'},
    }

    def __init__(
        self,
        *,
        virtual_network_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        public_ip_address_id: Optional[str] = None,
        public_ip_address: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        dns_name: Optional[str] = None,
        rdp_authority: Optional[str] = None,
        ssh_authority: Optional[str] = None,
        shared_public_ip_address_configuration: Optional["SharedPublicIpAddressConfigurationFragment"] = None,
        **kwargs
    ):
        super(NetworkInterfacePropertiesFragment, self).__init__(**kwargs)
        self.virtual_network_id = virtual_network_id
        self.subnet_id = subnet_id
        self.public_ip_address_id = public_ip_address_id
        self.public_ip_address = public_ip_address
        self.private_ip_address = private_ip_address
        self.dns_name = dns_name
        self.rdp_authority = rdp_authority
        self.ssh_authority = ssh_authority
        self.shared_public_ip_address_configuration = shared_public_ip_address_configuration


class NotificationChannel(Resource):
    """A notification.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param web_hook_url: The webhook URL to send notifications to.
    :type web_hook_url: str
    :param email_recipient: The email recipient to send notifications to (can be a list of semi-
     colon separated email addresses).
    :type email_recipient: str
    :param notification_locale: The locale to use when sending a notification (fallback for
     unsupported languages is EN).
    :type notification_locale: str
    :param description: Description of notification.
    :type description: str
    :param events: The list of event for which this notification is enabled.
    :type events: list[~azure.mgmt.devtestlabs.models.Event]
    :ivar created_date: The creation date of the notification channel.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'web_hook_url': {'key': 'properties.webHookUrl', 'type': 'str'},
        'email_recipient': {'key': 'properties.emailRecipient', 'type': 'str'},
        'notification_locale': {'key': 'properties.notificationLocale', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'events': {'key': 'properties.events', 'type': '[Event]'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        web_hook_url: Optional[str] = None,
        email_recipient: Optional[str] = None,
        notification_locale: Optional[str] = None,
        description: Optional[str] = None,
        events: Optional[List["Event"]] = None,
        **kwargs
    ):
        super(NotificationChannel, self).__init__(location=location, tags=tags, **kwargs)
        self.web_hook_url = web_hook_url
        self.email_recipient = email_recipient
        self.notification_locale = notification_locale
        self.description = description
        self.events = events
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class NotificationChannelFragment(UpdateResource):
    """A notification.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param web_hook_url: The webhook URL to send notifications to.
    :type web_hook_url: str
    :param email_recipient: The email recipient to send notifications to (can be a list of semi-
     colon separated email addresses).
    :type email_recipient: str
    :param notification_locale: The locale to use when sending a notification (fallback for
     unsupported languages is EN).
    :type notification_locale: str
    :param description: Description of notification.
    :type description: str
    :param events: The list of event for which this notification is enabled.
    :type events: list[~azure.mgmt.devtestlabs.models.EventFragment]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'web_hook_url': {'key': 'properties.webHookUrl', 'type': 'str'},
        'email_recipient': {'key': 'properties.emailRecipient', 'type': 'str'},
        'notification_locale': {'key': 'properties.notificationLocale', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'events': {'key': 'properties.events', 'type': '[EventFragment]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        web_hook_url: Optional[str] = None,
        email_recipient: Optional[str] = None,
        notification_locale: Optional[str] = None,
        description: Optional[str] = None,
        events: Optional[List["EventFragment"]] = None,
        **kwargs
    ):
        super(NotificationChannelFragment, self).__init__(tags=tags, **kwargs)
        self.web_hook_url = web_hook_url
        self.email_recipient = email_recipient
        self.notification_locale = notification_locale
        self.description = description
        self.events = events


class NotificationChannelList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.NotificationChannel]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[NotificationChannel]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["NotificationChannel"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NotificationChannelList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NotificationSettings(msrest.serialization.Model):
    """Notification settings for a schedule.

    :param status: If notifications are enabled for this schedule (i.e. Enabled, Disabled).
     Possible values include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param time_in_minutes: Time in minutes before event at which notification will be sent.
    :type time_in_minutes: int
    :param webhook_url: The webhook URL to which the notification will be sent.
    :type webhook_url: str
    :param email_recipient: The email recipient to send notifications to (can be a list of semi-
     colon separated email addresses).
    :type email_recipient: str
    :param notification_locale: The locale to use when sending a notification (fallback for
     unsupported languages is EN).
    :type notification_locale: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'time_in_minutes': {'key': 'timeInMinutes', 'type': 'int'},
        'webhook_url': {'key': 'webhookUrl', 'type': 'str'},
        'email_recipient': {'key': 'emailRecipient', 'type': 'str'},
        'notification_locale': {'key': 'notificationLocale', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "EnableStatus"]] = None,
        time_in_minutes: Optional[int] = None,
        webhook_url: Optional[str] = None,
        email_recipient: Optional[str] = None,
        notification_locale: Optional[str] = None,
        **kwargs
    ):
        super(NotificationSettings, self).__init__(**kwargs)
        self.status = status
        self.time_in_minutes = time_in_minutes
        self.webhook_url = webhook_url
        self.email_recipient = email_recipient
        self.notification_locale = notification_locale


class NotificationSettingsFragment(msrest.serialization.Model):
    """Notification settings for a schedule.

    :param status: If notifications are enabled for this schedule (i.e. Enabled, Disabled).
     Possible values include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param time_in_minutes: Time in minutes before event at which notification will be sent.
    :type time_in_minutes: int
    :param webhook_url: The webhook URL to which the notification will be sent.
    :type webhook_url: str
    :param email_recipient: The email recipient to send notifications to (can be a list of semi-
     colon separated email addresses).
    :type email_recipient: str
    :param notification_locale: The locale to use when sending a notification (fallback for
     unsupported languages is EN).
    :type notification_locale: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'time_in_minutes': {'key': 'timeInMinutes', 'type': 'int'},
        'webhook_url': {'key': 'webhookUrl', 'type': 'str'},
        'email_recipient': {'key': 'emailRecipient', 'type': 'str'},
        'notification_locale': {'key': 'notificationLocale', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "EnableStatus"]] = None,
        time_in_minutes: Optional[int] = None,
        webhook_url: Optional[str] = None,
        email_recipient: Optional[str] = None,
        notification_locale: Optional[str] = None,
        **kwargs
    ):
        super(NotificationSettingsFragment, self).__init__(**kwargs)
        self.status = status
        self.time_in_minutes = time_in_minutes
        self.webhook_url = webhook_url
        self.email_recipient = email_recipient
        self.notification_locale = notification_locale


class NotifyParameters(msrest.serialization.Model):
    """Properties for generating a Notification.

    :param event_name: The type of event (i.e. AutoShutdown, Cost). Possible values include:
     "AutoShutdown", "Cost".
    :type event_name: str or ~azure.mgmt.devtestlabs.models.NotificationChannelEventType
    :param json_payload: Properties for the notification in json format.
    :type json_payload: str
    """

    _attribute_map = {
        'event_name': {'key': 'eventName', 'type': 'str'},
        'json_payload': {'key': 'jsonPayload', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        event_name: Optional[Union[str, "NotificationChannelEventType"]] = None,
        json_payload: Optional[str] = None,
        **kwargs
    ):
        super(NotifyParameters, self).__init__(**kwargs)
        self.event_name = event_name
        self.json_payload = json_payload


class OperationError(msrest.serialization.Model):
    """Error details for the operation in case of a failure.

    :param code: The error code of the operation error.
    :type code: str
    :param message: The error message of the operation error.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(OperationError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class OperationMetadata(msrest.serialization.Model):
    """The REST API operation supported by DevTestLab ResourceProvider.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The object that describes the operations.
    :type display: ~azure.mgmt.devtestlabs.models.OperationMetadataDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationMetadataDisplay'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationMetadataDisplay"] = None,
        **kwargs
    ):
        super(OperationMetadata, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationMetadataDisplay(msrest.serialization.Model):
    """The object that describes the operations.

    :param provider: Friendly name of the resource provider.
    :type provider: str
    :param resource: Resource type on which the operation is performed.
    :type resource: str
    :param operation: Operation type: read, write, delete, listKeys/action, etc.
    :type operation: str
    :param description: Friendly name of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationMetadataDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationResult(msrest.serialization.Model):
    """An Operation Result.

    :param status: The operation status.
    :type status: str
    :param status_code: The status code for the operation. Possible values include: "Continue",
     "SwitchingProtocols", "OK", "Created", "Accepted", "NonAuthoritativeInformation", "NoContent",
     "ResetContent", "PartialContent", "MultipleChoices", "MovedPermanently", "Redirect",
     "SeeOther", "NotModified", "UseProxy", "Unused", "TemporaryRedirect", "BadRequest",
     "Unauthorized", "PaymentRequired", "Forbidden", "NotFound", "MethodNotAllowed",
     "NotAcceptable", "ProxyAuthenticationRequired", "RequestTimeout", "Conflict", "Gone",
     "LengthRequired", "PreconditionFailed", "RequestEntityTooLarge", "RequestUriTooLong",
     "UnsupportedMediaType", "RequestedRangeNotSatisfiable", "ExpectationFailed", "UpgradeRequired",
     "InternalServerError", "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout",
     "HttpVersionNotSupported".
    :type status_code: str or ~azure.mgmt.devtestlabs.models.HttpStatusCode
    :param error: Error details for the operation in case of a failure.
    :type error: ~azure.mgmt.devtestlabs.models.OperationError
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'error': {'key': 'error', 'type': 'OperationError'},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        status_code: Optional[Union[str, "HttpStatusCode"]] = None,
        error: Optional["OperationError"] = None,
        **kwargs
    ):
        super(OperationResult, self).__init__(**kwargs)
        self.status = status
        self.status_code = status_code
        self.error = error


class ParameterInfo(msrest.serialization.Model):
    """Information about an artifact's parameter.

    :param name: The name of the artifact parameter.
    :type name: str
    :param value: The value of the artifact parameter.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(ParameterInfo, self).__init__(**kwargs)
        self.name = name
        self.value = value


class ParametersValueFileInfo(msrest.serialization.Model):
    """A file containing a set of parameter values for an ARM template.

    :param file_name: File name.
    :type file_name: str
    :param parameters_value_info: Contents of the file.
    :type parameters_value_info: object
    """

    _attribute_map = {
        'file_name': {'key': 'fileName', 'type': 'str'},
        'parameters_value_info': {'key': 'parametersValueInfo', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        file_name: Optional[str] = None,
        parameters_value_info: Optional[object] = None,
        **kwargs
    ):
        super(ParametersValueFileInfo, self).__init__(**kwargs)
        self.file_name = file_name
        self.parameters_value_info = parameters_value_info


class PercentageCostThresholdProperties(msrest.serialization.Model):
    """Properties of a percentage cost threshold.

    :param threshold_value: The cost threshold value.
    :type threshold_value: float
    """

    _attribute_map = {
        'threshold_value': {'key': 'thresholdValue', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        threshold_value: Optional[float] = None,
        **kwargs
    ):
        super(PercentageCostThresholdProperties, self).__init__(**kwargs)
        self.threshold_value = threshold_value


class Policy(Resource):
    """A Policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param description: The description of the policy.
    :type description: str
    :param status: The status of the policy. Possible values include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.PolicyStatus
    :param fact_name: The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab,
     etc. Possible values include: "UserOwnedLabVmCount", "UserOwnedLabPremiumVmCount",
     "LabVmCount", "LabPremiumVmCount", "LabVmSize", "GalleryImage", "UserOwnedLabVmCountInSubnet",
     "LabTargetCost", "EnvironmentTemplate", "ScheduleEditPermission".
    :type fact_name: str or ~azure.mgmt.devtestlabs.models.PolicyFactName
    :param fact_data: The fact data of the policy.
    :type fact_data: str
    :param threshold: The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON
     array of values for AllowedValuesPolicy).
    :type threshold: str
    :param evaluator_type: The evaluator type of the policy (i.e. AllowedValuesPolicy,
     MaxValuePolicy). Possible values include: "AllowedValuesPolicy", "MaxValuePolicy".
    :type evaluator_type: str or ~azure.mgmt.devtestlabs.models.PolicyEvaluatorType
    :ivar created_date: The creation date of the policy.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'fact_name': {'key': 'properties.factName', 'type': 'str'},
        'fact_data': {'key': 'properties.factData', 'type': 'str'},
        'threshold': {'key': 'properties.threshold', 'type': 'str'},
        'evaluator_type': {'key': 'properties.evaluatorType', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        status: Optional[Union[str, "PolicyStatus"]] = None,
        fact_name: Optional[Union[str, "PolicyFactName"]] = None,
        fact_data: Optional[str] = None,
        threshold: Optional[str] = None,
        evaluator_type: Optional[Union[str, "PolicyEvaluatorType"]] = None,
        **kwargs
    ):
        super(Policy, self).__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.status = status
        self.fact_name = fact_name
        self.fact_data = fact_data
        self.threshold = threshold
        self.evaluator_type = evaluator_type
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class PolicyFragment(UpdateResource):
    """A Policy.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param description: The description of the policy.
    :type description: str
    :param status: The status of the policy. Possible values include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.PolicyStatus
    :param fact_name: The fact name of the policy (e.g. LabVmCount, LabVmSize, MaxVmsAllowedPerLab,
     etc. Possible values include: "UserOwnedLabVmCount", "UserOwnedLabPremiumVmCount",
     "LabVmCount", "LabPremiumVmCount", "LabVmSize", "GalleryImage", "UserOwnedLabVmCountInSubnet",
     "LabTargetCost", "EnvironmentTemplate", "ScheduleEditPermission".
    :type fact_name: str or ~azure.mgmt.devtestlabs.models.PolicyFactName
    :param fact_data: The fact data of the policy.
    :type fact_data: str
    :param threshold: The threshold of the policy (i.e. a number for MaxValuePolicy, and a JSON
     array of values for AllowedValuesPolicy).
    :type threshold: str
    :param evaluator_type: The evaluator type of the policy (i.e. AllowedValuesPolicy,
     MaxValuePolicy). Possible values include: "AllowedValuesPolicy", "MaxValuePolicy".
    :type evaluator_type: str or ~azure.mgmt.devtestlabs.models.PolicyEvaluatorType
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'fact_name': {'key': 'properties.factName', 'type': 'str'},
        'fact_data': {'key': 'properties.factData', 'type': 'str'},
        'threshold': {'key': 'properties.threshold', 'type': 'str'},
        'evaluator_type': {'key': 'properties.evaluatorType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        status: Optional[Union[str, "PolicyStatus"]] = None,
        fact_name: Optional[Union[str, "PolicyFactName"]] = None,
        fact_data: Optional[str] = None,
        threshold: Optional[str] = None,
        evaluator_type: Optional[Union[str, "PolicyEvaluatorType"]] = None,
        **kwargs
    ):
        super(PolicyFragment, self).__init__(tags=tags, **kwargs)
        self.description = description
        self.status = status
        self.fact_name = fact_name
        self.fact_data = fact_data
        self.threshold = threshold
        self.evaluator_type = evaluator_type


class PolicyList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.Policy]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Policy]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Policy"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PolicyList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PolicySetResult(msrest.serialization.Model):
    """Result of a policy set evaluation.

    :param has_error: A value indicating whether this policy set evaluation has discovered
     violations.
    :type has_error: bool
    :param policy_violations: The list of policy violations.
    :type policy_violations: list[~azure.mgmt.devtestlabs.models.PolicyViolation]
    """

    _attribute_map = {
        'has_error': {'key': 'hasError', 'type': 'bool'},
        'policy_violations': {'key': 'policyViolations', 'type': '[PolicyViolation]'},
    }

    def __init__(
        self,
        *,
        has_error: Optional[bool] = None,
        policy_violations: Optional[List["PolicyViolation"]] = None,
        **kwargs
    ):
        super(PolicySetResult, self).__init__(**kwargs)
        self.has_error = has_error
        self.policy_violations = policy_violations


class PolicyViolation(msrest.serialization.Model):
    """Policy violation.

    :param code: The code of the policy violation.
    :type code: str
    :param message: The message of the policy violation.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(PolicyViolation, self).__init__(**kwargs)
        self.code = code
        self.message = message


class Port(msrest.serialization.Model):
    """Properties of a network port.

    :param transport_protocol: Protocol type of the port. Possible values include: "Tcp", "Udp".
    :type transport_protocol: str or ~azure.mgmt.devtestlabs.models.TransportProtocol
    :param backend_port: Backend port of the target virtual machine.
    :type backend_port: int
    """

    _attribute_map = {
        'transport_protocol': {'key': 'transportProtocol', 'type': 'str'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        transport_protocol: Optional[Union[str, "TransportProtocol"]] = None,
        backend_port: Optional[int] = None,
        **kwargs
    ):
        super(Port, self).__init__(**kwargs)
        self.transport_protocol = transport_protocol
        self.backend_port = backend_port


class PortFragment(msrest.serialization.Model):
    """Properties of a network port.

    :param transport_protocol: Protocol type of the port. Possible values include: "Tcp", "Udp".
    :type transport_protocol: str or ~azure.mgmt.devtestlabs.models.TransportProtocol
    :param backend_port: Backend port of the target virtual machine.
    :type backend_port: int
    """

    _attribute_map = {
        'transport_protocol': {'key': 'transportProtocol', 'type': 'str'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        transport_protocol: Optional[Union[str, "TransportProtocol"]] = None,
        backend_port: Optional[int] = None,
        **kwargs
    ):
        super(PortFragment, self).__init__(**kwargs)
        self.transport_protocol = transport_protocol
        self.backend_port = backend_port


class ProviderOperationResult(msrest.serialization.Model):
    """Result of the request to list REST API operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: List of operations supported by the resource provider.
    :type value: list[~azure.mgmt.devtestlabs.models.OperationMetadata]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationMetadata]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OperationMetadata"]] = None,
        **kwargs
    ):
        super(ProviderOperationResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class RdpConnection(msrest.serialization.Model):
    """Represents a .rdp file.

    :param contents: The contents of the .rdp file.
    :type contents: str
    """

    _attribute_map = {
        'contents': {'key': 'contents', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        contents: Optional[str] = None,
        **kwargs
    ):
        super(RdpConnection, self).__init__(**kwargs)
        self.contents = contents


class ResizeLabVirtualMachineProperties(msrest.serialization.Model):
    """Request body for resizing a virtual machine.

    :param size: Specifies the size of the virtual machine.
    :type size: str
    """

    _attribute_map = {
        'size': {'key': 'size', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        size: Optional[str] = None,
        **kwargs
    ):
        super(ResizeLabVirtualMachineProperties, self).__init__(**kwargs)
        self.size = size


class RetargetScheduleProperties(msrest.serialization.Model):
    """Properties for retargeting a virtual machine schedule.

    :param current_resource_id: The resource Id of the virtual machine on which the schedule
     operates.
    :type current_resource_id: str
    :param target_resource_id: The resource Id of the virtual machine that the schedule should be
     retargeted to.
    :type target_resource_id: str
    """

    _attribute_map = {
        'current_resource_id': {'key': 'currentResourceId', 'type': 'str'},
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        current_resource_id: Optional[str] = None,
        target_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(RetargetScheduleProperties, self).__init__(**kwargs)
        self.current_resource_id = current_resource_id
        self.target_resource_id = target_resource_id


class Schedule(Resource):
    """A schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the schedule (i.e. Enabled, Disabled). Possible values include:
     "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
    :type task_type: str
    :param weekly_recurrence: If the schedule will occur only some days of the week, specify the
     weekly recurrence.
    :type weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetails
    :param daily_recurrence: If the schedule will occur once each day of the week, specify the
     daily recurrence.
    :type daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetails
    :param hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly
     recurrence.
    :type hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetails
    :param time_zone_id: The time zone ID (e.g. Pacific Standard time).
    :type time_zone_id: str
    :param notification_settings: Notification settings.
    :type notification_settings: ~azure.mgmt.devtestlabs.models.NotificationSettings
    :ivar created_date: The creation date of the schedule.
    :vartype created_date: ~datetime.datetime
    :param target_resource_id: The resource ID to which the schedule belongs.
    :type target_resource_id: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'task_type': {'key': 'properties.taskType', 'type': 'str'},
        'weekly_recurrence': {'key': 'properties.weeklyRecurrence', 'type': 'WeekDetails'},
        'daily_recurrence': {'key': 'properties.dailyRecurrence', 'type': 'DayDetails'},
        'hourly_recurrence': {'key': 'properties.hourlyRecurrence', 'type': 'HourDetails'},
        'time_zone_id': {'key': 'properties.timeZoneId', 'type': 'str'},
        'notification_settings': {'key': 'properties.notificationSettings', 'type': 'NotificationSettings'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "EnableStatus"]] = None,
        task_type: Optional[str] = None,
        weekly_recurrence: Optional["WeekDetails"] = None,
        daily_recurrence: Optional["DayDetails"] = None,
        hourly_recurrence: Optional["HourDetails"] = None,
        time_zone_id: Optional[str] = None,
        notification_settings: Optional["NotificationSettings"] = None,
        target_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(Schedule, self).__init__(location=location, tags=tags, **kwargs)
        self.status = status
        self.task_type = task_type
        self.weekly_recurrence = weekly_recurrence
        self.daily_recurrence = daily_recurrence
        self.hourly_recurrence = hourly_recurrence
        self.time_zone_id = time_zone_id
        self.notification_settings = notification_settings
        self.created_date = None
        self.target_resource_id = target_resource_id
        self.provisioning_state = None
        self.unique_identifier = None


class ScheduleCreationParameter(msrest.serialization.Model):
    """Properties for creating a schedule.

    :param name: The name of the virtual machine or environment.
    :type name: str
    :param location: The location of the new virtual machine or environment.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the schedule (i.e. Enabled, Disabled). Possible values include:
     "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
    :type task_type: str
    :param weekly_recurrence: If the schedule will occur only some days of the week, specify the
     weekly recurrence.
    :type weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetails
    :param daily_recurrence: If the schedule will occur once each day of the week, specify the
     daily recurrence.
    :type daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetails
    :param hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly
     recurrence.
    :type hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetails
    :param time_zone_id: The time zone ID (e.g. Pacific Standard time).
    :type time_zone_id: str
    :param notification_settings: Notification settings.
    :type notification_settings: ~azure.mgmt.devtestlabs.models.NotificationSettings
    :param target_resource_id: The resource ID to which the schedule belongs.
    :type target_resource_id: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'task_type': {'key': 'properties.taskType', 'type': 'str'},
        'weekly_recurrence': {'key': 'properties.weeklyRecurrence', 'type': 'WeekDetails'},
        'daily_recurrence': {'key': 'properties.dailyRecurrence', 'type': 'DayDetails'},
        'hourly_recurrence': {'key': 'properties.hourlyRecurrence', 'type': 'HourDetails'},
        'time_zone_id': {'key': 'properties.timeZoneId', 'type': 'str'},
        'notification_settings': {'key': 'properties.notificationSettings', 'type': 'NotificationSettings'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "EnableStatus"]] = None,
        task_type: Optional[str] = None,
        weekly_recurrence: Optional["WeekDetails"] = None,
        daily_recurrence: Optional["DayDetails"] = None,
        hourly_recurrence: Optional["HourDetails"] = None,
        time_zone_id: Optional[str] = None,
        notification_settings: Optional["NotificationSettings"] = None,
        target_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(ScheduleCreationParameter, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.status = status
        self.task_type = task_type
        self.weekly_recurrence = weekly_recurrence
        self.daily_recurrence = daily_recurrence
        self.hourly_recurrence = hourly_recurrence
        self.time_zone_id = time_zone_id
        self.notification_settings = notification_settings
        self.target_resource_id = target_resource_id


class ScheduleCreationParameterFragment(msrest.serialization.Model):
    """Properties for creating a schedule.

    :param name: The name of the virtual machine or environment.
    :type name: str
    :param location: The location of the new virtual machine or environment.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the schedule (i.e. Enabled, Disabled). Possible values include:
     "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
    :type task_type: str
    :param weekly_recurrence: If the schedule will occur only some days of the week, specify the
     weekly recurrence.
    :type weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetailsFragment
    :param daily_recurrence: If the schedule will occur once each day of the week, specify the
     daily recurrence.
    :type daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetailsFragment
    :param hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly
     recurrence.
    :type hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetailsFragment
    :param time_zone_id: The time zone ID (e.g. Pacific Standard time).
    :type time_zone_id: str
    :param notification_settings: Notification settings.
    :type notification_settings: ~azure.mgmt.devtestlabs.models.NotificationSettingsFragment
    :param target_resource_id: The resource ID to which the schedule belongs.
    :type target_resource_id: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'task_type': {'key': 'properties.taskType', 'type': 'str'},
        'weekly_recurrence': {'key': 'properties.weeklyRecurrence', 'type': 'WeekDetailsFragment'},
        'daily_recurrence': {'key': 'properties.dailyRecurrence', 'type': 'DayDetailsFragment'},
        'hourly_recurrence': {'key': 'properties.hourlyRecurrence', 'type': 'HourDetailsFragment'},
        'time_zone_id': {'key': 'properties.timeZoneId', 'type': 'str'},
        'notification_settings': {'key': 'properties.notificationSettings', 'type': 'NotificationSettingsFragment'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "EnableStatus"]] = None,
        task_type: Optional[str] = None,
        weekly_recurrence: Optional["WeekDetailsFragment"] = None,
        daily_recurrence: Optional["DayDetailsFragment"] = None,
        hourly_recurrence: Optional["HourDetailsFragment"] = None,
        time_zone_id: Optional[str] = None,
        notification_settings: Optional["NotificationSettingsFragment"] = None,
        target_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(ScheduleCreationParameterFragment, self).__init__(**kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.status = status
        self.task_type = task_type
        self.weekly_recurrence = weekly_recurrence
        self.daily_recurrence = daily_recurrence
        self.hourly_recurrence = hourly_recurrence
        self.time_zone_id = time_zone_id
        self.notification_settings = notification_settings
        self.target_resource_id = target_resource_id


class ScheduleFragment(UpdateResource):
    """A schedule.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param status: The status of the schedule (i.e. Enabled, Disabled). Possible values include:
     "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.EnableStatus
    :param task_type: The task type of the schedule (e.g. LabVmsShutdownTask, LabVmAutoStart).
    :type task_type: str
    :param weekly_recurrence: If the schedule will occur only some days of the week, specify the
     weekly recurrence.
    :type weekly_recurrence: ~azure.mgmt.devtestlabs.models.WeekDetailsFragment
    :param daily_recurrence: If the schedule will occur once each day of the week, specify the
     daily recurrence.
    :type daily_recurrence: ~azure.mgmt.devtestlabs.models.DayDetailsFragment
    :param hourly_recurrence: If the schedule will occur multiple times a day, specify the hourly
     recurrence.
    :type hourly_recurrence: ~azure.mgmt.devtestlabs.models.HourDetailsFragment
    :param time_zone_id: The time zone ID (e.g. Pacific Standard time).
    :type time_zone_id: str
    :param notification_settings: Notification settings.
    :type notification_settings: ~azure.mgmt.devtestlabs.models.NotificationSettingsFragment
    :param target_resource_id: The resource ID to which the schedule belongs.
    :type target_resource_id: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'task_type': {'key': 'properties.taskType', 'type': 'str'},
        'weekly_recurrence': {'key': 'properties.weeklyRecurrence', 'type': 'WeekDetailsFragment'},
        'daily_recurrence': {'key': 'properties.dailyRecurrence', 'type': 'DayDetailsFragment'},
        'hourly_recurrence': {'key': 'properties.hourlyRecurrence', 'type': 'HourDetailsFragment'},
        'time_zone_id': {'key': 'properties.timeZoneId', 'type': 'str'},
        'notification_settings': {'key': 'properties.notificationSettings', 'type': 'NotificationSettingsFragment'},
        'target_resource_id': {'key': 'properties.targetResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "EnableStatus"]] = None,
        task_type: Optional[str] = None,
        weekly_recurrence: Optional["WeekDetailsFragment"] = None,
        daily_recurrence: Optional["DayDetailsFragment"] = None,
        hourly_recurrence: Optional["HourDetailsFragment"] = None,
        time_zone_id: Optional[str] = None,
        notification_settings: Optional["NotificationSettingsFragment"] = None,
        target_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(ScheduleFragment, self).__init__(tags=tags, **kwargs)
        self.status = status
        self.task_type = task_type
        self.weekly_recurrence = weekly_recurrence
        self.daily_recurrence = daily_recurrence
        self.hourly_recurrence = hourly_recurrence
        self.time_zone_id = time_zone_id
        self.notification_settings = notification_settings
        self.target_resource_id = target_resource_id


class ScheduleList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.Schedule]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Schedule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Schedule"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ScheduleList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Secret(Resource):
    """A secret.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param value: The value of the secret for secret creation.
    :type value: str
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(Secret, self).__init__(location=location, tags=tags, **kwargs)
        self.value = value
        self.provisioning_state = None
        self.unique_identifier = None


class SecretFragment(UpdateResource):
    """A secret.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param value: The value of the secret for secret creation.
    :type value: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'value': {'key': 'properties.value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(SecretFragment, self).__init__(tags=tags, **kwargs)
        self.value = value


class SecretList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.Secret]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Secret]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Secret"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SecretList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceFabric(Resource):
    """A Service Fabric.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param external_service_fabric_id: The backing service fabric resource's id.
    :type external_service_fabric_id: str
    :param environment_id: The resource id of the environment under which the service fabric
     resource is present.
    :type environment_id: str
    :ivar applicable_schedule: The applicable schedule for the virtual machine.
    :vartype applicable_schedule: ~azure.mgmt.devtestlabs.models.ApplicableSchedule
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'applicable_schedule': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'external_service_fabric_id': {'key': 'properties.externalServiceFabricId', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
        'applicable_schedule': {'key': 'properties.applicableSchedule', 'type': 'ApplicableSchedule'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        external_service_fabric_id: Optional[str] = None,
        environment_id: Optional[str] = None,
        **kwargs
    ):
        super(ServiceFabric, self).__init__(location=location, tags=tags, **kwargs)
        self.external_service_fabric_id = external_service_fabric_id
        self.environment_id = environment_id
        self.applicable_schedule = None
        self.provisioning_state = None
        self.unique_identifier = None


class ServiceFabricFragment(UpdateResource):
    """A Service Fabric.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param external_service_fabric_id: The backing service fabric resource's id.
    :type external_service_fabric_id: str
    :param environment_id: The resource id of the environment under which the service fabric
     resource is present.
    :type environment_id: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'external_service_fabric_id': {'key': 'properties.externalServiceFabricId', 'type': 'str'},
        'environment_id': {'key': 'properties.environmentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        external_service_fabric_id: Optional[str] = None,
        environment_id: Optional[str] = None,
        **kwargs
    ):
        super(ServiceFabricFragment, self).__init__(tags=tags, **kwargs)
        self.external_service_fabric_id = external_service_fabric_id
        self.environment_id = environment_id


class ServiceFabricList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.ServiceFabric]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServiceFabric]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ServiceFabric"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ServiceFabricList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceRunner(Resource):
    """A container for a managed identity to execute DevTest lab services.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.devtestlabs.models.IdentityProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'IdentityProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["IdentityProperties"] = None,
        **kwargs
    ):
        super(ServiceRunner, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity


class SharedPublicIpAddressConfiguration(msrest.serialization.Model):
    """Properties of a virtual machine that determine how it is connected to a load balancer.

    :param inbound_nat_rules: The incoming NAT rules.
    :type inbound_nat_rules: list[~azure.mgmt.devtestlabs.models.InboundNatRule]
    """

    _attribute_map = {
        'inbound_nat_rules': {'key': 'inboundNatRules', 'type': '[InboundNatRule]'},
    }

    def __init__(
        self,
        *,
        inbound_nat_rules: Optional[List["InboundNatRule"]] = None,
        **kwargs
    ):
        super(SharedPublicIpAddressConfiguration, self).__init__(**kwargs)
        self.inbound_nat_rules = inbound_nat_rules


class SharedPublicIpAddressConfigurationFragment(msrest.serialization.Model):
    """Properties of a virtual machine that determine how it is connected to a load balancer.

    :param inbound_nat_rules: The incoming NAT rules.
    :type inbound_nat_rules: list[~azure.mgmt.devtestlabs.models.InboundNatRuleFragment]
    """

    _attribute_map = {
        'inbound_nat_rules': {'key': 'inboundNatRules', 'type': '[InboundNatRuleFragment]'},
    }

    def __init__(
        self,
        *,
        inbound_nat_rules: Optional[List["InboundNatRuleFragment"]] = None,
        **kwargs
    ):
        super(SharedPublicIpAddressConfigurationFragment, self).__init__(**kwargs)
        self.inbound_nat_rules = inbound_nat_rules


class ShutdownNotificationContent(msrest.serialization.Model):
    """The contents of a shutdown notification. Webhooks can use this type to deserialize the request body when they get notified of an imminent shutdown.

    :param skip_url: The URL to skip auto-shutdown.
    :type skip_url: str
    :param delay_url60: The URL to delay shutdown by 60 minutes.
    :type delay_url60: str
    :param delay_url120: The URL to delay shutdown by 2 hours.
    :type delay_url120: str
    :param vm_name: The virtual machine to be shut down.
    :type vm_name: str
    :param guid: The GUID for the virtual machine to be shut down.
    :type guid: str
    :param owner: The owner of the virtual machine.
    :type owner: str
    :param vm_url: The URL of the virtual machine.
    :type vm_url: str
    :param minutes_until_shutdown: Minutes remaining until shutdown.
    :type minutes_until_shutdown: str
    :param event_type: The event for which a notification will be sent.
    :type event_type: str
    :param text: The text for the notification.
    :type text: str
    :param subscription_id: The subscription ID for the schedule.
    :type subscription_id: str
    :param resource_group_name: The resource group name for the schedule.
    :type resource_group_name: str
    :param lab_name: The lab for the schedule.
    :type lab_name: str
    """

    _attribute_map = {
        'skip_url': {'key': 'skipUrl', 'type': 'str'},
        'delay_url60': {'key': 'delayUrl60', 'type': 'str'},
        'delay_url120': {'key': 'delayUrl120', 'type': 'str'},
        'vm_name': {'key': 'vmName', 'type': 'str'},
        'guid': {'key': 'guid', 'type': 'str'},
        'owner': {'key': 'owner', 'type': 'str'},
        'vm_url': {'key': 'vmUrl', 'type': 'str'},
        'minutes_until_shutdown': {'key': 'minutesUntilShutdown', 'type': 'str'},
        'event_type': {'key': 'eventType', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'lab_name': {'key': 'labName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        skip_url: Optional[str] = None,
        delay_url60: Optional[str] = None,
        delay_url120: Optional[str] = None,
        vm_name: Optional[str] = None,
        guid: Optional[str] = None,
        owner: Optional[str] = None,
        vm_url: Optional[str] = None,
        minutes_until_shutdown: Optional[str] = None,
        event_type: Optional[str] = None,
        text: Optional[str] = None,
        subscription_id: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        lab_name: Optional[str] = None,
        **kwargs
    ):
        super(ShutdownNotificationContent, self).__init__(**kwargs)
        self.skip_url = skip_url
        self.delay_url60 = delay_url60
        self.delay_url120 = delay_url120
        self.vm_name = vm_name
        self.guid = guid
        self.owner = owner
        self.vm_url = vm_url
        self.minutes_until_shutdown = minutes_until_shutdown
        self.event_type = event_type
        self.text = text
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.lab_name = lab_name


class Subnet(msrest.serialization.Model):
    """Subnet information.

    :param resource_id: The resource ID of the subnet.
    :type resource_id: str
    :param lab_subnet_name: The name of the subnet as seen in the lab.
    :type lab_subnet_name: str
    :param allow_public_ip: The permission policy of the subnet for allowing public IP addresses
     (i.e. Allow, Deny)). Possible values include: "Default", "Deny", "Allow".
    :type allow_public_ip: str or ~azure.mgmt.devtestlabs.models.UsagePermissionType
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'lab_subnet_name': {'key': 'labSubnetName', 'type': 'str'},
        'allow_public_ip': {'key': 'allowPublicIp', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        allow_public_ip: Optional[Union[str, "UsagePermissionType"]] = None,
        **kwargs
    ):
        super(Subnet, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.lab_subnet_name = lab_subnet_name
        self.allow_public_ip = allow_public_ip


class SubnetFragment(msrest.serialization.Model):
    """Subnet information.

    :param resource_id: The resource ID of the subnet.
    :type resource_id: str
    :param lab_subnet_name: The name of the subnet as seen in the lab.
    :type lab_subnet_name: str
    :param allow_public_ip: The permission policy of the subnet for allowing public IP addresses
     (i.e. Allow, Deny)). Possible values include: "Default", "Deny", "Allow".
    :type allow_public_ip: str or ~azure.mgmt.devtestlabs.models.UsagePermissionType
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'lab_subnet_name': {'key': 'labSubnetName', 'type': 'str'},
        'allow_public_ip': {'key': 'allowPublicIp', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        allow_public_ip: Optional[Union[str, "UsagePermissionType"]] = None,
        **kwargs
    ):
        super(SubnetFragment, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.lab_subnet_name = lab_subnet_name
        self.allow_public_ip = allow_public_ip


class SubnetOverride(msrest.serialization.Model):
    """Property overrides on a subnet of a virtual network.

    :param resource_id: The resource ID of the subnet.
    :type resource_id: str
    :param lab_subnet_name: The name given to the subnet within the lab.
    :type lab_subnet_name: str
    :param use_in_vm_creation_permission: Indicates whether this subnet can be used during virtual
     machine creation (i.e. Allow, Deny). Possible values include: "Default", "Deny", "Allow".
    :type use_in_vm_creation_permission: str or ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param use_public_ip_address_permission: Indicates whether public IP addresses can be assigned
     to virtual machines on this subnet (i.e. Allow, Deny). Possible values include: "Default",
     "Deny", "Allow".
    :type use_public_ip_address_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param shared_public_ip_address_configuration: Properties that virtual machines on this subnet
     will share.
    :type shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SubnetSharedPublicIpAddressConfiguration
    :param virtual_network_pool_name: The virtual network pool associated with this subnet.
    :type virtual_network_pool_name: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'lab_subnet_name': {'key': 'labSubnetName', 'type': 'str'},
        'use_in_vm_creation_permission': {'key': 'useInVmCreationPermission', 'type': 'str'},
        'use_public_ip_address_permission': {'key': 'usePublicIpAddressPermission', 'type': 'str'},
        'shared_public_ip_address_configuration': {'key': 'sharedPublicIpAddressConfiguration', 'type': 'SubnetSharedPublicIpAddressConfiguration'},
        'virtual_network_pool_name': {'key': 'virtualNetworkPoolName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        use_in_vm_creation_permission: Optional[Union[str, "UsagePermissionType"]] = None,
        use_public_ip_address_permission: Optional[Union[str, "UsagePermissionType"]] = None,
        shared_public_ip_address_configuration: Optional["SubnetSharedPublicIpAddressConfiguration"] = None,
        virtual_network_pool_name: Optional[str] = None,
        **kwargs
    ):
        super(SubnetOverride, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.lab_subnet_name = lab_subnet_name
        self.use_in_vm_creation_permission = use_in_vm_creation_permission
        self.use_public_ip_address_permission = use_public_ip_address_permission
        self.shared_public_ip_address_configuration = shared_public_ip_address_configuration
        self.virtual_network_pool_name = virtual_network_pool_name


class SubnetOverrideFragment(msrest.serialization.Model):
    """Property overrides on a subnet of a virtual network.

    :param resource_id: The resource ID of the subnet.
    :type resource_id: str
    :param lab_subnet_name: The name given to the subnet within the lab.
    :type lab_subnet_name: str
    :param use_in_vm_creation_permission: Indicates whether this subnet can be used during virtual
     machine creation (i.e. Allow, Deny). Possible values include: "Default", "Deny", "Allow".
    :type use_in_vm_creation_permission: str or ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param use_public_ip_address_permission: Indicates whether public IP addresses can be assigned
     to virtual machines on this subnet (i.e. Allow, Deny). Possible values include: "Default",
     "Deny", "Allow".
    :type use_public_ip_address_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param shared_public_ip_address_configuration: Properties that virtual machines on this subnet
     will share.
    :type shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SubnetSharedPublicIpAddressConfigurationFragment
    :param virtual_network_pool_name: The virtual network pool associated with this subnet.
    :type virtual_network_pool_name: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'lab_subnet_name': {'key': 'labSubnetName', 'type': 'str'},
        'use_in_vm_creation_permission': {'key': 'useInVmCreationPermission', 'type': 'str'},
        'use_public_ip_address_permission': {'key': 'usePublicIpAddressPermission', 'type': 'str'},
        'shared_public_ip_address_configuration': {'key': 'sharedPublicIpAddressConfiguration', 'type': 'SubnetSharedPublicIpAddressConfigurationFragment'},
        'virtual_network_pool_name': {'key': 'virtualNetworkPoolName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        lab_subnet_name: Optional[str] = None,
        use_in_vm_creation_permission: Optional[Union[str, "UsagePermissionType"]] = None,
        use_public_ip_address_permission: Optional[Union[str, "UsagePermissionType"]] = None,
        shared_public_ip_address_configuration: Optional["SubnetSharedPublicIpAddressConfigurationFragment"] = None,
        virtual_network_pool_name: Optional[str] = None,
        **kwargs
    ):
        super(SubnetOverrideFragment, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.lab_subnet_name = lab_subnet_name
        self.use_in_vm_creation_permission = use_in_vm_creation_permission
        self.use_public_ip_address_permission = use_public_ip_address_permission
        self.shared_public_ip_address_configuration = shared_public_ip_address_configuration
        self.virtual_network_pool_name = virtual_network_pool_name


class SubnetSharedPublicIpAddressConfiguration(msrest.serialization.Model):
    """Configuration for public IP address sharing.

    :param allowed_ports: Backend ports that virtual machines on this subnet are allowed to expose.
    :type allowed_ports: list[~azure.mgmt.devtestlabs.models.Port]
    """

    _attribute_map = {
        'allowed_ports': {'key': 'allowedPorts', 'type': '[Port]'},
    }

    def __init__(
        self,
        *,
        allowed_ports: Optional[List["Port"]] = None,
        **kwargs
    ):
        super(SubnetSharedPublicIpAddressConfiguration, self).__init__(**kwargs)
        self.allowed_ports = allowed_ports


class SubnetSharedPublicIpAddressConfigurationFragment(msrest.serialization.Model):
    """Configuration for public IP address sharing.

    :param allowed_ports: Backend ports that virtual machines on this subnet are allowed to expose.
    :type allowed_ports: list[~azure.mgmt.devtestlabs.models.PortFragment]
    """

    _attribute_map = {
        'allowed_ports': {'key': 'allowedPorts', 'type': '[PortFragment]'},
    }

    def __init__(
        self,
        *,
        allowed_ports: Optional[List["PortFragment"]] = None,
        **kwargs
    ):
        super(SubnetSharedPublicIpAddressConfigurationFragment, self).__init__(**kwargs)
        self.allowed_ports = allowed_ports


class TargetCostProperties(msrest.serialization.Model):
    """Properties of a cost target.

    :param status: Target cost status. Possible values include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.devtestlabs.models.TargetCostStatus
    :param target: Lab target cost.
    :type target: int
    :param cost_thresholds: Cost thresholds.
    :type cost_thresholds: list[~azure.mgmt.devtestlabs.models.CostThresholdProperties]
    :param cycle_start_date_time: Reporting cycle start date.
    :type cycle_start_date_time: ~datetime.datetime
    :param cycle_end_date_time: Reporting cycle end date.
    :type cycle_end_date_time: ~datetime.datetime
    :param cycle_type: Reporting cycle type. Possible values include: "CalendarMonth", "Custom".
    :type cycle_type: str or ~azure.mgmt.devtestlabs.models.ReportingCycleType
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'target': {'key': 'target', 'type': 'int'},
        'cost_thresholds': {'key': 'costThresholds', 'type': '[CostThresholdProperties]'},
        'cycle_start_date_time': {'key': 'cycleStartDateTime', 'type': 'iso-8601'},
        'cycle_end_date_time': {'key': 'cycleEndDateTime', 'type': 'iso-8601'},
        'cycle_type': {'key': 'cycleType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "TargetCostStatus"]] = None,
        target: Optional[int] = None,
        cost_thresholds: Optional[List["CostThresholdProperties"]] = None,
        cycle_start_date_time: Optional[datetime.datetime] = None,
        cycle_end_date_time: Optional[datetime.datetime] = None,
        cycle_type: Optional[Union[str, "ReportingCycleType"]] = None,
        **kwargs
    ):
        super(TargetCostProperties, self).__init__(**kwargs)
        self.status = status
        self.target = target
        self.cost_thresholds = cost_thresholds
        self.cycle_start_date_time = cycle_start_date_time
        self.cycle_end_date_time = cycle_end_date_time
        self.cycle_type = cycle_type


class User(Resource):
    """Profile of a lab user.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param identity: The identity of the user.
    :type identity: ~azure.mgmt.devtestlabs.models.UserIdentity
    :param secret_store: The secret store of the user.
    :type secret_store: ~azure.mgmt.devtestlabs.models.UserSecretStore
    :ivar created_date: The creation date of the user profile.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'properties.identity', 'type': 'UserIdentity'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'UserSecretStore'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["UserIdentity"] = None,
        secret_store: Optional["UserSecretStore"] = None,
        **kwargs
    ):
        super(User, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.secret_store = secret_store
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class UserFragment(UpdateResource):
    """Profile of a lab user.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param identity: The identity of the user.
    :type identity: ~azure.mgmt.devtestlabs.models.UserIdentityFragment
    :param secret_store: The secret store of the user.
    :type secret_store: ~azure.mgmt.devtestlabs.models.UserSecretStoreFragment
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'properties.identity', 'type': 'UserIdentityFragment'},
        'secret_store': {'key': 'properties.secretStore', 'type': 'UserSecretStoreFragment'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["UserIdentityFragment"] = None,
        secret_store: Optional["UserSecretStoreFragment"] = None,
        **kwargs
    ):
        super(UserFragment, self).__init__(tags=tags, **kwargs)
        self.identity = identity
        self.secret_store = secret_store


class UserIdentity(msrest.serialization.Model):
    """Identity attributes of a lab user.

    :param principal_name: Set to the principal name / UPN of the client JWT making the request.
    :type principal_name: str
    :param principal_id: Set to the principal Id of the client JWT making the request. Service
     principal will not have the principal Id.
    :type principal_id: str
    :param tenant_id: Set to the tenant ID of the client JWT making the request.
    :type tenant_id: str
    :param object_id: Set to the object Id of the client JWT making the request. Not all users have
     object Id. For CSP (reseller) scenarios for example, object Id is not available.
    :type object_id: str
    :param app_id: Set to the app Id of the client JWT making the request.
    :type app_id: str
    """

    _attribute_map = {
        'principal_name': {'key': 'principalName', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'app_id': {'key': 'appId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_name: Optional[str] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        object_id: Optional[str] = None,
        app_id: Optional[str] = None,
        **kwargs
    ):
        super(UserIdentity, self).__init__(**kwargs)
        self.principal_name = principal_name
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.object_id = object_id
        self.app_id = app_id


class UserIdentityFragment(msrest.serialization.Model):
    """Identity attributes of a lab user.

    :param principal_name: Set to the principal name / UPN of the client JWT making the request.
    :type principal_name: str
    :param principal_id: Set to the principal Id of the client JWT making the request. Service
     principal will not have the principal Id.
    :type principal_id: str
    :param tenant_id: Set to the tenant ID of the client JWT making the request.
    :type tenant_id: str
    :param object_id: Set to the object Id of the client JWT making the request. Not all users have
     object Id. For CSP (reseller) scenarios for example, object Id is not available.
    :type object_id: str
    :param app_id: Set to the app Id of the client JWT making the request.
    :type app_id: str
    """

    _attribute_map = {
        'principal_name': {'key': 'principalName', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'app_id': {'key': 'appId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        principal_name: Optional[str] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        object_id: Optional[str] = None,
        app_id: Optional[str] = None,
        **kwargs
    ):
        super(UserIdentityFragment, self).__init__(**kwargs)
        self.principal_name = principal_name
        self.principal_id = principal_id
        self.tenant_id = tenant_id
        self.object_id = object_id
        self.app_id = app_id


class UserList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.User]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[User]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["User"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(UserList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UserSecretStore(msrest.serialization.Model):
    """Properties of a user's secret store.

    :param key_vault_uri: The URI of the user's Key vault.
    :type key_vault_uri: str
    :param key_vault_id: The ID of the user's Key vault.
    :type key_vault_id: str
    """

    _attribute_map = {
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_uri: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        **kwargs
    ):
        super(UserSecretStore, self).__init__(**kwargs)
        self.key_vault_uri = key_vault_uri
        self.key_vault_id = key_vault_id


class UserSecretStoreFragment(msrest.serialization.Model):
    """Properties of a user's secret store.

    :param key_vault_uri: The URI of the user's Key vault.
    :type key_vault_uri: str
    :param key_vault_id: The ID of the user's Key vault.
    :type key_vault_id: str
    """

    _attribute_map = {
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'key_vault_id': {'key': 'keyVaultId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_vault_uri: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        **kwargs
    ):
        super(UserSecretStoreFragment, self).__init__(**kwargs)
        self.key_vault_uri = key_vault_uri
        self.key_vault_id = key_vault_id


class VirtualNetwork(Resource):
    """A virtual network.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param allowed_subnets: The allowed subnets of the virtual network.
    :type allowed_subnets: list[~azure.mgmt.devtestlabs.models.Subnet]
    :param description: The description of the virtual network.
    :type description: str
    :param external_provider_resource_id: The Microsoft.Network resource identifier of the virtual
     network.
    :type external_provider_resource_id: str
    :ivar external_subnets: The external subnet properties.
    :vartype external_subnets: list[~azure.mgmt.devtestlabs.models.ExternalSubnet]
    :param subnet_overrides: The subnet overrides of the virtual network.
    :type subnet_overrides: list[~azure.mgmt.devtestlabs.models.SubnetOverride]
    :ivar created_date: The creation date of the virtual network.
    :vartype created_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning status of the resource.
    :vartype provisioning_state: str
    :ivar unique_identifier: The unique immutable identifier of a resource (Guid).
    :vartype unique_identifier: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'external_subnets': {'readonly': True},
        'created_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'unique_identifier': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'allowed_subnets': {'key': 'properties.allowedSubnets', 'type': '[Subnet]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_provider_resource_id': {'key': 'properties.externalProviderResourceId', 'type': 'str'},
        'external_subnets': {'key': 'properties.externalSubnets', 'type': '[ExternalSubnet]'},
        'subnet_overrides': {'key': 'properties.subnetOverrides', 'type': '[SubnetOverride]'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        allowed_subnets: Optional[List["Subnet"]] = None,
        description: Optional[str] = None,
        external_provider_resource_id: Optional[str] = None,
        subnet_overrides: Optional[List["SubnetOverride"]] = None,
        **kwargs
    ):
        super(VirtualNetwork, self).__init__(location=location, tags=tags, **kwargs)
        self.allowed_subnets = allowed_subnets
        self.description = description
        self.external_provider_resource_id = external_provider_resource_id
        self.external_subnets = None
        self.subnet_overrides = subnet_overrides
        self.created_date = None
        self.provisioning_state = None
        self.unique_identifier = None


class VirtualNetworkFragment(UpdateResource):
    """A virtual network.

    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param allowed_subnets: The allowed subnets of the virtual network.
    :type allowed_subnets: list[~azure.mgmt.devtestlabs.models.SubnetFragment]
    :param description: The description of the virtual network.
    :type description: str
    :param external_provider_resource_id: The Microsoft.Network resource identifier of the virtual
     network.
    :type external_provider_resource_id: str
    :param subnet_overrides: The subnet overrides of the virtual network.
    :type subnet_overrides: list[~azure.mgmt.devtestlabs.models.SubnetOverrideFragment]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'allowed_subnets': {'key': 'properties.allowedSubnets', 'type': '[SubnetFragment]'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'external_provider_resource_id': {'key': 'properties.externalProviderResourceId', 'type': 'str'},
        'subnet_overrides': {'key': 'properties.subnetOverrides', 'type': '[SubnetOverrideFragment]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        allowed_subnets: Optional[List["SubnetFragment"]] = None,
        description: Optional[str] = None,
        external_provider_resource_id: Optional[str] = None,
        subnet_overrides: Optional[List["SubnetOverrideFragment"]] = None,
        **kwargs
    ):
        super(VirtualNetworkFragment, self).__init__(tags=tags, **kwargs)
        self.allowed_subnets = allowed_subnets
        self.description = description
        self.external_provider_resource_id = external_provider_resource_id
        self.subnet_overrides = subnet_overrides


class VirtualNetworkList(msrest.serialization.Model):
    """The response of a list operation.

    :param value: Results of the list operation.
    :type value: list[~azure.mgmt.devtestlabs.models.VirtualNetwork]
    :param next_link: Link for next set of results.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualNetwork]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualNetwork"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualNetworkList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WeekDetails(msrest.serialization.Model):
    """Properties of a weekly schedule.

    :param weekdays: The days of the week for which the schedule is set (e.g. Sunday, Monday,
     Tuesday, etc.).
    :type weekdays: list[str]
    :param time: The time of the day the schedule will occur.
    :type time: str
    """

    _attribute_map = {
        'weekdays': {'key': 'weekdays', 'type': '[str]'},
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        weekdays: Optional[List[str]] = None,
        time: Optional[str] = None,
        **kwargs
    ):
        super(WeekDetails, self).__init__(**kwargs)
        self.weekdays = weekdays
        self.time = time


class WeekDetailsFragment(msrest.serialization.Model):
    """Properties of a weekly schedule.

    :param weekdays: The days of the week for which the schedule is set (e.g. Sunday, Monday,
     Tuesday, etc.).
    :type weekdays: list[str]
    :param time: The time of the day the schedule will occur.
    :type time: str
    """

    _attribute_map = {
        'weekdays': {'key': 'weekdays', 'type': '[str]'},
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        weekdays: Optional[List[str]] = None,
        time: Optional[str] = None,
        **kwargs
    ):
        super(WeekDetailsFragment, self).__init__(**kwargs)
        self.weekdays = weekdays
        self.time = time


class WindowsOsInfo(msrest.serialization.Model):
    """Information about a Windows OS.

    :param windows_os_state: The state of the Windows OS (i.e. NonSysprepped, SysprepRequested,
     SysprepApplied). Possible values include: "NonSysprepped", "SysprepRequested",
     "SysprepApplied".
    :type windows_os_state: str or ~azure.mgmt.devtestlabs.models.WindowsOsState
    """

    _attribute_map = {
        'windows_os_state': {'key': 'windowsOsState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        windows_os_state: Optional[Union[str, "WindowsOsState"]] = None,
        **kwargs
    ):
        super(WindowsOsInfo, self).__init__(**kwargs)
        self.windows_os_state = windows_os_state


class WindowsOsInfoFragment(msrest.serialization.Model):
    """Information about a Windows OS.

    :param windows_os_state: The state of the Windows OS (i.e. NonSysprepped, SysprepRequested,
     SysprepApplied). Possible values include: "NonSysprepped", "SysprepRequested",
     "SysprepApplied".
    :type windows_os_state: str or ~azure.mgmt.devtestlabs.models.WindowsOsState
    """

    _attribute_map = {
        'windows_os_state': {'key': 'windowsOsState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        windows_os_state: Optional[Union[str, "WindowsOsState"]] = None,
        **kwargs
    ):
        super(WindowsOsInfoFragment, self).__init__(**kwargs)
        self.windows_os_state = windows_os_state
