# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from msrest import Deserializer, Serializer

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models
from ._configuration import MobileNetworkManagementClientConfiguration
from .operations import AttachedDataNetworksOperations, DataNetworksOperations, MobileNetworksOperations, Operations, PacketCoreControlPlaneVersionsOperations, PacketCoreControlPlanesOperations, PacketCoreDataPlanesOperations, ServicesOperations, SimGroupsOperations, SimPoliciesOperations, SimsOperations, SitesOperations, SlicesOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential

class MobileNetworkManagementClient:    # pylint: disable=too-many-instance-attributes
    """The resources in this swagger specification will be used to manage attached data network
    resources in mobile network attached to a particular packet core instance.

    :ivar attached_data_networks: AttachedDataNetworksOperations operations
    :vartype attached_data_networks:
     azure.mgmt.mobilenetwork.operations.AttachedDataNetworksOperations
    :ivar data_networks: DataNetworksOperations operations
    :vartype data_networks: azure.mgmt.mobilenetwork.operations.DataNetworksOperations
    :ivar mobile_networks: MobileNetworksOperations operations
    :vartype mobile_networks: azure.mgmt.mobilenetwork.operations.MobileNetworksOperations
    :ivar sites: SitesOperations operations
    :vartype sites: azure.mgmt.mobilenetwork.operations.SitesOperations
    :ivar sim_groups: SimGroupsOperations operations
    :vartype sim_groups: azure.mgmt.mobilenetwork.operations.SimGroupsOperations
    :ivar sims: SimsOperations operations
    :vartype sims: azure.mgmt.mobilenetwork.operations.SimsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.mobilenetwork.operations.Operations
    :ivar packet_core_control_planes: PacketCoreControlPlanesOperations operations
    :vartype packet_core_control_planes:
     azure.mgmt.mobilenetwork.operations.PacketCoreControlPlanesOperations
    :ivar packet_core_control_plane_versions: PacketCoreControlPlaneVersionsOperations operations
    :vartype packet_core_control_plane_versions:
     azure.mgmt.mobilenetwork.operations.PacketCoreControlPlaneVersionsOperations
    :ivar packet_core_data_planes: PacketCoreDataPlanesOperations operations
    :vartype packet_core_data_planes:
     azure.mgmt.mobilenetwork.operations.PacketCoreDataPlanesOperations
    :ivar services: ServicesOperations operations
    :vartype services: azure.mgmt.mobilenetwork.operations.ServicesOperations
    :ivar sim_policies: SimPoliciesOperations operations
    :vartype sim_policies: azure.mgmt.mobilenetwork.operations.SimPoliciesOperations
    :ivar slices: SlicesOperations operations
    :vartype slices: azure.mgmt.mobilenetwork.operations.SlicesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-04-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = MobileNetworkManagementClientConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.attached_data_networks = AttachedDataNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.data_networks = DataNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.mobile_networks = MobileNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sites = SitesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sim_groups = SimGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sims = SimsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.packet_core_control_planes = PacketCoreControlPlanesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.packet_core_control_plane_versions = PacketCoreControlPlaneVersionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.packet_core_data_planes = PacketCoreDataPlanesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.services = ServicesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sim_policies = SimPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.slices = SlicesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )


    def _send_request(
        self,
        request: HttpRequest,
        **kwargs: Any
    ) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> MobileNetworkManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
