# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AnalyzedTokenInfo(msrest.serialization.Model):
    """Information about a token returned by an analyzer.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar token: Required. The token returned by the analyzer.
    :vartype token: str
    :ivar start_offset: Required. The index of the first character of the token in the input text.
    :vartype start_offset: int
    :ivar end_offset: Required. The index of the last character of the token in the input text.
    :vartype end_offset: int
    :ivar position: Required. The position of the token in the input text relative to other tokens.
     The first token in the input text has position 0, the next has position 1, and so on. Depending
     on the analyzer used, some tokens might have the same position, for example if they are
     synonyms of each other.
    :vartype position: int
    """

    _validation = {
        'token': {'required': True, 'readonly': True},
        'start_offset': {'required': True, 'readonly': True},
        'end_offset': {'required': True, 'readonly': True},
        'position': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
        'start_offset': {'key': 'startOffset', 'type': 'int'},
        'end_offset': {'key': 'endOffset', 'type': 'int'},
        'position': {'key': 'position', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(AnalyzedTokenInfo, self).__init__(**kwargs)
        self.token = None
        self.start_offset = None
        self.end_offset = None
        self.position = None


class AnalyzeRequest(msrest.serialization.Model):
    """Specifies some text and analysis components used to break that text into tokens.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The text to break into tokens.
    :vartype text: str
    :ivar analyzer: The name of the analyzer to use to break the given text. Possible values
     include: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene", "bg.microsoft",
     "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft", "zh-Hans.lucene",
     "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft", "cs.lucene",
     "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft", "en.lucene",
     "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene", "gl.lucene",
     "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft", "he.microsoft",
     "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft", "id.microsoft",
     "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft", "ja.lucene",
     "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene", "lt.microsoft",
     "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene", "fa.lucene",
     "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
     "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
     "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
     "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
     "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
     "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop",
     "whitespace".
    :vartype analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :ivar tokenizer: The name of the tokenizer to use to break the given text. Possible values
     include: "classic", "edgeNGram", "keyword_v2", "letter", "lowercase",
     "microsoft_language_tokenizer", "microsoft_language_stemming_tokenizer", "nGram",
     "path_hierarchy_v2", "pattern", "standard_v2", "uax_url_email", "whitespace".
    :vartype tokenizer: str or ~azure.search.documents.indexes.models.LexicalTokenizerName
    :ivar normalizer: The name of the normalizer to use to normalize the given text. Possible
     values include: "asciifolding", "elision", "lowercase", "standard", "uppercase".
    :vartype normalizer: str or ~azure.search.documents.indexes.models.LexicalNormalizerName
    :ivar token_filters: An optional list of token filters to use when breaking the given text.
    :vartype token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
    :ivar char_filters: An optional list of character filters to use when breaking the given text.
    :vartype char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
    """

    _validation = {
        'text': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'analyzer': {'key': 'analyzer', 'type': 'str'},
        'tokenizer': {'key': 'tokenizer', 'type': 'str'},
        'normalizer': {'key': 'normalizer', 'type': 'str'},
        'token_filters': {'key': 'tokenFilters', 'type': '[str]'},
        'char_filters': {'key': 'charFilters', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword text: Required. The text to break into tokens.
        :paramtype text: str
        :keyword analyzer: The name of the analyzer to use to break the given text. Possible values
         include: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene", "bg.microsoft",
         "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft", "zh-Hans.lucene",
         "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft", "cs.lucene",
         "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft", "en.lucene",
         "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene", "gl.lucene",
         "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft", "he.microsoft",
         "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft", "id.microsoft",
         "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft", "ja.lucene",
         "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene", "lt.microsoft",
         "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene", "fa.lucene",
         "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
         "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
         "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
         "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
         "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
         "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop",
         "whitespace".
        :paramtype analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
        :keyword tokenizer: The name of the tokenizer to use to break the given text. Possible values
         include: "classic", "edgeNGram", "keyword_v2", "letter", "lowercase",
         "microsoft_language_tokenizer", "microsoft_language_stemming_tokenizer", "nGram",
         "path_hierarchy_v2", "pattern", "standard_v2", "uax_url_email", "whitespace".
        :paramtype tokenizer: str or ~azure.search.documents.indexes.models.LexicalTokenizerName
        :keyword normalizer: The name of the normalizer to use to normalize the given text. Possible
         values include: "asciifolding", "elision", "lowercase", "standard", "uppercase".
        :paramtype normalizer: str or ~azure.search.documents.indexes.models.LexicalNormalizerName
        :keyword token_filters: An optional list of token filters to use when breaking the given text.
        :paramtype token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
        :keyword char_filters: An optional list of character filters to use when breaking the given
         text.
        :paramtype char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
        """
        super(AnalyzeRequest, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.analyzer = kwargs.get('analyzer', None)
        self.tokenizer = kwargs.get('tokenizer', None)
        self.normalizer = kwargs.get('normalizer', None)
        self.token_filters = kwargs.get('token_filters', None)
        self.char_filters = kwargs.get('char_filters', None)


class AnalyzeResult(msrest.serialization.Model):
    """The result of testing an analyzer on text.

    All required parameters must be populated in order to send to Azure.

    :ivar tokens: Required. The list of tokens returned by the analyzer specified in the request.
    :vartype tokens: list[~azure.search.documents.indexes.models.AnalyzedTokenInfo]
    """

    _validation = {
        'tokens': {'required': True},
    }

    _attribute_map = {
        'tokens': {'key': 'tokens', 'type': '[AnalyzedTokenInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tokens: Required. The list of tokens returned by the analyzer specified in the
         request.
        :paramtype tokens: list[~azure.search.documents.indexes.models.AnalyzedTokenInfo]
        """
        super(AnalyzeResult, self).__init__(**kwargs)
        self.tokens = kwargs['tokens']


class TokenFilter(msrest.serialization.Model):
    """Base type for token filters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AsciiFoldingTokenFilter, CjkBigramTokenFilter, CommonGramTokenFilter, DictionaryDecompounderTokenFilter, EdgeNGramTokenFilter, EdgeNGramTokenFilterV2, ElisionTokenFilter, KeepTokenFilter, KeywordMarkerTokenFilter, LengthTokenFilter, LimitTokenFilter, NGramTokenFilter, NGramTokenFilterV2, PatternCaptureTokenFilter, PatternReplaceTokenFilter, PhoneticTokenFilter, ShingleTokenFilter, SnowballTokenFilter, StemmerOverrideTokenFilter, StemmerTokenFilter, StopwordsTokenFilter, SynonymTokenFilter, TruncateTokenFilter, UniqueTokenFilter, WordDelimiterTokenFilter.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.AsciiFoldingTokenFilter': 'AsciiFoldingTokenFilter', '#Microsoft.Azure.Search.CjkBigramTokenFilter': 'CjkBigramTokenFilter', '#Microsoft.Azure.Search.CommonGramTokenFilter': 'CommonGramTokenFilter', '#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter': 'DictionaryDecompounderTokenFilter', '#Microsoft.Azure.Search.EdgeNGramTokenFilter': 'EdgeNGramTokenFilter', '#Microsoft.Azure.Search.EdgeNGramTokenFilterV2': 'EdgeNGramTokenFilterV2', '#Microsoft.Azure.Search.ElisionTokenFilter': 'ElisionTokenFilter', '#Microsoft.Azure.Search.KeepTokenFilter': 'KeepTokenFilter', '#Microsoft.Azure.Search.KeywordMarkerTokenFilter': 'KeywordMarkerTokenFilter', '#Microsoft.Azure.Search.LengthTokenFilter': 'LengthTokenFilter', '#Microsoft.Azure.Search.LimitTokenFilter': 'LimitTokenFilter', '#Microsoft.Azure.Search.NGramTokenFilter': 'NGramTokenFilter', '#Microsoft.Azure.Search.NGramTokenFilterV2': 'NGramTokenFilterV2', '#Microsoft.Azure.Search.PatternCaptureTokenFilter': 'PatternCaptureTokenFilter', '#Microsoft.Azure.Search.PatternReplaceTokenFilter': 'PatternReplaceTokenFilter', '#Microsoft.Azure.Search.PhoneticTokenFilter': 'PhoneticTokenFilter', '#Microsoft.Azure.Search.ShingleTokenFilter': 'ShingleTokenFilter', '#Microsoft.Azure.Search.SnowballTokenFilter': 'SnowballTokenFilter', '#Microsoft.Azure.Search.StemmerOverrideTokenFilter': 'StemmerOverrideTokenFilter', '#Microsoft.Azure.Search.StemmerTokenFilter': 'StemmerTokenFilter', '#Microsoft.Azure.Search.StopwordsTokenFilter': 'StopwordsTokenFilter', '#Microsoft.Azure.Search.SynonymTokenFilter': 'SynonymTokenFilter', '#Microsoft.Azure.Search.TruncateTokenFilter': 'TruncateTokenFilter', '#Microsoft.Azure.Search.UniqueTokenFilter': 'UniqueTokenFilter', '#Microsoft.Azure.Search.WordDelimiterTokenFilter': 'WordDelimiterTokenFilter'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        """
        super(TokenFilter, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = kwargs['name']


class AsciiFoldingTokenFilter(TokenFilter):
    """Converts alphabetic, numeric, and symbolic Unicode characters which are not in the first 127 ASCII characters (the "Basic Latin" Unicode block) into their ASCII equivalents, if such equivalents exist. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar preserve_original: A value indicating whether the original token will be kept. Default is
     false.
    :vartype preserve_original: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'preserve_original': {'key': 'preserveOriginal', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword preserve_original: A value indicating whether the original token will be kept. Default
         is false.
        :paramtype preserve_original: bool
        """
        super(AsciiFoldingTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.AsciiFoldingTokenFilter'  # type: str
        self.preserve_original = kwargs.get('preserve_original', False)


class AzureActiveDirectoryApplicationCredentials(msrest.serialization.Model):
    """Credentials of a registered application created for your search service, used for authenticated access to the encryption keys stored in Azure Key Vault.

    All required parameters must be populated in order to send to Azure.

    :ivar application_id: Required. An AAD Application ID that was granted the required access
     permissions to the Azure Key Vault that is to be used when encrypting your data at rest. The
     Application ID should not be confused with the Object ID for your AAD Application.
    :vartype application_id: str
    :ivar application_secret: The authentication key of the specified AAD application.
    :vartype application_secret: str
    """

    _validation = {
        'application_id': {'required': True},
    }

    _attribute_map = {
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'application_secret': {'key': 'applicationSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword application_id: Required. An AAD Application ID that was granted the required access
         permissions to the Azure Key Vault that is to be used when encrypting your data at rest. The
         Application ID should not be confused with the Object ID for your AAD Application.
        :paramtype application_id: str
        :keyword application_secret: The authentication key of the specified AAD application.
        :paramtype application_secret: str
        """
        super(AzureActiveDirectoryApplicationCredentials, self).__init__(**kwargs)
        self.application_id = kwargs['application_id']
        self.application_secret = kwargs.get('application_secret', None)


class SearchIndexerSkill(msrest.serialization.Model):
    """Base type for skills.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureMachineLearningSkill, WebApiSkill, CustomEntityLookupSkill, EntityRecognitionSkill, KeyPhraseExtractionSkill, LanguageDetectionSkill, MergeSkill, PIIDetectionSkill, SentimentSkill, SplitSkill, TextTranslationSkill, EntityLinkingSkill, EntityRecognitionSkillV3, SentimentSkillV3, ConditionalSkill, DocumentExtractionSkill, ShaperSkill, ImageAnalysisSkill, OcrSkill.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Skills.Custom.AmlSkill': 'AzureMachineLearningSkill', '#Microsoft.Skills.Custom.WebApiSkill': 'WebApiSkill', '#Microsoft.Skills.Text.CustomEntityLookupSkill': 'CustomEntityLookupSkill', '#Microsoft.Skills.Text.EntityRecognitionSkill': 'EntityRecognitionSkill', '#Microsoft.Skills.Text.KeyPhraseExtractionSkill': 'KeyPhraseExtractionSkill', '#Microsoft.Skills.Text.LanguageDetectionSkill': 'LanguageDetectionSkill', '#Microsoft.Skills.Text.MergeSkill': 'MergeSkill', '#Microsoft.Skills.Text.PIIDetectionSkill': 'PIIDetectionSkill', '#Microsoft.Skills.Text.SentimentSkill': 'SentimentSkill', '#Microsoft.Skills.Text.SplitSkill': 'SplitSkill', '#Microsoft.Skills.Text.TranslationSkill': 'TextTranslationSkill', '#Microsoft.Skills.Text.V3.EntityLinkingSkill': 'EntityLinkingSkill', '#Microsoft.Skills.Text.V3.EntityRecognitionSkill': 'EntityRecognitionSkillV3', '#Microsoft.Skills.Text.V3.SentimentSkill': 'SentimentSkillV3', '#Microsoft.Skills.Util.ConditionalSkill': 'ConditionalSkill', '#Microsoft.Skills.Util.DocumentExtractionSkill': 'DocumentExtractionSkill', '#Microsoft.Skills.Util.ShaperSkill': 'ShaperSkill', '#Microsoft.Skills.Vision.ImageAnalysisSkill': 'ImageAnalysisSkill', '#Microsoft.Skills.Vision.OcrSkill': 'OcrSkill'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        """
        super(SearchIndexerSkill, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.context = kwargs.get('context', None)
        self.inputs = kwargs['inputs']
        self.outputs = kwargs['outputs']


class AzureMachineLearningSkill(SearchIndexerSkill):
    """The AML skill allows you to extend AI enrichment with a custom Azure Machine Learning (AML) model. Once an AML model is trained and deployed, an AML skill integrates it into AI enrichment.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar scoring_uri: (Required for no authentication or key authentication) The scoring URI of
     the AML service to which the JSON payload will be sent. Only the https URI scheme is allowed.
    :vartype scoring_uri: str
    :ivar authentication_key: (Required for key authentication) The key for the AML service.
    :vartype authentication_key: str
    :ivar resource_id: (Required for token authentication). The Azure Resource Manager resource ID
     of the AML service. It should be in the format
     subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}.
    :vartype resource_id: str
    :ivar timeout: (Optional) When specified, indicates the timeout for the http client making the
     API call.
    :vartype timeout: ~datetime.timedelta
    :ivar region: (Optional for token authentication). The region the AML service is deployed in.
    :vartype region: str
    :ivar degree_of_parallelism: (Optional) When specified, indicates the number of calls the
     indexer will make in parallel to the endpoint you have provided. You can decrease this value if
     your endpoint is failing under too high of a request load, or raise it if your endpoint is able
     to accept more requests and you would like an increase in the performance of the indexer. If
     not set, a default value of 5 is used. The degreeOfParallelism can be set to a maximum of 10
     and a minimum of 1.
    :vartype degree_of_parallelism: int
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'scoring_uri': {'key': 'uri', 'type': 'str'},
        'authentication_key': {'key': 'key', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
        'region': {'key': 'region', 'type': 'str'},
        'degree_of_parallelism': {'key': 'degreeOfParallelism', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword scoring_uri: (Required for no authentication or key authentication) The scoring URI of
         the AML service to which the JSON payload will be sent. Only the https URI scheme is allowed.
        :paramtype scoring_uri: str
        :keyword authentication_key: (Required for key authentication) The key for the AML service.
        :paramtype authentication_key: str
        :keyword resource_id: (Required for token authentication). The Azure Resource Manager resource
         ID of the AML service. It should be in the format
         subscriptions/{guid}/resourceGroups/{resource-group-name}/Microsoft.MachineLearningServices/workspaces/{workspace-name}/services/{service_name}.
        :paramtype resource_id: str
        :keyword timeout: (Optional) When specified, indicates the timeout for the http client making
         the API call.
        :paramtype timeout: ~datetime.timedelta
        :keyword region: (Optional for token authentication). The region the AML service is deployed
         in.
        :paramtype region: str
        :keyword degree_of_parallelism: (Optional) When specified, indicates the number of calls the
         indexer will make in parallel to the endpoint you have provided. You can decrease this value if
         your endpoint is failing under too high of a request load, or raise it if your endpoint is able
         to accept more requests and you would like an increase in the performance of the indexer. If
         not set, a default value of 5 is used. The degreeOfParallelism can be set to a maximum of 10
         and a minimum of 1.
        :paramtype degree_of_parallelism: int
        """
        super(AzureMachineLearningSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Custom.AmlSkill'  # type: str
        self.scoring_uri = kwargs.get('scoring_uri', None)
        self.authentication_key = kwargs.get('authentication_key', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.timeout = kwargs.get('timeout', None)
        self.region = kwargs.get('region', None)
        self.degree_of_parallelism = kwargs.get('degree_of_parallelism', None)


class Similarity(msrest.serialization.Model):
    """Base type for similarity algorithms. Similarity algorithms are used to calculate scores that tie queries to documents. The higher the score, the more relevant the document is to that specific query. Those scores are used to rank the search results.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BM25Similarity, ClassicSimilarity.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Constant filled by server.
    :vartype odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.BM25Similarity': 'BM25Similarity', '#Microsoft.Azure.Search.ClassicSimilarity': 'ClassicSimilarity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Similarity, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class BM25Similarity(Similarity):
    """Ranking function based on the Okapi BM25 similarity algorithm. BM25 is a TF-IDF-like algorithm that includes length normalization (controlled by the 'b' parameter) as well as term frequency saturation (controlled by the 'k1' parameter).

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Constant filled by server.
    :vartype odata_type: str
    :ivar k1: This property controls the scaling function between the term frequency of each
     matching terms and the final relevance score of a document-query pair. By default, a value of
     1.2 is used. A value of 0.0 means the score does not scale with an increase in term frequency.
    :vartype k1: float
    :ivar b: This property controls how the length of a document affects the relevance score. By
     default, a value of 0.75 is used. A value of 0.0 means no length normalization is applied,
     while a value of 1.0 means the score is fully normalized by the length of the document.
    :vartype b: float
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'k1': {'key': 'k1', 'type': 'float'},
        'b': {'key': 'b', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword k1: This property controls the scaling function between the term frequency of each
         matching terms and the final relevance score of a document-query pair. By default, a value of
         1.2 is used. A value of 0.0 means the score does not scale with an increase in term frequency.
        :paramtype k1: float
        :keyword b: This property controls how the length of a document affects the relevance score. By
         default, a value of 0.75 is used. A value of 0.0 means no length normalization is applied,
         while a value of 1.0 means the score is fully normalized by the length of the document.
        :paramtype b: float
        """
        super(BM25Similarity, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.BM25Similarity'  # type: str
        self.k1 = kwargs.get('k1', None)
        self.b = kwargs.get('b', None)


class CharFilter(msrest.serialization.Model):
    """Base type for character filters.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: MappingCharFilter, PatternReplaceCharFilter.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the char filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the char filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.MappingCharFilter': 'MappingCharFilter', '#Microsoft.Azure.Search.PatternReplaceCharFilter': 'PatternReplaceCharFilter'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the char filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        """
        super(CharFilter, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = kwargs['name']


class CjkBigramTokenFilter(TokenFilter):
    """Forms bigrams of CJK terms that are generated from the standard tokenizer. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar ignore_scripts: The scripts to ignore.
    :vartype ignore_scripts: list[str or
     ~azure.search.documents.indexes.models.CjkBigramTokenFilterScripts]
    :ivar output_unigrams: A value indicating whether to output both unigrams and bigrams (if
     true), or just bigrams (if false). Default is false.
    :vartype output_unigrams: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'ignore_scripts': {'key': 'ignoreScripts', 'type': '[str]'},
        'output_unigrams': {'key': 'outputUnigrams', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword ignore_scripts: The scripts to ignore.
        :paramtype ignore_scripts: list[str or
         ~azure.search.documents.indexes.models.CjkBigramTokenFilterScripts]
        :keyword output_unigrams: A value indicating whether to output both unigrams and bigrams (if
         true), or just bigrams (if false). Default is false.
        :paramtype output_unigrams: bool
        """
        super(CjkBigramTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.CjkBigramTokenFilter'  # type: str
        self.ignore_scripts = kwargs.get('ignore_scripts', None)
        self.output_unigrams = kwargs.get('output_unigrams', False)


class ClassicSimilarity(Similarity):
    """Legacy similarity algorithm which uses the Lucene TFIDFSimilarity implementation of TF-IDF. This variation of TF-IDF introduces static document length normalization as well as coordinating factors that penalize documents that only partially match the searched queries.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Constant filled by server.
    :vartype odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ClassicSimilarity, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.ClassicSimilarity'  # type: str


class LexicalTokenizer(msrest.serialization.Model):
    """Base type for tokenizers.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ClassicTokenizer, EdgeNGramTokenizer, KeywordTokenizer, KeywordTokenizerV2, MicrosoftLanguageStemmingTokenizer, MicrosoftLanguageTokenizer, NGramTokenizer, PathHierarchyTokenizerV2, PatternTokenizer, LuceneStandardTokenizer, LuceneStandardTokenizerV2, UaxUrlEmailTokenizer.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.ClassicTokenizer': 'ClassicTokenizer', '#Microsoft.Azure.Search.EdgeNGramTokenizer': 'EdgeNGramTokenizer', '#Microsoft.Azure.Search.KeywordTokenizer': 'KeywordTokenizer', '#Microsoft.Azure.Search.KeywordTokenizerV2': 'KeywordTokenizerV2', '#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer': 'MicrosoftLanguageStemmingTokenizer', '#Microsoft.Azure.Search.MicrosoftLanguageTokenizer': 'MicrosoftLanguageTokenizer', '#Microsoft.Azure.Search.NGramTokenizer': 'NGramTokenizer', '#Microsoft.Azure.Search.PathHierarchyTokenizerV2': 'PathHierarchyTokenizerV2', '#Microsoft.Azure.Search.PatternTokenizer': 'PatternTokenizer', '#Microsoft.Azure.Search.StandardTokenizer': 'LuceneStandardTokenizer', '#Microsoft.Azure.Search.StandardTokenizerV2': 'LuceneStandardTokenizerV2', '#Microsoft.Azure.Search.UaxUrlEmailTokenizer': 'UaxUrlEmailTokenizer'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        """
        super(LexicalTokenizer, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = kwargs['name']


class ClassicTokenizer(LexicalTokenizer):
    """Grammar-based tokenizer that is suitable for processing most European-language documents. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_token_length: The maximum token length. Default is 255. Tokens longer than the
         maximum length are split. The maximum token length that can be used is 300 characters.
        :paramtype max_token_length: int
        """
        super(ClassicTokenizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.ClassicTokenizer'  # type: str
        self.max_token_length = kwargs.get('max_token_length', 255)


class CognitiveServicesAccount(msrest.serialization.Model):
    """Base type for describing any cognitive service resource attached to a skillset.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CognitiveServicesAccountKey, DefaultCognitiveServicesAccount.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the cognitive service resource
     attached to a skillset.Constant filled by server.
    :vartype odata_type: str
    :ivar description: Description of the cognitive service resource attached to a skillset.
    :vartype description: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.CognitiveServicesByKey': 'CognitiveServicesAccountKey', '#Microsoft.Azure.Search.DefaultCognitiveServices': 'DefaultCognitiveServicesAccount'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Description of the cognitive service resource attached to a skillset.
        :paramtype description: str
        """
        super(CognitiveServicesAccount, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.description = kwargs.get('description', None)


class CognitiveServicesAccountKey(CognitiveServicesAccount):
    """A cognitive service resource provisioned with a key that is attached to a skillset.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the cognitive service resource
     attached to a skillset.Constant filled by server.
    :vartype odata_type: str
    :ivar description: Description of the cognitive service resource attached to a skillset.
    :vartype description: str
    :ivar key: Required. The key used to provision the cognitive service resource attached to a
     skillset.
    :vartype key: str
    """

    _validation = {
        'odata_type': {'required': True},
        'key': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Description of the cognitive service resource attached to a skillset.
        :paramtype description: str
        :keyword key: Required. The key used to provision the cognitive service resource attached to a
         skillset.
        :paramtype key: str
        """
        super(CognitiveServicesAccountKey, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.CognitiveServicesByKey'  # type: str
        self.key = kwargs['key']


class CommonGramTokenFilter(TokenFilter):
    """Construct bigrams for frequently occurring terms while indexing. Single terms are still indexed too, with bigrams overlaid. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar common_words: Required. The set of common words.
    :vartype common_words: list[str]
    :ivar ignore_case: A value indicating whether common words matching will be case insensitive.
     Default is false.
    :vartype ignore_case: bool
    :ivar use_query_mode: A value that indicates whether the token filter is in query mode. When in
     query mode, the token filter generates bigrams and then removes common words and single terms
     followed by a common word. Default is false.
    :vartype use_query_mode: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'common_words': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'common_words': {'key': 'commonWords', 'type': '[str]'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
        'use_query_mode': {'key': 'queryMode', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword common_words: Required. The set of common words.
        :paramtype common_words: list[str]
        :keyword ignore_case: A value indicating whether common words matching will be case
         insensitive. Default is false.
        :paramtype ignore_case: bool
        :keyword use_query_mode: A value that indicates whether the token filter is in query mode. When
         in query mode, the token filter generates bigrams and then removes common words and single
         terms followed by a common word. Default is false.
        :paramtype use_query_mode: bool
        """
        super(CommonGramTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.CommonGramTokenFilter'  # type: str
        self.common_words = kwargs['common_words']
        self.ignore_case = kwargs.get('ignore_case', False)
        self.use_query_mode = kwargs.get('use_query_mode', False)


class ConditionalSkill(SearchIndexerSkill):
    """A skill that enables scenarios that require a Boolean operation to determine the data to assign to an output.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        """
        super(ConditionalSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Util.ConditionalSkill'  # type: str


class CorsOptions(msrest.serialization.Model):
    """Defines options to control Cross-Origin Resource Sharing (CORS) for an index.

    All required parameters must be populated in order to send to Azure.

    :ivar allowed_origins: Required. The list of origins from which JavaScript code will be granted
     access to your index. Can contain a list of hosts of the form
     {protocol}://{fully-qualified-domain-name}[:{port#}], or a single '*' to allow all origins (not
     recommended).
    :vartype allowed_origins: list[str]
    :ivar max_age_in_seconds: The duration for which browsers should cache CORS preflight
     responses. Defaults to 5 minutes.
    :vartype max_age_in_seconds: long
    """

    _validation = {
        'allowed_origins': {'required': True},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'max_age_in_seconds': {'key': 'maxAgeInSeconds', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword allowed_origins: Required. The list of origins from which JavaScript code will be
         granted access to your index. Can contain a list of hosts of the form
         {protocol}://{fully-qualified-domain-name}[:{port#}], or a single '*' to allow all origins (not
         recommended).
        :paramtype allowed_origins: list[str]
        :keyword max_age_in_seconds: The duration for which browsers should cache CORS preflight
         responses. Defaults to 5 minutes.
        :paramtype max_age_in_seconds: long
        """
        super(CorsOptions, self).__init__(**kwargs)
        self.allowed_origins = kwargs['allowed_origins']
        self.max_age_in_seconds = kwargs.get('max_age_in_seconds', None)


class LexicalAnalyzer(msrest.serialization.Model):
    """Base type for analyzers.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomAnalyzer, PatternAnalyzer, LuceneStandardAnalyzer, StopAnalyzer.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.CustomAnalyzer': 'CustomAnalyzer', '#Microsoft.Azure.Search.PatternAnalyzer': 'PatternAnalyzer', '#Microsoft.Azure.Search.StandardAnalyzer': 'LuceneStandardAnalyzer', '#Microsoft.Azure.Search.StopAnalyzer': 'StopAnalyzer'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the analyzer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        """
        super(LexicalAnalyzer, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = kwargs['name']


class CustomAnalyzer(LexicalAnalyzer):
    """Allows you to take control over the process of converting text into indexable/searchable tokens. It's a user-defined configuration consisting of a single predefined tokenizer and one or more filters. The tokenizer is responsible for breaking text into tokens, and the filters for modifying tokens emitted by the tokenizer.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar tokenizer: Required. The name of the tokenizer to use to divide continuous text into a
     sequence of tokens, such as breaking a sentence into words. Possible values include: "classic",
     "edgeNGram", "keyword_v2", "letter", "lowercase", "microsoft_language_tokenizer",
     "microsoft_language_stemming_tokenizer", "nGram", "path_hierarchy_v2", "pattern",
     "standard_v2", "uax_url_email", "whitespace".
    :vartype tokenizer: str or ~azure.search.documents.indexes.models.LexicalTokenizerName
    :ivar token_filters: A list of token filters used to filter out or modify the tokens generated
     by a tokenizer. For example, you can specify a lowercase filter that converts all characters to
     lowercase. The filters are run in the order in which they are listed.
    :vartype token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
    :ivar char_filters: A list of character filters used to prepare input text before it is
     processed by the tokenizer. For instance, they can replace certain characters or symbols. The
     filters are run in the order in which they are listed.
    :vartype char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'tokenizer': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tokenizer': {'key': 'tokenizer', 'type': 'str'},
        'token_filters': {'key': 'tokenFilters', 'type': '[str]'},
        'char_filters': {'key': 'charFilters', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the analyzer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword tokenizer: Required. The name of the tokenizer to use to divide continuous text into a
         sequence of tokens, such as breaking a sentence into words. Possible values include: "classic",
         "edgeNGram", "keyword_v2", "letter", "lowercase", "microsoft_language_tokenizer",
         "microsoft_language_stemming_tokenizer", "nGram", "path_hierarchy_v2", "pattern",
         "standard_v2", "uax_url_email", "whitespace".
        :paramtype tokenizer: str or ~azure.search.documents.indexes.models.LexicalTokenizerName
        :keyword token_filters: A list of token filters used to filter out or modify the tokens
         generated by a tokenizer. For example, you can specify a lowercase filter that converts all
         characters to lowercase. The filters are run in the order in which they are listed.
        :paramtype token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
        :keyword char_filters: A list of character filters used to prepare input text before it is
         processed by the tokenizer. For instance, they can replace certain characters or symbols. The
         filters are run in the order in which they are listed.
        :paramtype char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
        """
        super(CustomAnalyzer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.CustomAnalyzer'  # type: str
        self.tokenizer = kwargs['tokenizer']
        self.token_filters = kwargs.get('token_filters', None)
        self.char_filters = kwargs.get('char_filters', None)


class CustomEntity(msrest.serialization.Model):
    """An object that contains information about the matches that were found, and related metadata.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The top-level entity descriptor. Matches in the skill output will be
     grouped by this name, and it should represent the "normalized" form of the text being found.
    :vartype name: str
    :ivar description: This field can be used as a passthrough for custom metadata about the
     matched text(s). The value of this field will appear with every match of its entity in the
     skill output.
    :vartype description: str
    :ivar type: This field can be used as a passthrough for custom metadata about the matched
     text(s). The value of this field will appear with every match of its entity in the skill
     output.
    :vartype type: str
    :ivar subtype: This field can be used as a passthrough for custom metadata about the matched
     text(s). The value of this field will appear with every match of its entity in the skill
     output.
    :vartype subtype: str
    :ivar id: This field can be used as a passthrough for custom metadata about the matched
     text(s). The value of this field will appear with every match of its entity in the skill
     output.
    :vartype id: str
    :ivar case_sensitive: Defaults to false. Boolean value denoting whether comparisons with the
     entity name should be sensitive to character casing. Sample case insensitive matches of
     "Microsoft" could be: microsoft, microSoft, MICROSOFT.
    :vartype case_sensitive: bool
    :ivar accent_sensitive: Defaults to false. Boolean value denoting whether comparisons with the
     entity name should be sensitive to accent.
    :vartype accent_sensitive: bool
    :ivar fuzzy_edit_distance: Defaults to 0. Maximum value of 5. Denotes the acceptable number of
     divergent characters that would still constitute a match with the entity name. The smallest
     possible fuzziness for any given match is returned. For instance, if the edit distance is set
     to 3, "Windows10" would still match "Windows", "Windows10" and "Windows 7". When case
     sensitivity is set to false, case differences do NOT count towards fuzziness tolerance, but
     otherwise do.
    :vartype fuzzy_edit_distance: int
    :ivar default_case_sensitive: Changes the default case sensitivity value for this entity. It be
     used to change the default value of all aliases caseSensitive values.
    :vartype default_case_sensitive: bool
    :ivar default_accent_sensitive: Changes the default accent sensitivity value for this entity.
     It be used to change the default value of all aliases accentSensitive values.
    :vartype default_accent_sensitive: bool
    :ivar default_fuzzy_edit_distance: Changes the default fuzzy edit distance value for this
     entity. It can be used to change the default value of all aliases fuzzyEditDistance values.
    :vartype default_fuzzy_edit_distance: int
    :ivar aliases: An array of complex objects that can be used to specify alternative spellings or
     synonyms to the root entity name.
    :vartype aliases: list[~azure.search.documents.indexes.models.CustomEntityAlias]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'subtype': {'key': 'subtype', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'case_sensitive': {'key': 'caseSensitive', 'type': 'bool'},
        'accent_sensitive': {'key': 'accentSensitive', 'type': 'bool'},
        'fuzzy_edit_distance': {'key': 'fuzzyEditDistance', 'type': 'int'},
        'default_case_sensitive': {'key': 'defaultCaseSensitive', 'type': 'bool'},
        'default_accent_sensitive': {'key': 'defaultAccentSensitive', 'type': 'bool'},
        'default_fuzzy_edit_distance': {'key': 'defaultFuzzyEditDistance', 'type': 'int'},
        'aliases': {'key': 'aliases', 'type': '[CustomEntityAlias]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The top-level entity descriptor. Matches in the skill output will be
         grouped by this name, and it should represent the "normalized" form of the text being found.
        :paramtype name: str
        :keyword description: This field can be used as a passthrough for custom metadata about the
         matched text(s). The value of this field will appear with every match of its entity in the
         skill output.
        :paramtype description: str
        :keyword type: This field can be used as a passthrough for custom metadata about the matched
         text(s). The value of this field will appear with every match of its entity in the skill
         output.
        :paramtype type: str
        :keyword subtype: This field can be used as a passthrough for custom metadata about the matched
         text(s). The value of this field will appear with every match of its entity in the skill
         output.
        :paramtype subtype: str
        :keyword id: This field can be used as a passthrough for custom metadata about the matched
         text(s). The value of this field will appear with every match of its entity in the skill
         output.
        :paramtype id: str
        :keyword case_sensitive: Defaults to false. Boolean value denoting whether comparisons with the
         entity name should be sensitive to character casing. Sample case insensitive matches of
         "Microsoft" could be: microsoft, microSoft, MICROSOFT.
        :paramtype case_sensitive: bool
        :keyword accent_sensitive: Defaults to false. Boolean value denoting whether comparisons with
         the entity name should be sensitive to accent.
        :paramtype accent_sensitive: bool
        :keyword fuzzy_edit_distance: Defaults to 0. Maximum value of 5. Denotes the acceptable number
         of divergent characters that would still constitute a match with the entity name. The smallest
         possible fuzziness for any given match is returned. For instance, if the edit distance is set
         to 3, "Windows10" would still match "Windows", "Windows10" and "Windows 7". When case
         sensitivity is set to false, case differences do NOT count towards fuzziness tolerance, but
         otherwise do.
        :paramtype fuzzy_edit_distance: int
        :keyword default_case_sensitive: Changes the default case sensitivity value for this entity. It
         be used to change the default value of all aliases caseSensitive values.
        :paramtype default_case_sensitive: bool
        :keyword default_accent_sensitive: Changes the default accent sensitivity value for this
         entity. It be used to change the default value of all aliases accentSensitive values.
        :paramtype default_accent_sensitive: bool
        :keyword default_fuzzy_edit_distance: Changes the default fuzzy edit distance value for this
         entity. It can be used to change the default value of all aliases fuzzyEditDistance values.
        :paramtype default_fuzzy_edit_distance: int
        :keyword aliases: An array of complex objects that can be used to specify alternative spellings
         or synonyms to the root entity name.
        :paramtype aliases: list[~azure.search.documents.indexes.models.CustomEntityAlias]
        """
        super(CustomEntity, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.type = kwargs.get('type', None)
        self.subtype = kwargs.get('subtype', None)
        self.id = kwargs.get('id', None)
        self.case_sensitive = kwargs.get('case_sensitive', None)
        self.accent_sensitive = kwargs.get('accent_sensitive', None)
        self.fuzzy_edit_distance = kwargs.get('fuzzy_edit_distance', None)
        self.default_case_sensitive = kwargs.get('default_case_sensitive', None)
        self.default_accent_sensitive = kwargs.get('default_accent_sensitive', None)
        self.default_fuzzy_edit_distance = kwargs.get('default_fuzzy_edit_distance', None)
        self.aliases = kwargs.get('aliases', None)


class CustomEntityAlias(msrest.serialization.Model):
    """A complex object that can be used to specify alternative spellings or synonyms to the root entity name.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Required. The text of the alias.
    :vartype text: str
    :ivar case_sensitive: Determine if the alias is case sensitive.
    :vartype case_sensitive: bool
    :ivar accent_sensitive: Determine if the alias is accent sensitive.
    :vartype accent_sensitive: bool
    :ivar fuzzy_edit_distance: Determine the fuzzy edit distance of the alias.
    :vartype fuzzy_edit_distance: int
    """

    _validation = {
        'text': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'case_sensitive': {'key': 'caseSensitive', 'type': 'bool'},
        'accent_sensitive': {'key': 'accentSensitive', 'type': 'bool'},
        'fuzzy_edit_distance': {'key': 'fuzzyEditDistance', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword text: Required. The text of the alias.
        :paramtype text: str
        :keyword case_sensitive: Determine if the alias is case sensitive.
        :paramtype case_sensitive: bool
        :keyword accent_sensitive: Determine if the alias is accent sensitive.
        :paramtype accent_sensitive: bool
        :keyword fuzzy_edit_distance: Determine the fuzzy edit distance of the alias.
        :paramtype fuzzy_edit_distance: int
        """
        super(CustomEntityAlias, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.case_sensitive = kwargs.get('case_sensitive', None)
        self.accent_sensitive = kwargs.get('accent_sensitive', None)
        self.fuzzy_edit_distance = kwargs.get('fuzzy_edit_distance', None)


class CustomEntityLookupSkill(SearchIndexerSkill):
    """A skill looks for text from a custom, user-defined list of words and phrases.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "da", "de", "en", "es", "fi", "fr", "it", "ko", "pt".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.CustomEntityLookupSkillLanguage
    :ivar entities_definition_uri: Path to a JSON or CSV file containing all the target text to
     match against. This entity definition is read at the beginning of an indexer run. Any updates
     to this file during an indexer run will not take effect until subsequent runs. This config must
     be accessible over HTTPS.
    :vartype entities_definition_uri: str
    :ivar inline_entities_definition: The inline CustomEntity definition.
    :vartype inline_entities_definition: list[~azure.search.documents.indexes.models.CustomEntity]
    :ivar global_default_case_sensitive: A global flag for CaseSensitive. If CaseSensitive is not
     set in CustomEntity, this value will be the default value.
    :vartype global_default_case_sensitive: bool
    :ivar global_default_accent_sensitive: A global flag for AccentSensitive. If AccentSensitive is
     not set in CustomEntity, this value will be the default value.
    :vartype global_default_accent_sensitive: bool
    :ivar global_default_fuzzy_edit_distance: A global flag for FuzzyEditDistance. If
     FuzzyEditDistance is not set in CustomEntity, this value will be the default value.
    :vartype global_default_fuzzy_edit_distance: int
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'entities_definition_uri': {'key': 'entitiesDefinitionUri', 'type': 'str'},
        'inline_entities_definition': {'key': 'inlineEntitiesDefinition', 'type': '[CustomEntity]'},
        'global_default_case_sensitive': {'key': 'globalDefaultCaseSensitive', 'type': 'bool'},
        'global_default_accent_sensitive': {'key': 'globalDefaultAccentSensitive', 'type': 'bool'},
        'global_default_fuzzy_edit_distance': {'key': 'globalDefaultFuzzyEditDistance', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
         Possible values include: "da", "de", "en", "es", "fi", "fr", "it", "ko", "pt".
        :paramtype default_language_code: str or
         ~azure.search.documents.indexes.models.CustomEntityLookupSkillLanguage
        :keyword entities_definition_uri: Path to a JSON or CSV file containing all the target text to
         match against. This entity definition is read at the beginning of an indexer run. Any updates
         to this file during an indexer run will not take effect until subsequent runs. This config must
         be accessible over HTTPS.
        :paramtype entities_definition_uri: str
        :keyword inline_entities_definition: The inline CustomEntity definition.
        :paramtype inline_entities_definition:
         list[~azure.search.documents.indexes.models.CustomEntity]
        :keyword global_default_case_sensitive: A global flag for CaseSensitive. If CaseSensitive is
         not set in CustomEntity, this value will be the default value.
        :paramtype global_default_case_sensitive: bool
        :keyword global_default_accent_sensitive: A global flag for AccentSensitive. If AccentSensitive
         is not set in CustomEntity, this value will be the default value.
        :paramtype global_default_accent_sensitive: bool
        :keyword global_default_fuzzy_edit_distance: A global flag for FuzzyEditDistance. If
         FuzzyEditDistance is not set in CustomEntity, this value will be the default value.
        :paramtype global_default_fuzzy_edit_distance: int
        """
        super(CustomEntityLookupSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.CustomEntityLookupSkill'  # type: str
        self.default_language_code = kwargs.get('default_language_code', None)
        self.entities_definition_uri = kwargs.get('entities_definition_uri', None)
        self.inline_entities_definition = kwargs.get('inline_entities_definition', None)
        self.global_default_case_sensitive = kwargs.get('global_default_case_sensitive', None)
        self.global_default_accent_sensitive = kwargs.get('global_default_accent_sensitive', None)
        self.global_default_fuzzy_edit_distance = kwargs.get('global_default_fuzzy_edit_distance', None)


class LexicalNormalizer(msrest.serialization.Model):
    """Base type for normalizers.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomNormalizer.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the normalizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the normalizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters. It cannot end in '.microsoft' nor '.lucene', nor be named 'asciifolding',
     'standard', 'lowercase', 'uppercase', or 'elision'.
    :vartype name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.CustomNormalizer': 'CustomNormalizer'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the normalizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters. It cannot end in '.microsoft' nor '.lucene', nor be named
         'asciifolding', 'standard', 'lowercase', 'uppercase', or 'elision'.
        :paramtype name: str
        """
        super(LexicalNormalizer, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.name = kwargs['name']


class CustomNormalizer(LexicalNormalizer):
    """Allows you to configure normalization for filterable, sortable, and facetable fields, which by default operate with strict matching. This is a user-defined configuration consisting of at least one or more filters, which modify the token that is stored.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the normalizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the normalizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters. It cannot end in '.microsoft' nor '.lucene', nor be named 'asciifolding',
     'standard', 'lowercase', 'uppercase', or 'elision'.
    :vartype name: str
    :ivar token_filters: A list of token filters used to filter out or modify the input token. For
     example, you can specify a lowercase filter that converts all characters to lowercase. The
     filters are run in the order in which they are listed.
    :vartype token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
    :ivar char_filters: A list of character filters used to prepare input text before it is
     processed. For instance, they can replace certain characters or symbols. The filters are run in
     the order in which they are listed.
    :vartype char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'token_filters': {'key': 'tokenFilters', 'type': '[str]'},
        'char_filters': {'key': 'charFilters', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the normalizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters. It cannot end in '.microsoft' nor '.lucene', nor be named
         'asciifolding', 'standard', 'lowercase', 'uppercase', or 'elision'.
        :paramtype name: str
        :keyword token_filters: A list of token filters used to filter out or modify the input token.
         For example, you can specify a lowercase filter that converts all characters to lowercase. The
         filters are run in the order in which they are listed.
        :paramtype token_filters: list[str or ~azure.search.documents.indexes.models.TokenFilterName]
        :keyword char_filters: A list of character filters used to prepare input text before it is
         processed. For instance, they can replace certain characters or symbols. The filters are run in
         the order in which they are listed.
        :paramtype char_filters: list[str or ~azure.search.documents.indexes.models.CharFilterName]
        """
        super(CustomNormalizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.CustomNormalizer'  # type: str
        self.token_filters = kwargs.get('token_filters', None)
        self.char_filters = kwargs.get('char_filters', None)


class DataChangeDetectionPolicy(msrest.serialization.Model):
    """Base type for data change detection policies.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: HighWaterMarkChangeDetectionPolicy, SqlIntegratedChangeTrackingPolicy.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the data change detection
     policy.Constant filled by server.
    :vartype odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy': 'HighWaterMarkChangeDetectionPolicy', '#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy': 'SqlIntegratedChangeTrackingPolicy'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DataChangeDetectionPolicy, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class DataDeletionDetectionPolicy(msrest.serialization.Model):
    """Base type for data deletion detection policies.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SoftDeleteColumnDeletionDetectionPolicy.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the data deletion detection
     policy.Constant filled by server.
    :vartype odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy': 'SoftDeleteColumnDeletionDetectionPolicy'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(DataDeletionDetectionPolicy, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class DataSourceCredentials(msrest.serialization.Model):
    """Represents credentials that can be used to connect to a datasource.

    :ivar connection_string: The connection string for the datasource. Set to ':code:`<unchanged>`'
     if you do not want the connection string updated.
    :vartype connection_string: str
    """

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword connection_string: The connection string for the datasource. Set to
         ':code:`<unchanged>`' if you do not want the connection string updated.
        :paramtype connection_string: str
        """
        super(DataSourceCredentials, self).__init__(**kwargs)
        self.connection_string = kwargs.get('connection_string', None)


class DefaultCognitiveServicesAccount(CognitiveServicesAccount):
    """An empty object that represents the default cognitive service resource for a skillset.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the cognitive service resource
     attached to a skillset.Constant filled by server.
    :vartype odata_type: str
    :ivar description: Description of the cognitive service resource attached to a skillset.
    :vartype description: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword description: Description of the cognitive service resource attached to a skillset.
        :paramtype description: str
        """
        super(DefaultCognitiveServicesAccount, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.DefaultCognitiveServices'  # type: str


class DictionaryDecompounderTokenFilter(TokenFilter):
    """Decomposes compound words found in many Germanic languages. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar word_list: Required. The list of words to match against.
    :vartype word_list: list[str]
    :ivar min_word_size: The minimum word size. Only words longer than this get processed. Default
     is 5. Maximum is 300.
    :vartype min_word_size: int
    :ivar min_subword_size: The minimum subword size. Only subwords longer than this are outputted.
     Default is 2. Maximum is 300.
    :vartype min_subword_size: int
    :ivar max_subword_size: The maximum subword size. Only subwords shorter than this are
     outputted. Default is 15. Maximum is 300.
    :vartype max_subword_size: int
    :ivar only_longest_match: A value indicating whether to add only the longest matching subword
     to the output. Default is false.
    :vartype only_longest_match: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'word_list': {'required': True},
        'min_word_size': {'maximum': 300},
        'min_subword_size': {'maximum': 300},
        'max_subword_size': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'word_list': {'key': 'wordList', 'type': '[str]'},
        'min_word_size': {'key': 'minWordSize', 'type': 'int'},
        'min_subword_size': {'key': 'minSubwordSize', 'type': 'int'},
        'max_subword_size': {'key': 'maxSubwordSize', 'type': 'int'},
        'only_longest_match': {'key': 'onlyLongestMatch', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword word_list: Required. The list of words to match against.
        :paramtype word_list: list[str]
        :keyword min_word_size: The minimum word size. Only words longer than this get processed.
         Default is 5. Maximum is 300.
        :paramtype min_word_size: int
        :keyword min_subword_size: The minimum subword size. Only subwords longer than this are
         outputted. Default is 2. Maximum is 300.
        :paramtype min_subword_size: int
        :keyword max_subword_size: The maximum subword size. Only subwords shorter than this are
         outputted. Default is 15. Maximum is 300.
        :paramtype max_subword_size: int
        :keyword only_longest_match: A value indicating whether to add only the longest matching
         subword to the output. Default is false.
        :paramtype only_longest_match: bool
        """
        super(DictionaryDecompounderTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter'  # type: str
        self.word_list = kwargs['word_list']
        self.min_word_size = kwargs.get('min_word_size', 5)
        self.min_subword_size = kwargs.get('min_subword_size', 2)
        self.max_subword_size = kwargs.get('max_subword_size', 15)
        self.only_longest_match = kwargs.get('only_longest_match', False)


class ScoringFunction(msrest.serialization.Model):
    """Base type for functions that can modify document scores during ranking.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: DistanceScoringFunction, FreshnessScoringFunction, MagnitudeScoringFunction, TagScoringFunction.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :vartype type: str
    :ivar field_name: Required. The name of the field used as input to the scoring function.
    :vartype field_name: str
    :ivar boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'distance': 'DistanceScoringFunction', 'freshness': 'FreshnessScoringFunction', 'magnitude': 'MagnitudeScoringFunction', 'tag': 'TagScoringFunction'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword field_name: Required. The name of the field used as input to the scoring function.
        :paramtype field_name: str
        :keyword boost: Required. A multiplier for the raw score. Must be a positive number not equal
         to 1.0.
        :paramtype boost: float
        :keyword interpolation: A value indicating how boosting will be interpolated across document
         scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
         "logarithmic".
        :paramtype interpolation: str or
         ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
        """
        super(ScoringFunction, self).__init__(**kwargs)
        self.type = None  # type: Optional[str]
        self.field_name = kwargs['field_name']
        self.boost = kwargs['boost']
        self.interpolation = kwargs.get('interpolation', None)


class DistanceScoringFunction(ScoringFunction):
    """Defines a function that boosts scores based on distance from a geographic location.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :vartype type: str
    :ivar field_name: Required. The name of the field used as input to the scoring function.
    :vartype field_name: str
    :ivar boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :ivar parameters: Required. Parameter values for the distance scoring function.
    :vartype parameters: ~azure.search.documents.indexes.models.DistanceScoringParameters
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
        'parameters': {'key': 'distance', 'type': 'DistanceScoringParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword field_name: Required. The name of the field used as input to the scoring function.
        :paramtype field_name: str
        :keyword boost: Required. A multiplier for the raw score. Must be a positive number not equal
         to 1.0.
        :paramtype boost: float
        :keyword interpolation: A value indicating how boosting will be interpolated across document
         scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
         "logarithmic".
        :paramtype interpolation: str or
         ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
        :keyword parameters: Required. Parameter values for the distance scoring function.
        :paramtype parameters: ~azure.search.documents.indexes.models.DistanceScoringParameters
        """
        super(DistanceScoringFunction, self).__init__(**kwargs)
        self.type = 'distance'  # type: str
        self.parameters = kwargs['parameters']


class DistanceScoringParameters(msrest.serialization.Model):
    """Provides parameter values to a distance scoring function.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_point_parameter: Required. The name of the parameter passed in search queries
     to specify the reference location.
    :vartype reference_point_parameter: str
    :ivar boosting_distance: Required. The distance in kilometers from the reference location where
     the boosting range ends.
    :vartype boosting_distance: float
    """

    _validation = {
        'reference_point_parameter': {'required': True},
        'boosting_distance': {'required': True},
    }

    _attribute_map = {
        'reference_point_parameter': {'key': 'referencePointParameter', 'type': 'str'},
        'boosting_distance': {'key': 'boostingDistance', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword reference_point_parameter: Required. The name of the parameter passed in search
         queries to specify the reference location.
        :paramtype reference_point_parameter: str
        :keyword boosting_distance: Required. The distance in kilometers from the reference location
         where the boosting range ends.
        :paramtype boosting_distance: float
        """
        super(DistanceScoringParameters, self).__init__(**kwargs)
        self.reference_point_parameter = kwargs['reference_point_parameter']
        self.boosting_distance = kwargs['boosting_distance']


class DocumentExtractionSkill(SearchIndexerSkill):
    """A skill that extracts content from a file within the enrichment pipeline.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar parsing_mode: The parsingMode for the skill. Will be set to 'default' if not defined.
    :vartype parsing_mode: str
    :ivar data_to_extract: The type of data to be extracted for the skill. Will be set to
     'contentAndMetadata' if not defined.
    :vartype data_to_extract: str
    :ivar configuration: A dictionary of configurations for the skill.
    :vartype configuration: dict[str, any]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'parsing_mode': {'key': 'parsingMode', 'type': 'str'},
        'data_to_extract': {'key': 'dataToExtract', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword parsing_mode: The parsingMode for the skill. Will be set to 'default' if not defined.
        :paramtype parsing_mode: str
        :keyword data_to_extract: The type of data to be extracted for the skill. Will be set to
         'contentAndMetadata' if not defined.
        :paramtype data_to_extract: str
        :keyword configuration: A dictionary of configurations for the skill.
        :paramtype configuration: dict[str, any]
        """
        super(DocumentExtractionSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Util.DocumentExtractionSkill'  # type: str
        self.parsing_mode = kwargs.get('parsing_mode', None)
        self.data_to_extract = kwargs.get('data_to_extract', None)
        self.configuration = kwargs.get('configuration', None)


class DocumentKeysOrIds(msrest.serialization.Model):
    """DocumentKeysOrIds.

    :ivar document_keys: document keys to be reset.
    :vartype document_keys: list[str]
    :ivar datasource_document_ids: datasource document identifiers to be reset.
    :vartype datasource_document_ids: list[str]
    """

    _attribute_map = {
        'document_keys': {'key': 'documentKeys', 'type': '[str]'},
        'datasource_document_ids': {'key': 'datasourceDocumentIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword document_keys: document keys to be reset.
        :paramtype document_keys: list[str]
        :keyword datasource_document_ids: datasource document identifiers to be reset.
        :paramtype datasource_document_ids: list[str]
        """
        super(DocumentKeysOrIds, self).__init__(**kwargs)
        self.document_keys = kwargs.get('document_keys', None)
        self.datasource_document_ids = kwargs.get('datasource_document_ids', None)


class EdgeNGramTokenFilter(TokenFilter):
    """Generates n-grams of the given size(s) starting from the front or the back of an input token. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Must be less than the value of
     maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2.
    :vartype max_gram: int
    :ivar side: Specifies which side of the input the n-gram should be generated from. Default is
     "front". Possible values include: "front", "back".
    :vartype side: str or ~azure.search.documents.indexes.models.EdgeNGramTokenFilterSide
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
        'side': {'key': 'side', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword min_gram: The minimum n-gram length. Default is 1. Must be less than the value of
         maxGram.
        :paramtype min_gram: int
        :keyword max_gram: The maximum n-gram length. Default is 2.
        :paramtype max_gram: int
        :keyword side: Specifies which side of the input the n-gram should be generated from. Default
         is "front". Possible values include: "front", "back".
        :paramtype side: str or ~azure.search.documents.indexes.models.EdgeNGramTokenFilterSide
        """
        super(EdgeNGramTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.EdgeNGramTokenFilter'  # type: str
        self.min_gram = kwargs.get('min_gram', 1)
        self.max_gram = kwargs.get('max_gram', 2)
        self.side = kwargs.get('side', None)


class EdgeNGramTokenFilterV2(TokenFilter):
    """Generates n-grams of the given size(s) starting from the front or the back of an input token. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :vartype max_gram: int
    :ivar side: Specifies which side of the input the n-gram should be generated from. Default is
     "front". Possible values include: "front", "back".
    :vartype side: str or ~azure.search.documents.indexes.models.EdgeNGramTokenFilterSide
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_gram': {'maximum': 300},
        'max_gram': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
        'side': {'key': 'side', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than
         the value of maxGram.
        :paramtype min_gram: int
        :keyword max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
        :paramtype max_gram: int
        :keyword side: Specifies which side of the input the n-gram should be generated from. Default
         is "front". Possible values include: "front", "back".
        :paramtype side: str or ~azure.search.documents.indexes.models.EdgeNGramTokenFilterSide
        """
        super(EdgeNGramTokenFilterV2, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.EdgeNGramTokenFilterV2'  # type: str
        self.min_gram = kwargs.get('min_gram', 1)
        self.max_gram = kwargs.get('max_gram', 2)
        self.side = kwargs.get('side', None)


class EdgeNGramTokenizer(LexicalTokenizer):
    """Tokenizes the input from an edge into n-grams of the given size(s). This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :vartype max_gram: int
    :ivar token_chars: Character classes to keep in the tokens.
    :vartype token_chars: list[str or ~azure.search.documents.indexes.models.TokenCharacterKind]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_gram': {'maximum': 300},
        'max_gram': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
        'token_chars': {'key': 'tokenChars', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than
         the value of maxGram.
        :paramtype min_gram: int
        :keyword max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
        :paramtype max_gram: int
        :keyword token_chars: Character classes to keep in the tokens.
        :paramtype token_chars: list[str or ~azure.search.documents.indexes.models.TokenCharacterKind]
        """
        super(EdgeNGramTokenizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.EdgeNGramTokenizer'  # type: str
        self.min_gram = kwargs.get('min_gram', 1)
        self.max_gram = kwargs.get('max_gram', 2)
        self.token_chars = kwargs.get('token_chars', None)


class ElisionTokenFilter(TokenFilter):
    """Removes elisions. For example, "l'avion" (the plane) will be converted to "avion" (plane). This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar articles: The set of articles to remove.
    :vartype articles: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'articles': {'key': 'articles', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword articles: The set of articles to remove.
        :paramtype articles: list[str]
        """
        super(ElisionTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.ElisionTokenFilter'  # type: str
        self.articles = kwargs.get('articles', None)


class EntityLinkingSkill(SearchIndexerSkill):
    """Using the Text Analytics API, extracts linked entities from text.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
    :vartype default_language_code: str
    :ivar minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :vartype minimum_precision: float
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'minimum_precision': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'minimum_precision': {'key': 'minimumPrecision', 'type': 'float'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
        :paramtype default_language_code: str
        :keyword minimum_precision: A value between 0 and 1 that be used to only include entities whose
         confidence score is greater than the value specified. If not set (default), or if explicitly
         set to null, all entities will be included.
        :paramtype minimum_precision: float
        :keyword model_version: The version of the model to use when calling the Text Analytics
         service. It will default to the latest available when not specified. We recommend you do not
         specify this value unless absolutely necessary.
        :paramtype model_version: str
        """
        super(EntityLinkingSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.V3.EntityLinkingSkill'  # type: str
        self.default_language_code = kwargs.get('default_language_code', None)
        self.minimum_precision = kwargs.get('minimum_precision', None)
        self.model_version = kwargs.get('model_version', None)


class EntityRecognitionSkill(SearchIndexerSkill):
    """Text analytics entity recognition.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar categories: A list of entity categories that should be extracted.
    :vartype categories: list[str or ~azure.search.documents.indexes.models.EntityCategory]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "ar", "cs", "zh-Hans", "zh-Hant", "da", "nl", "en", "fi", "fr", "de",
     "el", "hu", "it", "ja", "ko", "no", "pl", "pt-PT", "pt-BR", "ru", "es", "sv", "tr".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.EntityRecognitionSkillLanguage
    :ivar include_typeless_entities: Determines whether or not to include entities which are well
     known but don't conform to a pre-defined type. If this configuration is not set (default), set
     to null or set to false, entities which don't conform to one of the pre-defined types will not
     be surfaced.
    :vartype include_typeless_entities: bool
    :ivar minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :vartype minimum_precision: float
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'categories': {'key': 'categories', 'type': '[str]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'include_typeless_entities': {'key': 'includeTypelessEntities', 'type': 'bool'},
        'minimum_precision': {'key': 'minimumPrecision', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword categories: A list of entity categories that should be extracted.
        :paramtype categories: list[str or ~azure.search.documents.indexes.models.EntityCategory]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
         Possible values include: "ar", "cs", "zh-Hans", "zh-Hant", "da", "nl", "en", "fi", "fr", "de",
         "el", "hu", "it", "ja", "ko", "no", "pl", "pt-PT", "pt-BR", "ru", "es", "sv", "tr".
        :paramtype default_language_code: str or
         ~azure.search.documents.indexes.models.EntityRecognitionSkillLanguage
        :keyword include_typeless_entities: Determines whether or not to include entities which are
         well known but don't conform to a pre-defined type. If this configuration is not set (default),
         set to null or set to false, entities which don't conform to one of the pre-defined types will
         not be surfaced.
        :paramtype include_typeless_entities: bool
        :keyword minimum_precision: A value between 0 and 1 that be used to only include entities whose
         confidence score is greater than the value specified. If not set (default), or if explicitly
         set to null, all entities will be included.
        :paramtype minimum_precision: float
        """
        super(EntityRecognitionSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.EntityRecognitionSkill'  # type: str
        self.categories = kwargs.get('categories', None)
        self.default_language_code = kwargs.get('default_language_code', None)
        self.include_typeless_entities = kwargs.get('include_typeless_entities', None)
        self.minimum_precision = kwargs.get('minimum_precision', None)


class EntityRecognitionSkillV3(SearchIndexerSkill):
    """Using the Text Analytics API, extracts entities of different types from text.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar categories: A list of entity categories that should be extracted.
    :vartype categories: list[str]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
    :vartype default_language_code: str
    :ivar minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :vartype minimum_precision: float
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'minimum_precision': {'maximum': 1, 'minimum': 0},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'categories': {'key': 'categories', 'type': '[str]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'minimum_precision': {'key': 'minimumPrecision', 'type': 'float'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword categories: A list of entity categories that should be extracted.
        :paramtype categories: list[str]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
        :paramtype default_language_code: str
        :keyword minimum_precision: A value between 0 and 1 that be used to only include entities whose
         confidence score is greater than the value specified. If not set (default), or if explicitly
         set to null, all entities will be included.
        :paramtype minimum_precision: float
        :keyword model_version: The version of the model to use when calling the Text Analytics
         service. It will default to the latest available when not specified. We recommend you do not
         specify this value unless absolutely necessary.
        :paramtype model_version: str
        """
        super(EntityRecognitionSkillV3, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.V3.EntityRecognitionSkill'  # type: str
        self.categories = kwargs.get('categories', None)
        self.default_language_code = kwargs.get('default_language_code', None)
        self.minimum_precision = kwargs.get('minimum_precision', None)
        self.model_version = kwargs.get('model_version', None)


class FieldMapping(msrest.serialization.Model):
    """Defines a mapping between a field in a data source and a target field in an index.

    All required parameters must be populated in order to send to Azure.

    :ivar source_field_name: Required. The name of the field in the data source.
    :vartype source_field_name: str
    :ivar target_field_name: The name of the target field in the index. Same as the source field
     name by default.
    :vartype target_field_name: str
    :ivar mapping_function: A function to apply to each source field value before indexing.
    :vartype mapping_function: ~azure.search.documents.indexes.models.FieldMappingFunction
    """

    _validation = {
        'source_field_name': {'required': True},
    }

    _attribute_map = {
        'source_field_name': {'key': 'sourceFieldName', 'type': 'str'},
        'target_field_name': {'key': 'targetFieldName', 'type': 'str'},
        'mapping_function': {'key': 'mappingFunction', 'type': 'FieldMappingFunction'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword source_field_name: Required. The name of the field in the data source.
        :paramtype source_field_name: str
        :keyword target_field_name: The name of the target field in the index. Same as the source field
         name by default.
        :paramtype target_field_name: str
        :keyword mapping_function: A function to apply to each source field value before indexing.
        :paramtype mapping_function: ~azure.search.documents.indexes.models.FieldMappingFunction
        """
        super(FieldMapping, self).__init__(**kwargs)
        self.source_field_name = kwargs['source_field_name']
        self.target_field_name = kwargs.get('target_field_name', None)
        self.mapping_function = kwargs.get('mapping_function', None)


class FieldMappingFunction(msrest.serialization.Model):
    """Represents a function that transforms a value from a data source before indexing.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the field mapping function.
    :vartype name: str
    :ivar parameters: A dictionary of parameter name/value pairs to pass to the function. Each
     value must be of a primitive type.
    :vartype parameters: dict[str, any]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the field mapping function.
        :paramtype name: str
        :keyword parameters: A dictionary of parameter name/value pairs to pass to the function. Each
         value must be of a primitive type.
        :paramtype parameters: dict[str, any]
        """
        super(FieldMappingFunction, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.parameters = kwargs.get('parameters', None)


class FreshnessScoringFunction(ScoringFunction):
    """Defines a function that boosts scores based on the value of a date-time field.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :vartype type: str
    :ivar field_name: Required. The name of the field used as input to the scoring function.
    :vartype field_name: str
    :ivar boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :ivar parameters: Required. Parameter values for the freshness scoring function.
    :vartype parameters: ~azure.search.documents.indexes.models.FreshnessScoringParameters
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
        'parameters': {'key': 'freshness', 'type': 'FreshnessScoringParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword field_name: Required. The name of the field used as input to the scoring function.
        :paramtype field_name: str
        :keyword boost: Required. A multiplier for the raw score. Must be a positive number not equal
         to 1.0.
        :paramtype boost: float
        :keyword interpolation: A value indicating how boosting will be interpolated across document
         scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
         "logarithmic".
        :paramtype interpolation: str or
         ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
        :keyword parameters: Required. Parameter values for the freshness scoring function.
        :paramtype parameters: ~azure.search.documents.indexes.models.FreshnessScoringParameters
        """
        super(FreshnessScoringFunction, self).__init__(**kwargs)
        self.type = 'freshness'  # type: str
        self.parameters = kwargs['parameters']


class FreshnessScoringParameters(msrest.serialization.Model):
    """Provides parameter values to a freshness scoring function.

    All required parameters must be populated in order to send to Azure.

    :ivar boosting_duration: Required. The expiration period after which boosting will stop for a
     particular document.
    :vartype boosting_duration: ~datetime.timedelta
    """

    _validation = {
        'boosting_duration': {'required': True},
    }

    _attribute_map = {
        'boosting_duration': {'key': 'boostingDuration', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword boosting_duration: Required. The expiration period after which boosting will stop for
         a particular document.
        :paramtype boosting_duration: ~datetime.timedelta
        """
        super(FreshnessScoringParameters, self).__init__(**kwargs)
        self.boosting_duration = kwargs['boosting_duration']


class GetIndexStatisticsResult(msrest.serialization.Model):
    """Statistics for a given index. Statistics are collected periodically and are not guaranteed to always be up-to-date.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar document_count: Required. The number of documents in the index.
    :vartype document_count: long
    :ivar storage_size: Required. The amount of storage in bytes consumed by the index.
    :vartype storage_size: long
    """

    _validation = {
        'document_count': {'required': True, 'readonly': True},
        'storage_size': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'document_count': {'key': 'documentCount', 'type': 'long'},
        'storage_size': {'key': 'storageSize', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(GetIndexStatisticsResult, self).__init__(**kwargs)
        self.document_count = None
        self.storage_size = None


class HighWaterMarkChangeDetectionPolicy(DataChangeDetectionPolicy):
    """Defines a data change detection policy that captures changes based on the value of a high water mark column.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the data change detection
     policy.Constant filled by server.
    :vartype odata_type: str
    :ivar high_water_mark_column_name: Required. The name of the high water mark column.
    :vartype high_water_mark_column_name: str
    """

    _validation = {
        'odata_type': {'required': True},
        'high_water_mark_column_name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'high_water_mark_column_name': {'key': 'highWaterMarkColumnName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword high_water_mark_column_name: Required. The name of the high water mark column.
        :paramtype high_water_mark_column_name: str
        """
        super(HighWaterMarkChangeDetectionPolicy, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.HighWaterMarkChangeDetectionPolicy'  # type: str
        self.high_water_mark_column_name = kwargs['high_water_mark_column_name']


class ImageAnalysisSkill(SearchIndexerSkill):
    """A skill that analyzes image files. It extracts a rich set of visual features based on the image content.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "en", "es", "ja", "pt", "zh".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.ImageAnalysisSkillLanguage
    :ivar visual_features: A list of visual features.
    :vartype visual_features: list[str or ~azure.search.documents.indexes.models.VisualFeature]
    :ivar details: A string indicating which domain-specific details to return.
    :vartype details: list[str or ~azure.search.documents.indexes.models.ImageDetail]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'visual_features': {'key': 'visualFeatures', 'type': '[str]'},
        'details': {'key': 'details', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
         Possible values include: "en", "es", "ja", "pt", "zh".
        :paramtype default_language_code: str or
         ~azure.search.documents.indexes.models.ImageAnalysisSkillLanguage
        :keyword visual_features: A list of visual features.
        :paramtype visual_features: list[str or ~azure.search.documents.indexes.models.VisualFeature]
        :keyword details: A string indicating which domain-specific details to return.
        :paramtype details: list[str or ~azure.search.documents.indexes.models.ImageDetail]
        """
        super(ImageAnalysisSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Vision.ImageAnalysisSkill'  # type: str
        self.default_language_code = kwargs.get('default_language_code', None)
        self.visual_features = kwargs.get('visual_features', None)
        self.details = kwargs.get('details', None)


class IndexerCurrentState(msrest.serialization.Model):
    """Represents all of the state that defines and dictates the indexer's current execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mode: The mode the indexer is running in. Possible values include: "indexingAllDocs",
     "indexingResetDocs".
    :vartype mode: str or ~azure.search.documents.indexes.models.IndexingMode
    :ivar all_docs_initial_change_tracking_state: Change tracking state used when indexing starts
     on all documents in the datasource.
    :vartype all_docs_initial_change_tracking_state: str
    :ivar all_docs_final_change_tracking_state: Change tracking state value when indexing finishes
     on all documents in the datasource.
    :vartype all_docs_final_change_tracking_state: str
    :ivar reset_docs_initial_change_tracking_state: Change tracking state used when indexing starts
     on select, reset documents in the datasource.
    :vartype reset_docs_initial_change_tracking_state: str
    :ivar reset_docs_final_change_tracking_state: Change tracking state value when indexing
     finishes on select, reset documents in the datasource.
    :vartype reset_docs_final_change_tracking_state: str
    :ivar reset_document_keys: The list of document keys that have been reset. The document key is
     the document's unique identifier for the data in the search index. The indexer will prioritize
     selectively re-ingesting these keys.
    :vartype reset_document_keys: list[str]
    :ivar reset_datasource_document_ids: The list of datasource document ids that have been reset.
     The datasource document id is the unique identifier for the data in the datasource. The indexer
     will prioritize selectively re-ingesting these ids.
    :vartype reset_datasource_document_ids: list[str]
    """

    _validation = {
        'mode': {'readonly': True},
        'all_docs_initial_change_tracking_state': {'readonly': True},
        'all_docs_final_change_tracking_state': {'readonly': True},
        'reset_docs_initial_change_tracking_state': {'readonly': True},
        'reset_docs_final_change_tracking_state': {'readonly': True},
        'reset_document_keys': {'readonly': True},
        'reset_datasource_document_ids': {'readonly': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'all_docs_initial_change_tracking_state': {'key': 'allDocsInitialChangeTrackingState', 'type': 'str'},
        'all_docs_final_change_tracking_state': {'key': 'allDocsFinalChangeTrackingState', 'type': 'str'},
        'reset_docs_initial_change_tracking_state': {'key': 'resetDocsInitialChangeTrackingState', 'type': 'str'},
        'reset_docs_final_change_tracking_state': {'key': 'resetDocsFinalChangeTrackingState', 'type': 'str'},
        'reset_document_keys': {'key': 'resetDocumentKeys', 'type': '[str]'},
        'reset_datasource_document_ids': {'key': 'resetDatasourceDocumentIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IndexerCurrentState, self).__init__(**kwargs)
        self.mode = None
        self.all_docs_initial_change_tracking_state = None
        self.all_docs_final_change_tracking_state = None
        self.reset_docs_initial_change_tracking_state = None
        self.reset_docs_final_change_tracking_state = None
        self.reset_document_keys = None
        self.reset_datasource_document_ids = None


class IndexerExecutionResult(msrest.serialization.Model):
    """Represents the result of an individual indexer execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. The outcome of this indexer execution. Possible values include:
     "transientFailure", "success", "inProgress", "reset".
    :vartype status: str or ~azure.search.documents.indexes.models.IndexerExecutionStatus
    :ivar status_detail: The outcome of this indexer execution. Possible values include:
     "resetDocs".
    :vartype status_detail: str or
     ~azure.search.documents.indexes.models.IndexerExecutionStatusDetail
    :ivar current_state: All of the state that defines and dictates the indexer's current
     execution.
    :vartype current_state: ~azure.search.documents.indexes.models.IndexerCurrentState
    :ivar error_message: The error message indicating the top-level error, if any.
    :vartype error_message: str
    :ivar start_time: The start time of this indexer execution.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of this indexer execution, if the execution has already completed.
    :vartype end_time: ~datetime.datetime
    :ivar errors: Required. The item-level indexing errors.
    :vartype errors: list[~azure.search.documents.indexes.models.SearchIndexerError]
    :ivar warnings: Required. The item-level indexing warnings.
    :vartype warnings: list[~azure.search.documents.indexes.models.SearchIndexerWarning]
    :ivar item_count: Required. The number of items that were processed during this indexer
     execution. This includes both successfully processed items and items where indexing was
     attempted but failed.
    :vartype item_count: int
    :ivar failed_item_count: Required. The number of items that failed to be indexed during this
     indexer execution.
    :vartype failed_item_count: int
    :ivar initial_tracking_state: Change tracking state with which an indexer execution started.
    :vartype initial_tracking_state: str
    :ivar final_tracking_state: Change tracking state with which an indexer execution finished.
    :vartype final_tracking_state: str
    """

    _validation = {
        'status': {'required': True, 'readonly': True},
        'status_detail': {'readonly': True},
        'current_state': {'readonly': True},
        'error_message': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'errors': {'required': True, 'readonly': True},
        'warnings': {'required': True, 'readonly': True},
        'item_count': {'required': True, 'readonly': True},
        'failed_item_count': {'required': True, 'readonly': True},
        'initial_tracking_state': {'readonly': True},
        'final_tracking_state': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'status_detail': {'key': 'statusDetail', 'type': 'str'},
        'current_state': {'key': 'currentState', 'type': 'IndexerCurrentState'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[SearchIndexerError]'},
        'warnings': {'key': 'warnings', 'type': '[SearchIndexerWarning]'},
        'item_count': {'key': 'itemsProcessed', 'type': 'int'},
        'failed_item_count': {'key': 'itemsFailed', 'type': 'int'},
        'initial_tracking_state': {'key': 'initialTrackingState', 'type': 'str'},
        'final_tracking_state': {'key': 'finalTrackingState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IndexerExecutionResult, self).__init__(**kwargs)
        self.status = None
        self.status_detail = None
        self.current_state = None
        self.error_message = None
        self.start_time = None
        self.end_time = None
        self.errors = None
        self.warnings = None
        self.item_count = None
        self.failed_item_count = None
        self.initial_tracking_state = None
        self.final_tracking_state = None


class IndexingParameters(msrest.serialization.Model):
    """Represents parameters for indexer execution.

    :ivar batch_size: The number of items that are read from the data source and indexed as a
     single batch in order to improve performance. The default depends on the data source type.
    :vartype batch_size: int
    :ivar max_failed_items: The maximum number of items that can fail indexing for indexer
     execution to still be considered successful. -1 means no limit. Default is 0.
    :vartype max_failed_items: int
    :ivar max_failed_items_per_batch: The maximum number of items in a single batch that can fail
     indexing for the batch to still be considered successful. -1 means no limit. Default is 0.
    :vartype max_failed_items_per_batch: int
    :ivar configuration: A dictionary of indexer-specific configuration properties. Each name is
     the name of a specific property. Each value must be of a primitive type.
    :vartype configuration: ~azure.search.documents.indexes.models.IndexingParametersConfiguration
    """

    _attribute_map = {
        'batch_size': {'key': 'batchSize', 'type': 'int'},
        'max_failed_items': {'key': 'maxFailedItems', 'type': 'int'},
        'max_failed_items_per_batch': {'key': 'maxFailedItemsPerBatch', 'type': 'int'},
        'configuration': {'key': 'configuration', 'type': 'IndexingParametersConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword batch_size: The number of items that are read from the data source and indexed as a
         single batch in order to improve performance. The default depends on the data source type.
        :paramtype batch_size: int
        :keyword max_failed_items: The maximum number of items that can fail indexing for indexer
         execution to still be considered successful. -1 means no limit. Default is 0.
        :paramtype max_failed_items: int
        :keyword max_failed_items_per_batch: The maximum number of items in a single batch that can
         fail indexing for the batch to still be considered successful. -1 means no limit. Default is 0.
        :paramtype max_failed_items_per_batch: int
        :keyword configuration: A dictionary of indexer-specific configuration properties. Each name is
         the name of a specific property. Each value must be of a primitive type.
        :paramtype configuration:
         ~azure.search.documents.indexes.models.IndexingParametersConfiguration
        """
        super(IndexingParameters, self).__init__(**kwargs)
        self.batch_size = kwargs.get('batch_size', None)
        self.max_failed_items = kwargs.get('max_failed_items', 0)
        self.max_failed_items_per_batch = kwargs.get('max_failed_items_per_batch', 0)
        self.configuration = kwargs.get('configuration', None)


class IndexingParametersConfiguration(msrest.serialization.Model):
    """A dictionary of indexer-specific configuration properties. Each name is the name of a specific property. Each value must be of a primitive type.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar parsing_mode: Represents the parsing mode for indexing from an Azure blob data source.
     Possible values include: "default", "text", "delimitedText", "json", "jsonArray", "jsonLines".
     Default value: "default".
    :vartype parsing_mode: str or ~azure.search.documents.indexes.models.BlobIndexerParsingMode
    :ivar excluded_file_name_extensions: Comma-delimited list of filename extensions to ignore when
     processing from Azure blob storage.  For example, you could exclude ".png, .mp4" to skip over
     those files during indexing.
    :vartype excluded_file_name_extensions: str
    :ivar indexed_file_name_extensions: Comma-delimited list of filename extensions to select when
     processing from Azure blob storage.  For example, you could focus indexing on specific
     application files ".docx, .pptx, .msg" to specifically include those file types.
    :vartype indexed_file_name_extensions: str
    :ivar fail_on_unsupported_content_type: For Azure blobs, set to false if you want to continue
     indexing when an unsupported content type is encountered, and you don't know all the content
     types (file extensions) in advance.
    :vartype fail_on_unsupported_content_type: bool
    :ivar fail_on_unprocessable_document: For Azure blobs, set to false if you want to continue
     indexing if a document fails indexing.
    :vartype fail_on_unprocessable_document: bool
    :ivar index_storage_metadata_only_for_oversized_documents: For Azure blobs, set this property
     to true to still index storage metadata for blob content that is too large to process.
     Oversized blobs are treated as errors by default. For limits on blob size, see
     https://docs.microsoft.com/azure/search/search-limits-quotas-capacity.
    :vartype index_storage_metadata_only_for_oversized_documents: bool
    :ivar delimited_text_headers: For CSV blobs, specifies a comma-delimited list of column
     headers, useful for mapping source fields to destination fields in an index.
    :vartype delimited_text_headers: str
    :ivar delimited_text_delimiter: For CSV blobs, specifies the end-of-line single-character
     delimiter for CSV files where each line starts a new document (for example, "|").
    :vartype delimited_text_delimiter: str
    :ivar first_line_contains_headers: For CSV blobs, indicates that the first (non-blank) line of
     each blob contains headers.
    :vartype first_line_contains_headers: bool
    :ivar document_root: For JSON arrays, given a structured or semi-structured document, you can
     specify a path to the array using this property.
    :vartype document_root: str
    :ivar data_to_extract: Specifies the data to extract from Azure blob storage and tells the
     indexer which data to extract from image content when "imageAction" is set to a value other
     than "none".  This applies to embedded image content in a .PDF or other application, or image
     files such as .jpg and .png, in Azure blobs. Possible values include: "storageMetadata",
     "allMetadata", "contentAndMetadata". Default value: "contentAndMetadata".
    :vartype data_to_extract: str or
     ~azure.search.documents.indexes.models.BlobIndexerDataToExtract
    :ivar image_action: Determines how to process embedded images and image files in Azure blob
     storage.  Setting the "imageAction" configuration to any value other than "none" requires that
     a skillset also be attached to that indexer. Possible values include: "none",
     "generateNormalizedImages", "generateNormalizedImagePerPage". Default value: "none".
    :vartype image_action: str or ~azure.search.documents.indexes.models.BlobIndexerImageAction
    :ivar allow_skillset_to_read_file_data: If true, will create a path //document//file_data that
     is an object representing the original file data downloaded from your blob data source.  This
     allows you to pass the original file data to a custom skill for processing within the
     enrichment pipeline, or to the Document Extraction skill.
    :vartype allow_skillset_to_read_file_data: bool
    :ivar pdf_text_rotation_algorithm: Determines algorithm for text extraction from PDF files in
     Azure blob storage. Possible values include: "none", "detectAngles". Default value: "none".
    :vartype pdf_text_rotation_algorithm: str or
     ~azure.search.documents.indexes.models.BlobIndexerPDFTextRotationAlgorithm
    :ivar execution_environment: Specifies the environment in which the indexer should execute.
     Possible values include: "standard", "private". Default value: "standard".
    :vartype execution_environment: str or
     ~azure.search.documents.indexes.models.IndexerExecutionEnvironment
    :ivar query_timeout: Increases the timeout beyond the 5-minute default for Azure SQL database
     data sources, specified in the format "hh:mm:ss".
    :vartype query_timeout: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'parsing_mode': {'key': 'parsingMode', 'type': 'str'},
        'excluded_file_name_extensions': {'key': 'excludedFileNameExtensions', 'type': 'str'},
        'indexed_file_name_extensions': {'key': 'indexedFileNameExtensions', 'type': 'str'},
        'fail_on_unsupported_content_type': {'key': 'failOnUnsupportedContentType', 'type': 'bool'},
        'fail_on_unprocessable_document': {'key': 'failOnUnprocessableDocument', 'type': 'bool'},
        'index_storage_metadata_only_for_oversized_documents': {'key': 'indexStorageMetadataOnlyForOversizedDocuments', 'type': 'bool'},
        'delimited_text_headers': {'key': 'delimitedTextHeaders', 'type': 'str'},
        'delimited_text_delimiter': {'key': 'delimitedTextDelimiter', 'type': 'str'},
        'first_line_contains_headers': {'key': 'firstLineContainsHeaders', 'type': 'bool'},
        'document_root': {'key': 'documentRoot', 'type': 'str'},
        'data_to_extract': {'key': 'dataToExtract', 'type': 'str'},
        'image_action': {'key': 'imageAction', 'type': 'str'},
        'allow_skillset_to_read_file_data': {'key': 'allowSkillsetToReadFileData', 'type': 'bool'},
        'pdf_text_rotation_algorithm': {'key': 'pdfTextRotationAlgorithm', 'type': 'str'},
        'execution_environment': {'key': 'executionEnvironment', 'type': 'str'},
        'query_timeout': {'key': 'queryTimeout', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword parsing_mode: Represents the parsing mode for indexing from an Azure blob data source.
         Possible values include: "default", "text", "delimitedText", "json", "jsonArray", "jsonLines".
         Default value: "default".
        :paramtype parsing_mode: str or ~azure.search.documents.indexes.models.BlobIndexerParsingMode
        :keyword excluded_file_name_extensions: Comma-delimited list of filename extensions to ignore
         when processing from Azure blob storage.  For example, you could exclude ".png, .mp4" to skip
         over those files during indexing.
        :paramtype excluded_file_name_extensions: str
        :keyword indexed_file_name_extensions: Comma-delimited list of filename extensions to select
         when processing from Azure blob storage.  For example, you could focus indexing on specific
         application files ".docx, .pptx, .msg" to specifically include those file types.
        :paramtype indexed_file_name_extensions: str
        :keyword fail_on_unsupported_content_type: For Azure blobs, set to false if you want to
         continue indexing when an unsupported content type is encountered, and you don't know all the
         content types (file extensions) in advance.
        :paramtype fail_on_unsupported_content_type: bool
        :keyword fail_on_unprocessable_document: For Azure blobs, set to false if you want to continue
         indexing if a document fails indexing.
        :paramtype fail_on_unprocessable_document: bool
        :keyword index_storage_metadata_only_for_oversized_documents: For Azure blobs, set this
         property to true to still index storage metadata for blob content that is too large to process.
         Oversized blobs are treated as errors by default. For limits on blob size, see
         https://docs.microsoft.com/azure/search/search-limits-quotas-capacity.
        :paramtype index_storage_metadata_only_for_oversized_documents: bool
        :keyword delimited_text_headers: For CSV blobs, specifies a comma-delimited list of column
         headers, useful for mapping source fields to destination fields in an index.
        :paramtype delimited_text_headers: str
        :keyword delimited_text_delimiter: For CSV blobs, specifies the end-of-line single-character
         delimiter for CSV files where each line starts a new document (for example, "|").
        :paramtype delimited_text_delimiter: str
        :keyword first_line_contains_headers: For CSV blobs, indicates that the first (non-blank) line
         of each blob contains headers.
        :paramtype first_line_contains_headers: bool
        :keyword document_root: For JSON arrays, given a structured or semi-structured document, you
         can specify a path to the array using this property.
        :paramtype document_root: str
        :keyword data_to_extract: Specifies the data to extract from Azure blob storage and tells the
         indexer which data to extract from image content when "imageAction" is set to a value other
         than "none".  This applies to embedded image content in a .PDF or other application, or image
         files such as .jpg and .png, in Azure blobs. Possible values include: "storageMetadata",
         "allMetadata", "contentAndMetadata". Default value: "contentAndMetadata".
        :paramtype data_to_extract: str or
         ~azure.search.documents.indexes.models.BlobIndexerDataToExtract
        :keyword image_action: Determines how to process embedded images and image files in Azure blob
         storage.  Setting the "imageAction" configuration to any value other than "none" requires that
         a skillset also be attached to that indexer. Possible values include: "none",
         "generateNormalizedImages", "generateNormalizedImagePerPage". Default value: "none".
        :paramtype image_action: str or ~azure.search.documents.indexes.models.BlobIndexerImageAction
        :keyword allow_skillset_to_read_file_data: If true, will create a path //document//file_data
         that is an object representing the original file data downloaded from your blob data source.
         This allows you to pass the original file data to a custom skill for processing within the
         enrichment pipeline, or to the Document Extraction skill.
        :paramtype allow_skillset_to_read_file_data: bool
        :keyword pdf_text_rotation_algorithm: Determines algorithm for text extraction from PDF files
         in Azure blob storage. Possible values include: "none", "detectAngles". Default value: "none".
        :paramtype pdf_text_rotation_algorithm: str or
         ~azure.search.documents.indexes.models.BlobIndexerPDFTextRotationAlgorithm
        :keyword execution_environment: Specifies the environment in which the indexer should execute.
         Possible values include: "standard", "private". Default value: "standard".
        :paramtype execution_environment: str or
         ~azure.search.documents.indexes.models.IndexerExecutionEnvironment
        :keyword query_timeout: Increases the timeout beyond the 5-minute default for Azure SQL
         database data sources, specified in the format "hh:mm:ss".
        :paramtype query_timeout: str
        """
        super(IndexingParametersConfiguration, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.parsing_mode = kwargs.get('parsing_mode', "default")
        self.excluded_file_name_extensions = kwargs.get('excluded_file_name_extensions', "")
        self.indexed_file_name_extensions = kwargs.get('indexed_file_name_extensions', "")
        self.fail_on_unsupported_content_type = kwargs.get('fail_on_unsupported_content_type', False)
        self.fail_on_unprocessable_document = kwargs.get('fail_on_unprocessable_document', False)
        self.index_storage_metadata_only_for_oversized_documents = kwargs.get('index_storage_metadata_only_for_oversized_documents', False)
        self.delimited_text_headers = kwargs.get('delimited_text_headers', None)
        self.delimited_text_delimiter = kwargs.get('delimited_text_delimiter', None)
        self.first_line_contains_headers = kwargs.get('first_line_contains_headers', True)
        self.document_root = kwargs.get('document_root', None)
        self.data_to_extract = kwargs.get('data_to_extract', "contentAndMetadata")
        self.image_action = kwargs.get('image_action', "none")
        self.allow_skillset_to_read_file_data = kwargs.get('allow_skillset_to_read_file_data', False)
        self.pdf_text_rotation_algorithm = kwargs.get('pdf_text_rotation_algorithm', "none")
        self.execution_environment = kwargs.get('execution_environment', "standard")
        self.query_timeout = kwargs.get('query_timeout', "00:05:00")


class IndexingSchedule(msrest.serialization.Model):
    """Represents a schedule for indexer execution.

    All required parameters must be populated in order to send to Azure.

    :ivar interval: Required. The interval of time between indexer executions.
    :vartype interval: ~datetime.timedelta
    :ivar start_time: The time when an indexer should start running.
    :vartype start_time: ~datetime.datetime
    """

    _validation = {
        'interval': {'required': True},
    }

    _attribute_map = {
        'interval': {'key': 'interval', 'type': 'duration'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword interval: Required. The interval of time between indexer executions.
        :paramtype interval: ~datetime.timedelta
        :keyword start_time: The time when an indexer should start running.
        :paramtype start_time: ~datetime.datetime
        """
        super(IndexingSchedule, self).__init__(**kwargs)
        self.interval = kwargs['interval']
        self.start_time = kwargs.get('start_time', None)


class InputFieldMappingEntry(msrest.serialization.Model):
    """Input field mapping for a skill.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the input.
    :vartype name: str
    :ivar source: The source of the input.
    :vartype source: str
    :ivar source_context: The source context used for selecting recursive inputs.
    :vartype source_context: str
    :ivar inputs: The recursive inputs used when creating a complex type.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the input.
        :paramtype name: str
        :keyword source: The source of the input.
        :paramtype source: str
        :keyword source_context: The source context used for selecting recursive inputs.
        :paramtype source_context: str
        :keyword inputs: The recursive inputs used when creating a complex type.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        """
        super(InputFieldMappingEntry, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.source = kwargs.get('source', None)
        self.source_context = kwargs.get('source_context', None)
        self.inputs = kwargs.get('inputs', None)


class KeepTokenFilter(TokenFilter):
    """A token filter that only keeps tokens with text contained in a specified list of words. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar keep_words: Required. The list of words to keep.
    :vartype keep_words: list[str]
    :ivar lower_case_keep_words: A value indicating whether to lower case all words first. Default
     is false.
    :vartype lower_case_keep_words: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'keep_words': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'keep_words': {'key': 'keepWords', 'type': '[str]'},
        'lower_case_keep_words': {'key': 'keepWordsCase', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword keep_words: Required. The list of words to keep.
        :paramtype keep_words: list[str]
        :keyword lower_case_keep_words: A value indicating whether to lower case all words first.
         Default is false.
        :paramtype lower_case_keep_words: bool
        """
        super(KeepTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.KeepTokenFilter'  # type: str
        self.keep_words = kwargs['keep_words']
        self.lower_case_keep_words = kwargs.get('lower_case_keep_words', False)


class KeyPhraseExtractionSkill(SearchIndexerSkill):
    """A skill that uses text analytics for key phrase extraction.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "da", "nl", "en", "fi", "fr", "de", "it", "ja", "ko", "no", "pl",
     "pt-PT", "pt-BR", "ru", "es", "sv".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.KeyPhraseExtractionSkillLanguage
    :ivar max_key_phrase_count: A number indicating how many key phrases to return. If absent, all
     identified key phrases will be returned.
    :vartype max_key_phrase_count: int
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'max_key_phrase_count': {'key': 'maxKeyPhraseCount', 'type': 'int'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
         Possible values include: "da", "nl", "en", "fi", "fr", "de", "it", "ja", "ko", "no", "pl",
         "pt-PT", "pt-BR", "ru", "es", "sv".
        :paramtype default_language_code: str or
         ~azure.search.documents.indexes.models.KeyPhraseExtractionSkillLanguage
        :keyword max_key_phrase_count: A number indicating how many key phrases to return. If absent,
         all identified key phrases will be returned.
        :paramtype max_key_phrase_count: int
        :keyword model_version: The version of the model to use when calling the Text Analytics
         service. It will default to the latest available when not specified. We recommend you do not
         specify this value unless absolutely necessary.
        :paramtype model_version: str
        """
        super(KeyPhraseExtractionSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.KeyPhraseExtractionSkill'  # type: str
        self.default_language_code = kwargs.get('default_language_code', None)
        self.max_key_phrase_count = kwargs.get('max_key_phrase_count', None)
        self.model_version = kwargs.get('model_version', None)


class KeywordMarkerTokenFilter(TokenFilter):
    """Marks terms as keywords. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar keywords: Required. A list of words to mark as keywords.
    :vartype keywords: list[str]
    :ivar ignore_case: A value indicating whether to ignore case. If true, all words are converted
     to lower case first. Default is false.
    :vartype ignore_case: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'keywords': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'keywords': {'key': 'keywords', 'type': '[str]'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword keywords: Required. A list of words to mark as keywords.
        :paramtype keywords: list[str]
        :keyword ignore_case: A value indicating whether to ignore case. If true, all words are
         converted to lower case first. Default is false.
        :paramtype ignore_case: bool
        """
        super(KeywordMarkerTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.KeywordMarkerTokenFilter'  # type: str
        self.keywords = kwargs['keywords']
        self.ignore_case = kwargs.get('ignore_case', False)


class KeywordTokenizer(LexicalTokenizer):
    """Emits the entire input as a single token. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar buffer_size: The read buffer size in bytes. Default is 256.
    :vartype buffer_size: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'buffer_size': {'key': 'bufferSize', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword buffer_size: The read buffer size in bytes. Default is 256.
        :paramtype buffer_size: int
        """
        super(KeywordTokenizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.KeywordTokenizer'  # type: str
        self.buffer_size = kwargs.get('buffer_size', 256)


class KeywordTokenizerV2(LexicalTokenizer):
    """Emits the entire input as a single token. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 256. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_token_length: The maximum token length. Default is 256. Tokens longer than the
         maximum length are split. The maximum token length that can be used is 300 characters.
        :paramtype max_token_length: int
        """
        super(KeywordTokenizerV2, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.KeywordTokenizerV2'  # type: str
        self.max_token_length = kwargs.get('max_token_length', 256)


class LanguageDetectionSkill(SearchIndexerSkill):
    """A skill that detects the language of input text and reports a single language code for every document submitted on the request. The language code is paired with a score indicating the confidence of the analysis.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_country_hint: A country code to use as a hint to the language detection model if
     it cannot disambiguate the language.
    :vartype default_country_hint: str
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_country_hint': {'key': 'defaultCountryHint', 'type': 'str'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_country_hint: A country code to use as a hint to the language detection model
         if it cannot disambiguate the language.
        :paramtype default_country_hint: str
        :keyword model_version: The version of the model to use when calling the Text Analytics
         service. It will default to the latest available when not specified. We recommend you do not
         specify this value unless absolutely necessary.
        :paramtype model_version: str
        """
        super(LanguageDetectionSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.LanguageDetectionSkill'  # type: str
        self.default_country_hint = kwargs.get('default_country_hint', None)
        self.model_version = kwargs.get('model_version', None)


class LengthTokenFilter(TokenFilter):
    """Removes words that are too long or too short. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar min_length: The minimum length in characters. Default is 0. Maximum is 300. Must be less
     than the value of max.
    :vartype min_length: int
    :ivar max_length: The maximum length in characters. Default and maximum is 300.
    :vartype max_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_length': {'maximum': 300},
        'max_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_length': {'key': 'min', 'type': 'int'},
        'max_length': {'key': 'max', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword min_length: The minimum length in characters. Default is 0. Maximum is 300. Must be
         less than the value of max.
        :paramtype min_length: int
        :keyword max_length: The maximum length in characters. Default and maximum is 300.
        :paramtype max_length: int
        """
        super(LengthTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.LengthTokenFilter'  # type: str
        self.min_length = kwargs.get('min_length', 0)
        self.max_length = kwargs.get('max_length', 300)


class LimitTokenFilter(TokenFilter):
    """Limits the number of tokens while indexing. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar max_token_count: The maximum number of tokens to produce. Default is 1.
    :vartype max_token_count: int
    :ivar consume_all_tokens: A value indicating whether all tokens from the input must be consumed
     even if maxTokenCount is reached. Default is false.
    :vartype consume_all_tokens: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_count': {'key': 'maxTokenCount', 'type': 'int'},
        'consume_all_tokens': {'key': 'consumeAllTokens', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_token_count: The maximum number of tokens to produce. Default is 1.
        :paramtype max_token_count: int
        :keyword consume_all_tokens: A value indicating whether all tokens from the input must be
         consumed even if maxTokenCount is reached. Default is false.
        :paramtype consume_all_tokens: bool
        """
        super(LimitTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.LimitTokenFilter'  # type: str
        self.max_token_count = kwargs.get('max_token_count', 1)
        self.consume_all_tokens = kwargs.get('consume_all_tokens', False)


class ListAliasesResult(msrest.serialization.Model):
    """Response from a List Aliases request. If successful, it includes the associated index mappings for all aliases.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar aliases: Required. The aliases in the Search service.
    :vartype aliases: list[~azure.search.documents.indexes.models.SearchAlias]
    """

    _validation = {
        'aliases': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'aliases': {'key': 'value', 'type': '[SearchAlias]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListAliasesResult, self).__init__(**kwargs)
        self.aliases = None


class ListDataSourcesResult(msrest.serialization.Model):
    """Response from a List Datasources request. If successful, it includes the full definitions of all datasources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar data_sources: Required. The datasources in the Search service.
    :vartype data_sources: list[~azure.search.documents.indexes.models.SearchIndexerDataSource]
    """

    _validation = {
        'data_sources': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'data_sources': {'key': 'value', 'type': '[SearchIndexerDataSource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListDataSourcesResult, self).__init__(**kwargs)
        self.data_sources = None


class ListIndexersResult(msrest.serialization.Model):
    """Response from a List Indexers request. If successful, it includes the full definitions of all indexers.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar indexers: Required. The indexers in the Search service.
    :vartype indexers: list[~azure.search.documents.indexes.models.SearchIndexer]
    """

    _validation = {
        'indexers': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'indexers': {'key': 'value', 'type': '[SearchIndexer]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListIndexersResult, self).__init__(**kwargs)
        self.indexers = None


class ListIndexesResult(msrest.serialization.Model):
    """Response from a List Indexes request. If successful, it includes the full definitions of all indexes.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar indexes: Required. The indexes in the Search service.
    :vartype indexes: list[~azure.search.documents.indexes.models.SearchIndex]
    """

    _validation = {
        'indexes': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'indexes': {'key': 'value', 'type': '[SearchIndex]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListIndexesResult, self).__init__(**kwargs)
        self.indexes = None


class ListSkillsetsResult(msrest.serialization.Model):
    """Response from a list skillset request. If successful, it includes the full definitions of all skillsets.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar skillsets: Required. The skillsets defined in the Search service.
    :vartype skillsets: list[~azure.search.documents.indexes.models.SearchIndexerSkillset]
    """

    _validation = {
        'skillsets': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'skillsets': {'key': 'value', 'type': '[SearchIndexerSkillset]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListSkillsetsResult, self).__init__(**kwargs)
        self.skillsets = None


class ListSynonymMapsResult(msrest.serialization.Model):
    """Response from a List SynonymMaps request. If successful, it includes the full definitions of all synonym maps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar synonym_maps: Required. The synonym maps in the Search service.
    :vartype synonym_maps: list[~azure.search.documents.indexes.models.SynonymMap]
    """

    _validation = {
        'synonym_maps': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'synonym_maps': {'key': 'value', 'type': '[SynonymMap]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ListSynonymMapsResult, self).__init__(**kwargs)
        self.synonym_maps = None


class LuceneStandardAnalyzer(LexicalAnalyzer):
    """Standard Apache Lucene analyzer; Composed of the standard tokenizer, lowercase filter and stop filter.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    :ivar stopwords: A list of stopwords.
    :vartype stopwords: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
        'stopwords': {'key': 'stopwords', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the analyzer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_token_length: The maximum token length. Default is 255. Tokens longer than the
         maximum length are split. The maximum token length that can be used is 300 characters.
        :paramtype max_token_length: int
        :keyword stopwords: A list of stopwords.
        :paramtype stopwords: list[str]
        """
        super(LuceneStandardAnalyzer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StandardAnalyzer'  # type: str
        self.max_token_length = kwargs.get('max_token_length', 255)
        self.stopwords = kwargs.get('stopwords', None)


class LuceneStandardTokenizer(LexicalTokenizer):
    """Breaks text following the Unicode Text Segmentation rules. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split.
    :vartype max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_token_length: The maximum token length. Default is 255. Tokens longer than the
         maximum length are split.
        :paramtype max_token_length: int
        """
        super(LuceneStandardTokenizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StandardTokenizer'  # type: str
        self.max_token_length = kwargs.get('max_token_length', 255)


class LuceneStandardTokenizerV2(LexicalTokenizer):
    """Breaks text following the Unicode Text Segmentation rules. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_token_length: The maximum token length. Default is 255. Tokens longer than the
         maximum length are split. The maximum token length that can be used is 300 characters.
        :paramtype max_token_length: int
        """
        super(LuceneStandardTokenizerV2, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StandardTokenizerV2'  # type: str
        self.max_token_length = kwargs.get('max_token_length', 255)


class MagnitudeScoringFunction(ScoringFunction):
    """Defines a function that boosts scores based on the magnitude of a numeric field.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :vartype type: str
    :ivar field_name: Required. The name of the field used as input to the scoring function.
    :vartype field_name: str
    :ivar boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :ivar parameters: Required. Parameter values for the magnitude scoring function.
    :vartype parameters: ~azure.search.documents.indexes.models.MagnitudeScoringParameters
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
        'parameters': {'key': 'magnitude', 'type': 'MagnitudeScoringParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword field_name: Required. The name of the field used as input to the scoring function.
        :paramtype field_name: str
        :keyword boost: Required. A multiplier for the raw score. Must be a positive number not equal
         to 1.0.
        :paramtype boost: float
        :keyword interpolation: A value indicating how boosting will be interpolated across document
         scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
         "logarithmic".
        :paramtype interpolation: str or
         ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
        :keyword parameters: Required. Parameter values for the magnitude scoring function.
        :paramtype parameters: ~azure.search.documents.indexes.models.MagnitudeScoringParameters
        """
        super(MagnitudeScoringFunction, self).__init__(**kwargs)
        self.type = 'magnitude'  # type: str
        self.parameters = kwargs['parameters']


class MagnitudeScoringParameters(msrest.serialization.Model):
    """Provides parameter values to a magnitude scoring function.

    All required parameters must be populated in order to send to Azure.

    :ivar boosting_range_start: Required. The field value at which boosting starts.
    :vartype boosting_range_start: float
    :ivar boosting_range_end: Required. The field value at which boosting ends.
    :vartype boosting_range_end: float
    :ivar should_boost_beyond_range_by_constant: A value indicating whether to apply a constant
     boost for field values beyond the range end value; default is false.
    :vartype should_boost_beyond_range_by_constant: bool
    """

    _validation = {
        'boosting_range_start': {'required': True},
        'boosting_range_end': {'required': True},
    }

    _attribute_map = {
        'boosting_range_start': {'key': 'boostingRangeStart', 'type': 'float'},
        'boosting_range_end': {'key': 'boostingRangeEnd', 'type': 'float'},
        'should_boost_beyond_range_by_constant': {'key': 'constantBoostBeyondRange', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword boosting_range_start: Required. The field value at which boosting starts.
        :paramtype boosting_range_start: float
        :keyword boosting_range_end: Required. The field value at which boosting ends.
        :paramtype boosting_range_end: float
        :keyword should_boost_beyond_range_by_constant: A value indicating whether to apply a constant
         boost for field values beyond the range end value; default is false.
        :paramtype should_boost_beyond_range_by_constant: bool
        """
        super(MagnitudeScoringParameters, self).__init__(**kwargs)
        self.boosting_range_start = kwargs['boosting_range_start']
        self.boosting_range_end = kwargs['boosting_range_end']
        self.should_boost_beyond_range_by_constant = kwargs.get('should_boost_beyond_range_by_constant', None)


class MappingCharFilter(CharFilter):
    """A character filter that applies mappings defined with the mappings option. Matching is greedy (longest pattern matching at a given point wins). Replacement is allowed to be the empty string. This character filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the char filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the char filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar mappings: Required. A list of mappings of the following format: "a=>b" (all occurrences
     of the character "a" will be replaced with character "b").
    :vartype mappings: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'mappings': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'mappings': {'key': 'mappings', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the char filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword mappings: Required. A list of mappings of the following format: "a=>b" (all
         occurrences of the character "a" will be replaced with character "b").
        :paramtype mappings: list[str]
        """
        super(MappingCharFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.MappingCharFilter'  # type: str
        self.mappings = kwargs['mappings']


class MergeSkill(SearchIndexerSkill):
    """A skill for merging two or more strings into a single unified string, with an optional user-defined delimiter separating each component part.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar insert_pre_tag: The tag indicates the start of the merged text. By default, the tag is an
     empty space.
    :vartype insert_pre_tag: str
    :ivar insert_post_tag: The tag indicates the end of the merged text. By default, the tag is an
     empty space.
    :vartype insert_post_tag: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'insert_pre_tag': {'key': 'insertPreTag', 'type': 'str'},
        'insert_post_tag': {'key': 'insertPostTag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword insert_pre_tag: The tag indicates the start of the merged text. By default, the tag is
         an empty space.
        :paramtype insert_pre_tag: str
        :keyword insert_post_tag: The tag indicates the end of the merged text. By default, the tag is
         an empty space.
        :paramtype insert_post_tag: str
        """
        super(MergeSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.MergeSkill'  # type: str
        self.insert_pre_tag = kwargs.get('insert_pre_tag', " ")
        self.insert_post_tag = kwargs.get('insert_post_tag', " ")


class MicrosoftLanguageStemmingTokenizer(LexicalTokenizer):
    """Divides text using language-specific rules and reduces words to their base forms.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Tokens longer than the maximum length are
     split. Maximum token length that can be used is 300 characters. Tokens longer than 300
     characters are first split into tokens of length 300 and then each of those tokens is split
     based on the max token length set. Default is 255.
    :vartype max_token_length: int
    :ivar is_search_tokenizer: A value indicating how the tokenizer is used. Set to true if used as
     the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
    :vartype is_search_tokenizer: bool
    :ivar language: The language to use. The default is English. Possible values include: "arabic",
     "bangla", "bulgarian", "catalan", "croatian", "czech", "danish", "dutch", "english",
     "estonian", "finnish", "french", "german", "greek", "gujarati", "hebrew", "hindi", "hungarian",
     "icelandic", "indonesian", "italian", "kannada", "latvian", "lithuanian", "malay", "malayalam",
     "marathi", "norwegianBokmaal", "polish", "portuguese", "portugueseBrazilian", "punjabi",
     "romanian", "russian", "serbianCyrillic", "serbianLatin", "slovak", "slovenian", "spanish",
     "swedish", "tamil", "telugu", "turkish", "ukrainian", "urdu".
    :vartype language: str or
     ~azure.search.documents.indexes.models.MicrosoftStemmingTokenizerLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
        'is_search_tokenizer': {'key': 'isSearchTokenizer', 'type': 'bool'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_token_length: The maximum token length. Tokens longer than the maximum length are
         split. Maximum token length that can be used is 300 characters. Tokens longer than 300
         characters are first split into tokens of length 300 and then each of those tokens is split
         based on the max token length set. Default is 255.
        :paramtype max_token_length: int
        :keyword is_search_tokenizer: A value indicating how the tokenizer is used. Set to true if used
         as the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
        :paramtype is_search_tokenizer: bool
        :keyword language: The language to use. The default is English. Possible values include:
         "arabic", "bangla", "bulgarian", "catalan", "croatian", "czech", "danish", "dutch", "english",
         "estonian", "finnish", "french", "german", "greek", "gujarati", "hebrew", "hindi", "hungarian",
         "icelandic", "indonesian", "italian", "kannada", "latvian", "lithuanian", "malay", "malayalam",
         "marathi", "norwegianBokmaal", "polish", "portuguese", "portugueseBrazilian", "punjabi",
         "romanian", "russian", "serbianCyrillic", "serbianLatin", "slovak", "slovenian", "spanish",
         "swedish", "tamil", "telugu", "turkish", "ukrainian", "urdu".
        :paramtype language: str or
         ~azure.search.documents.indexes.models.MicrosoftStemmingTokenizerLanguage
        """
        super(MicrosoftLanguageStemmingTokenizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.MicrosoftLanguageStemmingTokenizer'  # type: str
        self.max_token_length = kwargs.get('max_token_length', 255)
        self.is_search_tokenizer = kwargs.get('is_search_tokenizer', False)
        self.language = kwargs.get('language', None)


class MicrosoftLanguageTokenizer(LexicalTokenizer):
    """Divides text using language-specific rules.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Tokens longer than the maximum length are
     split. Maximum token length that can be used is 300 characters. Tokens longer than 300
     characters are first split into tokens of length 300 and then each of those tokens is split
     based on the max token length set. Default is 255.
    :vartype max_token_length: int
    :ivar is_search_tokenizer: A value indicating how the tokenizer is used. Set to true if used as
     the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
    :vartype is_search_tokenizer: bool
    :ivar language: The language to use. The default is English. Possible values include: "bangla",
     "bulgarian", "catalan", "chineseSimplified", "chineseTraditional", "croatian", "czech",
     "danish", "dutch", "english", "french", "german", "greek", "gujarati", "hindi", "icelandic",
     "indonesian", "italian", "japanese", "kannada", "korean", "malay", "malayalam", "marathi",
     "norwegianBokmaal", "polish", "portuguese", "portugueseBrazilian", "punjabi", "romanian",
     "russian", "serbianCyrillic", "serbianLatin", "slovenian", "spanish", "swedish", "tamil",
     "telugu", "thai", "ukrainian", "urdu", "vietnamese".
    :vartype language: str or ~azure.search.documents.indexes.models.MicrosoftTokenizerLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
        'is_search_tokenizer': {'key': 'isSearchTokenizer', 'type': 'bool'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_token_length: The maximum token length. Tokens longer than the maximum length are
         split. Maximum token length that can be used is 300 characters. Tokens longer than 300
         characters are first split into tokens of length 300 and then each of those tokens is split
         based on the max token length set. Default is 255.
        :paramtype max_token_length: int
        :keyword is_search_tokenizer: A value indicating how the tokenizer is used. Set to true if used
         as the search tokenizer, set to false if used as the indexing tokenizer. Default is false.
        :paramtype is_search_tokenizer: bool
        :keyword language: The language to use. The default is English. Possible values include:
         "bangla", "bulgarian", "catalan", "chineseSimplified", "chineseTraditional", "croatian",
         "czech", "danish", "dutch", "english", "french", "german", "greek", "gujarati", "hindi",
         "icelandic", "indonesian", "italian", "japanese", "kannada", "korean", "malay", "malayalam",
         "marathi", "norwegianBokmaal", "polish", "portuguese", "portugueseBrazilian", "punjabi",
         "romanian", "russian", "serbianCyrillic", "serbianLatin", "slovenian", "spanish", "swedish",
         "tamil", "telugu", "thai", "ukrainian", "urdu", "vietnamese".
        :paramtype language: str or ~azure.search.documents.indexes.models.MicrosoftTokenizerLanguage
        """
        super(MicrosoftLanguageTokenizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.MicrosoftLanguageTokenizer'  # type: str
        self.max_token_length = kwargs.get('max_token_length', 255)
        self.is_search_tokenizer = kwargs.get('is_search_tokenizer', False)
        self.language = kwargs.get('language', None)


class NGramTokenFilter(TokenFilter):
    """Generates n-grams of the given size(s). This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Must be less than the value of
     maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2.
    :vartype max_gram: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword min_gram: The minimum n-gram length. Default is 1. Must be less than the value of
         maxGram.
        :paramtype min_gram: int
        :keyword max_gram: The maximum n-gram length. Default is 2.
        :paramtype max_gram: int
        """
        super(NGramTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.NGramTokenFilter'  # type: str
        self.min_gram = kwargs.get('min_gram', 1)
        self.max_gram = kwargs.get('max_gram', 2)


class NGramTokenFilterV2(TokenFilter):
    """Generates n-grams of the given size(s). This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :vartype max_gram: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_gram': {'maximum': 300},
        'max_gram': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than
         the value of maxGram.
        :paramtype min_gram: int
        :keyword max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
        :paramtype max_gram: int
        """
        super(NGramTokenFilterV2, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.NGramTokenFilterV2'  # type: str
        self.min_gram = kwargs.get('min_gram', 1)
        self.max_gram = kwargs.get('max_gram', 2)


class NGramTokenizer(LexicalTokenizer):
    """Tokenizes the input into n-grams of the given size(s). This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than the
     value of maxGram.
    :vartype min_gram: int
    :ivar max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
    :vartype max_gram: int
    :ivar token_chars: Character classes to keep in the tokens.
    :vartype token_chars: list[str or ~azure.search.documents.indexes.models.TokenCharacterKind]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'min_gram': {'maximum': 300},
        'max_gram': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'min_gram': {'key': 'minGram', 'type': 'int'},
        'max_gram': {'key': 'maxGram', 'type': 'int'},
        'token_chars': {'key': 'tokenChars', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword min_gram: The minimum n-gram length. Default is 1. Maximum is 300. Must be less than
         the value of maxGram.
        :paramtype min_gram: int
        :keyword max_gram: The maximum n-gram length. Default is 2. Maximum is 300.
        :paramtype max_gram: int
        :keyword token_chars: Character classes to keep in the tokens.
        :paramtype token_chars: list[str or ~azure.search.documents.indexes.models.TokenCharacterKind]
        """
        super(NGramTokenizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.NGramTokenizer'  # type: str
        self.min_gram = kwargs.get('min_gram', 1)
        self.max_gram = kwargs.get('max_gram', 2)
        self.token_chars = kwargs.get('token_chars', None)


class OcrSkill(SearchIndexerSkill):
    """A skill that extracts text from image files.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "zh-Hans", "zh-Hant", "cs", "da", "nl", "en", "fi", "fr", "de", "el",
     "hu", "it", "ja", "ko", "nb", "pl", "pt", "ru", "es", "sv", "tr", "ar", "ro", "sr-Cyrl",
     "sr-Latn", "sk", "unk".
    :vartype default_language_code: str or ~azure.search.documents.indexes.models.OcrSkillLanguage
    :ivar should_detect_orientation: A value indicating to turn orientation detection on or not.
     Default is false.
    :vartype should_detect_orientation: bool
    :ivar line_ending: Defines the sequence of characters to use between the lines of text
     recognized by the OCR skill. The default value is "space". Possible values include: "space",
     "carriageReturn", "lineFeed", "carriageReturnLineFeed".
    :vartype line_ending: str or ~azure.search.documents.indexes.models.LineEnding
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'should_detect_orientation': {'key': 'detectOrientation', 'type': 'bool'},
        'line_ending': {'key': 'lineEnding', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
         Possible values include: "zh-Hans", "zh-Hant", "cs", "da", "nl", "en", "fi", "fr", "de", "el",
         "hu", "it", "ja", "ko", "nb", "pl", "pt", "ru", "es", "sv", "tr", "ar", "ro", "sr-Cyrl",
         "sr-Latn", "sk", "unk".
        :paramtype default_language_code: str or
         ~azure.search.documents.indexes.models.OcrSkillLanguage
        :keyword should_detect_orientation: A value indicating to turn orientation detection on or not.
         Default is false.
        :paramtype should_detect_orientation: bool
        :keyword line_ending: Defines the sequence of characters to use between the lines of text
         recognized by the OCR skill. The default value is "space". Possible values include: "space",
         "carriageReturn", "lineFeed", "carriageReturnLineFeed".
        :paramtype line_ending: str or ~azure.search.documents.indexes.models.LineEnding
        """
        super(OcrSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Vision.OcrSkill'  # type: str
        self.default_language_code = kwargs.get('default_language_code', None)
        self.should_detect_orientation = kwargs.get('should_detect_orientation', False)
        self.line_ending = kwargs.get('line_ending', None)


class OutputFieldMappingEntry(msrest.serialization.Model):
    """Output field mapping for a skill.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the output defined by the skill.
    :vartype name: str
    :ivar target_name: The target name of the output. It is optional and default to name.
    :vartype target_name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'target_name': {'key': 'targetName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the output defined by the skill.
        :paramtype name: str
        :keyword target_name: The target name of the output. It is optional and default to name.
        :paramtype target_name: str
        """
        super(OutputFieldMappingEntry, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.target_name = kwargs.get('target_name', None)


class PathHierarchyTokenizerV2(LexicalTokenizer):
    """Tokenizer for path-like hierarchies. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar delimiter: The delimiter character to use. Default is "/".
    :vartype delimiter: str
    :ivar replacement: A value that, if set, replaces the delimiter character. Default is "/".
    :vartype replacement: str
    :ivar max_token_length: The maximum token length. Default and maximum is 300.
    :vartype max_token_length: int
    :ivar reverse_token_order: A value indicating whether to generate tokens in reverse order.
     Default is false.
    :vartype reverse_token_order: bool
    :ivar number_of_tokens_to_skip: The number of initial tokens to skip. Default is 0.
    :vartype number_of_tokens_to_skip: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'delimiter': {'key': 'delimiter', 'type': 'str'},
        'replacement': {'key': 'replacement', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
        'reverse_token_order': {'key': 'reverse', 'type': 'bool'},
        'number_of_tokens_to_skip': {'key': 'skip', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword delimiter: The delimiter character to use. Default is "/".
        :paramtype delimiter: str
        :keyword replacement: A value that, if set, replaces the delimiter character. Default is "/".
        :paramtype replacement: str
        :keyword max_token_length: The maximum token length. Default and maximum is 300.
        :paramtype max_token_length: int
        :keyword reverse_token_order: A value indicating whether to generate tokens in reverse order.
         Default is false.
        :paramtype reverse_token_order: bool
        :keyword number_of_tokens_to_skip: The number of initial tokens to skip. Default is 0.
        :paramtype number_of_tokens_to_skip: int
        """
        super(PathHierarchyTokenizerV2, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PathHierarchyTokenizerV2'  # type: str
        self.delimiter = kwargs.get('delimiter', "/")
        self.replacement = kwargs.get('replacement', "/")
        self.max_token_length = kwargs.get('max_token_length', 300)
        self.reverse_token_order = kwargs.get('reverse_token_order', False)
        self.number_of_tokens_to_skip = kwargs.get('number_of_tokens_to_skip', 0)


class PatternAnalyzer(LexicalAnalyzer):
    """Flexibly separates text into terms via a regular expression pattern. This analyzer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar lower_case_terms: A value indicating whether terms should be lower-cased. Default is
     true.
    :vartype lower_case_terms: bool
    :ivar pattern: A regular expression pattern to match token separators. Default is an expression
     that matches one or more non-word characters.
    :vartype pattern: str
    :ivar flags: Regular expression flags. Possible values include: "CANON_EQ", "CASE_INSENSITIVE",
     "COMMENTS", "DOTALL", "LITERAL", "MULTILINE", "UNICODE_CASE", "UNIX_LINES".
    :vartype flags: str or ~azure.search.documents.indexes.models.RegexFlags
    :ivar stopwords: A list of stopwords.
    :vartype stopwords: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'lower_case_terms': {'key': 'lowercase', 'type': 'bool'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'flags': {'key': 'flags', 'type': 'str'},
        'stopwords': {'key': 'stopwords', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the analyzer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword lower_case_terms: A value indicating whether terms should be lower-cased. Default is
         true.
        :paramtype lower_case_terms: bool
        :keyword pattern: A regular expression pattern to match token separators. Default is an
         expression that matches one or more non-word characters.
        :paramtype pattern: str
        :keyword flags: Regular expression flags. Possible values include: "CANON_EQ",
         "CASE_INSENSITIVE", "COMMENTS", "DOTALL", "LITERAL", "MULTILINE", "UNICODE_CASE", "UNIX_LINES".
        :paramtype flags: str or ~azure.search.documents.indexes.models.RegexFlags
        :keyword stopwords: A list of stopwords.
        :paramtype stopwords: list[str]
        """
        super(PatternAnalyzer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternAnalyzer'  # type: str
        self.lower_case_terms = kwargs.get('lower_case_terms', True)
        self.pattern = kwargs.get('pattern', "\W+")
        self.flags = kwargs.get('flags', None)
        self.stopwords = kwargs.get('stopwords', None)


class PatternCaptureTokenFilter(TokenFilter):
    """Uses Java regexes to emit multiple tokens - one for each capture group in one or more patterns. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar patterns: Required. A list of patterns to match against each token.
    :vartype patterns: list[str]
    :ivar preserve_original: A value indicating whether to return the original token even if one of
     the patterns matches. Default is true.
    :vartype preserve_original: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'patterns': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'patterns': {'key': 'patterns', 'type': '[str]'},
        'preserve_original': {'key': 'preserveOriginal', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword patterns: Required. A list of patterns to match against each token.
        :paramtype patterns: list[str]
        :keyword preserve_original: A value indicating whether to return the original token even if one
         of the patterns matches. Default is true.
        :paramtype preserve_original: bool
        """
        super(PatternCaptureTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternCaptureTokenFilter'  # type: str
        self.patterns = kwargs['patterns']
        self.preserve_original = kwargs.get('preserve_original', True)


class PatternReplaceCharFilter(CharFilter):
    """A character filter that replaces characters in the input string. It uses a regular expression to identify character sequences to preserve and a replacement pattern to identify characters to replace. For example, given the input text "aa bb aa bb", pattern "(aa)\s+(bb)", and replacement "$1#$2", the result would be "aa#bb aa#bb". This character filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the char filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the char filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar pattern: Required. A regular expression pattern.
    :vartype pattern: str
    :ivar replacement: Required. The replacement text.
    :vartype replacement: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'pattern': {'required': True},
        'replacement': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'replacement': {'key': 'replacement', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the char filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword pattern: Required. A regular expression pattern.
        :paramtype pattern: str
        :keyword replacement: Required. The replacement text.
        :paramtype replacement: str
        """
        super(PatternReplaceCharFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternReplaceCharFilter'  # type: str
        self.pattern = kwargs['pattern']
        self.replacement = kwargs['replacement']


class PatternReplaceTokenFilter(TokenFilter):
    """A character filter that replaces characters in the input string. It uses a regular expression to identify character sequences to preserve and a replacement pattern to identify characters to replace. For example, given the input text "aa bb aa bb", pattern "(aa)\s+(bb)", and replacement "$1#$2", the result would be "aa#bb aa#bb". This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar pattern: Required. A regular expression pattern.
    :vartype pattern: str
    :ivar replacement: Required. The replacement text.
    :vartype replacement: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'pattern': {'required': True},
        'replacement': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'replacement': {'key': 'replacement', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword pattern: Required. A regular expression pattern.
        :paramtype pattern: str
        :keyword replacement: Required. The replacement text.
        :paramtype replacement: str
        """
        super(PatternReplaceTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternReplaceTokenFilter'  # type: str
        self.pattern = kwargs['pattern']
        self.replacement = kwargs['replacement']


class PatternTokenizer(LexicalTokenizer):
    """Tokenizer that uses regex pattern matching to construct distinct tokens. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar pattern: A regular expression pattern to match token separators. Default is an expression
     that matches one or more non-word characters.
    :vartype pattern: str
    :ivar flags: Regular expression flags. Possible values include: "CANON_EQ", "CASE_INSENSITIVE",
     "COMMENTS", "DOTALL", "LITERAL", "MULTILINE", "UNICODE_CASE", "UNIX_LINES".
    :vartype flags: str or ~azure.search.documents.indexes.models.RegexFlags
    :ivar group: The zero-based ordinal of the matching group in the regular expression pattern to
     extract into tokens. Use -1 if you want to use the entire pattern to split the input into
     tokens, irrespective of matching groups. Default is -1.
    :vartype group: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'pattern': {'key': 'pattern', 'type': 'str'},
        'flags': {'key': 'flags', 'type': 'str'},
        'group': {'key': 'group', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword pattern: A regular expression pattern to match token separators. Default is an
         expression that matches one or more non-word characters.
        :paramtype pattern: str
        :keyword flags: Regular expression flags. Possible values include: "CANON_EQ",
         "CASE_INSENSITIVE", "COMMENTS", "DOTALL", "LITERAL", "MULTILINE", "UNICODE_CASE", "UNIX_LINES".
        :paramtype flags: str or ~azure.search.documents.indexes.models.RegexFlags
        :keyword group: The zero-based ordinal of the matching group in the regular expression pattern
         to extract into tokens. Use -1 if you want to use the entire pattern to split the input into
         tokens, irrespective of matching groups. Default is -1.
        :paramtype group: int
        """
        super(PatternTokenizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PatternTokenizer'  # type: str
        self.pattern = kwargs.get('pattern', "\W+")
        self.flags = kwargs.get('flags', None)
        self.group = kwargs.get('group', -1)


class PhoneticTokenFilter(TokenFilter):
    """Create tokens for phonetic matches. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar encoder: The phonetic encoder to use. Default is "metaphone". Possible values include:
     "metaphone", "doubleMetaphone", "soundex", "refinedSoundex", "caverphone1", "caverphone2",
     "cologne", "nysiis", "koelnerPhonetik", "haasePhonetik", "beiderMorse".
    :vartype encoder: str or ~azure.search.documents.indexes.models.PhoneticEncoder
    :ivar replace_original_tokens: A value indicating whether encoded tokens should replace
     original tokens. If false, encoded tokens are added as synonyms. Default is true.
    :vartype replace_original_tokens: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'encoder': {'key': 'encoder', 'type': 'str'},
        'replace_original_tokens': {'key': 'replace', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword encoder: The phonetic encoder to use. Default is "metaphone". Possible values include:
         "metaphone", "doubleMetaphone", "soundex", "refinedSoundex", "caverphone1", "caverphone2",
         "cologne", "nysiis", "koelnerPhonetik", "haasePhonetik", "beiderMorse".
        :paramtype encoder: str or ~azure.search.documents.indexes.models.PhoneticEncoder
        :keyword replace_original_tokens: A value indicating whether encoded tokens should replace
         original tokens. If false, encoded tokens are added as synonyms. Default is true.
        :paramtype replace_original_tokens: bool
        """
        super(PhoneticTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.PhoneticTokenFilter'  # type: str
        self.encoder = kwargs.get('encoder', None)
        self.replace_original_tokens = kwargs.get('replace_original_tokens', True)


class PIIDetectionSkill(SearchIndexerSkill):
    """Using the Text Analytics API, extracts personal information from an input text and gives you the option of masking it.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
    :vartype default_language_code: str
    :ivar minimum_precision: A value between 0 and 1 that be used to only include entities whose
     confidence score is greater than the value specified. If not set (default), or if explicitly
     set to null, all entities will be included.
    :vartype minimum_precision: float
    :ivar masking_mode: A parameter that provides various ways to mask the personal information
     detected in the input text. Default is 'none'. Possible values include: "none", "replace".
    :vartype masking_mode: str or
     ~azure.search.documents.indexes.models.PIIDetectionSkillMaskingMode
    :ivar masking_character: The character used to mask the text if the maskingMode parameter is
     set to replace. Default is '*'.
    :vartype masking_character: str
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    :ivar pii_categories: A list of PII entity categories that should be extracted and masked.
    :vartype pii_categories: list[str]
    :ivar domain: If specified, will set the PII domain to include only a subset of the entity
     categories. Possible values include: 'phi', 'none'. Default is 'none'.
    :vartype domain: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'minimum_precision': {'maximum': 1, 'minimum': 0},
        'masking_character': {'max_length': 1, 'min_length': 0},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'minimum_precision': {'key': 'minimumPrecision', 'type': 'float'},
        'masking_mode': {'key': 'maskingMode', 'type': 'str'},
        'masking_character': {'key': 'maskingCharacter', 'type': 'str'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
        'pii_categories': {'key': 'piiCategories', 'type': '[str]'},
        'domain': {'key': 'domain', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
        :paramtype default_language_code: str
        :keyword minimum_precision: A value between 0 and 1 that be used to only include entities whose
         confidence score is greater than the value specified. If not set (default), or if explicitly
         set to null, all entities will be included.
        :paramtype minimum_precision: float
        :keyword masking_mode: A parameter that provides various ways to mask the personal information
         detected in the input text. Default is 'none'. Possible values include: "none", "replace".
        :paramtype masking_mode: str or
         ~azure.search.documents.indexes.models.PIIDetectionSkillMaskingMode
        :keyword masking_character: The character used to mask the text if the maskingMode parameter is
         set to replace. Default is '*'.
        :paramtype masking_character: str
        :keyword model_version: The version of the model to use when calling the Text Analytics
         service. It will default to the latest available when not specified. We recommend you do not
         specify this value unless absolutely necessary.
        :paramtype model_version: str
        :keyword pii_categories: A list of PII entity categories that should be extracted and masked.
        :paramtype pii_categories: list[str]
        :keyword domain: If specified, will set the PII domain to include only a subset of the entity
         categories. Possible values include: 'phi', 'none'. Default is 'none'.
        :paramtype domain: str
        """
        super(PIIDetectionSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.PIIDetectionSkill'  # type: str
        self.default_language_code = kwargs.get('default_language_code', None)
        self.minimum_precision = kwargs.get('minimum_precision', None)
        self.masking_mode = kwargs.get('masking_mode', None)
        self.masking_character = kwargs.get('masking_character', None)
        self.model_version = kwargs.get('model_version', None)
        self.pii_categories = kwargs.get('pii_categories', None)
        self.domain = kwargs.get('domain', None)


class PrioritizedFields(msrest.serialization.Model):
    """Describes the title, content, and keywords fields to be used for semantic ranking, captions, highlights, and answers.

    :ivar title_field: Defines the title field to be used for semantic ranking, captions,
     highlights, and answers. If you don't have a title field in your index, leave this blank.
    :vartype title_field: ~azure.search.documents.indexes.models.SemanticField
    :ivar prioritized_content_fields: Defines the content fields to be used for semantic ranking,
     captions, highlights, and answers. For the best result, the selected fields should contain text
     in natural language form. The order of the fields in the array represents their priority.
     Fields with lower priority may get truncated if the content is long.
    :vartype prioritized_content_fields: list[~azure.search.documents.indexes.models.SemanticField]
    :ivar prioritized_keywords_fields: Defines the keyword fields to be used for semantic ranking,
     captions, highlights, and answers. For the best result, the selected fields should contain a
     list of keywords. The order of the fields in the array represents their priority. Fields with
     lower priority may get truncated if the content is long.
    :vartype prioritized_keywords_fields:
     list[~azure.search.documents.indexes.models.SemanticField]
    """

    _attribute_map = {
        'title_field': {'key': 'titleField', 'type': 'SemanticField'},
        'prioritized_content_fields': {'key': 'prioritizedContentFields', 'type': '[SemanticField]'},
        'prioritized_keywords_fields': {'key': 'prioritizedKeywordsFields', 'type': '[SemanticField]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword title_field: Defines the title field to be used for semantic ranking, captions,
         highlights, and answers. If you don't have a title field in your index, leave this blank.
        :paramtype title_field: ~azure.search.documents.indexes.models.SemanticField
        :keyword prioritized_content_fields: Defines the content fields to be used for semantic
         ranking, captions, highlights, and answers. For the best result, the selected fields should
         contain text in natural language form. The order of the fields in the array represents their
         priority. Fields with lower priority may get truncated if the content is long.
        :paramtype prioritized_content_fields:
         list[~azure.search.documents.indexes.models.SemanticField]
        :keyword prioritized_keywords_fields: Defines the keyword fields to be used for semantic
         ranking, captions, highlights, and answers. For the best result, the selected fields should
         contain a list of keywords. The order of the fields in the array represents their priority.
         Fields with lower priority may get truncated if the content is long.
        :paramtype prioritized_keywords_fields:
         list[~azure.search.documents.indexes.models.SemanticField]
        """
        super(PrioritizedFields, self).__init__(**kwargs)
        self.title_field = kwargs.get('title_field', None)
        self.prioritized_content_fields = kwargs.get('prioritized_content_fields', None)
        self.prioritized_keywords_fields = kwargs.get('prioritized_keywords_fields', None)


class RequestOptions(msrest.serialization.Model):
    """Parameter group.

    :ivar x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
    :vartype x_ms_client_request_id: str
    """

    _attribute_map = {
        'x_ms_client_request_id': {'key': 'x-ms-client-request-id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
        :paramtype x_ms_client_request_id: str
        """
        super(RequestOptions, self).__init__(**kwargs)
        self.x_ms_client_request_id = kwargs.get('x_ms_client_request_id', None)


class ResourceCounter(msrest.serialization.Model):
    """Represents a resource's usage and quota.

    All required parameters must be populated in order to send to Azure.

    :ivar usage: Required. The resource usage amount.
    :vartype usage: long
    :ivar quota: The resource amount quota.
    :vartype quota: long
    """

    _validation = {
        'usage': {'required': True},
    }

    _attribute_map = {
        'usage': {'key': 'usage', 'type': 'long'},
        'quota': {'key': 'quota', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword usage: Required. The resource usage amount.
        :paramtype usage: long
        :keyword quota: The resource amount quota.
        :paramtype quota: long
        """
        super(ResourceCounter, self).__init__(**kwargs)
        self.usage = kwargs['usage']
        self.quota = kwargs.get('quota', None)


class ScoringProfile(msrest.serialization.Model):
    """Defines parameters for a search index that influence scoring in search queries.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the scoring profile.
    :vartype name: str
    :ivar text_weights: Parameters that boost scoring based on text matches in certain index
     fields.
    :vartype text_weights: ~azure.search.documents.indexes.models.TextWeights
    :ivar functions: The collection of functions that influence the scoring of documents.
    :vartype functions: list[~azure.search.documents.indexes.models.ScoringFunction]
    :ivar function_aggregation: A value indicating how the results of individual scoring functions
     should be combined. Defaults to "Sum". Ignored if there are no scoring functions. Possible
     values include: "sum", "average", "minimum", "maximum", "firstMatching".
    :vartype function_aggregation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionAggregation
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'text_weights': {'key': 'text', 'type': 'TextWeights'},
        'functions': {'key': 'functions', 'type': '[ScoringFunction]'},
        'function_aggregation': {'key': 'functionAggregation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the scoring profile.
        :paramtype name: str
        :keyword text_weights: Parameters that boost scoring based on text matches in certain index
         fields.
        :paramtype text_weights: ~azure.search.documents.indexes.models.TextWeights
        :keyword functions: The collection of functions that influence the scoring of documents.
        :paramtype functions: list[~azure.search.documents.indexes.models.ScoringFunction]
        :keyword function_aggregation: A value indicating how the results of individual scoring
         functions should be combined. Defaults to "Sum". Ignored if there are no scoring functions.
         Possible values include: "sum", "average", "minimum", "maximum", "firstMatching".
        :paramtype function_aggregation: str or
         ~azure.search.documents.indexes.models.ScoringFunctionAggregation
        """
        super(ScoringProfile, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.text_weights = kwargs.get('text_weights', None)
        self.functions = kwargs.get('functions', None)
        self.function_aggregation = kwargs.get('function_aggregation', None)


class SearchAlias(msrest.serialization.Model):
    """Represents an index alias, which describes a mapping from the alias name to an index. The alias name can be used in place of the index name for supported operations.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the alias.
    :vartype name: str
    :ivar indexes: Required. The name of the index this alias maps to. Only one index name may be
     specified.
    :vartype indexes: list[str]
    :ivar e_tag: The ETag of the alias.
    :vartype e_tag: str
    """

    _validation = {
        'name': {'required': True},
        'indexes': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'indexes': {'key': 'indexes', 'type': '[str]'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the alias.
        :paramtype name: str
        :keyword indexes: Required. The name of the index this alias maps to. Only one index name may
         be specified.
        :paramtype indexes: list[str]
        :keyword e_tag: The ETag of the alias.
        :paramtype e_tag: str
        """
        super(SearchAlias, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.indexes = kwargs['indexes']
        self.e_tag = kwargs.get('e_tag', None)


class SearchError(msrest.serialization.Model):
    """Describes an error condition for the Azure Cognitive Search API.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar message: Required. A human-readable representation of the error.
    :vartype message: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.search.documents.indexes.models.SearchError]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'required': True, 'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[SearchError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SearchError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class SearchField(msrest.serialization.Model):
    """Represents a field in an index definition, which describes the name, data type, and search behavior of a field.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the field, which must be unique within the fields collection
     of the index or parent field.
    :vartype name: str
    :ivar type: Required. The data type of the field. Possible values include: "Edm.String",
     "Edm.Int32", "Edm.Int64", "Edm.Double", "Edm.Boolean", "Edm.DateTimeOffset",
     "Edm.GeographyPoint", "Edm.ComplexType".
    :vartype type: str or ~azure.search.documents.indexes.models.SearchFieldDataType
    :ivar key: A value indicating whether the field uniquely identifies documents in the index.
     Exactly one top-level field in each index must be chosen as the key field and it must be of
     type Edm.String. Key fields can be used to look up documents directly and update or delete
     specific documents. Default is false for simple fields and null for complex fields.
    :vartype key: bool
    :ivar retrievable: A value indicating whether the field can be returned in a search result. You
     can disable this option if you want to use a field (for example, margin) as a filter, sorting,
     or scoring mechanism but do not want the field to be visible to the end user. This property
     must be true for key fields, and it must be null for complex fields. This property can be
     changed on existing fields. Enabling this property does not cause any increase in index storage
     requirements. Default is true for simple fields and null for complex fields.
    :vartype retrievable: bool
    :ivar searchable: A value indicating whether the field is full-text searchable. This means it
     will undergo analysis such as word-breaking during indexing. If you set a searchable field to a
     value like "sunny day", internally it will be split into the individual tokens "sunny" and
     "day". This enables full-text searches for these terms. Fields of type Edm.String or
     Collection(Edm.String) are searchable by default. This property must be false for simple fields
     of other non-string data types, and it must be null for complex fields. Note: searchable fields
     consume extra space in your index since Azure Cognitive Search will store an additional
     tokenized version of the field value for full-text searches. If you want to save space in your
     index and you don't need a field to be included in searches, set searchable to false.
    :vartype searchable: bool
    :ivar filterable: A value indicating whether to enable the field to be referenced in $filter
     queries. filterable differs from searchable in how strings are handled. Fields of type
     Edm.String or Collection(Edm.String) that are filterable do not undergo word-breaking, so
     comparisons are for exact matches only. For example, if you set such a field f to "sunny day",
     $filter=f eq 'sunny' will find no matches, but $filter=f eq 'sunny day' will. This property
     must be null for complex fields. Default is true for simple fields and null for complex fields.
    :vartype filterable: bool
    :ivar sortable: A value indicating whether to enable the field to be referenced in $orderby
     expressions. By default Azure Cognitive Search sorts results by score, but in many experiences
     users will want to sort by fields in the documents. A simple field can be sortable only if it
     is single-valued (it has a single value in the scope of the parent document). Simple collection
     fields cannot be sortable, since they are multi-valued. Simple sub-fields of complex
     collections are also multi-valued, and therefore cannot be sortable. This is true whether it's
     an immediate parent field, or an ancestor field, that's the complex collection. Complex fields
     cannot be sortable and the sortable property must be null for such fields. The default for
     sortable is true for single-valued simple fields, false for multi-valued simple fields, and
     null for complex fields.
    :vartype sortable: bool
    :ivar facetable: A value indicating whether to enable the field to be referenced in facet
     queries. Typically used in a presentation of search results that includes hit count by category
     (for example, search for digital cameras and see hits by brand, by megapixels, by price, and so
     on). This property must be null for complex fields. Fields of type Edm.GeographyPoint or
     Collection(Edm.GeographyPoint) cannot be facetable. Default is true for all other simple
     fields.
    :vartype facetable: bool
    :ivar analyzer: The name of the analyzer to use for the field. This option can be used only
     with searchable fields and it can't be set together with either searchAnalyzer or
     indexAnalyzer. Once the analyzer is chosen, it cannot be changed for the field. Must be null
     for complex fields. Possible values include: "ar.microsoft", "ar.lucene", "hy.lucene",
     "bn.microsoft", "eu.lucene", "bg.microsoft", "bg.lucene", "ca.microsoft", "ca.lucene",
     "zh-Hans.microsoft", "zh-Hans.lucene", "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft",
     "cs.microsoft", "cs.lucene", "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene",
     "en.microsoft", "en.lucene", "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft",
     "fr.lucene", "gl.lucene", "de.microsoft", "de.lucene", "el.microsoft", "el.lucene",
     "gu.microsoft", "he.microsoft", "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene",
     "is.microsoft", "id.microsoft", "id.lucene", "ga.lucene", "it.microsoft", "it.lucene",
     "ja.microsoft", "ja.lucene", "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft",
     "lv.lucene", "lt.microsoft", "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft",
     "no.lucene", "fa.lucene", "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene",
     "pt-PT.microsoft", "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft",
     "ru.lucene", "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft",
     "es.microsoft", "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft",
     "th.microsoft", "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft",
     "vi.microsoft", "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern",
     "simple", "stop", "whitespace".
    :vartype analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :ivar search_analyzer: The name of the analyzer used at search time for the field. This option
     can be used only with searchable fields. It must be set together with indexAnalyzer and it
     cannot be set together with the analyzer option. This property cannot be set to the name of a
     language analyzer; use the analyzer property instead if you need a language analyzer. This
     analyzer can be updated on an existing field. Must be null for complex fields. Possible values
     include: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene", "bg.microsoft",
     "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft", "zh-Hans.lucene",
     "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft", "cs.lucene",
     "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft", "en.lucene",
     "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene", "gl.lucene",
     "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft", "he.microsoft",
     "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft", "id.microsoft",
     "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft", "ja.lucene",
     "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene", "lt.microsoft",
     "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene", "fa.lucene",
     "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
     "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
     "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
     "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
     "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
     "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop",
     "whitespace".
    :vartype search_analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :ivar index_analyzer: The name of the analyzer used at indexing time for the field. This option
     can be used only with searchable fields. It must be set together with searchAnalyzer and it
     cannot be set together with the analyzer option.  This property cannot be set to the name of a
     language analyzer; use the analyzer property instead if you need a language analyzer. Once the
     analyzer is chosen, it cannot be changed for the field. Must be null for complex fields.
     Possible values include: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene",
     "bg.microsoft", "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft",
     "zh-Hans.lucene", "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft",
     "cs.lucene", "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft",
     "en.lucene", "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene",
     "gl.lucene", "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft",
     "he.microsoft", "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft",
     "id.microsoft", "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft",
     "ja.lucene", "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene",
     "lt.microsoft", "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene",
     "fa.lucene", "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
     "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
     "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
     "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
     "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
     "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop",
     "whitespace".
    :vartype index_analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
    :ivar normalizer: The name of the normalizer to use for the field. This option can be used only
     with fields with filterable, sortable, or facetable enabled. Once the normalizer is chosen, it
     cannot be changed for the field. Must be null for complex fields. Possible values include:
     "asciifolding", "elision", "lowercase", "standard", "uppercase".
    :vartype normalizer: str or ~azure.search.documents.indexes.models.LexicalNormalizerName
    :ivar synonym_maps: A list of the names of synonym maps to associate with this field. This
     option can be used only with searchable fields. Currently only one synonym map per field is
     supported. Assigning a synonym map to a field ensures that query terms targeting that field are
     expanded at query-time using the rules in the synonym map. This attribute can be changed on
     existing fields. Must be null or an empty collection for complex fields.
    :vartype synonym_maps: list[str]
    :ivar fields: A list of sub-fields if this is a field of type Edm.ComplexType or
     Collection(Edm.ComplexType). Must be null or empty for simple fields.
    :vartype fields: list[~azure.search.documents.indexes.models.SearchField]
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'key': {'key': 'key', 'type': 'bool'},
        'retrievable': {'key': 'retrievable', 'type': 'bool'},
        'searchable': {'key': 'searchable', 'type': 'bool'},
        'filterable': {'key': 'filterable', 'type': 'bool'},
        'sortable': {'key': 'sortable', 'type': 'bool'},
        'facetable': {'key': 'facetable', 'type': 'bool'},
        'analyzer': {'key': 'analyzer', 'type': 'str'},
        'search_analyzer': {'key': 'searchAnalyzer', 'type': 'str'},
        'index_analyzer': {'key': 'indexAnalyzer', 'type': 'str'},
        'normalizer': {'key': 'normalizer', 'type': 'str'},
        'synonym_maps': {'key': 'synonymMaps', 'type': '[str]'},
        'fields': {'key': 'fields', 'type': '[SearchField]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the field, which must be unique within the fields
         collection of the index or parent field.
        :paramtype name: str
        :keyword type: Required. The data type of the field. Possible values include: "Edm.String",
         "Edm.Int32", "Edm.Int64", "Edm.Double", "Edm.Boolean", "Edm.DateTimeOffset",
         "Edm.GeographyPoint", "Edm.ComplexType".
        :paramtype type: str or ~azure.search.documents.indexes.models.SearchFieldDataType
        :keyword key: A value indicating whether the field uniquely identifies documents in the index.
         Exactly one top-level field in each index must be chosen as the key field and it must be of
         type Edm.String. Key fields can be used to look up documents directly and update or delete
         specific documents. Default is false for simple fields and null for complex fields.
        :paramtype key: bool
        :keyword retrievable: A value indicating whether the field can be returned in a search result.
         You can disable this option if you want to use a field (for example, margin) as a filter,
         sorting, or scoring mechanism but do not want the field to be visible to the end user. This
         property must be true for key fields, and it must be null for complex fields. This property can
         be changed on existing fields. Enabling this property does not cause any increase in index
         storage requirements. Default is true for simple fields and null for complex fields.
        :paramtype retrievable: bool
        :keyword searchable: A value indicating whether the field is full-text searchable. This means
         it will undergo analysis such as word-breaking during indexing. If you set a searchable field
         to a value like "sunny day", internally it will be split into the individual tokens "sunny" and
         "day". This enables full-text searches for these terms. Fields of type Edm.String or
         Collection(Edm.String) are searchable by default. This property must be false for simple fields
         of other non-string data types, and it must be null for complex fields. Note: searchable fields
         consume extra space in your index since Azure Cognitive Search will store an additional
         tokenized version of the field value for full-text searches. If you want to save space in your
         index and you don't need a field to be included in searches, set searchable to false.
        :paramtype searchable: bool
        :keyword filterable: A value indicating whether to enable the field to be referenced in $filter
         queries. filterable differs from searchable in how strings are handled. Fields of type
         Edm.String or Collection(Edm.String) that are filterable do not undergo word-breaking, so
         comparisons are for exact matches only. For example, if you set such a field f to "sunny day",
         $filter=f eq 'sunny' will find no matches, but $filter=f eq 'sunny day' will. This property
         must be null for complex fields. Default is true for simple fields and null for complex fields.
        :paramtype filterable: bool
        :keyword sortable: A value indicating whether to enable the field to be referenced in $orderby
         expressions. By default Azure Cognitive Search sorts results by score, but in many experiences
         users will want to sort by fields in the documents. A simple field can be sortable only if it
         is single-valued (it has a single value in the scope of the parent document). Simple collection
         fields cannot be sortable, since they are multi-valued. Simple sub-fields of complex
         collections are also multi-valued, and therefore cannot be sortable. This is true whether it's
         an immediate parent field, or an ancestor field, that's the complex collection. Complex fields
         cannot be sortable and the sortable property must be null for such fields. The default for
         sortable is true for single-valued simple fields, false for multi-valued simple fields, and
         null for complex fields.
        :paramtype sortable: bool
        :keyword facetable: A value indicating whether to enable the field to be referenced in facet
         queries. Typically used in a presentation of search results that includes hit count by category
         (for example, search for digital cameras and see hits by brand, by megapixels, by price, and so
         on). This property must be null for complex fields. Fields of type Edm.GeographyPoint or
         Collection(Edm.GeographyPoint) cannot be facetable. Default is true for all other simple
         fields.
        :paramtype facetable: bool
        :keyword analyzer: The name of the analyzer to use for the field. This option can be used only
         with searchable fields and it can't be set together with either searchAnalyzer or
         indexAnalyzer. Once the analyzer is chosen, it cannot be changed for the field. Must be null
         for complex fields. Possible values include: "ar.microsoft", "ar.lucene", "hy.lucene",
         "bn.microsoft", "eu.lucene", "bg.microsoft", "bg.lucene", "ca.microsoft", "ca.lucene",
         "zh-Hans.microsoft", "zh-Hans.lucene", "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft",
         "cs.microsoft", "cs.lucene", "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene",
         "en.microsoft", "en.lucene", "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft",
         "fr.lucene", "gl.lucene", "de.microsoft", "de.lucene", "el.microsoft", "el.lucene",
         "gu.microsoft", "he.microsoft", "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene",
         "is.microsoft", "id.microsoft", "id.lucene", "ga.lucene", "it.microsoft", "it.lucene",
         "ja.microsoft", "ja.lucene", "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft",
         "lv.lucene", "lt.microsoft", "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft",
         "no.lucene", "fa.lucene", "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene",
         "pt-PT.microsoft", "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft",
         "ru.lucene", "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft",
         "es.microsoft", "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft",
         "th.microsoft", "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft",
         "vi.microsoft", "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern",
         "simple", "stop", "whitespace".
        :paramtype analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
        :keyword search_analyzer: The name of the analyzer used at search time for the field. This
         option can be used only with searchable fields. It must be set together with indexAnalyzer and
         it cannot be set together with the analyzer option. This property cannot be set to the name of
         a language analyzer; use the analyzer property instead if you need a language analyzer. This
         analyzer can be updated on an existing field. Must be null for complex fields. Possible values
         include: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene", "bg.microsoft",
         "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft", "zh-Hans.lucene",
         "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft", "cs.lucene",
         "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft", "en.lucene",
         "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene", "gl.lucene",
         "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft", "he.microsoft",
         "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft", "id.microsoft",
         "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft", "ja.lucene",
         "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene", "lt.microsoft",
         "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene", "fa.lucene",
         "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
         "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
         "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
         "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
         "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
         "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop",
         "whitespace".
        :paramtype search_analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
        :keyword index_analyzer: The name of the analyzer used at indexing time for the field. This
         option can be used only with searchable fields. It must be set together with searchAnalyzer and
         it cannot be set together with the analyzer option.  This property cannot be set to the name of
         a language analyzer; use the analyzer property instead if you need a language analyzer. Once
         the analyzer is chosen, it cannot be changed for the field. Must be null for complex fields.
         Possible values include: "ar.microsoft", "ar.lucene", "hy.lucene", "bn.microsoft", "eu.lucene",
         "bg.microsoft", "bg.lucene", "ca.microsoft", "ca.lucene", "zh-Hans.microsoft",
         "zh-Hans.lucene", "zh-Hant.microsoft", "zh-Hant.lucene", "hr.microsoft", "cs.microsoft",
         "cs.lucene", "da.microsoft", "da.lucene", "nl.microsoft", "nl.lucene", "en.microsoft",
         "en.lucene", "et.microsoft", "fi.microsoft", "fi.lucene", "fr.microsoft", "fr.lucene",
         "gl.lucene", "de.microsoft", "de.lucene", "el.microsoft", "el.lucene", "gu.microsoft",
         "he.microsoft", "hi.microsoft", "hi.lucene", "hu.microsoft", "hu.lucene", "is.microsoft",
         "id.microsoft", "id.lucene", "ga.lucene", "it.microsoft", "it.lucene", "ja.microsoft",
         "ja.lucene", "kn.microsoft", "ko.microsoft", "ko.lucene", "lv.microsoft", "lv.lucene",
         "lt.microsoft", "ml.microsoft", "ms.microsoft", "mr.microsoft", "nb.microsoft", "no.lucene",
         "fa.lucene", "pl.microsoft", "pl.lucene", "pt-BR.microsoft", "pt-BR.lucene", "pt-PT.microsoft",
         "pt-PT.lucene", "pa.microsoft", "ro.microsoft", "ro.lucene", "ru.microsoft", "ru.lucene",
         "sr-cyrillic.microsoft", "sr-latin.microsoft", "sk.microsoft", "sl.microsoft", "es.microsoft",
         "es.lucene", "sv.microsoft", "sv.lucene", "ta.microsoft", "te.microsoft", "th.microsoft",
         "th.lucene", "tr.microsoft", "tr.lucene", "uk.microsoft", "ur.microsoft", "vi.microsoft",
         "standard.lucene", "standardasciifolding.lucene", "keyword", "pattern", "simple", "stop",
         "whitespace".
        :paramtype index_analyzer: str or ~azure.search.documents.indexes.models.LexicalAnalyzerName
        :keyword normalizer: The name of the normalizer to use for the field. This option can be used
         only with fields with filterable, sortable, or facetable enabled. Once the normalizer is
         chosen, it cannot be changed for the field. Must be null for complex fields. Possible values
         include: "asciifolding", "elision", "lowercase", "standard", "uppercase".
        :paramtype normalizer: str or ~azure.search.documents.indexes.models.LexicalNormalizerName
        :keyword synonym_maps: A list of the names of synonym maps to associate with this field. This
         option can be used only with searchable fields. Currently only one synonym map per field is
         supported. Assigning a synonym map to a field ensures that query terms targeting that field are
         expanded at query-time using the rules in the synonym map. This attribute can be changed on
         existing fields. Must be null or an empty collection for complex fields.
        :paramtype synonym_maps: list[str]
        :keyword fields: A list of sub-fields if this is a field of type Edm.ComplexType or
         Collection(Edm.ComplexType). Must be null or empty for simple fields.
        :paramtype fields: list[~azure.search.documents.indexes.models.SearchField]
        """
        super(SearchField, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.key = kwargs.get('key', None)
        self.retrievable = kwargs.get('retrievable', None)
        self.searchable = kwargs.get('searchable', None)
        self.filterable = kwargs.get('filterable', None)
        self.sortable = kwargs.get('sortable', None)
        self.facetable = kwargs.get('facetable', None)
        self.analyzer = kwargs.get('analyzer', None)
        self.search_analyzer = kwargs.get('search_analyzer', None)
        self.index_analyzer = kwargs.get('index_analyzer', None)
        self.normalizer = kwargs.get('normalizer', None)
        self.synonym_maps = kwargs.get('synonym_maps', None)
        self.fields = kwargs.get('fields', None)


class SearchIndex(msrest.serialization.Model):
    """Represents a search index definition, which describes the fields and search behavior of an index.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the index.
    :vartype name: str
    :ivar fields: Required. The fields of the index.
    :vartype fields: list[~azure.search.documents.indexes.models.SearchField]
    :ivar scoring_profiles: The scoring profiles for the index.
    :vartype scoring_profiles: list[~azure.search.documents.indexes.models.ScoringProfile]
    :ivar default_scoring_profile: The name of the scoring profile to use if none is specified in
     the query. If this property is not set and no scoring profile is specified in the query, then
     default scoring (tf-idf) will be used.
    :vartype default_scoring_profile: str
    :ivar cors_options: Options to control Cross-Origin Resource Sharing (CORS) for the index.
    :vartype cors_options: ~azure.search.documents.indexes.models.CorsOptions
    :ivar suggesters: The suggesters for the index.
    :vartype suggesters: list[~azure.search.documents.indexes.models.Suggester]
    :ivar analyzers: The analyzers for the index.
    :vartype analyzers: list[~azure.search.documents.indexes.models.LexicalAnalyzer]
    :ivar tokenizers: The tokenizers for the index.
    :vartype tokenizers: list[~azure.search.documents.indexes.models.LexicalTokenizer]
    :ivar token_filters: The token filters for the index.
    :vartype token_filters: list[~azure.search.documents.indexes.models.TokenFilter]
    :ivar char_filters: The character filters for the index.
    :vartype char_filters: list[~azure.search.documents.indexes.models.CharFilter]
    :ivar normalizers: The normalizers for the index.
    :vartype normalizers: list[~azure.search.documents.indexes.models.LexicalNormalizer]
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your data when you
     want full assurance that no one, not even Microsoft, can decrypt your data in Azure Cognitive
     Search. Once you have encrypted your data, it will always remain encrypted. Azure Cognitive
     Search will ignore attempts to set this property to null. You can change this property as
     needed if you want to rotate your encryption key; Your data will be unaffected. Encryption with
     customer-managed keys is not available for free search services, and is only available for paid
     services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar similarity: The type of similarity algorithm to be used when scoring and ranking the
     documents matching a search query. The similarity algorithm can only be defined at index
     creation time and cannot be modified on existing indexes. If null, the ClassicSimilarity
     algorithm is used.
    :vartype similarity: ~azure.search.documents.indexes.models.Similarity
    :ivar semantic_settings: Defines parameters for a search index that influence semantic
     capabilities.
    :vartype semantic_settings: ~azure.search.documents.indexes.models.SemanticSettings
    :ivar e_tag: The ETag of the index.
    :vartype e_tag: str
    """

    _validation = {
        'name': {'required': True},
        'fields': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'fields': {'key': 'fields', 'type': '[SearchField]'},
        'scoring_profiles': {'key': 'scoringProfiles', 'type': '[ScoringProfile]'},
        'default_scoring_profile': {'key': 'defaultScoringProfile', 'type': 'str'},
        'cors_options': {'key': 'corsOptions', 'type': 'CorsOptions'},
        'suggesters': {'key': 'suggesters', 'type': '[Suggester]'},
        'analyzers': {'key': 'analyzers', 'type': '[LexicalAnalyzer]'},
        'tokenizers': {'key': 'tokenizers', 'type': '[LexicalTokenizer]'},
        'token_filters': {'key': 'tokenFilters', 'type': '[TokenFilter]'},
        'char_filters': {'key': 'charFilters', 'type': '[CharFilter]'},
        'normalizers': {'key': 'normalizers', 'type': '[LexicalNormalizer]'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
        'similarity': {'key': 'similarity', 'type': 'Similarity'},
        'semantic_settings': {'key': 'semantic', 'type': 'SemanticSettings'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the index.
        :paramtype name: str
        :keyword fields: Required. The fields of the index.
        :paramtype fields: list[~azure.search.documents.indexes.models.SearchField]
        :keyword scoring_profiles: The scoring profiles for the index.
        :paramtype scoring_profiles: list[~azure.search.documents.indexes.models.ScoringProfile]
        :keyword default_scoring_profile: The name of the scoring profile to use if none is specified
         in the query. If this property is not set and no scoring profile is specified in the query,
         then default scoring (tf-idf) will be used.
        :paramtype default_scoring_profile: str
        :keyword cors_options: Options to control Cross-Origin Resource Sharing (CORS) for the index.
        :paramtype cors_options: ~azure.search.documents.indexes.models.CorsOptions
        :keyword suggesters: The suggesters for the index.
        :paramtype suggesters: list[~azure.search.documents.indexes.models.Suggester]
        :keyword analyzers: The analyzers for the index.
        :paramtype analyzers: list[~azure.search.documents.indexes.models.LexicalAnalyzer]
        :keyword tokenizers: The tokenizers for the index.
        :paramtype tokenizers: list[~azure.search.documents.indexes.models.LexicalTokenizer]
        :keyword token_filters: The token filters for the index.
        :paramtype token_filters: list[~azure.search.documents.indexes.models.TokenFilter]
        :keyword char_filters: The character filters for the index.
        :paramtype char_filters: list[~azure.search.documents.indexes.models.CharFilter]
        :keyword normalizers: The normalizers for the index.
        :paramtype normalizers: list[~azure.search.documents.indexes.models.LexicalNormalizer]
        :keyword encryption_key: A description of an encryption key that you create in Azure Key Vault.
         This key is used to provide an additional level of encryption-at-rest for your data when you
         want full assurance that no one, not even Microsoft, can decrypt your data in Azure Cognitive
         Search. Once you have encrypted your data, it will always remain encrypted. Azure Cognitive
         Search will ignore attempts to set this property to null. You can change this property as
         needed if you want to rotate your encryption key; Your data will be unaffected. Encryption with
         customer-managed keys is not available for free search services, and is only available for paid
         services created on or after January 1, 2019.
        :paramtype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
        :keyword similarity: The type of similarity algorithm to be used when scoring and ranking the
         documents matching a search query. The similarity algorithm can only be defined at index
         creation time and cannot be modified on existing indexes. If null, the ClassicSimilarity
         algorithm is used.
        :paramtype similarity: ~azure.search.documents.indexes.models.Similarity
        :keyword semantic_settings: Defines parameters for a search index that influence semantic
         capabilities.
        :paramtype semantic_settings: ~azure.search.documents.indexes.models.SemanticSettings
        :keyword e_tag: The ETag of the index.
        :paramtype e_tag: str
        """
        super(SearchIndex, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.fields = kwargs['fields']
        self.scoring_profiles = kwargs.get('scoring_profiles', None)
        self.default_scoring_profile = kwargs.get('default_scoring_profile', None)
        self.cors_options = kwargs.get('cors_options', None)
        self.suggesters = kwargs.get('suggesters', None)
        self.analyzers = kwargs.get('analyzers', None)
        self.tokenizers = kwargs.get('tokenizers', None)
        self.token_filters = kwargs.get('token_filters', None)
        self.char_filters = kwargs.get('char_filters', None)
        self.normalizers = kwargs.get('normalizers', None)
        self.encryption_key = kwargs.get('encryption_key', None)
        self.similarity = kwargs.get('similarity', None)
        self.semantic_settings = kwargs.get('semantic_settings', None)
        self.e_tag = kwargs.get('e_tag', None)


class SearchIndexer(msrest.serialization.Model):
    """Represents an indexer.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the indexer.
    :vartype name: str
    :ivar description: The description of the indexer.
    :vartype description: str
    :ivar data_source_name: Required. The name of the datasource from which this indexer reads
     data.
    :vartype data_source_name: str
    :ivar skillset_name: The name of the skillset executing with this indexer.
    :vartype skillset_name: str
    :ivar target_index_name: Required. The name of the index to which this indexer writes data.
    :vartype target_index_name: str
    :ivar schedule: The schedule for this indexer.
    :vartype schedule: ~azure.search.documents.indexes.models.IndexingSchedule
    :ivar parameters: Parameters for indexer execution.
    :vartype parameters: ~azure.search.documents.indexes.models.IndexingParameters
    :ivar field_mappings: Defines mappings between fields in the data source and corresponding
     target fields in the index.
    :vartype field_mappings: list[~azure.search.documents.indexes.models.FieldMapping]
    :ivar output_field_mappings: Output field mappings are applied after enrichment and immediately
     before indexing.
    :vartype output_field_mappings: list[~azure.search.documents.indexes.models.FieldMapping]
    :ivar is_disabled: A value indicating whether the indexer is disabled. Default is false.
    :vartype is_disabled: bool
    :ivar e_tag: The ETag of the indexer.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your indexer
     definition (as well as indexer execution status) when you want full assurance that no one, not
     even Microsoft, can decrypt them in Azure Cognitive Search. Once you have encrypted your
     indexer definition, it will always remain encrypted. Azure Cognitive Search will ignore
     attempts to set this property to null. You can change this property as needed if you want to
     rotate your encryption key; Your indexer definition (and indexer execution status) will be
     unaffected. Encryption with customer-managed keys is not available for free search services,
     and is only available for paid services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar cache: Adds caching to an enrichment pipeline to allow for incremental modification steps
     without having to rebuild the index every time.
    :vartype cache: ~azure.search.documents.indexes.models.SearchIndexerCache
    """

    _validation = {
        'name': {'required': True},
        'data_source_name': {'required': True},
        'target_index_name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'data_source_name': {'key': 'dataSourceName', 'type': 'str'},
        'skillset_name': {'key': 'skillsetName', 'type': 'str'},
        'target_index_name': {'key': 'targetIndexName', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'IndexingSchedule'},
        'parameters': {'key': 'parameters', 'type': 'IndexingParameters'},
        'field_mappings': {'key': 'fieldMappings', 'type': '[FieldMapping]'},
        'output_field_mappings': {'key': 'outputFieldMappings', 'type': '[FieldMapping]'},
        'is_disabled': {'key': 'disabled', 'type': 'bool'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
        'cache': {'key': 'cache', 'type': 'SearchIndexerCache'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the indexer.
        :paramtype name: str
        :keyword description: The description of the indexer.
        :paramtype description: str
        :keyword data_source_name: Required. The name of the datasource from which this indexer reads
         data.
        :paramtype data_source_name: str
        :keyword skillset_name: The name of the skillset executing with this indexer.
        :paramtype skillset_name: str
        :keyword target_index_name: Required. The name of the index to which this indexer writes data.
        :paramtype target_index_name: str
        :keyword schedule: The schedule for this indexer.
        :paramtype schedule: ~azure.search.documents.indexes.models.IndexingSchedule
        :keyword parameters: Parameters for indexer execution.
        :paramtype parameters: ~azure.search.documents.indexes.models.IndexingParameters
        :keyword field_mappings: Defines mappings between fields in the data source and corresponding
         target fields in the index.
        :paramtype field_mappings: list[~azure.search.documents.indexes.models.FieldMapping]
        :keyword output_field_mappings: Output field mappings are applied after enrichment and
         immediately before indexing.
        :paramtype output_field_mappings: list[~azure.search.documents.indexes.models.FieldMapping]
        :keyword is_disabled: A value indicating whether the indexer is disabled. Default is false.
        :paramtype is_disabled: bool
        :keyword e_tag: The ETag of the indexer.
        :paramtype e_tag: str
        :keyword encryption_key: A description of an encryption key that you create in Azure Key Vault.
         This key is used to provide an additional level of encryption-at-rest for your indexer
         definition (as well as indexer execution status) when you want full assurance that no one, not
         even Microsoft, can decrypt them in Azure Cognitive Search. Once you have encrypted your
         indexer definition, it will always remain encrypted. Azure Cognitive Search will ignore
         attempts to set this property to null. You can change this property as needed if you want to
         rotate your encryption key; Your indexer definition (and indexer execution status) will be
         unaffected. Encryption with customer-managed keys is not available for free search services,
         and is only available for paid services created on or after January 1, 2019.
        :paramtype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
        :keyword cache: Adds caching to an enrichment pipeline to allow for incremental modification
         steps without having to rebuild the index every time.
        :paramtype cache: ~azure.search.documents.indexes.models.SearchIndexerCache
        """
        super(SearchIndexer, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.data_source_name = kwargs['data_source_name']
        self.skillset_name = kwargs.get('skillset_name', None)
        self.target_index_name = kwargs['target_index_name']
        self.schedule = kwargs.get('schedule', None)
        self.parameters = kwargs.get('parameters', None)
        self.field_mappings = kwargs.get('field_mappings', None)
        self.output_field_mappings = kwargs.get('output_field_mappings', None)
        self.is_disabled = kwargs.get('is_disabled', False)
        self.e_tag = kwargs.get('e_tag', None)
        self.encryption_key = kwargs.get('encryption_key', None)
        self.cache = kwargs.get('cache', None)


class SearchIndexerCache(msrest.serialization.Model):
    """SearchIndexerCache.

    :ivar storage_connection_string: The connection string to the storage account where the cache
     data will be persisted.
    :vartype storage_connection_string: str
    :ivar enable_reprocessing: Specifies whether incremental reprocessing is enabled.
    :vartype enable_reprocessing: bool
    """

    _attribute_map = {
        'storage_connection_string': {'key': 'storageConnectionString', 'type': 'str'},
        'enable_reprocessing': {'key': 'enableReprocessing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword storage_connection_string: The connection string to the storage account where the
         cache data will be persisted.
        :paramtype storage_connection_string: str
        :keyword enable_reprocessing: Specifies whether incremental reprocessing is enabled.
        :paramtype enable_reprocessing: bool
        """
        super(SearchIndexerCache, self).__init__(**kwargs)
        self.storage_connection_string = kwargs.get('storage_connection_string', None)
        self.enable_reprocessing = kwargs.get('enable_reprocessing', None)


class SearchIndexerDataContainer(msrest.serialization.Model):
    """Represents information about the entity (such as Azure SQL table or CosmosDB collection) that will be indexed.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the table or view (for Azure SQL data source) or collection
     (for CosmosDB data source) that will be indexed.
    :vartype name: str
    :ivar query: A query that is applied to this data container. The syntax and meaning of this
     parameter is datasource-specific. Not supported by Azure SQL datasources.
    :vartype query: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the table or view (for Azure SQL data source) or
         collection (for CosmosDB data source) that will be indexed.
        :paramtype name: str
        :keyword query: A query that is applied to this data container. The syntax and meaning of this
         parameter is datasource-specific. Not supported by Azure SQL datasources.
        :paramtype query: str
        """
        super(SearchIndexerDataContainer, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.query = kwargs.get('query', None)


class SearchIndexerDataIdentity(msrest.serialization.Model):
    """Abstract base type for data identities.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SearchIndexerDataNoneIdentity, SearchIndexerDataUserAssignedIdentity.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the identity.Constant filled by
     server.
    :vartype odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'#Microsoft.Azure.Search.SearchIndexerDataNoneIdentity': 'SearchIndexerDataNoneIdentity', '#Microsoft.Azure.Search.SearchIndexerDataUserAssignedIdentity': 'SearchIndexerDataUserAssignedIdentity'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SearchIndexerDataIdentity, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class SearchIndexerDataNoneIdentity(SearchIndexerDataIdentity):
    """Clears the identity property of a datasource.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the identity.Constant filled by
     server.
    :vartype odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SearchIndexerDataNoneIdentity, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SearchIndexerDataNoneIdentity'  # type: str


class SearchIndexerDataSource(msrest.serialization.Model):
    """Represents a datasource definition, which can be used to configure an indexer.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the datasource.
    :vartype name: str
    :ivar description: The description of the datasource.
    :vartype description: str
    :ivar type: Required. The type of the datasource. Possible values include: "azuresql",
     "cosmosdb", "azureblob", "azuretable", "mysql", "adlsgen2".
    :vartype type: str or ~azure.search.documents.indexes.models.SearchIndexerDataSourceType
    :ivar credentials: Required. Credentials for the datasource.
    :vartype credentials: ~azure.search.documents.indexes.models.DataSourceCredentials
    :ivar container: Required. The data container for the datasource.
    :vartype container: ~azure.search.documents.indexes.models.SearchIndexerDataContainer
    :ivar identity: An explicit managed identity to use for this datasource. If not specified and
     the connection string is a managed identity, the system-assigned managed identity is used. If
     not specified, the value remains unchanged. If "none" is specified, the value of this property
     is cleared.
    :vartype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    :ivar data_change_detection_policy: The data change detection policy for the datasource.
    :vartype data_change_detection_policy:
     ~azure.search.documents.indexes.models.DataChangeDetectionPolicy
    :ivar data_deletion_detection_policy: The data deletion detection policy for the datasource.
    :vartype data_deletion_detection_policy:
     ~azure.search.documents.indexes.models.DataDeletionDetectionPolicy
    :ivar e_tag: The ETag of the data source.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your datasource
     definition when you want full assurance that no one, not even Microsoft, can decrypt your data
     source definition in Azure Cognitive Search. Once you have encrypted your data source
     definition, it will always remain encrypted. Azure Cognitive Search will ignore attempts to set
     this property to null. You can change this property as needed if you want to rotate your
     encryption key; Your datasource definition will be unaffected. Encryption with customer-managed
     keys is not available for free search services, and is only available for paid services created
     on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'credentials': {'required': True},
        'container': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'DataSourceCredentials'},
        'container': {'key': 'container', 'type': 'SearchIndexerDataContainer'},
        'identity': {'key': 'identity', 'type': 'SearchIndexerDataIdentity'},
        'data_change_detection_policy': {'key': 'dataChangeDetectionPolicy', 'type': 'DataChangeDetectionPolicy'},
        'data_deletion_detection_policy': {'key': 'dataDeletionDetectionPolicy', 'type': 'DataDeletionDetectionPolicy'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the datasource.
        :paramtype name: str
        :keyword description: The description of the datasource.
        :paramtype description: str
        :keyword type: Required. The type of the datasource. Possible values include: "azuresql",
         "cosmosdb", "azureblob", "azuretable", "mysql", "adlsgen2".
        :paramtype type: str or ~azure.search.documents.indexes.models.SearchIndexerDataSourceType
        :keyword credentials: Required. Credentials for the datasource.
        :paramtype credentials: ~azure.search.documents.indexes.models.DataSourceCredentials
        :keyword container: Required. The data container for the datasource.
        :paramtype container: ~azure.search.documents.indexes.models.SearchIndexerDataContainer
        :keyword identity: An explicit managed identity to use for this datasource. If not specified
         and the connection string is a managed identity, the system-assigned managed identity is used.
         If not specified, the value remains unchanged. If "none" is specified, the value of this
         property is cleared.
        :paramtype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
        :keyword data_change_detection_policy: The data change detection policy for the datasource.
        :paramtype data_change_detection_policy:
         ~azure.search.documents.indexes.models.DataChangeDetectionPolicy
        :keyword data_deletion_detection_policy: The data deletion detection policy for the datasource.
        :paramtype data_deletion_detection_policy:
         ~azure.search.documents.indexes.models.DataDeletionDetectionPolicy
        :keyword e_tag: The ETag of the data source.
        :paramtype e_tag: str
        :keyword encryption_key: A description of an encryption key that you create in Azure Key Vault.
         This key is used to provide an additional level of encryption-at-rest for your datasource
         definition when you want full assurance that no one, not even Microsoft, can decrypt your data
         source definition in Azure Cognitive Search. Once you have encrypted your data source
         definition, it will always remain encrypted. Azure Cognitive Search will ignore attempts to set
         this property to null. You can change this property as needed if you want to rotate your
         encryption key; Your datasource definition will be unaffected. Encryption with customer-managed
         keys is not available for free search services, and is only available for paid services created
         on or after January 1, 2019.
        :paramtype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
        """
        super(SearchIndexerDataSource, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.type = kwargs['type']
        self.credentials = kwargs['credentials']
        self.container = kwargs['container']
        self.identity = kwargs.get('identity', None)
        self.data_change_detection_policy = kwargs.get('data_change_detection_policy', None)
        self.data_deletion_detection_policy = kwargs.get('data_deletion_detection_policy', None)
        self.e_tag = kwargs.get('e_tag', None)
        self.encryption_key = kwargs.get('encryption_key', None)


class SearchIndexerDataUserAssignedIdentity(SearchIndexerDataIdentity):
    """Specifies the identity for a datasource to use.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the identity.Constant filled by
     server.
    :vartype odata_type: str
    :ivar user_assigned_identity: Required. The fully qualified Azure resource Id of a user
     assigned managed identity typically in the form
     "/subscriptions/12345678-1234-1234-1234-1234567890ab/resourceGroups/rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId"
     that should have been assigned to the search service.
    :vartype user_assigned_identity: str
    """

    _validation = {
        'odata_type': {'required': True},
        'user_assigned_identity': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword user_assigned_identity: Required. The fully qualified Azure resource Id of a user
         assigned managed identity typically in the form
         "/subscriptions/12345678-1234-1234-1234-1234567890ab/resourceGroups/rg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId"
         that should have been assigned to the search service.
        :paramtype user_assigned_identity: str
        """
        super(SearchIndexerDataUserAssignedIdentity, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SearchIndexerDataUserAssignedIdentity'  # type: str
        self.user_assigned_identity = kwargs['user_assigned_identity']


class SearchIndexerError(msrest.serialization.Model):
    """Represents an item- or document-level indexing error.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The key of the item for which indexing failed.
    :vartype key: str
    :ivar error_message: Required. The message describing the error that occurred while processing
     the item.
    :vartype error_message: str
    :ivar status_code: Required. The status code indicating why the indexing operation failed.
     Possible values include: 400 for a malformed input document, 404 for document not found, 409
     for a version conflict, 422 when the index is temporarily unavailable, or 503 for when the
     service is too busy.
    :vartype status_code: int
    :ivar name: The name of the source at which the error originated. For example, this could refer
     to a particular skill in the attached skillset. This may not be always available.
    :vartype name: str
    :ivar details: Additional, verbose details about the error to assist in debugging the indexer.
     This may not be always available.
    :vartype details: str
    :ivar documentation_link: A link to a troubleshooting guide for these classes of errors. This
     may not be always available.
    :vartype documentation_link: str
    """

    _validation = {
        'key': {'readonly': True},
        'error_message': {'required': True, 'readonly': True},
        'status_code': {'required': True, 'readonly': True},
        'name': {'readonly': True},
        'details': {'readonly': True},
        'documentation_link': {'readonly': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'documentation_link': {'key': 'documentationLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SearchIndexerError, self).__init__(**kwargs)
        self.key = None
        self.error_message = None
        self.status_code = None
        self.name = None
        self.details = None
        self.documentation_link = None


class SearchIndexerKnowledgeStore(msrest.serialization.Model):
    """Definition of additional projections to azure blob, table, or files, of enriched data.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_connection_string: Required. The connection string to the storage account
     projections will be stored in.
    :vartype storage_connection_string: str
    :ivar projections: Required. A list of additional projections to perform during indexing.
    :vartype projections:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreProjection]
    """

    _validation = {
        'storage_connection_string': {'required': True},
        'projections': {'required': True},
    }

    _attribute_map = {
        'storage_connection_string': {'key': 'storageConnectionString', 'type': 'str'},
        'projections': {'key': 'projections', 'type': '[SearchIndexerKnowledgeStoreProjection]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword storage_connection_string: Required. The connection string to the storage account
         projections will be stored in.
        :paramtype storage_connection_string: str
        :keyword projections: Required. A list of additional projections to perform during indexing.
        :paramtype projections:
         list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreProjection]
        """
        super(SearchIndexerKnowledgeStore, self).__init__(**kwargs)
        self.storage_connection_string = kwargs['storage_connection_string']
        self.projections = kwargs['projections']


class SearchIndexerKnowledgeStoreProjectionSelector(msrest.serialization.Model):
    """Abstract class to share properties between concrete selectors.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar generated_key_name: Name of generated key to store projection under.
    :vartype generated_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    """

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword reference_key_name: Name of reference key to different projection.
        :paramtype reference_key_name: str
        :keyword generated_key_name: Name of generated key to store projection under.
        :paramtype generated_key_name: str
        :keyword source: Source data to project.
        :paramtype source: str
        :keyword source_context: Source context for complex projections.
        :paramtype source_context: str
        :keyword inputs: Nested inputs for complex projections.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        """
        super(SearchIndexerKnowledgeStoreProjectionSelector, self).__init__(**kwargs)
        self.reference_key_name = kwargs.get('reference_key_name', None)
        self.generated_key_name = kwargs.get('generated_key_name', None)
        self.source = kwargs.get('source', None)
        self.source_context = kwargs.get('source_context', None)
        self.inputs = kwargs.get('inputs', None)


class SearchIndexerKnowledgeStoreBlobProjectionSelector(SearchIndexerKnowledgeStoreProjectionSelector):
    """Abstract class to share properties between concrete selectors.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar generated_key_name: Name of generated key to store projection under.
    :vartype generated_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar storage_container: Required. Blob container to store projections in.
    :vartype storage_container: str
    """

    _validation = {
        'storage_container': {'required': True},
    }

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'storage_container': {'key': 'storageContainer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword reference_key_name: Name of reference key to different projection.
        :paramtype reference_key_name: str
        :keyword generated_key_name: Name of generated key to store projection under.
        :paramtype generated_key_name: str
        :keyword source: Source data to project.
        :paramtype source: str
        :keyword source_context: Source context for complex projections.
        :paramtype source_context: str
        :keyword inputs: Nested inputs for complex projections.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword storage_container: Required. Blob container to store projections in.
        :paramtype storage_container: str
        """
        super(SearchIndexerKnowledgeStoreBlobProjectionSelector, self).__init__(**kwargs)
        self.storage_container = kwargs['storage_container']


class SearchIndexerKnowledgeStoreFileProjectionSelector(SearchIndexerKnowledgeStoreBlobProjectionSelector):
    """Projection definition for what data to store in Azure Files.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar generated_key_name: Name of generated key to store projection under.
    :vartype generated_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar storage_container: Required. Blob container to store projections in.
    :vartype storage_container: str
    """

    _validation = {
        'storage_container': {'required': True},
    }

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'storage_container': {'key': 'storageContainer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword reference_key_name: Name of reference key to different projection.
        :paramtype reference_key_name: str
        :keyword generated_key_name: Name of generated key to store projection under.
        :paramtype generated_key_name: str
        :keyword source: Source data to project.
        :paramtype source: str
        :keyword source_context: Source context for complex projections.
        :paramtype source_context: str
        :keyword inputs: Nested inputs for complex projections.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword storage_container: Required. Blob container to store projections in.
        :paramtype storage_container: str
        """
        super(SearchIndexerKnowledgeStoreFileProjectionSelector, self).__init__(**kwargs)


class SearchIndexerKnowledgeStoreObjectProjectionSelector(SearchIndexerKnowledgeStoreBlobProjectionSelector):
    """Projection definition for what data to store in Azure Blob.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar generated_key_name: Name of generated key to store projection under.
    :vartype generated_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar storage_container: Required. Blob container to store projections in.
    :vartype storage_container: str
    """

    _validation = {
        'storage_container': {'required': True},
    }

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'storage_container': {'key': 'storageContainer', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword reference_key_name: Name of reference key to different projection.
        :paramtype reference_key_name: str
        :keyword generated_key_name: Name of generated key to store projection under.
        :paramtype generated_key_name: str
        :keyword source: Source data to project.
        :paramtype source: str
        :keyword source_context: Source context for complex projections.
        :paramtype source_context: str
        :keyword inputs: Nested inputs for complex projections.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword storage_container: Required. Blob container to store projections in.
        :paramtype storage_container: str
        """
        super(SearchIndexerKnowledgeStoreObjectProjectionSelector, self).__init__(**kwargs)


class SearchIndexerKnowledgeStoreProjection(msrest.serialization.Model):
    """Container object for various projection selectors.

    :ivar tables: Projections to Azure Table storage.
    :vartype tables:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreTableProjectionSelector]
    :ivar objects: Projections to Azure Blob storage.
    :vartype objects:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreObjectProjectionSelector]
    :ivar files: Projections to Azure File storage.
    :vartype files:
     list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreFileProjectionSelector]
    """

    _attribute_map = {
        'tables': {'key': 'tables', 'type': '[SearchIndexerKnowledgeStoreTableProjectionSelector]'},
        'objects': {'key': 'objects', 'type': '[SearchIndexerKnowledgeStoreObjectProjectionSelector]'},
        'files': {'key': 'files', 'type': '[SearchIndexerKnowledgeStoreFileProjectionSelector]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tables: Projections to Azure Table storage.
        :paramtype tables:
         list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreTableProjectionSelector]
        :keyword objects: Projections to Azure Blob storage.
        :paramtype objects:
         list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreObjectProjectionSelector]
        :keyword files: Projections to Azure File storage.
        :paramtype files:
         list[~azure.search.documents.indexes.models.SearchIndexerKnowledgeStoreFileProjectionSelector]
        """
        super(SearchIndexerKnowledgeStoreProjection, self).__init__(**kwargs)
        self.tables = kwargs.get('tables', None)
        self.objects = kwargs.get('objects', None)
        self.files = kwargs.get('files', None)


class SearchIndexerKnowledgeStoreTableProjectionSelector(SearchIndexerKnowledgeStoreProjectionSelector):
    """Description for what data to store in Azure Tables.

    All required parameters must be populated in order to send to Azure.

    :ivar reference_key_name: Name of reference key to different projection.
    :vartype reference_key_name: str
    :ivar generated_key_name: Name of generated key to store projection under.
    :vartype generated_key_name: str
    :ivar source: Source data to project.
    :vartype source: str
    :ivar source_context: Source context for complex projections.
    :vartype source_context: str
    :ivar inputs: Nested inputs for complex projections.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar table_name: Required. Name of the Azure table to store projected data in.
    :vartype table_name: str
    """

    _validation = {
        'table_name': {'required': True},
    }

    _attribute_map = {
        'reference_key_name': {'key': 'referenceKeyName', 'type': 'str'},
        'generated_key_name': {'key': 'generatedKeyName', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'source_context': {'key': 'sourceContext', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'table_name': {'key': 'tableName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword reference_key_name: Name of reference key to different projection.
        :paramtype reference_key_name: str
        :keyword generated_key_name: Name of generated key to store projection under.
        :paramtype generated_key_name: str
        :keyword source: Source data to project.
        :paramtype source: str
        :keyword source_context: Source context for complex projections.
        :paramtype source_context: str
        :keyword inputs: Nested inputs for complex projections.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword table_name: Required. Name of the Azure table to store projected data in.
        :paramtype table_name: str
        """
        super(SearchIndexerKnowledgeStoreTableProjectionSelector, self).__init__(**kwargs)
        self.table_name = kwargs['table_name']


class SearchIndexerLimits(msrest.serialization.Model):
    """SearchIndexerLimits.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar max_run_time: The maximum duration that the indexer is permitted to run for one
     execution.
    :vartype max_run_time: ~datetime.timedelta
    :ivar max_document_extraction_size: The maximum size of a document, in bytes, which will be
     considered valid for indexing.
    :vartype max_document_extraction_size: long
    :ivar max_document_content_characters_to_extract: The maximum number of characters that will be
     extracted from a document picked up for indexing.
    :vartype max_document_content_characters_to_extract: long
    """

    _validation = {
        'max_run_time': {'readonly': True},
        'max_document_extraction_size': {'readonly': True},
        'max_document_content_characters_to_extract': {'readonly': True},
    }

    _attribute_map = {
        'max_run_time': {'key': 'maxRunTime', 'type': 'duration'},
        'max_document_extraction_size': {'key': 'maxDocumentExtractionSize', 'type': 'long'},
        'max_document_content_characters_to_extract': {'key': 'maxDocumentContentCharactersToExtract', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SearchIndexerLimits, self).__init__(**kwargs)
        self.max_run_time = None
        self.max_document_extraction_size = None
        self.max_document_content_characters_to_extract = None


class SearchIndexerSkillset(msrest.serialization.Model):
    """A list of skills.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the skillset.
    :vartype name: str
    :ivar description: The description of the skillset.
    :vartype description: str
    :ivar skills: Required. A list of skills in the skillset.
    :vartype skills: list[~azure.search.documents.indexes.models.SearchIndexerSkill]
    :ivar cognitive_services_account: Details about cognitive services to be used when running
     skills.
    :vartype cognitive_services_account:
     ~azure.search.documents.indexes.models.CognitiveServicesAccount
    :ivar knowledge_store: Definition of additional projections to azure blob, table, or files, of
     enriched data.
    :vartype knowledge_store: ~azure.search.documents.indexes.models.SearchIndexerKnowledgeStore
    :ivar e_tag: The ETag of the skillset.
    :vartype e_tag: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your skillset
     definition when you want full assurance that no one, not even Microsoft, can decrypt your
     skillset definition in Azure Cognitive Search. Once you have encrypted your skillset
     definition, it will always remain encrypted. Azure Cognitive Search will ignore attempts to set
     this property to null. You can change this property as needed if you want to rotate your
     encryption key; Your skillset definition will be unaffected. Encryption with customer-managed
     keys is not available for free search services, and is only available for paid services created
     on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    """

    _validation = {
        'name': {'required': True},
        'skills': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'skills': {'key': 'skills', 'type': '[SearchIndexerSkill]'},
        'cognitive_services_account': {'key': 'cognitiveServices', 'type': 'CognitiveServicesAccount'},
        'knowledge_store': {'key': 'knowledgeStore', 'type': 'SearchIndexerKnowledgeStore'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the skillset.
        :paramtype name: str
        :keyword description: The description of the skillset.
        :paramtype description: str
        :keyword skills: Required. A list of skills in the skillset.
        :paramtype skills: list[~azure.search.documents.indexes.models.SearchIndexerSkill]
        :keyword cognitive_services_account: Details about cognitive services to be used when running
         skills.
        :paramtype cognitive_services_account:
         ~azure.search.documents.indexes.models.CognitiveServicesAccount
        :keyword knowledge_store: Definition of additional projections to azure blob, table, or files,
         of enriched data.
        :paramtype knowledge_store: ~azure.search.documents.indexes.models.SearchIndexerKnowledgeStore
        :keyword e_tag: The ETag of the skillset.
        :paramtype e_tag: str
        :keyword encryption_key: A description of an encryption key that you create in Azure Key Vault.
         This key is used to provide an additional level of encryption-at-rest for your skillset
         definition when you want full assurance that no one, not even Microsoft, can decrypt your
         skillset definition in Azure Cognitive Search. Once you have encrypted your skillset
         definition, it will always remain encrypted. Azure Cognitive Search will ignore attempts to set
         this property to null. You can change this property as needed if you want to rotate your
         encryption key; Your skillset definition will be unaffected. Encryption with customer-managed
         keys is not available for free search services, and is only available for paid services created
         on or after January 1, 2019.
        :paramtype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
        """
        super(SearchIndexerSkillset, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.skills = kwargs['skills']
        self.cognitive_services_account = kwargs.get('cognitive_services_account', None)
        self.knowledge_store = kwargs.get('knowledge_store', None)
        self.e_tag = kwargs.get('e_tag', None)
        self.encryption_key = kwargs.get('encryption_key', None)


class SearchIndexerStatus(msrest.serialization.Model):
    """Represents the current status and execution history of an indexer.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: Required. Overall indexer status. Possible values include: "unknown", "error",
     "running".
    :vartype status: str or ~azure.search.documents.indexes.models.IndexerStatus
    :ivar last_result: The result of the most recent or an in-progress indexer execution.
    :vartype last_result: ~azure.search.documents.indexes.models.IndexerExecutionResult
    :ivar execution_history: Required. History of the recent indexer executions, sorted in reverse
     chronological order.
    :vartype execution_history: list[~azure.search.documents.indexes.models.IndexerExecutionResult]
    :ivar limits: Required. The execution limits for the indexer.
    :vartype limits: ~azure.search.documents.indexes.models.SearchIndexerLimits
    """

    _validation = {
        'status': {'required': True, 'readonly': True},
        'last_result': {'readonly': True},
        'execution_history': {'required': True, 'readonly': True},
        'limits': {'required': True, 'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'last_result': {'key': 'lastResult', 'type': 'IndexerExecutionResult'},
        'execution_history': {'key': 'executionHistory', 'type': '[IndexerExecutionResult]'},
        'limits': {'key': 'limits', 'type': 'SearchIndexerLimits'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SearchIndexerStatus, self).__init__(**kwargs)
        self.status = None
        self.last_result = None
        self.execution_history = None
        self.limits = None


class SearchIndexerWarning(msrest.serialization.Model):
    """Represents an item-level warning.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar key: The key of the item which generated a warning.
    :vartype key: str
    :ivar message: Required. The message describing the warning that occurred while processing the
     item.
    :vartype message: str
    :ivar name: The name of the source at which the warning originated. For example, this could
     refer to a particular skill in the attached skillset. This may not be always available.
    :vartype name: str
    :ivar details: Additional, verbose details about the warning to assist in debugging the
     indexer. This may not be always available.
    :vartype details: str
    :ivar documentation_link: A link to a troubleshooting guide for these classes of warnings. This
     may not be always available.
    :vartype documentation_link: str
    """

    _validation = {
        'key': {'readonly': True},
        'message': {'required': True, 'readonly': True},
        'name': {'readonly': True},
        'details': {'readonly': True},
        'documentation_link': {'readonly': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
        'documentation_link': {'key': 'documentationLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SearchIndexerWarning, self).__init__(**kwargs)
        self.key = None
        self.message = None
        self.name = None
        self.details = None
        self.documentation_link = None


class SearchResourceEncryptionKey(msrest.serialization.Model):
    """A customer-managed encryption key in Azure Key Vault. Keys that you create and manage can be used to encrypt or decrypt data-at-rest in Azure Cognitive Search, such as indexes and synonym maps.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: Required. The name of your Azure Key Vault key to be used to encrypt your data
     at rest.
    :vartype key_name: str
    :ivar key_version: Required. The version of your Azure Key Vault key to be used to encrypt your
     data at rest.
    :vartype key_version: str
    :ivar vault_uri: Required. The URI of your Azure Key Vault, also referred to as DNS name, that
     contains the key to be used to encrypt your data at rest. An example URI might be
     https://my-keyvault-name.vault.azure.net.
    :vartype vault_uri: str
    :ivar access_credentials: Optional Azure Active Directory credentials used for accessing your
     Azure Key Vault. Not required if using managed identity instead.
    :vartype access_credentials:
     ~azure.search.documents.indexes.models.AzureActiveDirectoryApplicationCredentials
    :ivar identity: An explicit managed identity to use for this encryption key. If not specified
     and the access credentials property is null, the system-assigned managed identity is used. On
     update to the resource, if the explicit identity is unspecified, it remains unchanged. If
     "none" is specified, the value of this property is cleared.
    :vartype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
    """

    _validation = {
        'key_name': {'required': True},
        'key_version': {'required': True},
        'vault_uri': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyVaultKeyName', 'type': 'str'},
        'key_version': {'key': 'keyVaultKeyVersion', 'type': 'str'},
        'vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'access_credentials': {'key': 'accessCredentials', 'type': 'AzureActiveDirectoryApplicationCredentials'},
        'identity': {'key': 'identity', 'type': 'SearchIndexerDataIdentity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword key_name: Required. The name of your Azure Key Vault key to be used to encrypt your
         data at rest.
        :paramtype key_name: str
        :keyword key_version: Required. The version of your Azure Key Vault key to be used to encrypt
         your data at rest.
        :paramtype key_version: str
        :keyword vault_uri: Required. The URI of your Azure Key Vault, also referred to as DNS name,
         that contains the key to be used to encrypt your data at rest. An example URI might be
         https://my-keyvault-name.vault.azure.net.
        :paramtype vault_uri: str
        :keyword access_credentials: Optional Azure Active Directory credentials used for accessing
         your Azure Key Vault. Not required if using managed identity instead.
        :paramtype access_credentials:
         ~azure.search.documents.indexes.models.AzureActiveDirectoryApplicationCredentials
        :keyword identity: An explicit managed identity to use for this encryption key. If not
         specified and the access credentials property is null, the system-assigned managed identity is
         used. On update to the resource, if the explicit identity is unspecified, it remains unchanged.
         If "none" is specified, the value of this property is cleared.
        :paramtype identity: ~azure.search.documents.indexes.models.SearchIndexerDataIdentity
        """
        super(SearchResourceEncryptionKey, self).__init__(**kwargs)
        self.key_name = kwargs['key_name']
        self.key_version = kwargs['key_version']
        self.vault_uri = kwargs['vault_uri']
        self.access_credentials = kwargs.get('access_credentials', None)
        self.identity = kwargs.get('identity', None)


class SemanticConfiguration(msrest.serialization.Model):
    """Defines a specific configuration to be used in the context of semantic capabilities.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the semantic configuration.
    :vartype name: str
    :ivar prioritized_fields: Required. Describes the title, content, and keyword fields to be used
     for semantic ranking, captions, highlights, and answers. At least one of the three sub
     properties (titleField, prioritizedKeywordsFields and prioritizedContentFields) need to be set.
    :vartype prioritized_fields: ~azure.search.documents.indexes.models.PrioritizedFields
    """

    _validation = {
        'name': {'required': True},
        'prioritized_fields': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'prioritized_fields': {'key': 'prioritizedFields', 'type': 'PrioritizedFields'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the semantic configuration.
        :paramtype name: str
        :keyword prioritized_fields: Required. Describes the title, content, and keyword fields to be
         used for semantic ranking, captions, highlights, and answers. At least one of the three sub
         properties (titleField, prioritizedKeywordsFields and prioritizedContentFields) need to be set.
        :paramtype prioritized_fields: ~azure.search.documents.indexes.models.PrioritizedFields
        """
        super(SemanticConfiguration, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.prioritized_fields = kwargs['prioritized_fields']


class SemanticField(msrest.serialization.Model):
    """A field that is used as part of the semantic configuration.

    :ivar field_name:
    :vartype field_name: str
    """

    _attribute_map = {
        'field_name': {'key': 'fieldName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword field_name:
        :paramtype field_name: str
        """
        super(SemanticField, self).__init__(**kwargs)
        self.field_name = kwargs.get('field_name', None)


class SemanticSettings(msrest.serialization.Model):
    """Defines parameters for a search index that influence semantic capabilities.

    :ivar configurations: The semantic configurations for the index.
    :vartype configurations: list[~azure.search.documents.indexes.models.SemanticConfiguration]
    """

    _attribute_map = {
        'configurations': {'key': 'configurations', 'type': '[SemanticConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword configurations: The semantic configurations for the index.
        :paramtype configurations: list[~azure.search.documents.indexes.models.SemanticConfiguration]
        """
        super(SemanticSettings, self).__init__(**kwargs)
        self.configurations = kwargs.get('configurations', None)


class SentimentSkill(SearchIndexerSkill):
    """Text analytics positive-negative sentiment analysis, scored as a floating point value in a range of zero to 1.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "da", "nl", "en", "fi", "fr", "de", "el", "it", "no", "pl", "pt-PT",
     "ru", "es", "sv", "tr".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.SentimentSkillLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
         Possible values include: "da", "nl", "en", "fi", "fr", "de", "el", "it", "no", "pl", "pt-PT",
         "ru", "es", "sv", "tr".
        :paramtype default_language_code: str or
         ~azure.search.documents.indexes.models.SentimentSkillLanguage
        """
        super(SentimentSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.SentimentSkill'  # type: str
        self.default_language_code = kwargs.get('default_language_code', None)


class SentimentSkillV3(SearchIndexerSkill):
    """Using the Text Analytics API, evaluates unstructured text and for each record, provides sentiment labels (such as "negative", "neutral" and "positive") based on the highest confidence score found by the service at a sentence and document-level.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
    :vartype default_language_code: str
    :ivar include_opinion_mining: If set to true, the skill output will include information from
     Text Analytics for opinion mining, namely targets (nouns or verbs) and their associated
     assessment (adjective) in the text. Default is false.
    :vartype include_opinion_mining: bool
    :ivar model_version: The version of the model to use when calling the Text Analytics service.
     It will default to the latest available when not specified. We recommend you do not specify
     this value unless absolutely necessary.
    :vartype model_version: str
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'include_opinion_mining': {'key': 'includeOpinionMining', 'type': 'bool'},
        'model_version': {'key': 'modelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
        :paramtype default_language_code: str
        :keyword include_opinion_mining: If set to true, the skill output will include information from
         Text Analytics for opinion mining, namely targets (nouns or verbs) and their associated
         assessment (adjective) in the text. Default is false.
        :paramtype include_opinion_mining: bool
        :keyword model_version: The version of the model to use when calling the Text Analytics
         service. It will default to the latest available when not specified. We recommend you do not
         specify this value unless absolutely necessary.
        :paramtype model_version: str
        """
        super(SentimentSkillV3, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.V3.SentimentSkill'  # type: str
        self.default_language_code = kwargs.get('default_language_code', None)
        self.include_opinion_mining = kwargs.get('include_opinion_mining', False)
        self.model_version = kwargs.get('model_version', None)


class ServiceCounters(msrest.serialization.Model):
    """Represents service-level resource counters and quotas.

    All required parameters must be populated in order to send to Azure.

    :ivar alias_counter: Total number of aliases.
    :vartype alias_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar document_counter: Required. Total number of documents across all indexes in the service.
    :vartype document_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar index_counter: Required. Total number of indexes.
    :vartype index_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar indexer_counter: Required. Total number of indexers.
    :vartype indexer_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar data_source_counter: Required. Total number of data sources.
    :vartype data_source_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar storage_size_counter: Required. Total size of used storage in bytes.
    :vartype storage_size_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar synonym_map_counter: Required. Total number of synonym maps.
    :vartype synonym_map_counter: ~azure.search.documents.indexes.models.ResourceCounter
    :ivar skillset_counter: Total number of skillsets.
    :vartype skillset_counter: ~azure.search.documents.indexes.models.ResourceCounter
    """

    _validation = {
        'document_counter': {'required': True},
        'index_counter': {'required': True},
        'indexer_counter': {'required': True},
        'data_source_counter': {'required': True},
        'storage_size_counter': {'required': True},
        'synonym_map_counter': {'required': True},
    }

    _attribute_map = {
        'alias_counter': {'key': 'aliasesCount', 'type': 'ResourceCounter'},
        'document_counter': {'key': 'documentCount', 'type': 'ResourceCounter'},
        'index_counter': {'key': 'indexesCount', 'type': 'ResourceCounter'},
        'indexer_counter': {'key': 'indexersCount', 'type': 'ResourceCounter'},
        'data_source_counter': {'key': 'dataSourcesCount', 'type': 'ResourceCounter'},
        'storage_size_counter': {'key': 'storageSize', 'type': 'ResourceCounter'},
        'synonym_map_counter': {'key': 'synonymMaps', 'type': 'ResourceCounter'},
        'skillset_counter': {'key': 'skillsetCount', 'type': 'ResourceCounter'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword alias_counter: Total number of aliases.
        :paramtype alias_counter: ~azure.search.documents.indexes.models.ResourceCounter
        :keyword document_counter: Required. Total number of documents across all indexes in the
         service.
        :paramtype document_counter: ~azure.search.documents.indexes.models.ResourceCounter
        :keyword index_counter: Required. Total number of indexes.
        :paramtype index_counter: ~azure.search.documents.indexes.models.ResourceCounter
        :keyword indexer_counter: Required. Total number of indexers.
        :paramtype indexer_counter: ~azure.search.documents.indexes.models.ResourceCounter
        :keyword data_source_counter: Required. Total number of data sources.
        :paramtype data_source_counter: ~azure.search.documents.indexes.models.ResourceCounter
        :keyword storage_size_counter: Required. Total size of used storage in bytes.
        :paramtype storage_size_counter: ~azure.search.documents.indexes.models.ResourceCounter
        :keyword synonym_map_counter: Required. Total number of synonym maps.
        :paramtype synonym_map_counter: ~azure.search.documents.indexes.models.ResourceCounter
        :keyword skillset_counter: Total number of skillsets.
        :paramtype skillset_counter: ~azure.search.documents.indexes.models.ResourceCounter
        """
        super(ServiceCounters, self).__init__(**kwargs)
        self.alias_counter = kwargs.get('alias_counter', None)
        self.document_counter = kwargs['document_counter']
        self.index_counter = kwargs['index_counter']
        self.indexer_counter = kwargs['indexer_counter']
        self.data_source_counter = kwargs['data_source_counter']
        self.storage_size_counter = kwargs['storage_size_counter']
        self.synonym_map_counter = kwargs['synonym_map_counter']
        self.skillset_counter = kwargs.get('skillset_counter', None)


class ServiceLimits(msrest.serialization.Model):
    """Represents various service level limits.

    :ivar max_fields_per_index: The maximum allowed fields per index.
    :vartype max_fields_per_index: int
    :ivar max_field_nesting_depth_per_index: The maximum depth which you can nest sub-fields in an
     index, including the top-level complex field. For example, a/b/c has a nesting depth of 3.
    :vartype max_field_nesting_depth_per_index: int
    :ivar max_complex_collection_fields_per_index: The maximum number of fields of type
     Collection(Edm.ComplexType) allowed in an index.
    :vartype max_complex_collection_fields_per_index: int
    :ivar max_complex_objects_in_collections_per_document: The maximum number of objects in complex
     collections allowed per document.
    :vartype max_complex_objects_in_collections_per_document: int
    """

    _attribute_map = {
        'max_fields_per_index': {'key': 'maxFieldsPerIndex', 'type': 'int'},
        'max_field_nesting_depth_per_index': {'key': 'maxFieldNestingDepthPerIndex', 'type': 'int'},
        'max_complex_collection_fields_per_index': {'key': 'maxComplexCollectionFieldsPerIndex', 'type': 'int'},
        'max_complex_objects_in_collections_per_document': {'key': 'maxComplexObjectsInCollectionsPerDocument', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword max_fields_per_index: The maximum allowed fields per index.
        :paramtype max_fields_per_index: int
        :keyword max_field_nesting_depth_per_index: The maximum depth which you can nest sub-fields in
         an index, including the top-level complex field. For example, a/b/c has a nesting depth of 3.
        :paramtype max_field_nesting_depth_per_index: int
        :keyword max_complex_collection_fields_per_index: The maximum number of fields of type
         Collection(Edm.ComplexType) allowed in an index.
        :paramtype max_complex_collection_fields_per_index: int
        :keyword max_complex_objects_in_collections_per_document: The maximum number of objects in
         complex collections allowed per document.
        :paramtype max_complex_objects_in_collections_per_document: int
        """
        super(ServiceLimits, self).__init__(**kwargs)
        self.max_fields_per_index = kwargs.get('max_fields_per_index', None)
        self.max_field_nesting_depth_per_index = kwargs.get('max_field_nesting_depth_per_index', None)
        self.max_complex_collection_fields_per_index = kwargs.get('max_complex_collection_fields_per_index', None)
        self.max_complex_objects_in_collections_per_document = kwargs.get('max_complex_objects_in_collections_per_document', None)


class ServiceStatistics(msrest.serialization.Model):
    """Response from a get service statistics request. If successful, it includes service level counters and limits.

    All required parameters must be populated in order to send to Azure.

    :ivar counters: Required. Service level resource counters.
    :vartype counters: ~azure.search.documents.indexes.models.ServiceCounters
    :ivar limits: Required. Service level general limits.
    :vartype limits: ~azure.search.documents.indexes.models.ServiceLimits
    """

    _validation = {
        'counters': {'required': True},
        'limits': {'required': True},
    }

    _attribute_map = {
        'counters': {'key': 'counters', 'type': 'ServiceCounters'},
        'limits': {'key': 'limits', 'type': 'ServiceLimits'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword counters: Required. Service level resource counters.
        :paramtype counters: ~azure.search.documents.indexes.models.ServiceCounters
        :keyword limits: Required. Service level general limits.
        :paramtype limits: ~azure.search.documents.indexes.models.ServiceLimits
        """
        super(ServiceStatistics, self).__init__(**kwargs)
        self.counters = kwargs['counters']
        self.limits = kwargs['limits']


class ShaperSkill(SearchIndexerSkill):
    """A skill for reshaping the outputs. It creates a complex type to support composite fields (also known as multipart fields).

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        """
        super(ShaperSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Util.ShaperSkill'  # type: str


class ShingleTokenFilter(TokenFilter):
    """Creates combinations of tokens as a single token. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar max_shingle_size: The maximum shingle size. Default and minimum value is 2.
    :vartype max_shingle_size: int
    :ivar min_shingle_size: The minimum shingle size. Default and minimum value is 2. Must be less
     than the value of maxShingleSize.
    :vartype min_shingle_size: int
    :ivar output_unigrams: A value indicating whether the output stream will contain the input
     tokens (unigrams) as well as shingles. Default is true.
    :vartype output_unigrams: bool
    :ivar output_unigrams_if_no_shingles: A value indicating whether to output unigrams for those
     times when no shingles are available. This property takes precedence when outputUnigrams is set
     to false. Default is false.
    :vartype output_unigrams_if_no_shingles: bool
    :ivar token_separator: The string to use when joining adjacent tokens to form a shingle.
     Default is a single space (" ").
    :vartype token_separator: str
    :ivar filter_token: The string to insert for each position at which there is no token. Default
     is an underscore ("_").
    :vartype filter_token: str
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_shingle_size': {'minimum': 2},
        'min_shingle_size': {'minimum': 2},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_shingle_size': {'key': 'maxShingleSize', 'type': 'int'},
        'min_shingle_size': {'key': 'minShingleSize', 'type': 'int'},
        'output_unigrams': {'key': 'outputUnigrams', 'type': 'bool'},
        'output_unigrams_if_no_shingles': {'key': 'outputUnigramsIfNoShingles', 'type': 'bool'},
        'token_separator': {'key': 'tokenSeparator', 'type': 'str'},
        'filter_token': {'key': 'filterToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_shingle_size: The maximum shingle size. Default and minimum value is 2.
        :paramtype max_shingle_size: int
        :keyword min_shingle_size: The minimum shingle size. Default and minimum value is 2. Must be
         less than the value of maxShingleSize.
        :paramtype min_shingle_size: int
        :keyword output_unigrams: A value indicating whether the output stream will contain the input
         tokens (unigrams) as well as shingles. Default is true.
        :paramtype output_unigrams: bool
        :keyword output_unigrams_if_no_shingles: A value indicating whether to output unigrams for
         those times when no shingles are available. This property takes precedence when outputUnigrams
         is set to false. Default is false.
        :paramtype output_unigrams_if_no_shingles: bool
        :keyword token_separator: The string to use when joining adjacent tokens to form a shingle.
         Default is a single space (" ").
        :paramtype token_separator: str
        :keyword filter_token: The string to insert for each position at which there is no token.
         Default is an underscore ("_").
        :paramtype filter_token: str
        """
        super(ShingleTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.ShingleTokenFilter'  # type: str
        self.max_shingle_size = kwargs.get('max_shingle_size', 2)
        self.min_shingle_size = kwargs.get('min_shingle_size', 2)
        self.output_unigrams = kwargs.get('output_unigrams', True)
        self.output_unigrams_if_no_shingles = kwargs.get('output_unigrams_if_no_shingles', False)
        self.token_separator = kwargs.get('token_separator', " ")
        self.filter_token = kwargs.get('filter_token', "_")


class SkillNames(msrest.serialization.Model):
    """SkillNames.

    :ivar skill_names: the names of skills to be reset.
    :vartype skill_names: list[str]
    """

    _attribute_map = {
        'skill_names': {'key': 'skillNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword skill_names: the names of skills to be reset.
        :paramtype skill_names: list[str]
        """
        super(SkillNames, self).__init__(**kwargs)
        self.skill_names = kwargs.get('skill_names', None)


class SnowballTokenFilter(TokenFilter):
    """A filter that stems words using a Snowball-generated stemmer. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar language: Required. The language to use. Possible values include: "armenian", "basque",
     "catalan", "danish", "dutch", "english", "finnish", "french", "german", "german2", "hungarian",
     "italian", "kp", "lovins", "norwegian", "porter", "portuguese", "romanian", "russian",
     "spanish", "swedish", "turkish".
    :vartype language: str or ~azure.search.documents.indexes.models.SnowballTokenFilterLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'language': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword language: Required. The language to use. Possible values include: "armenian",
         "basque", "catalan", "danish", "dutch", "english", "finnish", "french", "german", "german2",
         "hungarian", "italian", "kp", "lovins", "norwegian", "porter", "portuguese", "romanian",
         "russian", "spanish", "swedish", "turkish".
        :paramtype language: str or ~azure.search.documents.indexes.models.SnowballTokenFilterLanguage
        """
        super(SnowballTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SnowballTokenFilter'  # type: str
        self.language = kwargs['language']


class SoftDeleteColumnDeletionDetectionPolicy(DataDeletionDetectionPolicy):
    """Defines a data deletion detection policy that implements a soft-deletion strategy. It determines whether an item should be deleted based on the value of a designated 'soft delete' column.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the data deletion detection
     policy.Constant filled by server.
    :vartype odata_type: str
    :ivar soft_delete_column_name: The name of the column to use for soft-deletion detection.
    :vartype soft_delete_column_name: str
    :ivar soft_delete_marker_value: The marker value that identifies an item as deleted.
    :vartype soft_delete_marker_value: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'soft_delete_column_name': {'key': 'softDeleteColumnName', 'type': 'str'},
        'soft_delete_marker_value': {'key': 'softDeleteMarkerValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword soft_delete_column_name: The name of the column to use for soft-deletion detection.
        :paramtype soft_delete_column_name: str
        :keyword soft_delete_marker_value: The marker value that identifies an item as deleted.
        :paramtype soft_delete_marker_value: str
        """
        super(SoftDeleteColumnDeletionDetectionPolicy, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SoftDeleteColumnDeletionDetectionPolicy'  # type: str
        self.soft_delete_column_name = kwargs.get('soft_delete_column_name', None)
        self.soft_delete_marker_value = kwargs.get('soft_delete_marker_value', None)


class SplitSkill(SearchIndexerSkill):
    """A skill to split a string into chunks of text.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_language_code: A value indicating which language code to use. Default is en.
     Possible values include: "da", "de", "en", "es", "fi", "fr", "it", "ko", "pt".
    :vartype default_language_code: str or
     ~azure.search.documents.indexes.models.SplitSkillLanguage
    :ivar text_split_mode: A value indicating which split mode to perform. Possible values include:
     "pages", "sentences".
    :vartype text_split_mode: str or ~azure.search.documents.indexes.models.TextSplitMode
    :ivar maximum_page_length: The desired maximum page length. Default is 10000.
    :vartype maximum_page_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_language_code': {'key': 'defaultLanguageCode', 'type': 'str'},
        'text_split_mode': {'key': 'textSplitMode', 'type': 'str'},
        'maximum_page_length': {'key': 'maximumPageLength', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_language_code: A value indicating which language code to use. Default is en.
         Possible values include: "da", "de", "en", "es", "fi", "fr", "it", "ko", "pt".
        :paramtype default_language_code: str or
         ~azure.search.documents.indexes.models.SplitSkillLanguage
        :keyword text_split_mode: A value indicating which split mode to perform. Possible values
         include: "pages", "sentences".
        :paramtype text_split_mode: str or ~azure.search.documents.indexes.models.TextSplitMode
        :keyword maximum_page_length: The desired maximum page length. Default is 10000.
        :paramtype maximum_page_length: int
        """
        super(SplitSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.SplitSkill'  # type: str
        self.default_language_code = kwargs.get('default_language_code', None)
        self.text_split_mode = kwargs.get('text_split_mode', None)
        self.maximum_page_length = kwargs.get('maximum_page_length', None)


class SqlIntegratedChangeTrackingPolicy(DataChangeDetectionPolicy):
    """Defines a data change detection policy that captures changes using the Integrated Change Tracking feature of Azure SQL Database.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the data change detection
     policy.Constant filled by server.
    :vartype odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SqlIntegratedChangeTrackingPolicy, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SqlIntegratedChangeTrackingPolicy'  # type: str


class StemmerOverrideTokenFilter(TokenFilter):
    """Provides the ability to override other stemming filters with custom dictionary-based stemming. Any dictionary-stemmed terms will be marked as keywords so that they will not be stemmed with stemmers down the chain. Must be placed before any stemming filters. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar rules: Required. A list of stemming rules in the following format: "word => stem", for
     example: "ran => run".
    :vartype rules: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'rules': {'key': 'rules', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword rules: Required. A list of stemming rules in the following format: "word => stem", for
         example: "ran => run".
        :paramtype rules: list[str]
        """
        super(StemmerOverrideTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StemmerOverrideTokenFilter'  # type: str
        self.rules = kwargs['rules']


class StemmerTokenFilter(TokenFilter):
    """Language specific stemming filter. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar language: Required. The language to use. Possible values include: "arabic", "armenian",
     "basque", "brazilian", "bulgarian", "catalan", "czech", "danish", "dutch", "dutchKp",
     "english", "lightEnglish", "minimalEnglish", "possessiveEnglish", "porter2", "lovins",
     "finnish", "lightFinnish", "french", "lightFrench", "minimalFrench", "galician",
     "minimalGalician", "german", "german2", "lightGerman", "minimalGerman", "greek", "hindi",
     "hungarian", "lightHungarian", "indonesian", "irish", "italian", "lightItalian", "sorani",
     "latvian", "norwegian", "lightNorwegian", "minimalNorwegian", "lightNynorsk", "minimalNynorsk",
     "portuguese", "lightPortuguese", "minimalPortuguese", "portugueseRslp", "romanian", "russian",
     "lightRussian", "spanish", "lightSpanish", "swedish", "lightSwedish", "turkish".
    :vartype language: str or ~azure.search.documents.indexes.models.StemmerTokenFilterLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'language': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'language': {'key': 'language', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword language: Required. The language to use. Possible values include: "arabic",
         "armenian", "basque", "brazilian", "bulgarian", "catalan", "czech", "danish", "dutch",
         "dutchKp", "english", "lightEnglish", "minimalEnglish", "possessiveEnglish", "porter2",
         "lovins", "finnish", "lightFinnish", "french", "lightFrench", "minimalFrench", "galician",
         "minimalGalician", "german", "german2", "lightGerman", "minimalGerman", "greek", "hindi",
         "hungarian", "lightHungarian", "indonesian", "irish", "italian", "lightItalian", "sorani",
         "latvian", "norwegian", "lightNorwegian", "minimalNorwegian", "lightNynorsk", "minimalNynorsk",
         "portuguese", "lightPortuguese", "minimalPortuguese", "portugueseRslp", "romanian", "russian",
         "lightRussian", "spanish", "lightSpanish", "swedish", "lightSwedish", "turkish".
        :paramtype language: str or ~azure.search.documents.indexes.models.StemmerTokenFilterLanguage
        """
        super(StemmerTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StemmerTokenFilter'  # type: str
        self.language = kwargs['language']


class StopAnalyzer(LexicalAnalyzer):
    """Divides text at non-letters; Applies the lowercase and stopword token filters. This analyzer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the analyzer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the analyzer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar stopwords: A list of stopwords.
    :vartype stopwords: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'stopwords': {'key': 'stopwords', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the analyzer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword stopwords: A list of stopwords.
        :paramtype stopwords: list[str]
        """
        super(StopAnalyzer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StopAnalyzer'  # type: str
        self.stopwords = kwargs.get('stopwords', None)


class StopwordsTokenFilter(TokenFilter):
    """Removes stop words from a token stream. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar stopwords: The list of stopwords. This property and the stopwords list property cannot
     both be set.
    :vartype stopwords: list[str]
    :ivar stopwords_list: A predefined list of stopwords to use. This property and the stopwords
     property cannot both be set. Default is English. Possible values include: "arabic", "armenian",
     "basque", "brazilian", "bulgarian", "catalan", "czech", "danish", "dutch", "english",
     "finnish", "french", "galician", "german", "greek", "hindi", "hungarian", "indonesian",
     "irish", "italian", "latvian", "norwegian", "persian", "portuguese", "romanian", "russian",
     "sorani", "spanish", "swedish", "thai", "turkish".
    :vartype stopwords_list: str or ~azure.search.documents.indexes.models.StopwordsList
    :ivar ignore_case: A value indicating whether to ignore case. If true, all words are converted
     to lower case first. Default is false.
    :vartype ignore_case: bool
    :ivar remove_trailing_stop_words: A value indicating whether to ignore the last search term if
     it's a stop word. Default is true.
    :vartype remove_trailing_stop_words: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'stopwords': {'key': 'stopwords', 'type': '[str]'},
        'stopwords_list': {'key': 'stopwordsList', 'type': 'str'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
        'remove_trailing_stop_words': {'key': 'removeTrailing', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword stopwords: The list of stopwords. This property and the stopwords list property cannot
         both be set.
        :paramtype stopwords: list[str]
        :keyword stopwords_list: A predefined list of stopwords to use. This property and the stopwords
         property cannot both be set. Default is English. Possible values include: "arabic", "armenian",
         "basque", "brazilian", "bulgarian", "catalan", "czech", "danish", "dutch", "english",
         "finnish", "french", "galician", "german", "greek", "hindi", "hungarian", "indonesian",
         "irish", "italian", "latvian", "norwegian", "persian", "portuguese", "romanian", "russian",
         "sorani", "spanish", "swedish", "thai", "turkish".
        :paramtype stopwords_list: str or ~azure.search.documents.indexes.models.StopwordsList
        :keyword ignore_case: A value indicating whether to ignore case. If true, all words are
         converted to lower case first. Default is false.
        :paramtype ignore_case: bool
        :keyword remove_trailing_stop_words: A value indicating whether to ignore the last search term
         if it's a stop word. Default is true.
        :paramtype remove_trailing_stop_words: bool
        """
        super(StopwordsTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.StopwordsTokenFilter'  # type: str
        self.stopwords = kwargs.get('stopwords', None)
        self.stopwords_list = kwargs.get('stopwords_list', None)
        self.ignore_case = kwargs.get('ignore_case', False)
        self.remove_trailing_stop_words = kwargs.get('remove_trailing_stop_words', True)


class Suggester(msrest.serialization.Model):
    """Defines how the Suggest API should apply to a group of fields in the index.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the suggester.
    :vartype name: str
    :ivar search_mode: A value indicating the capabilities of the suggester. Has constant value:
     "analyzingInfixMatching".
    :vartype search_mode: str
    :ivar source_fields: Required. The list of field names to which the suggester applies. Each
     field must be searchable.
    :vartype source_fields: list[str]
    """

    _validation = {
        'name': {'required': True},
        'search_mode': {'required': True, 'constant': True},
        'source_fields': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'search_mode': {'key': 'searchMode', 'type': 'str'},
        'source_fields': {'key': 'sourceFields', 'type': '[str]'},
    }

    search_mode = "analyzingInfixMatching"

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the suggester.
        :paramtype name: str
        :keyword source_fields: Required. The list of field names to which the suggester applies. Each
         field must be searchable.
        :paramtype source_fields: list[str]
        """
        super(Suggester, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.source_fields = kwargs['source_fields']


class SynonymMap(msrest.serialization.Model):
    """Represents a synonym map definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the synonym map.
    :vartype name: str
    :ivar format: The format of the synonym map. Only the 'solr' format is currently supported. Has
     constant value: "solr".
    :vartype format: str
    :ivar synonyms: Required. A series of synonym rules in the specified synonym map format. The
     rules must be separated by newlines.
    :vartype synonyms: str
    :ivar encryption_key: A description of an encryption key that you create in Azure Key Vault.
     This key is used to provide an additional level of encryption-at-rest for your data when you
     want full assurance that no one, not even Microsoft, can decrypt your data in Azure Cognitive
     Search. Once you have encrypted your data, it will always remain encrypted. Azure Cognitive
     Search will ignore attempts to set this property to null. You can change this property as
     needed if you want to rotate your encryption key; Your data will be unaffected. Encryption with
     customer-managed keys is not available for free search services, and is only available for paid
     services created on or after January 1, 2019.
    :vartype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
    :ivar e_tag: The ETag of the synonym map.
    :vartype e_tag: str
    """

    _validation = {
        'name': {'required': True},
        'format': {'required': True, 'constant': True},
        'synonyms': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'format': {'key': 'format', 'type': 'str'},
        'synonyms': {'key': 'synonyms', 'type': 'str'},
        'encryption_key': {'key': 'encryptionKey', 'type': 'SearchResourceEncryptionKey'},
        'e_tag': {'key': '@odata\\.etag', 'type': 'str'},
    }

    format = "solr"

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the synonym map.
        :paramtype name: str
        :keyword synonyms: Required. A series of synonym rules in the specified synonym map format. The
         rules must be separated by newlines.
        :paramtype synonyms: str
        :keyword encryption_key: A description of an encryption key that you create in Azure Key Vault.
         This key is used to provide an additional level of encryption-at-rest for your data when you
         want full assurance that no one, not even Microsoft, can decrypt your data in Azure Cognitive
         Search. Once you have encrypted your data, it will always remain encrypted. Azure Cognitive
         Search will ignore attempts to set this property to null. You can change this property as
         needed if you want to rotate your encryption key; Your data will be unaffected. Encryption with
         customer-managed keys is not available for free search services, and is only available for paid
         services created on or after January 1, 2019.
        :paramtype encryption_key: ~azure.search.documents.indexes.models.SearchResourceEncryptionKey
        :keyword e_tag: The ETag of the synonym map.
        :paramtype e_tag: str
        """
        super(SynonymMap, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.synonyms = kwargs['synonyms']
        self.encryption_key = kwargs.get('encryption_key', None)
        self.e_tag = kwargs.get('e_tag', None)


class SynonymTokenFilter(TokenFilter):
    """Matches single or multi-word synonyms in a token stream. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar synonyms: Required. A list of synonyms in following one of two formats: 1. incredible,
     unbelievable, fabulous => amazing - all terms on the left side of => symbol will be replaced
     with all terms on its right side; 2. incredible, unbelievable, fabulous, amazing - comma
     separated list of equivalent words. Set the expand option to change how this list is
     interpreted.
    :vartype synonyms: list[str]
    :ivar ignore_case: A value indicating whether to case-fold input for matching. Default is
     false.
    :vartype ignore_case: bool
    :ivar expand: A value indicating whether all words in the list of synonyms (if => notation is
     not used) will map to one another. If true, all words in the list of synonyms (if => notation
     is not used) will map to one another. The following list: incredible, unbelievable, fabulous,
     amazing is equivalent to: incredible, unbelievable, fabulous, amazing => incredible,
     unbelievable, fabulous, amazing. If false, the following list: incredible, unbelievable,
     fabulous, amazing will be equivalent to: incredible, unbelievable, fabulous, amazing =>
     incredible. Default is true.
    :vartype expand: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'synonyms': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'synonyms': {'key': 'synonyms', 'type': '[str]'},
        'ignore_case': {'key': 'ignoreCase', 'type': 'bool'},
        'expand': {'key': 'expand', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword synonyms: Required. A list of synonyms in following one of two formats: 1. incredible,
         unbelievable, fabulous => amazing - all terms on the left side of => symbol will be replaced
         with all terms on its right side; 2. incredible, unbelievable, fabulous, amazing - comma
         separated list of equivalent words. Set the expand option to change how this list is
         interpreted.
        :paramtype synonyms: list[str]
        :keyword ignore_case: A value indicating whether to case-fold input for matching. Default is
         false.
        :paramtype ignore_case: bool
        :keyword expand: A value indicating whether all words in the list of synonyms (if => notation
         is not used) will map to one another. If true, all words in the list of synonyms (if =>
         notation is not used) will map to one another. The following list: incredible, unbelievable,
         fabulous, amazing is equivalent to: incredible, unbelievable, fabulous, amazing => incredible,
         unbelievable, fabulous, amazing. If false, the following list: incredible, unbelievable,
         fabulous, amazing will be equivalent to: incredible, unbelievable, fabulous, amazing =>
         incredible. Default is true.
        :paramtype expand: bool
        """
        super(SynonymTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.SynonymTokenFilter'  # type: str
        self.synonyms = kwargs['synonyms']
        self.ignore_case = kwargs.get('ignore_case', False)
        self.expand = kwargs.get('expand', True)


class TagScoringFunction(ScoringFunction):
    """Defines a function that boosts scores of documents with string values matching a given list of tags.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Indicates the type of function to use. Valid values include magnitude,
     freshness, distance, and tag. The function type must be lower case.Constant filled by server.
    :vartype type: str
    :ivar field_name: Required. The name of the field used as input to the scoring function.
    :vartype field_name: str
    :ivar boost: Required. A multiplier for the raw score. Must be a positive number not equal to
     1.0.
    :vartype boost: float
    :ivar interpolation: A value indicating how boosting will be interpolated across document
     scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
     "logarithmic".
    :vartype interpolation: str or
     ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
    :ivar parameters: Required. Parameter values for the tag scoring function.
    :vartype parameters: ~azure.search.documents.indexes.models.TagScoringParameters
    """

    _validation = {
        'type': {'required': True},
        'field_name': {'required': True},
        'boost': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'field_name': {'key': 'fieldName', 'type': 'str'},
        'boost': {'key': 'boost', 'type': 'float'},
        'interpolation': {'key': 'interpolation', 'type': 'str'},
        'parameters': {'key': 'tag', 'type': 'TagScoringParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword field_name: Required. The name of the field used as input to the scoring function.
        :paramtype field_name: str
        :keyword boost: Required. A multiplier for the raw score. Must be a positive number not equal
         to 1.0.
        :paramtype boost: float
        :keyword interpolation: A value indicating how boosting will be interpolated across document
         scores; defaults to "Linear". Possible values include: "linear", "constant", "quadratic",
         "logarithmic".
        :paramtype interpolation: str or
         ~azure.search.documents.indexes.models.ScoringFunctionInterpolation
        :keyword parameters: Required. Parameter values for the tag scoring function.
        :paramtype parameters: ~azure.search.documents.indexes.models.TagScoringParameters
        """
        super(TagScoringFunction, self).__init__(**kwargs)
        self.type = 'tag'  # type: str
        self.parameters = kwargs['parameters']


class TagScoringParameters(msrest.serialization.Model):
    """Provides parameter values to a tag scoring function.

    All required parameters must be populated in order to send to Azure.

    :ivar tags_parameter: Required. The name of the parameter passed in search queries to specify
     the list of tags to compare against the target field.
    :vartype tags_parameter: str
    """

    _validation = {
        'tags_parameter': {'required': True},
    }

    _attribute_map = {
        'tags_parameter': {'key': 'tagsParameter', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword tags_parameter: Required. The name of the parameter passed in search queries to
         specify the list of tags to compare against the target field.
        :paramtype tags_parameter: str
        """
        super(TagScoringParameters, self).__init__(**kwargs)
        self.tags_parameter = kwargs['tags_parameter']


class TextTranslationSkill(SearchIndexerSkill):
    """A skill to translate text from one language to another.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar default_to_language_code: Required. The language code to translate documents into for
     documents that don't specify the to language explicitly. Possible values include: "af", "ar",
     "bn", "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et", "fj",
     "fil", "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja", "sw",
     "tlh", "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl", "pt",
     "pt-br", "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv", "ty",
     "ta", "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml", "pa".
    :vartype default_to_language_code: str or
     ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
    :ivar default_from_language_code: The language code to translate documents from for documents
     that don't specify the from language explicitly. Possible values include: "af", "ar", "bn",
     "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et", "fj", "fil",
     "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja", "sw", "tlh",
     "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl", "pt", "pt-br",
     "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv", "ty", "ta",
     "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml", "pa".
    :vartype default_from_language_code: str or
     ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
    :ivar suggested_from: The language code to translate documents from when neither the
     fromLanguageCode input nor the defaultFromLanguageCode parameter are provided, and the
     automatic language detection is unsuccessful. Default is en. Possible values include: "af",
     "ar", "bn", "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et",
     "fj", "fil", "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja",
     "sw", "tlh", "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl",
     "pt", "pt-br", "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv",
     "ty", "ta", "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml",
     "pa".
    :vartype suggested_from: str or
     ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'default_to_language_code': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'default_to_language_code': {'key': 'defaultToLanguageCode', 'type': 'str'},
        'default_from_language_code': {'key': 'defaultFromLanguageCode', 'type': 'str'},
        'suggested_from': {'key': 'suggestedFrom', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword default_to_language_code: Required. The language code to translate documents into for
         documents that don't specify the to language explicitly. Possible values include: "af", "ar",
         "bn", "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et", "fj",
         "fil", "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja", "sw",
         "tlh", "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl", "pt",
         "pt-br", "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv", "ty",
         "ta", "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml", "pa".
        :paramtype default_to_language_code: str or
         ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
        :keyword default_from_language_code: The language code to translate documents from for
         documents that don't specify the from language explicitly. Possible values include: "af", "ar",
         "bn", "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et", "fj",
         "fil", "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja", "sw",
         "tlh", "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl", "pt",
         "pt-br", "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv", "ty",
         "ta", "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml", "pa".
        :paramtype default_from_language_code: str or
         ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
        :keyword suggested_from: The language code to translate documents from when neither the
         fromLanguageCode input nor the defaultFromLanguageCode parameter are provided, and the
         automatic language detection is unsuccessful. Default is en. Possible values include: "af",
         "ar", "bn", "bs", "bg", "yue", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en", "et",
         "fj", "fil", "fi", "fr", "de", "el", "ht", "he", "hi", "mww", "hu", "is", "id", "it", "ja",
         "sw", "tlh", "tlh-Latn", "tlh-Piqd", "ko", "lv", "lt", "mg", "ms", "mt", "nb", "fa", "pl",
         "pt", "pt-br", "pt-PT", "otq", "ro", "ru", "sm", "sr-Cyrl", "sr-Latn", "sk", "sl", "es", "sv",
         "ty", "ta", "te", "th", "to", "tr", "uk", "ur", "vi", "cy", "yua", "ga", "kn", "mi", "ml",
         "pa".
        :paramtype suggested_from: str or
         ~azure.search.documents.indexes.models.TextTranslationSkillLanguage
        """
        super(TextTranslationSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Text.TranslationSkill'  # type: str
        self.default_to_language_code = kwargs['default_to_language_code']
        self.default_from_language_code = kwargs.get('default_from_language_code', None)
        self.suggested_from = kwargs.get('suggested_from', None)


class TextWeights(msrest.serialization.Model):
    """Defines weights on index fields for which matches should boost scoring in search queries.

    All required parameters must be populated in order to send to Azure.

    :ivar weights: Required. The dictionary of per-field weights to boost document scoring. The
     keys are field names and the values are the weights for each field.
    :vartype weights: dict[str, float]
    """

    _validation = {
        'weights': {'required': True},
    }

    _attribute_map = {
        'weights': {'key': 'weights', 'type': '{float}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword weights: Required. The dictionary of per-field weights to boost document scoring. The
         keys are field names and the values are the weights for each field.
        :paramtype weights: dict[str, float]
        """
        super(TextWeights, self).__init__(**kwargs)
        self.weights = kwargs['weights']


class TruncateTokenFilter(TokenFilter):
    """Truncates the terms to a specific length. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar length: The length at which terms will be truncated. Default and maximum is 300.
    :vartype length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'length': {'key': 'length', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword length: The length at which terms will be truncated. Default and maximum is 300.
        :paramtype length: int
        """
        super(TruncateTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.TruncateTokenFilter'  # type: str
        self.length = kwargs.get('length', 300)


class UaxUrlEmailTokenizer(LexicalTokenizer):
    """Tokenizes urls and emails as one token. This tokenizer is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the tokenizer.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the tokenizer. It must only contain letters, digits, spaces,
     dashes or underscores, can only start and end with alphanumeric characters, and is limited to
     128 characters.
    :vartype name: str
    :ivar max_token_length: The maximum token length. Default is 255. Tokens longer than the
     maximum length are split. The maximum token length that can be used is 300 characters.
    :vartype max_token_length: int
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
        'max_token_length': {'maximum': 300},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'max_token_length': {'key': 'maxTokenLength', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the tokenizer. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword max_token_length: The maximum token length. Default is 255. Tokens longer than the
         maximum length are split. The maximum token length that can be used is 300 characters.
        :paramtype max_token_length: int
        """
        super(UaxUrlEmailTokenizer, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.UaxUrlEmailTokenizer'  # type: str
        self.max_token_length = kwargs.get('max_token_length', 255)


class UniqueTokenFilter(TokenFilter):
    """Filters out tokens with same text as the previous token. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar only_on_same_position: A value indicating whether to remove duplicates only at the same
     position. Default is false.
    :vartype only_on_same_position: bool
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'only_on_same_position': {'key': 'onlyOnSamePosition', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword only_on_same_position: A value indicating whether to remove duplicates only at the
         same position. Default is false.
        :paramtype only_on_same_position: bool
        """
        super(UniqueTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.UniqueTokenFilter'  # type: str
        self.only_on_same_position = kwargs.get('only_on_same_position', False)


class WebApiSkill(SearchIndexerSkill):
    """A skill that can call a Web API endpoint, allowing you to extend a skillset by having it call your custom code.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the skill.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: The name of the skill which uniquely identifies it within the skillset. A skill
     with no name defined will be given a default name of its 1-based index in the skills array,
     prefixed with the character '#'.
    :vartype name: str
    :ivar description: The description of the skill which describes the inputs, outputs, and usage
     of the skill.
    :vartype description: str
    :ivar context: Represents the level at which operations take place, such as the document root
     or document content (for example, /document or /document/content). The default is /document.
    :vartype context: str
    :ivar inputs: Required. Inputs of the skills could be a column in the source data set, or the
     output of an upstream skill.
    :vartype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
    :ivar outputs: Required. The output of a skill is either a field in a search index, or a value
     that can be consumed as an input by another skill.
    :vartype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
    :ivar uri: Required. The url for the Web API.
    :vartype uri: str
    :ivar http_headers: The headers required to make the http request.
    :vartype http_headers: dict[str, str]
    :ivar http_method: The method for the http request.
    :vartype http_method: str
    :ivar timeout: The desired timeout for the request. Default is 30 seconds.
    :vartype timeout: ~datetime.timedelta
    :ivar batch_size: The desired batch size which indicates number of documents.
    :vartype batch_size: int
    :ivar degree_of_parallelism: If set, the number of parallel calls that can be made to the Web
     API.
    :vartype degree_of_parallelism: int
    """

    _validation = {
        'odata_type': {'required': True},
        'inputs': {'required': True},
        'outputs': {'required': True},
        'uri': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'context': {'key': 'context', 'type': 'str'},
        'inputs': {'key': 'inputs', 'type': '[InputFieldMappingEntry]'},
        'outputs': {'key': 'outputs', 'type': '[OutputFieldMappingEntry]'},
        'uri': {'key': 'uri', 'type': 'str'},
        'http_headers': {'key': 'httpHeaders', 'type': '{str}'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
        'batch_size': {'key': 'batchSize', 'type': 'int'},
        'degree_of_parallelism': {'key': 'degreeOfParallelism', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: The name of the skill which uniquely identifies it within the skillset. A skill
         with no name defined will be given a default name of its 1-based index in the skills array,
         prefixed with the character '#'.
        :paramtype name: str
        :keyword description: The description of the skill which describes the inputs, outputs, and
         usage of the skill.
        :paramtype description: str
        :keyword context: Represents the level at which operations take place, such as the document
         root or document content (for example, /document or /document/content). The default is
         /document.
        :paramtype context: str
        :keyword inputs: Required. Inputs of the skills could be a column in the source data set, or
         the output of an upstream skill.
        :paramtype inputs: list[~azure.search.documents.indexes.models.InputFieldMappingEntry]
        :keyword outputs: Required. The output of a skill is either a field in a search index, or a
         value that can be consumed as an input by another skill.
        :paramtype outputs: list[~azure.search.documents.indexes.models.OutputFieldMappingEntry]
        :keyword uri: Required. The url for the Web API.
        :paramtype uri: str
        :keyword http_headers: The headers required to make the http request.
        :paramtype http_headers: dict[str, str]
        :keyword http_method: The method for the http request.
        :paramtype http_method: str
        :keyword timeout: The desired timeout for the request. Default is 30 seconds.
        :paramtype timeout: ~datetime.timedelta
        :keyword batch_size: The desired batch size which indicates number of documents.
        :paramtype batch_size: int
        :keyword degree_of_parallelism: If set, the number of parallel calls that can be made to the
         Web API.
        :paramtype degree_of_parallelism: int
        """
        super(WebApiSkill, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Skills.Custom.WebApiSkill'  # type: str
        self.uri = kwargs['uri']
        self.http_headers = kwargs.get('http_headers', None)
        self.http_method = kwargs.get('http_method', None)
        self.timeout = kwargs.get('timeout', None)
        self.batch_size = kwargs.get('batch_size', None)
        self.degree_of_parallelism = kwargs.get('degree_of_parallelism', None)


class WordDelimiterTokenFilter(TokenFilter):
    """Splits words into subwords and performs optional transformations on subword groups. This token filter is implemented using Apache Lucene.

    All required parameters must be populated in order to send to Azure.

    :ivar odata_type: Required. Identifies the concrete type of the token filter.Constant filled by
     server.
    :vartype odata_type: str
    :ivar name: Required. The name of the token filter. It must only contain letters, digits,
     spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
     limited to 128 characters.
    :vartype name: str
    :ivar generate_word_parts: A value indicating whether to generate part words. If set, causes
     parts of words to be generated; for example "AzureSearch" becomes "Azure" "Search". Default is
     true.
    :vartype generate_word_parts: bool
    :ivar generate_number_parts: A value indicating whether to generate number subwords. Default is
     true.
    :vartype generate_number_parts: bool
    :ivar catenate_words: A value indicating whether maximum runs of word parts will be catenated.
     For example, if this is set to true, "Azure-Search" becomes "AzureSearch". Default is false.
    :vartype catenate_words: bool
    :ivar catenate_numbers: A value indicating whether maximum runs of number parts will be
     catenated. For example, if this is set to true, "1-2" becomes "12". Default is false.
    :vartype catenate_numbers: bool
    :ivar catenate_all: A value indicating whether all subword parts will be catenated. For
     example, if this is set to true, "Azure-Search-1" becomes "AzureSearch1". Default is false.
    :vartype catenate_all: bool
    :ivar split_on_case_change: A value indicating whether to split words on caseChange. For
     example, if this is set to true, "AzureSearch" becomes "Azure" "Search". Default is true.
    :vartype split_on_case_change: bool
    :ivar preserve_original: A value indicating whether original words will be preserved and added
     to the subword list. Default is false.
    :vartype preserve_original: bool
    :ivar split_on_numerics: A value indicating whether to split on numbers. For example, if this
     is set to true, "Azure1Search" becomes "Azure" "1" "Search". Default is true.
    :vartype split_on_numerics: bool
    :ivar stem_english_possessive: A value indicating whether to remove trailing "'s" for each
     subword. Default is true.
    :vartype stem_english_possessive: bool
    :ivar protected_words: A list of tokens to protect from being delimited.
    :vartype protected_words: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': '@odata\\.type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'generate_word_parts': {'key': 'generateWordParts', 'type': 'bool'},
        'generate_number_parts': {'key': 'generateNumberParts', 'type': 'bool'},
        'catenate_words': {'key': 'catenateWords', 'type': 'bool'},
        'catenate_numbers': {'key': 'catenateNumbers', 'type': 'bool'},
        'catenate_all': {'key': 'catenateAll', 'type': 'bool'},
        'split_on_case_change': {'key': 'splitOnCaseChange', 'type': 'bool'},
        'preserve_original': {'key': 'preserveOriginal', 'type': 'bool'},
        'split_on_numerics': {'key': 'splitOnNumerics', 'type': 'bool'},
        'stem_english_possessive': {'key': 'stemEnglishPossessive', 'type': 'bool'},
        'protected_words': {'key': 'protectedWords', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the token filter. It must only contain letters, digits,
         spaces, dashes or underscores, can only start and end with alphanumeric characters, and is
         limited to 128 characters.
        :paramtype name: str
        :keyword generate_word_parts: A value indicating whether to generate part words. If set, causes
         parts of words to be generated; for example "AzureSearch" becomes "Azure" "Search". Default is
         true.
        :paramtype generate_word_parts: bool
        :keyword generate_number_parts: A value indicating whether to generate number subwords. Default
         is true.
        :paramtype generate_number_parts: bool
        :keyword catenate_words: A value indicating whether maximum runs of word parts will be
         catenated. For example, if this is set to true, "Azure-Search" becomes "AzureSearch". Default
         is false.
        :paramtype catenate_words: bool
        :keyword catenate_numbers: A value indicating whether maximum runs of number parts will be
         catenated. For example, if this is set to true, "1-2" becomes "12". Default is false.
        :paramtype catenate_numbers: bool
        :keyword catenate_all: A value indicating whether all subword parts will be catenated. For
         example, if this is set to true, "Azure-Search-1" becomes "AzureSearch1". Default is false.
        :paramtype catenate_all: bool
        :keyword split_on_case_change: A value indicating whether to split words on caseChange. For
         example, if this is set to true, "AzureSearch" becomes "Azure" "Search". Default is true.
        :paramtype split_on_case_change: bool
        :keyword preserve_original: A value indicating whether original words will be preserved and
         added to the subword list. Default is false.
        :paramtype preserve_original: bool
        :keyword split_on_numerics: A value indicating whether to split on numbers. For example, if
         this is set to true, "Azure1Search" becomes "Azure" "1" "Search". Default is true.
        :paramtype split_on_numerics: bool
        :keyword stem_english_possessive: A value indicating whether to remove trailing "'s" for each
         subword. Default is true.
        :paramtype stem_english_possessive: bool
        :keyword protected_words: A list of tokens to protect from being delimited.
        :paramtype protected_words: list[str]
        """
        super(WordDelimiterTokenFilter, self).__init__(**kwargs)
        self.odata_type = '#Microsoft.Azure.Search.WordDelimiterTokenFilter'  # type: str
        self.generate_word_parts = kwargs.get('generate_word_parts', True)
        self.generate_number_parts = kwargs.get('generate_number_parts', True)
        self.catenate_words = kwargs.get('catenate_words', False)
        self.catenate_numbers = kwargs.get('catenate_numbers', False)
        self.catenate_all = kwargs.get('catenate_all', False)
        self.split_on_case_change = kwargs.get('split_on_case_change', True)
        self.preserve_original = kwargs.get('preserve_original', False)
        self.split_on_numerics = kwargs.get('split_on_numerics', True)
        self.stem_english_possessive = kwargs.get('stem_english_possessive', True)
        self.protected_words = kwargs.get('protected_words', None)
