# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ActionableRemediation(_serialization.Model):
    """ActionableRemediation.

    :ivar state: Known values are: "None", "Disabled", and "Enabled".
    :vartype state: str or ~azure.mgmt.securitydevops.models.ActionableRemediationState
    :ivar severity_levels:
    :vartype severity_levels: list[str]
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.securitydevops.models.RuleCategory]
    :ivar branch_configuration: Branch onboarding info.
    :vartype branch_configuration: ~azure.mgmt.securitydevops.models.TargetBranchConfiguration
    """

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "severity_levels": {"key": "severityLevels", "type": "[str]"},
        "categories": {"key": "categories", "type": "[str]"},
        "branch_configuration": {"key": "branchConfiguration", "type": "TargetBranchConfiguration"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.ActionableRemediationState"]] = None,
        severity_levels: Optional[List[str]] = None,
        categories: Optional[List[Union[str, "_models.RuleCategory"]]] = None,
        branch_configuration: Optional["_models.TargetBranchConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword state: Known values are: "None", "Disabled", and "Enabled".
        :paramtype state: str or ~azure.mgmt.securitydevops.models.ActionableRemediationState
        :keyword severity_levels:
        :paramtype severity_levels: list[str]
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.securitydevops.models.RuleCategory]
        :keyword branch_configuration: Branch onboarding info.
        :paramtype branch_configuration: ~azure.mgmt.securitydevops.models.TargetBranchConfiguration
        """
        super().__init__(**kwargs)
        self.state = state
        self.severity_levels = severity_levels
        self.categories = categories
        self.branch_configuration = branch_configuration


class AuthorizationInfo(_serialization.Model):
    """AuthorizationInfo.

    :ivar code: Gets or sets one-time OAuth code to exchange for refresh and access tokens.
    :vartype code: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, **kwargs):
        """
        :keyword code: Gets or sets one-time OAuth code to exchange for refresh and access tokens.
        :paramtype code: str
        """
        super().__init__(**kwargs)
        self.code = code


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AzureDevOpsConnector(TrackedResource):
    """AzureDevOpsConnector.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsConnectorProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "AzureDevOpsConnectorProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.AzureDevOpsConnectorProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties:
        :paramtype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsConnectorProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class AzureDevOpsConnectorListResponse(_serialization.Model):
    """AzureDevOpsConnectorListResponse.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsConnector]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsConnector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AzureDevOpsConnector"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsConnector]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsConnectorProperties(_serialization.Model):
    """AzureDevOpsConnectorProperties.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar authorization:
    :vartype authorization: ~azure.mgmt.securitydevops.models.AuthorizationInfo
    :ivar orgs: Gets or sets org onboarding information.
    :vartype orgs: list[~azure.mgmt.securitydevops.models.AzureDevOpsOrgMetadata]
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "authorization": {"key": "authorization", "type": "AuthorizationInfo"},
        "orgs": {"key": "orgs", "type": "[AzureDevOpsOrgMetadata]"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        authorization: Optional["_models.AuthorizationInfo"] = None,
        orgs: Optional[List["_models.AzureDevOpsOrgMetadata"]] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword authorization:
        :paramtype authorization: ~azure.mgmt.securitydevops.models.AuthorizationInfo
        :keyword orgs: Gets or sets org onboarding information.
        :paramtype orgs: list[~azure.mgmt.securitydevops.models.AzureDevOpsOrgMetadata]
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.authorization = authorization
        self.orgs = orgs


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class AzureDevOpsConnectorStats(ProxyResource):
    """AzureDevOpsConnectorStats.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsConnectorStatsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsConnectorStatsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AzureDevOpsConnectorStatsProperties"] = None, **kwargs):
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsConnectorStatsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AzureDevOpsConnectorStatsListResponse(_serialization.Model):
    """AzureDevOpsConnectorStatsListResponse.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsConnectorStats]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsConnectorStats]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AzureDevOpsConnectorStats"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsConnectorStats]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsConnectorStatsProperties(_serialization.Model):
    """AzureDevOpsConnectorStatsProperties.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar orgs_count: Gets or sets orgs count.
    :vartype orgs_count: int
    :ivar projects_count: Gets or sets projects count.
    :vartype projects_count: int
    :ivar repos_count: Gets or sets repos count.
    :vartype repos_count: int
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "orgs_count": {"key": "orgsCount", "type": "int"},
        "projects_count": {"key": "projectsCount", "type": "int"},
        "repos_count": {"key": "reposCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        orgs_count: Optional[int] = None,
        projects_count: Optional[int] = None,
        repos_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword orgs_count: Gets or sets orgs count.
        :paramtype orgs_count: int
        :keyword projects_count: Gets or sets projects count.
        :paramtype projects_count: int
        :keyword repos_count: Gets or sets repos count.
        :paramtype repos_count: int
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.orgs_count = orgs_count
        self.projects_count = projects_count
        self.repos_count = repos_count


class AzureDevOpsOrg(ProxyResource):
    """Azure DevOps Org Proxy Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar properties: AzureDevOps Org properties.
    :vartype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsOrgProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsOrgProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AzureDevOpsOrgProperties"] = None, **kwargs):
        """
        :keyword properties: AzureDevOps Org properties.
        :paramtype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsOrgProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AzureDevOpsOrgListResponse(_serialization.Model):
    """AzureDevOpsOrgListResponse.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsOrg]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsOrg]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AzureDevOpsOrg"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsOrg]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsOrgMetadata(_serialization.Model):
    """Org onboarding info.

    :ivar name: Gets or sets name of the AzureDevOps Org.
    :vartype name: str
    :ivar auto_discovery: Known values are: "Disabled" and "Enabled".
    :vartype auto_discovery: str or ~azure.mgmt.securitydevops.models.AutoDiscovery
    :ivar projects:
    :vartype projects: list[~azure.mgmt.securitydevops.models.AzureDevOpsProjectMetadata]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "projects": {"key": "projects", "type": "[AzureDevOpsProjectMetadata]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        projects: Optional[List["_models.AzureDevOpsProjectMetadata"]] = None,
        **kwargs
    ):
        """
        :keyword name: Gets or sets name of the AzureDevOps Org.
        :paramtype name: str
        :keyword auto_discovery: Known values are: "Disabled" and "Enabled".
        :paramtype auto_discovery: str or ~azure.mgmt.securitydevops.models.AutoDiscovery
        :keyword projects:
        :paramtype projects: list[~azure.mgmt.securitydevops.models.AzureDevOpsProjectMetadata]
        """
        super().__init__(**kwargs)
        self.name = name
        self.auto_discovery = auto_discovery
        self.projects = projects


class AzureDevOpsOrgProperties(_serialization.Model):
    """AzureDevOps Org properties.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar auto_discovery: Known values are: "Disabled" and "Enabled".
    :vartype auto_discovery: str or ~azure.mgmt.securitydevops.models.AutoDiscovery
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword auto_discovery: Known values are: "Disabled" and "Enabled".
        :paramtype auto_discovery: str or ~azure.mgmt.securitydevops.models.AutoDiscovery
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.auto_discovery = auto_discovery


class AzureDevOpsProject(ProxyResource):
    """Azure DevOps Project Proxy Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar properties: AzureDevOps Project properties.
    :vartype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsProjectProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsProjectProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AzureDevOpsProjectProperties"] = None, **kwargs):
        """
        :keyword properties: AzureDevOps Project properties.
        :paramtype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsProjectProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AzureDevOpsProjectListResponse(_serialization.Model):
    """AzureDevOpsProjectListResponse.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsProject]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsProject]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AzureDevOpsProject"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsProject]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsProjectMetadata(_serialization.Model):
    """Project onboarding info.

    :ivar name: Gets or sets name of the AzureDevOps Project.
    :vartype name: str
    :ivar auto_discovery: Known values are: "Disabled" and "Enabled".
    :vartype auto_discovery: str or ~azure.mgmt.securitydevops.models.AutoDiscovery
    :ivar repos: Gets or sets repositories.
    :vartype repos: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
        "repos": {"key": "repos", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        repos: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword name: Gets or sets name of the AzureDevOps Project.
        :paramtype name: str
        :keyword auto_discovery: Known values are: "Disabled" and "Enabled".
        :paramtype auto_discovery: str or ~azure.mgmt.securitydevops.models.AutoDiscovery
        :keyword repos: Gets or sets repositories.
        :paramtype repos: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.auto_discovery = auto_discovery
        self.repos = repos


class AzureDevOpsProjectProperties(_serialization.Model):
    """AzureDevOps Project properties.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar project_id: Gets or sets AzureDevOps Project Id.
    :vartype project_id: str
    :ivar org_name: Gets or sets AzureDevOps Org Name.
    :vartype org_name: str
    :ivar auto_discovery: Known values are: "Disabled" and "Enabled".
    :vartype auto_discovery: str or ~azure.mgmt.securitydevops.models.AutoDiscovery
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "project_id": {"key": "projectId", "type": "str"},
        "org_name": {"key": "orgName", "type": "str"},
        "auto_discovery": {"key": "autoDiscovery", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        project_id: Optional[str] = None,
        org_name: Optional[str] = None,
        auto_discovery: Optional[Union[str, "_models.AutoDiscovery"]] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword project_id: Gets or sets AzureDevOps Project Id.
        :paramtype project_id: str
        :keyword org_name: Gets or sets AzureDevOps Org Name.
        :paramtype org_name: str
        :keyword auto_discovery: Known values are: "Disabled" and "Enabled".
        :paramtype auto_discovery: str or ~azure.mgmt.securitydevops.models.AutoDiscovery
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.project_id = project_id
        self.org_name = org_name
        self.auto_discovery = auto_discovery


class AzureDevOpsRepo(ProxyResource):
    """Azure DevOps Repo Proxy Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar properties: AzureDevOps Repo properties.
    :vartype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsRepoProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "AzureDevOpsRepoProperties"},
    }

    def __init__(self, *, properties: Optional["_models.AzureDevOpsRepoProperties"] = None, **kwargs):
        """
        :keyword properties: AzureDevOps Repo properties.
        :paramtype properties: ~azure.mgmt.securitydevops.models.AzureDevOpsRepoProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class AzureDevOpsRepoListResponse(_serialization.Model):
    """AzureDevOpsRepoListResponse.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsRepo]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AzureDevOpsRepo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AzureDevOpsRepo"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.securitydevops.models.AzureDevOpsRepo]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureDevOpsRepoProperties(_serialization.Model):
    """AzureDevOps Repo properties.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar repo_id: Gets or sets Azure DevOps repo id.
    :vartype repo_id: str
    :ivar repo_url: Gets or sets AzureDevOps repo url.
    :vartype repo_url: str
    :ivar org_name: Gets or sets AzureDevOps Org Name.
    :vartype org_name: str
    :ivar project_name: Gets or sets AzureDevOps Project Name.
    :vartype project_name: str
    :ivar visibility: Gets or sets AzureDevOps repo visibility, whether it is public or private
     etc.
    :vartype visibility: str
    :ivar actionable_remediation:
    :vartype actionable_remediation: ~azure.mgmt.securitydevops.models.ActionableRemediation
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "repo_id": {"key": "repoId", "type": "str"},
        "repo_url": {"key": "repoUrl", "type": "str"},
        "org_name": {"key": "orgName", "type": "str"},
        "project_name": {"key": "projectName", "type": "str"},
        "visibility": {"key": "visibility", "type": "str"},
        "actionable_remediation": {"key": "actionableRemediation", "type": "ActionableRemediation"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        repo_id: Optional[str] = None,
        repo_url: Optional[str] = None,
        org_name: Optional[str] = None,
        project_name: Optional[str] = None,
        visibility: Optional[str] = None,
        actionable_remediation: Optional["_models.ActionableRemediation"] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword repo_id: Gets or sets Azure DevOps repo id.
        :paramtype repo_id: str
        :keyword repo_url: Gets or sets AzureDevOps repo url.
        :paramtype repo_url: str
        :keyword org_name: Gets or sets AzureDevOps Org Name.
        :paramtype org_name: str
        :keyword project_name: Gets or sets AzureDevOps Project Name.
        :paramtype project_name: str
        :keyword visibility: Gets or sets AzureDevOps repo visibility, whether it is public or private
         etc.
        :paramtype visibility: str
        :keyword actionable_remediation:
        :paramtype actionable_remediation: ~azure.mgmt.securitydevops.models.ActionableRemediation
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.repo_id = repo_id
        self.repo_url = repo_url
        self.org_name = org_name
        self.project_name = project_name
        self.visibility = visibility
        self.actionable_remediation = actionable_remediation


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.securitydevops.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.securitydevops.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.securitydevops.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.securitydevops.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class GitHubConnector(TrackedResource):
    """Represents an ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Properties of the ARM resource for
     /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
    :vartype properties: ~azure.mgmt.securitydevops.models.GitHubConnectorProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "GitHubConnectorProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.GitHubConnectorProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Properties of the ARM resource for
         /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.
        :paramtype properties: ~azure.mgmt.securitydevops.models.GitHubConnectorProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class GitHubConnectorListResponse(_serialization.Model):
    """GitHubConnectorListResponse.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.securitydevops.models.GitHubConnector]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitHubConnector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitHubConnector"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.securitydevops.models.GitHubConnector]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitHubConnectorProperties(_serialization.Model):
    """Properties of the ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar code: Gets or sets one-time OAuth code to exchange for refresh and access tokens.
    :vartype code: str
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "code": {"key": "code", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        code: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword code: Gets or sets one-time OAuth code to exchange for refresh and access tokens.
        :paramtype code: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.code = code


class GitHubConnectorStats(ProxyResource):
    """GitHubConnectorStats.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar properties:
    :vartype properties: ~azure.mgmt.securitydevops.models.GitHubConnectorStatsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitHubConnectorStatsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitHubConnectorStatsProperties"] = None, **kwargs):
        """
        :keyword properties:
        :paramtype properties: ~azure.mgmt.securitydevops.models.GitHubConnectorStatsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GitHubConnectorStatsListResponse(_serialization.Model):
    """GitHubConnectorStatsListResponse.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.securitydevops.models.GitHubConnectorStats]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitHubConnectorStats]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitHubConnectorStats"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.securitydevops.models.GitHubConnectorStats]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitHubConnectorStatsProperties(_serialization.Model):
    """GitHubConnectorStatsProperties.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar owners_count: Gets or sets owners count.
    :vartype owners_count: int
    :ivar repos_count: Gets or sets repos count.
    :vartype repos_count: int
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "owners_count": {"key": "ownersCount", "type": "int"},
        "repos_count": {"key": "reposCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        owners_count: Optional[int] = None,
        repos_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword owners_count: Gets or sets owners count.
        :paramtype owners_count: int
        :keyword repos_count: Gets or sets repos count.
        :paramtype repos_count: int
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.owners_count = owners_count
        self.repos_count = repos_count


class GitHubOwner(ProxyResource):
    """GitHub repo owner Proxy Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar properties: GitHub Repo Owner properties.
    :vartype properties: ~azure.mgmt.securitydevops.models.GitHubOwnerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitHubOwnerProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitHubOwnerProperties"] = None, **kwargs):
        """
        :keyword properties: GitHub Repo Owner properties.
        :paramtype properties: ~azure.mgmt.securitydevops.models.GitHubOwnerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GitHubOwnerListResponse(_serialization.Model):
    """GitHubOwnerListResponse.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.securitydevops.models.GitHubOwner]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitHubOwner]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitHubOwner"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.securitydevops.models.GitHubOwner]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitHubOwnerProperties(_serialization.Model):
    """GitHub Repo Owner properties.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar owner_url: Gets or sets gitHub owner url.
    :vartype owner_url: str
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "owner_url": {"key": "ownerUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        owner_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword owner_url: Gets or sets gitHub owner url.
        :paramtype owner_url: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.owner_url = owner_url


class GitHubRepo(ProxyResource):
    """GitHub repo Proxy Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.securitydevops.models.SystemData
    :ivar properties: GitHub Repo properties.
    :vartype properties: ~azure.mgmt.securitydevops.models.GitHubRepoProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "GitHubRepoProperties"},
    }

    def __init__(self, *, properties: Optional["_models.GitHubRepoProperties"] = None, **kwargs):
        """
        :keyword properties: GitHub Repo properties.
        :paramtype properties: ~azure.mgmt.securitydevops.models.GitHubRepoProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class GitHubRepoListResponse(_serialization.Model):
    """GitHubRepoListResponse.

    :ivar value: Gets or sets list of resources.
    :vartype value: list[~azure.mgmt.securitydevops.models.GitHubRepo]
    :ivar next_link: Gets or sets next link to scroll over the results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GitHubRepo]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.GitHubRepo"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets or sets list of resources.
        :paramtype value: list[~azure.mgmt.securitydevops.models.GitHubRepo]
        :keyword next_link: Gets or sets next link to scroll over the results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GitHubRepoProperties(_serialization.Model):
    """GitHub Repo properties.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar account_id: Gets or sets gitHub repo account id.
    :vartype account_id: int
    :ivar repo_url: Gets or sets gitHub repo url.
    :vartype repo_url: str
    :ivar owner_name: Gets or sets GitHub Owner Name.
    :vartype owner_name: str
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "account_id": {"key": "accountId", "type": "int"},
        "repo_url": {"key": "repoUrl", "type": "str"},
        "owner_name": {"key": "ownerName", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        account_id: Optional[int] = None,
        repo_url: Optional[str] = None,
        owner_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword account_id: Gets or sets gitHub repo account id.
        :paramtype account_id: int
        :keyword repo_url: Gets or sets gitHub repo url.
        :paramtype repo_url: str
        :keyword owner_name: Gets or sets GitHub Owner Name.
        :paramtype owner_name: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.account_id = account_id
        self.repo_url = repo_url
        self.owner_name = owner_name


class GitHubReposProperties(_serialization.Model):
    """GitHubReposProperties.

    :ivar provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
    :ivar account_id: Gets or sets gitHub repo account id.
    :vartype account_id: int
    :ivar repo_name: Gets or sets gitHub repo name.
    :vartype repo_name: str
    :ivar repo_url: Gets or sets gitHub repo url.
    :vartype repo_url: str
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "account_id": {"key": "accountId", "type": "int"},
        "repo_name": {"key": "repoName", "type": "str"},
        "repo_url": {"key": "repoUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        account_id: Optional[int] = None,
        repo_name: Optional[str] = None,
        repo_url: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provisioning_state: Known values are: "Succeeded", "Failed", and "Canceled".
        :paramtype provisioning_state: str or ~azure.mgmt.securitydevops.models.ProvisioningState
        :keyword account_id: Gets or sets gitHub repo account id.
        :paramtype account_id: int
        :keyword repo_name: Gets or sets gitHub repo name.
        :paramtype repo_name: str
        :keyword repo_url: Gets or sets gitHub repo url.
        :paramtype repo_url: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.account_id = account_id
        self.repo_name = repo_name
        self.repo_url = repo_url


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.securitydevops.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.securitydevops.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.securitydevops.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.securitydevops.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.securitydevops.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.securitydevops.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.securitydevops.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.securitydevops.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.securitydevops.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TargetBranchConfiguration(_serialization.Model):
    """Branch onboarding info.

    :ivar names: Gets or sets branches that should have annotations.

     For Ignite, we will be supporting a single default branch configuration in the UX.
    :vartype names: list[str]
    """

    _attribute_map = {
        "names": {"key": "names", "type": "[str]"},
    }

    def __init__(self, *, names: Optional[List[str]] = None, **kwargs):
        """
        :keyword names: Gets or sets branches that should have annotations.

         For Ignite, we will be supporting a single default branch configuration in the UX.
        :paramtype names: list[str]
        """
        super().__init__(**kwargs)
        self.names = names
