"""togl_setup.py

Compiles and installs Togl.

"""

# created 2000/08/01, Rene Liebscher <R.Liebscher@gmx.de>

import sys,os,string
from distutils.command.build_ext import build_ext
from distutils.dep_util import newer_group

# this is also a simple test if we need to build Togl
# without Tkinter it is not neccessary
import Tkinter
tk = Tkinter.Tk()

Togl = "Togl-1.5"
#Togl = "Togl-1.6"


# build togl
def togl_build(build_ext): # a simple function, not a class !!!
    import config

    # maybe we should use build as base, but we need an initialized
    # compiler object from build_ext
    # so let us get a instance of 'build' now
    build = build_ext.get_finalized_command ('build')

    extra_compile_args = [] # ["-Wall","-O"]
    extra_link_args = [] # ["-s"]
    # Name for the shared lib: (distutils will change it to Togl.{so|dll})
    output_name = "Togl"
    # where to put the built shared object (only for build process)
    output_dir = Togl + "-tk" + tk.getvar('tk_version')
    export_symbols = ["Togl_Init"]
    sources = [os.path.join("src",Togl,"togl.c")]

    if sys.platform == "win32":
        # VC++ 6.0 needs this, why togl doesn't use _WIN32?
        extra_compile_args.append("-DWIN32=1")

        tcl_lib = "tcl" + string.replace(tk.getvar('tcl_version'),".","")
        tk_lib = "tk" + string.replace(tk.getvar('tk_version'),".","")
        # we need the directory above tk_library
        tk_dir = os.path.normpath(os.path.join(tk.getvar('tk_library'),".."))
        
        include_dirs = [os.path.join("src",Togl)] + config.togl_include_dirs + \
                       [os.path.join(tk_dir,"..","include")]
        libraries = config.togl_libs + [tcl_lib,tk_lib]
        library_dirs = config.togl_lib_dirs + [tk_dir]
        runtime_library_dirs = None
    else:
        tcl_include_dir = os.path.join( tk.getvar('tcl_library'),
                                        "../../include" )
        tk_include_dir = os.path.join(tk.getvar('tk_library'),
                                        "../../include" )
        tcl_lib_dir = os.path.normpath(os.path.join(tk.getvar('tcl_library'),".."))
        tk_lib_dir = os.path.normpath(os.path.join(tk.getvar('tk_library'),".."))
        tcl_lib = "tcl" + tk.getvar('tcl_version')
        tk_lib = "tk" + tk.getvar('tk_version')

        # Where to find tcl.h, tk.h, OpenGL/Mesa headers, etc:
        include_dirs = [os.path.join("src",Togl),
                        tcl_include_dir, tk_include_dir] + \
                        config.togl_include_dirs
        # Libraries to link with:
        libraries = config.togl_libs + [tcl_lib,tk_lib]
        # Where to find libtcl.a, libtk.a, OpenGL/Mesa libraries:
        library_dirs = config.togl_lib_dirs + [tcl_lib_dir, tk_lib_dir]
        runtime_library_dirs = None

    # rest of this function was inspired by build_ext.py , build_extensions() 
    
    if build_ext.inplace:
        # ignore build-base -- put the compiled extension into
        # the source tree along with pure Python modules
        pass
    else:
        output_dir = os.path.join (build.build_base, output_dir)

    if os.environ.has_key('CFLAGS'):
        extra_compile_args.extend(string.split(os.environ['CFLAGS']))

    # what is the name of the resulting file
    output_filename = build_ext.compiler.shared_object_filename(
                    basename=output_name,
                    output_dir=output_dir)

    if not (build_ext.force or newer_group(sources, output_filename, 'newer')):
        build_ext.announce ("skipping '%s' (up-to-date)" % output_name)  
    else:
        build_ext.announce ("building '%s'" % output_name)

        # compile source files        
        objects = build_ext.compiler.compile (sources,
                            output_dir=build_ext.build_temp,
                            #macros=macros,
                            include_dirs=include_dirs,
                            debug=build_ext.debug,
                            extra_postargs=extra_compile_args)

        # link all together
        build_ext.compiler.link_shared_object (
                objects, 
                output_filename,
                '', # <= output_dir
                libraries=libraries,
                library_dirs=library_dirs,
                runtime_library_dirs=runtime_library_dirs,
                extra_postargs=extra_link_args,
                export_symbols=export_symbols, 
                debug=build_ext.debug,
                build_temp=build_ext.build_temp)

    # building togl shared library

# togl_build    


from distutils.util import change_root
# install togl
#
# It is possibly to do this all in the build step, but then
# it is not included in a RPM distribution.
#
def togl_install(install,dry_run=0): # a simple function, not a class !!!
        
    outfiles = [] # we have to return all files we have installed

    # get path to Tk directory
    togl_dir = os.path.normpath(os.path.join(install.install_lib,"OpenGL","Tk", \
                                sys.platform + "-tk" + tk.getvar('tk_version')))
    install.mkpath(togl_dir)       
    # how are the built files called, and 
    # which names should have the installed files
    if sys.platform == "win32":
        togl = "Togl.dll"
    else:
        togl = "Togl.so"
    togl_src = os.path.join(install.build_base,
                            Togl + "-tk" + tk.getvar('tk_version'), togl)
    togl_dst = os.path.join(togl_dir,togl)
    # copy togl in tk directory
    if not dry_run:
        from types import TupleType
        out = install.copy_file(togl_src, togl_dst)
        if type(out) is TupleType:
            out = out[0] 
    else:
        out = togl_dst
    outfiles.append(out)

    # make package index for tcl/tk
    if not dry_run: 
        # only if real install
        install.announce("running 'pkg_mkIndex %s %s'" % (togl_dir, togl))
        if install.verbose:
            tk.tk.call('pkg_mkIndex','-verbose',togl_dir, togl)
        else:
            tk.tk.call('pkg_mkIndex',togl_dir, togl)
    outfiles.append(os.path.join(togl_dir,'pkgIndex.tcl'))

    return outfiles
