# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class ExportTestCase(IntegrationTestCase):

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.preview.bulk_exports.exports(resource_type="resource_type").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://preview.twilio.com/BulkExports/Exports/resource_type',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "resource_type": "Calls",
                "url": "https://preview.twilio.com/BulkExports/Exports/Calls",
                "links": {
                    "days": "https://preview.twilio.com/BulkExports/Exports/Calls/Days"
                }
            }
            '''
        ))

        actual = self.client.preview.bulk_exports.exports(resource_type="resource_type").fetch()

        self.assertIsNotNone(actual)
