/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: edittransaction.cpp 344 2005-12-23 02:44:58Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "edittransaction.h"
#include "kbanking.h"
#include "refpointer.h"
#include "selectpayee.h"
#include "payee.h"
#include <qbanking/qbselectbank.h>

#include <qcombobox.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qregexp.h>
#include <qvalidator.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qtimer.h>
#include <qdatetime.h>
#include <qdatetimeedit.h>
#include <qpushbutton.h>

#include <list>
#include <string>

#include <gwenhywfar/debug.h>
#include <gwenhywfar/text.h>

#include <aqbanking/jobsingledebitnote.h>
#include <aqbanking/jobsingletransfer.h>
#include <aqbanking/jobcreatedatedtransfer.h>
#include <aqbanking/jobmodifydatedtransfer.h>


#ifdef WIN32
# define strcasecmp stricmp
#endif

EditTransaction::EditTransaction(KBanking *app,
                                 RefPointer<Transfer> t,
                                 bool isDated,
                                 bool isCreate,
                                 QWidget* parent,
                                 const char* name,
                                 bool modal,
                                 WFlags fl)
:EditTransactionUi(parent, name, modal, fl)
,_app(app)
,_transfer(t)
,_maxPurpose(1)
, _isDated(isDated)
, _isCreate(isCreate)
, _minDelay(0)
, _maxDelay(0) {
  int found;
  std::list<Account*>::const_iterator ait;
  int i;
  QString recipientName;
  QString s, cs;
  std::list<std::string>::const_iterator sit;
  std::list<RefPointer<Transfer> >::iterator xit;
  const AB_VALUE *v;
  //QRegExp valueRx("^[0-9]{1,12}.[0-9]{1,2}$");
  QRegExp bankCodeRx(QString("^[0-9]{1,8}$"));
  //QValidator *valueValidator=new QRegExpValidator(valueRx, this);
  QValidator *bankCodeValidator=new QRegExpValidator(bankCodeRx, this);
  GWEN_TYPE_UINT64 an;

  QLayout *lo=layout();
  if (lo) {
    QSize csi;
    QSize nsi;

    csi=size();
    nsi=lo->sizeHint();
    if (csi.width()>nsi.width())
      nsi.setWidth(csi.width());
    if (csi.height()>nsi.height())
      nsi.setWidth(csi.height());
    resize(nsi);
  }

  /* set validators */
  //valueEdit->setValidator(valueValidator);
  remoteBankCodeEdit->setValidator(bankCodeValidator);
  //localAccountCombo->lineEdit()->
  // setValidator(new QRegExpValidator(QRegExp("^[0-9,A-Z,a-z]{1,12}$"),this));
  // -- unfortunately setting this on the localAccountCombo crashes
  // the dialog, therefore it is commented out for now

  remoteNameEdit->setMaxLength(27);

  remoteAccountIdEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteAccountNumber().c_str()));
  remoteBankCodeEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteBankCode().c_str()));

  remoteBankNameEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteBankName().c_str()));
  remoteBankLocationEdit
    ->setText(QString::fromUtf8(t.ref().getRemoteBankLocation().c_str()));

  // set recipient name(s)
  for (sit=t.ref().getRemoteName().begin();
       sit!=t.ref().getRemoteName().end();
       sit++) {
    s=QString::fromUtf8(sit->c_str());
    if (!s.isEmpty()) {
      if (!recipientName.isEmpty())
        recipientName+=" ";
      recipientName+=s;
    }
  } // for
  remoteNameEdit->setText(recipientName);

  // setup account combo
  found=0;
  i=0;
  an=App::char2uint64(t.ref().getLocalAccountNumber().c_str());
  localAccountCombo->insertItem(_tr("Select Account"), -1);
  for (ait=app->getAppAccounts().begin();
       ait!=app->getAppAccounts().end();
       ait++) {
    GWEN_TYPE_UINT64 lan;

    i++;
    cs="";

    lan=App::char2uint64((*ait)->getAccountNumber().c_str());
    s=QString::fromUtf8((*ait)->getBankName().c_str());
    if (s.isEmpty())
      s=QString::fromUtf8((*ait)->getBankCode().c_str());
    cs+=s;
    cs+=" / ";
    s=QString::fromUtf8((*ait)->getAccountNumber().c_str());
    cs+=s;
    cs+=" (";
    cs+=QString::number((*ait)->getBankingId());
    cs+=")";

    _setComboTextNoDup(localAccountCombo, cs);
    if ((strcasecmp((*ait)->getBankCode().c_str(),
                    t.ref().getLocalBankCode().c_str())==0) &&
        (strcasecmp((*ait)->getAccountNumber().c_str(),
                    t.ref().getLocalAccountNumber().c_str())==0))
      found=i;
    else if (an && lan && an==lan &&
             (strcasecmp((*ait)->getBankCode().c_str(),
                         t.ref().getLocalBankCode().c_str())==0))
      found=i;
  } // for
  localAccountCombo->setCurrentItem(found);
  slotAccountChanged(found);

  // setup purpose
  cs="";
  for (sit=t.ref().getPurpose().begin();
       sit!=t.ref().getPurpose().end();
       sit++) {
    i++;
    s = QString::fromUtf8(sit->c_str());
    if (!s.isEmpty()) {
      if (!cs.isEmpty())
        cs+="\n";
      cs+=s;
    }
  } // for
  purposeEdit->setText(cs);

  // set value
  v=t.ref().getValue();
  if (v) {
    const char *st;

    valueEdit->setText(QString::number(AB_Value_GetValue(v), 'f', 2));
    st=AB_Value_GetCurrency(v);
    if (!st)
      st="EUR";
    _setComboTextNoDup(currencyCombo, QString::fromUtf8(st));
  }

  // set Text key
  _setComboTextIfPossible(textKeyCombo, QString::number(t.ref().getTextKey()));


  // connect buttons
  QObject::connect(bankCodeButton, SIGNAL(clicked()),
                   this, SLOT(slotBankCode()));
  QObject::connect(payeeButton, SIGNAL(clicked()),
                   this, SLOT(slotGetPayee()));
  QObject::connect(bankCodeButton, SIGNAL(clicked()),
                   this, SLOT(slotGetBankCode()));

  QObject::connect(localAccountCombo, SIGNAL(activated(int)),
                   this, SLOT(slotAccountChanged(int)));

  QTimer::singleShot(0, this, SLOT(adjustSize()));
}



EditTransaction::~EditTransaction(){
}



void EditTransaction::_setComboTextNoDup(QComboBox *qb, const QString &s){
  int i;

  for (i=0; i<qb->count(); i++) {
    if (qb->text(i)==s)
      return;
  }
  qb->insertItem(s, -1);
}



void EditTransaction::_setComboTextIfPossible(QComboBox *qb,
                                              const QString &s){
  int i;

  for (i=0; i<qb->count(); i++) {
    if (qb->text(i)==s) {
      qb->setCurrentItem(i);
      break;
    }
  }
}



void EditTransaction::accept(){
  int pos;
  QString qs;
  std::list<Account*>::const_iterator ait;
  int i;
  Account *a;
  AB_VALUE *value;
  QRegExp valueRx(QString("^[0-9]{1,12}.[0-9]{1,2}$"));
  QRegExpValidator qv(valueRx, this);
  GWEN_TIME *ti;

  pos=0;

  qs=valueEdit->text();
  if (qv.validate(qs, pos)!=
      QValidator::Acceptable) {
    QMessageBox::critical(this,
                          _tr("Bad Value"),
                          _tr("<qt>"
                             "<p>"
                             "The value needs to be in the following "
                             "format: "
                             "\"<b>XX,YY</b>\".<br>"
                             "<b>XX</b> are between 1 and 12 digits before "
                             "the comma, <b>YY</b> are 1 or 2 digits "
                             "after it"
                             "</p>"
                             "<p>"
                             "Examples:"
                             "<ul>"
                             "<li>123,45</li>"
                             "<li>0,12</li>"
                             "<li>123,00</li>"
                             "</ul>"
                             "</p>"
                             "<p>"
                             "Please correct the value."
                             "</p>"
                             "</qt>"
                            ),
                          _tr("Dismiss"), QString::null);
    return;
  }

  if (localAccountCombo->currentItem()==0) {
    QMessageBox::critical(this,
                          _tr("No Source Account"),
                          _tr("<qt>"
                             "<p>"
                             "Please select the source account."
                             "</p>"
                             "</qt>"
                            ),
                          _tr("Dismiss"), QString::null);
    return;
  }

  if (remoteNameEdit->text().isEmpty() ||
      remoteAccountIdEdit->text().isEmpty() ||
      remoteBankCodeEdit->text().isEmpty() ||
      purposeEdit->text().isEmpty()) {
    QMessageBox::critical(this,
                          _tr("Empty Fields"),
                          _tr("<qt>"
                             "<p>"
                             "Please fill out all fields."
                             "</p>"
                             "</qt>"
                            ),
                          _tr("Dismiss"), QString::null);
    return;
  }

  qs=textKeyCombo->currentText();
  if (!qs.isEmpty()) {
    bool isOk;

    i=qs.toInt(&isOk);
    if (!isOk) {
      QMessageBox::critical(this,
                            _tr("Bad Text Key"),
                            _tr("<qt>"
                               "<p>"
                               "The text key must be a positive integer."
                               "</p>"
                               "</qt>"
                              ),
                            _tr("Dismiss"), QString::null);
      return;
    }
  }


  qs=purposeEdit->text();
  DBG_NOTICE(0, "Got this string (%d lines):",
             purposeEdit->lines());
#ifndef WIN32
  // In MSVC this function crashes
  GWEN_Text_DumpString(qs.latin1(), qs.length(), stderr, 2);
#endif
  if (_maxPurpose!=-1) {
    int lines;

    lines=purposeEdit->lines();
    if (qs.endsWith("\n"))
      lines--;
    if (lines>_maxPurpose) {
      QString qs=QString(_tr("<qt>"
                            "<p>"
                            "Your purpose input exceeds the limit of "
                            "%1 lines."
                            "</p>"
                            "<p>"
                            "Please remove %2 lines."
                            "</p>"
                            "</qt>"
                           )
                         )
        .arg(_maxPurpose)
        .arg(lines-_maxPurpose);
      QMessageBox::critical(this,
                            _tr("Field Error"),
                            qs,
                            _tr("Dismiss"), QString::null);
      return;
    }
    if (lines<1) {
      QMessageBox::critical(this,
                            _tr("Field Error"),
                            _tr("Please enter the purpose."),
                            _tr("Dismiss"), QString::null);
      return;
    }
  }

  if (_isDated) {
    if (!execDateEdit->date().isValid()) {
      QMessageBox::critical(this,
			    _tr("Field Error"),
                            _tr("Please enter the execution date."),
                            _tr("Dismiss"), QString::null);
      return;
    }
    else {
      QDate currentDate=QDate::currentDate();
      QDate d=execDateEdit->date();
      int dt;

      dt=currentDate.daysTo(d);
      if (dt<0) {
	QMessageBox::critical(this,
			      _tr("Invalid Input"),
			      _tr("<qt>"
				  "<p>"
				  "Execution date is in the past."
				  "</p>"
				  "</qt>"
				 ),
			      _tr("Dismiss"), QString::null);
	return;
      }
      else if (dt<_minDelay) {
	QMessageBox::critical(this,
			      _tr("Invalid Input"),
			      _tr("<qt>"
				  "<p>"
				  "Start date is too near."
				  "</p>"
				  "</qt>"
				 ),
			      _tr("Dismiss"), QString::null);
	return;
      }
      if (_maxDelay) {
	if (dt>_maxDelay) {
	  QMessageBox::critical(this,
				_tr("Invalid Input"),
				_tr("<qt>"
				    "<p>"
				    "Start date is too far."
				    "</p>"
				    "</qt>"
				   ),
				_tr("Dismiss"), QString::null);
	  return;
	}
      }
    }
  }

  // all checks performed, now copy data back to transaction

  // find account
  i=localAccountCombo->currentItem();
  a=0;
  for (ait=_app->getAppAccounts().begin();
       ait!=_app->getAppAccounts().end();
       ait++) {
    if (!--i) {
      a=*ait;
      break;
    }
  } // for
  assert(a);

  _transfer.ref().setLocalCountry(a->getCountry());
  _transfer.ref().setRemoteCountry(a->getCountry());
  _transfer.ref().setLocalBankCode(a->getBankCode());
  _transfer.ref().setLocalAccountNumber(a->getAccountNumber());
  _transfer.ref().setLocalName(a->getOwnerName());

  _transfer.ref().setRemoteBankCode
    (KBanking::QStringToUtf8String(remoteBankCodeEdit->text()));

  _transfer.ref().setRemoteAccountNumber
    (KBanking::QStringToUtf8String(remoteAccountIdEdit->text()));

  _transfer.ref().setRemoteBankName
    (KBanking::QStringToUtf8String(remoteBankNameEdit->text()));
  _transfer.ref().setRemoteBankLocation
    (KBanking::QStringToUtf8String(remoteBankLocationEdit->text()));

  _transfer.ref().clearRemoteName();
  _transfer.ref().addRemoteName
    (KBanking::QStringToUtf8String(remoteNameEdit->text()));

  qs=textKeyCombo->currentText();
  if (!qs.isEmpty()) {
    bool isOk;

    i=qs.toInt(&isOk);
    if (isOk)
      _transfer.ref().setTextKey(i);
  }

  qs=valueEdit->text();
  qs+=":";
  qs+=currencyCombo->currentText();
  value=AB_Value_fromString(qs.latin1());
  _transfer.ref().setValue(value);
  AB_Value_free(value);

  // get purpose
  _transfer.ref().clearPurpose();
  qs=purposeEdit->text();
  if (!qs.isEmpty()) {
    QString currLine;
    unsigned int i;
    int lastBlank;

    lastBlank=-1;
    // In qt4 QString::length() will return a signed int
    for (i=0; i < unsigned(qs.length()); i++) {
      if (qs.at(i)=='\n') {
        // next line
        if (!currLine.isEmpty()) {
          _transfer.ref().addPurpose
            (KBanking::QStringToUtf8String(currLine.upper()));
        }
        currLine="";
        lastBlank=-1;
      }
      else {
        if (qs.at(i).isSpace())
          lastBlank=i;
        if (currLine.length()>=27) {
          // wrap word at word boundary
          if (lastBlank==-1)
            // force word wrap here if no preceeding blank
            lastBlank=i;
          _transfer.ref().addPurpose
            (KBanking::QStringToUtf8String(currLine.left(lastBlank).upper()));
          currLine=currLine.mid(lastBlank+1);
          if (!qs.at(i).isSpace())
	    currLine+=qs.at(i);
          lastBlank=-1;
        }
        else
          currLine+=qs.at(i);
      }
    } // for
    if (!currLine.isEmpty()) {
      _transfer.ref().addPurpose
        (KBanking::QStringToUtf8String(currLine.upper()));
    }
  }

  if (_isDated) {
    QDate qd;

    qd=execDateEdit->date();
    ti=GWEN_Time_new(qd.year(),
		     qd.month()-1,
		     qd.day(),
		     12, 00, 00, 1);
    _transfer.ref().setDate(ti);
    GWEN_Time_free(ti);
  }

  return QDialog::accept();
}



void EditTransaction::reject(){
  return QDialog::reject();
}



void EditTransaction::slotBankCode(){
  AB_BANKINFO *bi;

  bi=_app->selectBank(this,
                      tr("Select a Bank"),
                      QString("de"),
                      remoteBankCodeEdit->text());
  if (bi) {
    const char *s;

    DBG_ERROR(0, "Got a bankInfo");

    s=AB_BankInfo_GetBankId(bi);
    if (s)
      remoteBankCodeEdit->setText(QString::fromUtf8(s));
    s=AB_BankInfo_GetBankName(bi);
    if (s)
      remoteBankNameEdit->setText(QString::fromUtf8(s));
    s=AB_BankInfo_GetLocation(bi);
    if (s)
      remoteBankLocationEdit->setText(QString::fromUtf8(s));
    AB_BankInfo_free(bi);
    DBG_ERROR(0, "Got a bankInfo, done");
  }
}



void EditTransaction::slotAccountChanged(int i){
  std::list<Account*>::const_iterator ait;
  Account *a;
  QString qs;

  qs=textKeyCombo->currentText();
  fprintf(stderr, "Current textKey: %s\n", qs.latin1());
  textKeyCombo->clear();

  a=0;
  for (ait=_app->getAppAccounts().begin();
       ait!=_app->getAppAccounts().end();
       ait++) {
    if (!--i) {
      a=*ait;
      break;
    }
  } // for
  if (a) {
    AB_ACCOUNT *ba;

    ba=AB_Banking_GetAccount(_app->getCInterface(),
                             a->getBankingId());
    if (ba) {
      AB_JOB *j=0;
      const AB_TRANSACTION_LIMITS *lim=0;

      if (_isDated) {
        if (_isCreate) {
          j=AB_JobCreateDatedTransfer_new(ba);
          if (AB_Job_CheckAvailability(j)==0) {
            lim=AB_JobCreateDatedTransfer_GetFieldLimits(j);
          }
          else {
            DBG_ERROR(0, "Job not supported with this account");
            QMessageBox::critical(this,
                                  _tr("Job not Supported"),
                                  _tr("<qt>"
                                     "<p>"
                                     "This account does not support this job."
                                     "</p>"
                                     "</qt>"
                                    ),
                                  _tr("Dismiss"), QString::null);
          }
        }
        else {
          j=AB_JobModifyDatedTransfer_new(ba);
          if (AB_Job_CheckAvailability(j)==0) {
            lim=AB_JobModifyDatedTransfer_GetFieldLimits(j);
          }
          else {
            DBG_ERROR(0, "Job not supported with this account");
            QMessageBox::critical(this,
                                  _tr("Job not Supported"),
                                  _tr("<qt>"
                                     "<p>"
                                     "This account does not support this job."
                                     "</p>"
                                     "</qt>"
                                    ),
                                  _tr("Dismiss"), QString::null);
          }
        }
      }
      else {
        if (_transfer.ref().getTransferType()==Transfer::TransferType_DebitNote) {
          j=AB_JobSingleDebitNote_new(ba);
          if (AB_Job_CheckAvailability(j)==0) {
            lim=AB_JobSingleDebitNote_GetFieldLimits(j);
          }
          else {
            DBG_ERROR(0, "Job not supported with this account");
            QMessageBox::critical(this,
                                  _tr("Job not Supported"),
                                  _tr("<qt>"
                                     "<p>"
                                     "This account does not support this job."
                                     "</p>"
                                     "</qt>"
                                    ),
                                  _tr("Dismiss"), QString::null);
          }
        }
        else {
          j=AB_JobSingleTransfer_new(ba);
          if (AB_Job_CheckAvailability(j)==0) {
            lim=AB_JobSingleTransfer_GetFieldLimits(j);
          }
          else {
            DBG_ERROR(0, "Job not supported with this account");
            QMessageBox::critical(this,
                                  _tr("Job not Supported"),
                                  _tr("<qt>"
                                     "<p>"
                                     "This account does not support this job."
                                     "</p>"
                                     "</qt>"
                                    ),
                                  _tr("Dismiss"), QString::null);
          }
        }
      }

      _maxPurpose=1;
      if (lim) {
        GWEN_STRINGLISTENTRY *se;

        _maxPurpose=AB_TransactionLimits_GetMaxLinesPurpose(lim);
        if (_maxPurpose==-1)
	  _maxPurpose=1;

	_minDelay=AB_TransactionLimits_GetMinValueSetupTime(lim);
        _maxDelay=AB_TransactionLimits_GetMaxValueSetupTime(lim);

        // read text keys
        se=GWEN_StringList_FirstEntry(AB_TransactionLimits_GetValuesTextKey(lim));
        while(se) {
          const char *s;

          s=GWEN_StringListEntry_Data(se);
          assert(s);
          textKeyCombo->insertItem(QString::fromUtf8(s));
          se=GWEN_StringListEntry_Next(se);
        } // while
      }

      // select previously selected textkey
      if (!qs.isEmpty()) {
        _setComboTextIfPossible(textKeyCombo, qs);
      }
    } // if account
  } // if account
}



void EditTransaction::slotGetBankCode(){
}



void EditTransaction::slotGetPayee(){
  Payee *p;

  p=SelectPayee::selectPayee(_app,
                             _tr("Select Payee"),
                             _tr("Select the payee from the list below"),
                             this);
  if (p) {
    std::string s;

    s=p->accountNumber();
    if (!s.empty())
      remoteAccountIdEdit
        ->setText(QString::fromUtf8(s.c_str()));
    s=p->bankCode();
    if (!s.empty())
      remoteBankCodeEdit
        ->setText(QString::fromUtf8(s.c_str()));
    s=p->name();
    if (!s.empty())
      remoteNameEdit
        ->setText(QString::fromUtf8(s.c_str()));
  }
}



bool EditTransaction::editTransfer(KBanking *app,
                                   RefPointer<Transfer> t,
                                   const QString &title,
                                   QWidget* parent,
                                   bool modal,
                                   WFlags fl) {
  EditTransaction w(app, t, false, false, parent, 0, modal, fl);

  t.ref().setTransferType(Transfer::TransferType_Simple);
  if (t.ref().getTextKey()==0)
    t.ref().setTextKey(51);

  w.execDateBox->hide();

  if (!title.isEmpty())
    w.setCaption(title);
  w.titleLabel->setText(_tr("<qt>"
                           "<h3>Transfer</h3>"
                           "Transfer money from your account "
                           "to someone elses' (within your country)."
                           "</qt>"));
  w.grp_myaccount->setTitle(_tr("editTransfer|Payee"));
  w.grp_recipient->setTitle(_tr("editTransfer|Recipient"));
  return (w.exec()==QDialog::Accepted);
}



bool EditTransaction::editDebitNote(KBanking *app,
                                    RefPointer<Transfer> t,
                                    const QString &title,
                                    QWidget* parent,
                                    bool modal,
                                    WFlags fl) {
  EditTransaction w(app, t, false, false, parent, 0, modal, fl);

  t.ref().setTransferType(Transfer::TransferType_DebitNote);
  if (t.ref().getTextKey()==0)
    t.ref().setTextKey(5);

  w.execDateBox->hide();

  if (!title.isEmpty())
    w.setCaption(title);
  w.titleLabel->setText(_tr("<qt>"
			    "<h3>Debit Note</h3>"
			    "Draw money from someone elses' account "
			    "to yours (within your country)."
			    "</qt>"));
  w.grp_myaccount->setTitle(_tr("editDebitNote|Recipient Account"));
  w.grp_recipient->setTitle(_tr("editDebitNote|Payee"));
  return (w.exec()==QDialog::Accepted);
}



bool EditTransaction::createDatedTransfer(KBanking *app,
                                          RefPointer<Transfer> t,
                                          const QString &title,
                                          QWidget* parent,
                                          bool modal,
                                          WFlags fl) {
  EditTransaction w(app, t, true, true, parent, 0, modal, fl);
  const GWEN_TIME *ti;

  t.ref().setTransferType(Transfer::TransferType_Simple);
  if (t.ref().getTextKey()==0)
    t.ref().setTextKey(51);

  ti=t.ref().getDate();
  if (ti) {
    int days, months, year;

    GWEN_Time_GetBrokenDownUtcDate(ti, &days, &months, &year);
    w.execDateEdit->setDate(QDate(year, months+1, days));
  }
  else {
    w.execDateEdit->setDate(QDate::currentDate());
  }

  if (!title.isEmpty())
    w.setCaption(title);
  w.titleLabel->setText(_tr("<qt>"
                           "<h3>Dated Transfer</h3>"
                            "Let your bank transfer money from your account "
                            "to someone elses' (within your country). "
                            "on a specified date."
                            "</qt>"));
  w.grp_myaccount->setTitle(_tr("editTransfer|Payee"));
  w.grp_recipient->setTitle(_tr("editTransfer|Recipient"));
  return (w.exec()==QDialog::Accepted);
}



bool EditTransaction::modifyDatedTransfer(KBanking *app,
                                          RefPointer<Transfer> t,
                                          const QString &title,
                                          QWidget* parent,
                                          bool modal,
                                          WFlags fl) {
  EditTransaction w(app, t, true, false, parent, 0, modal, fl);
  const GWEN_TIME *ti;

  t.ref().setTransferType(Transfer::TransferType_Simple);
  if (t.ref().getTextKey()==0)
    t.ref().setTextKey(51);

  ti=t.ref().getDate();
  if (ti) {
    int days, months, year;

    GWEN_Time_GetBrokenDownUtcDate(ti, &days, &months, &year);
    w.execDateEdit->setDate(QDate(year, months+1, days));
  }
  else {
    w.execDateEdit->setDate(QDate::currentDate());
  }

  if (!title.isEmpty())
    w.setCaption(title);
  w.titleLabel->setText(_tr("<qt>"
                           "<h3>Dated Transfer</h3>"
                            "Modify an existing dated transfer."
                            "</qt>"));
  w.grp_myaccount->setTitle(_tr("editTransfer|Payee"));
  w.grp_recipient->setTitle(_tr("editTransfer|Recipient"));
  return (w.exec()==QDialog::Accepted);
}



QString EditTransaction::_tr(const char * sourceText){
  QString qs;
  int i;

  qs=tr(sourceText);
  i=qs.find('|');
  if (i) {
    qs=qs.mid(i+1);
  }
  return qs;
}






