/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: standingorder.cpp 234 2005-07-09 16:11:21Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "standingorder.h"

#include <stdlib.h>
#include <gwenhywfar/md.h>
#include <gwenhywfar/buffer.h>
#include <gwenhywfar/text.h>
#include <gwenhywfar/debug.h>

#include <time.h>

#ifdef WIN32
# define strcasecmp stricmp
#endif


StandingOrder::StandingOrder()
:Transaction()
,_period(AB_Transaction_PeriodUnknown)
,_cycle(1)
,_executionDay(1)
,_firstExecutionDate(0)
,_lastExecutionDate(0)
,_nextExecutionDate(0)
{

}



StandingOrder::StandingOrder(const AB_TRANSACTION *t)
:Transaction(t)
,_period(AB_Transaction_PeriodUnknown)
,_cycle(1)
,_executionDay(1)
,_firstExecutionDate(0)
,_lastExecutionDate(0)
,_nextExecutionDate(0)
{
  const GWEN_TIME *ti;

  setPeriod(AB_Transaction_GetPeriod(t));
  setCycle(AB_Transaction_GetCycle(t));
  setExecutionDay(AB_Transaction_GetExecutionDay(t));

  ti=AB_Transaction_GetFirstExecutionDate(t);
  if (ti)
    setFirstExecutionDate(ti);
  ti=AB_Transaction_GetLastExecutionDate(t);
  if (ti)
    setLastExecutionDate(ti);
  ti=AB_Transaction_GetNextExecutionDate(t);
  if (ti)
    setNextExecutionDate(ti);
}



StandingOrder::StandingOrder(const StandingOrder &t)
:Transaction(t)
,_period(t._period)
,_cycle(t._cycle)
,_executionDay(t._executionDay)
,_firstExecutionDate(0)
,_lastExecutionDate(0)
,_nextExecutionDate(0)
{
  const GWEN_TIME *ti;

  ti=t.getFirstExecutionDate();
  if (ti)
    setFirstExecutionDate(ti);
  ti=t.getLastExecutionDate();
  if (ti)
    setLastExecutionDate(ti);
  ti=t.getNextExecutionDate();
  if (ti)
    setNextExecutionDate(ti);
}



StandingOrder::StandingOrder(GWEN_DB_NODE *db)
:Transaction()
,_period(AB_Transaction_PeriodUnknown)
,_cycle(1)
,_executionDay(1)
,_firstExecutionDate(0)
,_lastExecutionDate(0)
,_nextExecutionDate(0)
{
  if (!fromDb(db)) {
    DBG_ERROR(0, "Error loading transaction from DB");
    abort();
  }
}



StandingOrder::~StandingOrder(){
  GWEN_Time_free(_nextExecutionDate);
  GWEN_Time_free(_lastExecutionDate);
  GWEN_Time_free(_firstExecutionDate);
}




AB_TRANSACTION_PERIOD StandingOrder::getPeriod() const {
  return _period;
}



void StandingOrder::setPeriod(AB_TRANSACTION_PERIOD p) {
  _period=p;
}



int StandingOrder::getCycle() const {
  return _cycle;
}



void StandingOrder::setCycle(int i) {
  _cycle=i;
}



int StandingOrder::getExecutionDay() const {
  return _executionDay;
}



void StandingOrder::setExecutionDay(int i) {
  _executionDay=i;
}



const GWEN_TIME *StandingOrder::getFirstExecutionDate() const {
  return _firstExecutionDate;
}



void StandingOrder::setFirstExecutionDate(const GWEN_TIME *ti){
  GWEN_Time_free(_firstExecutionDate);
  if (ti)
    _firstExecutionDate=GWEN_Time_dup(ti);
  else
    _firstExecutionDate=0;
}



const GWEN_TIME *StandingOrder::getLastExecutionDate() const {
  return _lastExecutionDate;
}



void StandingOrder::setLastExecutionDate(const GWEN_TIME *ti) {
  GWEN_Time_free(_lastExecutionDate);
  if (ti)
    _lastExecutionDate=GWEN_Time_dup(ti);
  else
    _lastExecutionDate=0;
}



const GWEN_TIME *StandingOrder::getNextExecutionDate() const {
  return _nextExecutionDate;
}



void StandingOrder::setNextExecutionDate(const GWEN_TIME *ti) {
  GWEN_Time_free(_nextExecutionDate);
  if (ti)
    _nextExecutionDate=GWEN_Time_dup(ti);
  else
    _nextExecutionDate=0;
}



bool StandingOrder::toDb(GWEN_DB_NODE *db) const {
  if (!Transaction::toDb(db)) {
    DBG_ERROR(0, "Error saving transaction part");
    return false;
  }

  GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
                       "period", AB_Transaction_Period_toString(_period));
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "cycle", _cycle);
  GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
		      "executionDay", _executionDay);

  if (_firstExecutionDate) {
    GWEN_BUFFER *tbuf;

    tbuf=GWEN_Buffer_new(0, 32, 0, 1);
    if (GWEN_Time_toUtcString(_firstExecutionDate, "YYYYMMDD", tbuf)) {
      DBG_ERROR(0, "Could not store date");
      GWEN_Buffer_free(tbuf);
      return false;
    }
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
			 "firstExecutionDate", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }

  if (_lastExecutionDate) {
    GWEN_BUFFER *tbuf;

    tbuf=GWEN_Buffer_new(0, 32, 0, 1);
    if (GWEN_Time_toUtcString(_lastExecutionDate, "YYYYMMDD", tbuf)) {
      DBG_ERROR(0, "Could not store date");
      GWEN_Buffer_free(tbuf);
      return false;
    }
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
			 "lastExecutionDate", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }

  if (_nextExecutionDate) {
    GWEN_BUFFER *tbuf;

    tbuf=GWEN_Buffer_new(0, 32, 0, 1);
    if (GWEN_Time_toUtcString(_nextExecutionDate, "YYYYMMDD", tbuf)) {
      DBG_ERROR(0, "Could not store date");
      GWEN_Buffer_free(tbuf);
      return false;
    }
    GWEN_DB_SetCharValue(db, GWEN_DB_FLAGS_OVERWRITE_VARS,
			 "nextExecutionDate", GWEN_Buffer_GetStart(tbuf));
    GWEN_Buffer_free(tbuf);
  }

  return true;
}



bool StandingOrder::fromDb(GWEN_DB_NODE *db) {
  const char *p;

  if (!Transaction::fromDb(db)) {
    DBG_ERROR(0, "Error loading transaction part");
    return false;
  }

  p=GWEN_DB_GetCharValue(db, "period", 0, 0);
  if (p)
    _period=AB_Transaction_Period_fromString(p);
  _cycle=GWEN_DB_GetIntValue(db, "cycle", 0, 1);
  _executionDay=GWEN_DB_GetIntValue(db, "executionDay", 0, 1);

  p=GWEN_DB_GetCharValue(db, "firstExecutionDate", 0, 0);
  if (p) {
    std::string s;
    GWEN_TIME *ti;

    s=p;
    s+="-12:00";

    ti=GWEN_Time_fromUtcString(s.c_str(), "YYYYMMDD-hh:mm");
    assert(ti);
    _firstExecutionDate=ti;
  }

  p=GWEN_DB_GetCharValue(db, "lastExecutionDate", 0, 0);
  if (p) {
    std::string s;
    GWEN_TIME *ti;

    s=p;
    s+="-12:00";

    ti=GWEN_Time_fromUtcString(s.c_str(), "YYYYMMDD-hh:mm");
    assert(ti);
    _lastExecutionDate=ti;
  }

  p=GWEN_DB_GetCharValue(db, "nextExecutionDate", 0, 0);
  if (p) {
    std::string s;
    GWEN_TIME *ti;

    s=p;
    s+="-12:00";

    ti=GWEN_Time_fromUtcString(s.c_str(), "YYYYMMDD-hh:mm");
    assert(ti);
    _nextExecutionDate=ti;
  }

  return true;
}



AB_TRANSACTION *StandingOrder::toBankingTransaction() {
  AB_TRANSACTION *t;

  t=Transaction::toBankingTransaction();
  if (!t)
    return 0;
  AB_Transaction_SetPeriod(t, _period);
  AB_Transaction_SetCycle(t, _cycle);
  AB_Transaction_SetExecutionDay(t, _executionDay);
  AB_Transaction_SetFirstExecutionDate(t, _firstExecutionDate);
  AB_Transaction_SetLastExecutionDate(t, _lastExecutionDate);
  AB_Transaction_SetNextExecutionDate(t, _nextExecutionDate);

  return t;
}







