/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: jobview.cpp 385 2006-02-14 13:23:12Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "jobview.h"
#include "kbanking.h"
#include "timport.h"
#include <aqbanking/jobgetbalance.h>
#include <aqbanking/jobgettransactions.h>

#include <qevent.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qmessagebox.h>
#include <qlayout.h>

#include <gwenhywfar/debug.h>



#define BUTTON_WIDTH 110


JobView::JobView(KBanking *kb,
                 QWidget* parent,
                 const char* name,
                 WFlags fl)
:JobViewUi(parent, name, fl), _app(kb) {
  assert(kb);

  // Manually create and add layout here because the .ui-generated
  // QGroupBox doesn't have one.
  jobBox->setColumnLayout(0, Qt::Vertical );
  QBoxLayout *jobBoxLayout = new QHBoxLayout( jobBox->layout() );
  jobBoxLayout->setAlignment( Qt::AlignTop );

  _jobList=new QBJobListView(jobBox, name);
  _jobList->setSelectionMode(QListView::Extended);
  jobBoxLayout->addWidget(_jobList);

  QObject::connect(_app->flagStaff(), SIGNAL(signalQueueUpdated()),
                   this, SLOT(slotQueueUpdated()));
  QObject::connect(executeButton, SIGNAL(clicked()),
                   this, SLOT(slotExecute()));
  QObject::connect(dequeueButton, SIGNAL(clicked()),
                   this, SLOT(slotDequeue()));

}



JobView::~JobView(){
}


bool JobView::init(){
  GWEN_DB_NODE *db;

  db=_app->getAppData();
  assert(db);
  db=GWEN_DB_GetGroup(db, GWEN_PATH_FLAGS_NAMEMUSTEXIST,
                      "gui/views/jobview");
  if (db) {
    int i, j;

    /* found settings */
    for (i=0; i<_jobList->columns(); i++) {
      _jobList->setColumnWidthMode(i, QListView::Manual);
      j=GWEN_DB_GetIntValue(db, "columns", i, -1);
      if (j!=-1)
        _jobList->setColumnWidth(i, j);
    } /* for */
  } /* if settings */

  _jobList->addJobs(_app->getEnqueuedJobs());
  _app->outboxCountChanged(_jobList->childCount());

  return true;
}



bool JobView::fini(){
  GWEN_DB_NODE *db;
  int i, j;

  db=_app->getAppData();
  assert(db);
  assert(db);
  GWEN_DB_ClearGroup(db, "gui/views/jobview");
  for (i=0; i<_jobList->columns(); i++) {
    j=_jobList->columnWidth(i);
    GWEN_DB_SetIntValue(db, GWEN_DB_FLAGS_DEFAULT,
                        "gui/views/jobview/columns", j);
  } /* for */

  return true;
}


void JobView::slotQueueUpdated(){
  DBG_DEBUG(0, "Job queue updated");
  _jobList->clear();
  _jobList->addJobs(_app->getEnqueuedJobs());
  _app->outboxCountChanged(_jobList->childCount());
}



void JobView::slotExecute(){
  std::list<AB_JOB*> jl;
  std::list<AB_JOB*>::iterator jit;
  int rv;
  bool updated;
  AB_IMEXPORTER_CONTEXT *ctx;

  updated=false;
  _app->nextSession();
  jl=_app->getEnqueuedJobs();
  if (jl.size()==0) {
    QMessageBox::warning(this,
                         tr("No Jobs"),
                         tr("There are no jobs in the queue."),
                         tr("Dismiss"), QString::null);
    return;
  }

  DBG_INFO(0, "Executing queue");
  ctx=AB_ImExporterContext_new();
  rv=_app->executeQueue(ctx);
  if (rv) {
    DBG_NOTICE(0, "Error %d", rv);
  }

  /* handle results of all jobs */
  if (!rv) {
    AB_IMEXPORTER_ACCOUNTINFO *ai;
  
    ai=AB_ImExporterContext_GetFirstAccountInfo(ctx);
    while(ai) {
      Account *a;

      a=_app->findAccount(AB_ImExporterAccountInfo_GetBankCode(ai),
                          AB_ImExporterAccountInfo_GetAccountNumber(ai));
      if (a) {
        GWEN_DB_NODE *dbAccountSettings;

        dbAccountSettings=_app->getAppData();
        assert(dbAccountSettings);
        dbAccountSettings=GWEN_DB_GetGroup(dbAccountSettings,
                                           GWEN_DB_FLAGS_DEFAULT,
                                           "settings/accounts/");
        assert(dbAccountSettings);
        dbAccountSettings=GWEN_DB_GetGroup(dbAccountSettings,
                                           GWEN_DB_FLAGS_DEFAULT,
                                           a->getCountry().c_str());
        assert(dbAccountSettings);
        dbAccountSettings=GWEN_DB_GetGroup(dbAccountSettings,
                                           GWEN_DB_FLAGS_DEFAULT,
                                           a->getBankCode().c_str());
        assert(dbAccountSettings);
        dbAccountSettings=GWEN_DB_GetGroup(dbAccountSettings,
                                           GWEN_DB_FLAGS_DEFAULT,
                                           a->getAccountNumber().c_str());
        assert(dbAccountSettings);
  
        if (GWEN_DB_GetIntValue(dbAccountSettings,
                                "clearStandingOrdersOnNextImport", 0, 0)) {
          DBG_DEBUG(0, "Clearing standing orders for account %s / %s",
                    a->getBankCode().c_str(),
                    a->getAccountNumber().c_str());
          a->clearStandingOrders();
          GWEN_DB_SetIntValue(dbAccountSettings, GWEN_DB_FLAGS_OVERWRITE_VARS,
                              "clearStandingOrdersOnNextImport", 0);
        }
        else {
          DBG_DEBUG(0, "Not clearing standing orders for account %s / %s",
                    a->getBankCode().c_str(),
                    a->getAccountNumber().c_str());
        }
        if (GWEN_DB_GetIntValue(dbAccountSettings,
                                "clearDatedTransfersOnNextImport", 0, 0)) {
          DBG_DEBUG(0, "Clearing standing orders for account %s / %s",
                    a->getBankCode().c_str(),
                    a->getAccountNumber().c_str());
          a->clearDatedTransfers();
          GWEN_DB_SetIntValue(dbAccountSettings, GWEN_DB_FLAGS_OVERWRITE_VARS,
                              "clearDatedTransfersOnNextImport", 0);
        }
        else {
          DBG_DEBUG(0, "Not clearing standing orders for account %s / %s",
                    a->getBankCode().c_str(),
                    a->getAccountNumber().c_str());
        }
      }
      ai=AB_ImExporterContext_GetNextAccountInfo(ctx);
    } /* while */

    _app->importContext(ctx,
                        TRANSACTION_IMPORTER_FLAGS_COMPLETE_DAYS /*|
                        TRANSACTION_IMPORTER_FLAGS_OVERWRITE_DAYS */);
  }
  AB_ImExporterContext_free(ctx);
}



void JobView::slotDequeue(){
  std::list<AB_JOB*> jl;
  std::list<AB_JOB*>::iterator jit;

  jl=_jobList->getSelectedJobs();
  if (jl.empty()) {
    DBG_DEBUG(0, "No job selected");
    QMessageBox::warning(this,
			 tr("No Selection"),
                         tr("Please select a job first."),
			 tr("Dismiss"), QString::null);
    return;
  }

  int res = QMessageBox::warning(this,
			   tr("Delete job"),
			   tr("Do you really want to delete the "
			      "selected job(s)?"),
			   QMessageBox::Yes,QMessageBox::No);
  if (res != 0 && res != QMessageBox::Yes)
    return;

  for (jit=jl.begin(); jit!=jl.end(); jit++) {
    int rv;

    rv=AB_Banking_DequeueJob(_app->getCInterface(), *jit);
    if (rv) {
      DBG_ERROR(0, "Error dequeing job (%d)", rv);
    }
  } // for
  slotQueueUpdated();
}









