<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY docbook SYSTEM "/usr/local/share/xml/stylesheets/dsssl/docbook/html/docbook.dsl" CDATA DSSSL>
]>

<!-- an html stylesheet for use with the qbrew documentation -->

<style-sheet>
<style-specification use="docbook">
<style-specification-body>

(define %graphic-extensions% '("jpg" "jpeg" "png"))     ;; acceptable graphic extensions
(define %graphic-default-extension% ".png")             ;; we don't want gifs

(define %html-pubid%"-//W3C//DTD HTML 4.01//EN")        ;; public dtd declaration
(define %html-prefix% "qbrew-")                         ;; add in an appropriate prefix
(define %html-ext% ".html")                             ;; use a proper html extension
(define %use-id-as-filename% #t)                        ;; use the ID tags for filenames
(define %body-attr%
  (list
   (list "BGCOLOR" "#FFFFFF")
   (list "TEXT" "#000000")
   (list "LINK" "#AA0000")
   (list "VLINK" "#AA0055")
   (list "ALINK" "#AA0000")
   (list "STYLE" "font-family: sans-serif;")))

(define admon-graphic-default-extension %graphic-default-extension%)
(define %admon-graphics% #t)                            ;; use graphic admonitions
(define %admon-graphics-path% "./stylesheet-images/")   ;; define admon graphic path
(define ($admon-graphic$ #!optional (nd (current-node)))
  (cond ((equal? (gi nd) (normalize "tip"))
         (string-append %admon-graphics-path% "tip" %graphic-default-extension%))
        ((equal? (gi nd) (normalize "note"))
         (string-append %admon-graphics-path% "note" %graphic-default-extension%))
        ((equal? (gi nd) (normalize "important"))
         (string-append %admon-graphics-path% "important" %graphic-default-extension%))
        ((equal? (gi nd) (normalize "caution"))
         (string-append %admon-graphics-path% "caution" %graphic-default-extension%))
        ((equal? (gi nd) (normalize "warning"))
         (string-append %admon-graphics-path% "warning" %graphic-default-extension%))
        (else (error (string-append (gi nd) " is not an admonition.")))))

(define %shade-verbatim% #t)                            ;; shade verbatim blocks

</style-specification-body>
</style-specification>
<external-specification id="docbook" document="docbook">

</style-sheet>
