/***************************************************************************
  notepage.cpp
  -------------------
  A dialog page for notes
  -------------------
  Copyright 2003-2004, David Johnson
  Please see the header file for copyright and license information
 ***************************************************************************/

#include <qlabel.h>
#include <qlayout.h>
#include <qtextedit.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "controller.h"
#include "model.h"
#include "view.h"

#include "notepage.h"

//////////////////////////////////////////////////////////////////////////////
// Construction, Destruction                                                //
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// NotePage()
// ----------
// Constructor

NotePage::NotePage(Model *model, View *view, Controller *controller,
                   const char *name)
    : QWidget(view, name), model_(model), controller_(controller),
      recipelabel_(0),  recipeedit_(0), batchlabel_(0), batchedit_(0)
{
    recipeedit_ = new QTextEdit(this, "recipeedit_");
    recipelabel_ = new QLabel(recipeedit_, "&Recipe Notes",
                              this, "recipelabel_");
    QToolTip::add(recipeedit_, "Recipe Notes");
    QWhatsThis::add(recipeedit_,
                    "Use this form to enter in any notes relating to the "
                    "recipe, such as specific brewing procedures or awards");

    batchedit_ = new QTextEdit(this, "batchedit_");
    batchlabel_ = new QLabel(batchedit_, "&Batch Notes",
                             this, "batchlabel_");
    QToolTip::add(batchedit_, "Batch Notes");
    QWhatsThis::add(batchedit_,
                    "Use this form to enter in any notes relating to brewing "
                    "batches of this recipe, such as brew and bottling dates");

    QVBoxLayout *layout = new QVBoxLayout(this, 6, 3, "layout"); 
    layout->addWidget(recipelabel_, 0);
    layout->addWidget(recipeedit_, 1);
    layout->addWidget(batchlabel_, 0);
    layout->addWidget(batchedit_, 1);

    // set up connections
    connect(recipeedit_, SIGNAL(textChanged()),
            this, SLOT(updateRecipeNotes()));
    connect(batchedit_, SIGNAL(textChanged()),
            this, SLOT(updateBatchNotes()));
}

NotePage::~NotePage() { ; }

//////////////////////////////////////////////////////////////////////////////
// documentChanged()
// -----------------
// the document has changed

void NotePage::documentChanged()
{
    recipeedit_->setText(model_->recipe()->recipeNotes());
    batchedit_->setText(model_->recipe()->batchNotes());
}

//////////////////////////////////////////////////////////////////////////////
// updateRecipeNotes()
// -----------------
// Update the notes in the model

void NotePage::updateRecipeNotes()
{
    // no need to get view involved as it will cause unnecessary updates
    model_->recipe()->setRecipeNotes(recipeedit_->text());
    controller_->documentModified();
}

//////////////////////////////////////////////////////////////////////////////
// updateBatchNotes()
// -----------------
// Update the notes in the model

void NotePage::updateBatchNotes()
{
    // no need to get view involved as it will cause unnecessary updates
    model_->recipe()->setBatchNotes(batchedit_->text());
    controller_->documentModified();
}

