/***************************************************************************
                          rattribdialog.cpp  -  description
                             -------------------
    begin                : Tue Sep 28 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

#include <qlabel.h>

#include "rattribdialog.h"


/**
 * Constructor
 */
RAttribDialog::RAttribDialog(const QString& _caption,
                             const QString& _label,
                             QWidget* _parent)
  :QDialog(_parent, _caption, true, WStyle_NormalBorder)
{
  setCaption(_caption);

  setFixedSize(DEF_ATTRIBDLG_WIDTH, DEF_ATTRIBDLG_HEIGHT+20);

  // Create label:
  //
  lText = new QLabel(_label, this, "ltext");
  lText->setAlignment(AlignCenter);
  if(lText->sizeHint().width()+20>DEF_ATTRIBDLG_WIDTH) {
    setFixedWidth(lText->sizeHint().width()+20);
  }
  if(lText->sizeHint().height()+70>DEF_ATTRIBDLG_HEIGHT) {
    setFixedHeight(lText->sizeHint().height()+70);
  }
  lText->setGeometry(10, 10, width()-10, 30);

  // Create labels:
  //
  QLabel* lab = new QLabel(tr("Color"), this);
  lab->setGeometry(10, 60, (width()-20)/3, 20);

  lab = new QLabel(tr("Width"), this);
  lab->setGeometry(10+(width()-20)/3, 60, (width()-20)/3, 20);

  lab = new QLabel(tr("Style"), this);
  lab->setGeometry(10+(width()-20)/3*2, 60, (width()-20)/3, 20);

  // Create comboboxes:
  //
  cbColor = new RComboBox(false, this, "color");
  cbColor->fillInColors();
  cbColor->insertItem(tr("unchanged"));
  cbColor->setEditText(tr("unchanged"));
  QToolTip::add(cbColor, tr("Color"));
  cbColor->setGeometry(10, 80, (width()-20)/3, 20);

  cbWidth = new RComboBox(false, this, "width");
  cbWidth->fillInWidths();
  cbWidth->insertItem(tr("unchanged"));
  cbWidth->setEditText(tr("unchanged"));
  QToolTip::add(cbWidth, tr("Width"));
  cbWidth->setGeometry(10+(width()-20)/3, 80, (width()-20)/3, 20);

  cbStyle = new RComboBox(false, this, "width");
  cbStyle->fillInStyles();
  cbStyle->insertItem(tr("unchanged"));
  cbStyle->setEditText(tr("unchanged"));
  QToolTip::add(cbStyle, tr("Style"));
  cbStyle->setGeometry(10+(width()-20)/3*2, 80, (width()-20)/3, 20);

  // Create buttons:
  //
  bOk = new QPushButton(tr("Ok"), this);
  bOk->setGeometry(width()-150, 110, 70, 20);
  bOk->setAccel(Key_Return);
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));

  bCancel = new QPushButton(tr("Cancel"), this);
  bCancel->setGeometry(width()-80, 110, 70, 20);
  bCancel->setAccel(Key_Escape);
  connect(bCancel, SIGNAL(clicked()), SLOT(reject()));

  /*
  bHelp = new QPushButton(tr("Help"), this);
  bHelp->setGeometry(10+(width()-20)/3*2, 110, (width()-20)/3, 20);
  bHelp->setAccel(Key_F1);
  */
}


/**
 * Destructor
 */
RAttribDialog::~RAttribDialog()
{

}



// Get the chosen color or -1 if no color was chosen:
//
int
RAttribDialog::getColor()
{
  if(cbColor) {
    if(cbColor->currentText().isNull()) {
      return cbColor->currentItem();
    }
  }

  return -1;
}



// Get the chosen width or -1 if no width was chosen:
//
int
RAttribDialog::getWidth()
{
  if(cbWidth) {
    if(cbWidth->currentText().isNull()) {
      return cbWidth->currentItem();
    }
  }

  return -1;
}


// Get the chosen style or -1 if no style was chosen:
//
int
RAttribDialog::getStyle()
{
  if(cbStyle) {
    if(cbStyle->currentText().isNull()) {
      return cbStyle->currentItem();
    }
  }

  return -1;
}










