//
// C++ Implementation: CCursorEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CCursorEdit.hpp"

CCursorEditDlg::CCursorEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CCursorEditDlg::~CCursorEditDlg() {
}

void CCursorEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CCursorEditDlg::slotGetData(FolderListItem *i)
{
    point=i;
    
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());

    ui.locx->setText(i->GetValue("x",i));
    ui.locy->setText(i->GetValue("y",i));
    ui.locz->setText(i->GetValue("z",i));

    ui.mx->setValue(i->GetValue("mx",i).toDouble());
    ui.my->setValue(i->GetValue("my",i).toDouble());

    qWarning( "CCursorEditDlg::slotGetData(): Geht !" );
}

void CCursorEditDlg::slotEditData()
{
    if(point != NULL){
        point->setText(0,ui.text->text());

        point->SetValue("on",ui.on->isChecked() ? "1" : "0");

        point->SetValue("x",ui.locx->text());
        point->SetValue("y",ui.locy->text());
        point->SetValue("z",ui.locz->text());

        point->SetValue("mx",ui.mx->text());
        point->SetValue("my",ui.my->text());

	point->updategl();
    }
    qWarning( "CCursorEditDlg::slotEditData(): Geht !" );
}
