//
// C++ Implementation: CPrefEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CPrefEdit.hpp"

CPrefEditDlg::CPrefEditDlg(QString strTitle, QWidget * parent, QString tmppath, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   ui.setupUi(this);
   
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.toolButton1, SIGNAL(pressed()), this, SLOT(slotGetEditor()));

   ui.editor->setText(tmppath);
   editorpath = tmppath;
   myParent = parent;
   setWindowTitle(strTitle);
}

CPrefEditDlg::~CPrefEditDlg() {
}

void CPrefEditDlg::slotGetEditor()
{
    QString fileName =
            QFileDialog::getOpenFileName(this, tr("Editor"),
                                         QString(QDir::homePath ()),
                                         tr("Files (*)"));

    qWarning( fileName.toAscii() );
    if(!fileName.isEmpty()){
      ui.editor->setText(fileName);
      editorpath = fileName;
    }
}

QString CPrefEditDlg::geteditpath()
{
  return editorpath;
}

void CPrefEditDlg::slotGetData()
{
    reject();
    qWarning( "CPrefEditDlg::slotGetData(): Geht !" );
}

void CPrefEditDlg::slotEditData()
{
    editorpath = ui.editor->text();
    accept();
    qWarning( "CPrefEditDlg::slotEditData(): Geht !" );
}
