/***************************************************************************
                          alsound.cpp  -  description
                             -------------------
    begin                : Wed Jan 21 2004
    copyright            : (C) 2004 by Harald Krippel
    email                : neuro.harald@surfeu.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 * todo:                                                                   *
 *       make memberfunctins to get boxobjtrans and set boxobjtrans        *
 *       make memberfunctins to get snd and set snd                        *
 ***************************************************************************/
#include <alsound.hpp>

AlSound::AlSound(void)
{
  snd = 0;
  boxobjtrans = NULL;
  Audio=AudioEnv::theInstance();
}

/*!
 set the sound position to x,y,z coordinate
*/
void AlSound::setPosition (float x, float y, float z)
{
     pos.xyz[0]=x;
     pos.xyz[0]=y;
     pos.xyz[0]=z;
     Audio->SetSourcePosition( snd, pos.xyz);
}

/*!
 play the sound
*/
void AlSound::Play()
{
    if(snd != 0 && Audio->IsPlaying(snd) == 0)
    {
       Audio->Play(snd);
    }
}

/*!
 stop play the sound
*/
void AlSound::Stop()
{
    if(snd != 0 && Audio->IsPlaying(snd) == 1)
    {
       Audio->Stop(snd);
    }
}

/*!
 set the sound attribute flag loop
*/
void AlSound::Loop(int flag)
{
    if(snd != 0 )
    {
       Audio->Loop(snd,flag);
    }
}

/*!
 set the sound attribute flag relative
*/
void AlSound::Relative(int flag)
{
    if(snd != 0 )
    {
       Audio->Relative(snd,flag);
    }
}

/*!
 adjust the volume of the sound
*/
void AlSound::adjustVolume(float gain)
{
    if(snd != 0 )
    {
       Audio->SetSourceGain (snd, gain);
    }
}

/*!
 load the sound file
*/
void AlSound::LoadFile(const char *file)
{
   snd = Audio->LoadFile(file, false);
}
    
AlSound::~AlSound()
{
   if (AudioEnv *Audio=AudioEnv::theInstance()) {
      delete Audio;
   }
}
