/***************************************************************************
                          usercamera.h  -  description
                             -------------------
    begin                : Don Dez 15 2005
    copyright            : (C) 2005 by Krippel Harald
    email                : neuro.harald@surfeu.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef USERCAMERA_H
#define USERCAMERA_H

/**
	@author Harald Krippel <harald@the-develop.net>
*/

#include "camera.hpp"
#include <plib/ssg.h>

class FolderListItem;
/**
  *@author Krippel Harald
  */

class usercamera
{
public: 
  usercamera(Camera *glcontext);
  void update();
  void setUserCamera (const float pos[3], const float R[12]);
  void bind(const int id);
  void kbd ( char key );
  void view();
  ~usercamera();

  int cbind;
  int camtyp;
  float  camrotw;
  float  camhight;
  float  camradius;
  sgMat4 cmat;
  ssgTransform    *objtrans;

   char kbcamrotadd;  ///< key to rotate the camera clockwise
   char kbcamrotsub;  ///< key to rotate the camera counterclockwise
   char kbcamradadd;
   char kbcamradsub;
   char kbcamheightadd;
   char kbcamheightsub;
   char kbforward;
   char kbback;
   char kbleft;
   char kbright;
   float gox;
   float goy;

   FolderListItem *item;
   FolderListItem *miditem;

protected:
  Camera *scontext;
};

#endif
