#include "imlibloader.h"
#include "imlibimage.h"

using namespace QComicBook;

ImlibLoaderThread::ImlibLoaderThread(): QThread(), prio(QThread::LowPriority), stopped(false)
{
}

ImlibLoaderThread::~ImlibLoaderThread()
{
}

void ImlibLoaderThread::setPriority(QThread::Priority p)
{
	mtx.lock();
	prio = p;
	mtx.unlock();
}

void ImlibLoaderThread::request(const QString &file)
{
	mtx.lock();
	if (requests.contains(file))
	{
		mtx.unlock();
		return;
	}
	requests.append(file);
	if (!running() && !stopped)
	{
		mtx.unlock();
		start(prio);
	}
	else
		mtx.unlock();
}

void ImlibLoaderThread::stop()
{
	mtx.lock();
	stopped = true;
	mtx.unlock();
}

void ImlibLoaderThread::run()
{
	for (;;)
	{
		mtx.lock();
		if (stopped || requests.empty())
		{
			mtx.unlock();
			break;
		}
		
		const QString file = requests.first();
		requests.pop_front();
		
		ImlibImage *image = new ImlibImage();
		image->load(file);
		delete image;
		
		mtx.unlock();
	}
}

