#!/usr/bin/env python
# coding=utf-8

##    Qemulator - a qemu gui written in python and GTK/Glade.
##    Copyright (C) 2006  rainer haage
##
##    This program is free software; you can redistribute it and/or
##    modify it under the terms of the GNU General Public License
##    as published by the Free Software Foundation; either version 2
##    of the License, or (at your option) any later version.
##    
##    This program is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##    
##    You should have received a copy of the GNU General Public License
##    along with this program; if not, write to the Free Software
##    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import gtk

class WidgetStyle:        
    def __init__(self, widget):
        self.widget = widget
        self.style = widget.get_style()
        
    def set_fg(self, hexval):
        #red, green, blue = rgbvalues
        #color = gtk.gdk.Color(red, green, blue, 255)
        rgbval = HexToRGB(hexval)
        print "RGB: " + str(rgbval)
        ncolor = gtk.gdk.color_parse(hexval)
        self.widget.modify_fg(gtk.STATE_NORMAL, ncolor)
        return self.style
        
    def set_bg(self, hexval):
        #red, green, blue = rgbvalues
        #color = gtk.gdk.Color(red, green, blue, 255)
        #rgbval = HexToRGB(hexval)
        #print "RGB: " + str(rgbval)
        #red, green, blue = rgbval
        ncolor = gtk.gdk.color_parse(hexval)
        self.widget.modify_bg(gtk.STATE_NORMAL, ncolor)
        
        ocolor = gtk.gdk.color_parse(lighten_color(hexval, 10))
        self.widget.modify_bg(gtk.STATE_PRELIGHT, ocolor)
        
        acolor = gtk.gdk.color_parse(darken_color(hexval, 10))
        self.widget.modify_bg(gtk.STATE_ACTIVE, acolor)
        return self.style

def lighten_color(hexval, amount):
    red, green, blue = HexToRGB(hexval)
    ored = lightup(red, amount)
    ogreen = lightup(green, amount)
    oblue = lightup(blue, amount)
    outrgb = (ored, ogreen, oblue)
    outhex = RGBToHex(outrgb)
    return outhex
    
def lightup(rgbval, amount):
    newval = rgbval + amount
    if newval > 255:
        newval = 255
    return newval
    
def darken_color(hexval, amount):
    red, green, blue = HexToRGB(hexval)
    ored = greydown(red, amount)
    ogreen = greydown(green, amount)
    oblue = greydown(blue, amount)
    outrgb = (ored, ogreen, oblue)
    outhex = RGBToHex(outrgb)
    return outhex
    
def greydown(rgbval, amount):
    newval = rgbval - amount
    if newval < 0:
        newval = 0
    return newval    
            
    
def HexToRGB(colorstring):
    """ convert #RRGGBB to an (R, G, B) tuple """
    colorstring = colorstring.strip()
    if colorstring[0] == '#': colorstring = colorstring[1:]
    if len(colorstring) != 6:
        raise ValueError, "input #%s is not in #RRGGBB format" % colorstring
    r, g, b = colorstring[:2], colorstring[2:4], colorstring[4:]
    r, g, b = [int(n, 16) for n in (r, g, b)]
    return (r, g, b)

def RGBToHex(rgb_tuple):
    """ convert an (R, G, B) tuple to #RRGGBB """
    hexcolor = '#%02x%02x%02x' % rgb_tuple
    # that's it! '%02x' means zero-padded, 2-digit hex values
    return hexcolor
        
