/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef MYPROCESS_H
#define MYPROCESS_H

#include <qprocess.h>
#include "git.h"

class Git;

//custom process used to run shell commands in parallel

class MyProcess : public QProcess {
Q_OBJECT
public:
	MyProcess(QObject *go, Git* g, const QString& wd, bool reportErrors);
	bool runSync(SCRef runCmd, QByteArray* runOutput, QObject* rcv, SCRef buf, QStringList* env);
	bool runAsync(SCRef rc, QObject* rcv, SCRef buf, QStringList* env);
	static const QStringList splitArgList(SCRef cmd);

signals:
	void procDataReady(const QByteArray&);
	void eof();

public slots:
	void on_cancel();

private slots:
	void on_readyReadStdout();
	void on_readyReadStderr();
	void on_processExited();
	void on_launchFinished();

private:
	void setupSignals();
	void appendSystemEnvironment(QStringList* env);
	bool launchMe(SCRef runCmd, SCRef buf, QStringList* env);
	void sendErrorMsg(bool notStarted = false);
	static void restoreSpaces(QString& newCmd, SCRef sepChar);

	QObject* guiObject;
	Git* git;
	QString runCmd;
	QByteArray* runOutput;
	QString workDir;
	QObject* receiver;
	bool errorReportingEnabled;
	bool canceling;
	bool busy;
	bool exitStatus;
	bool async;
	bool isLaunching;
};

#endif
