/*
 * QCameraDropSite.h
 * $Id: QCameraDropSite.h,v 1.2 2001/11/15 16:54:52 guenth Exp $
 *
 * Copyright (C) 1999, 2000 Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

//  Description : Class QCameraDropSite
//  Purpose     : Provides an area where you can drag'n drop cameras


#ifndef __QCAMERADROPSITE_H
#define __QCAMERADROPSITE_H


// Qt
///////
#include <qlabel.h>


// System
///////////


// Own
///////////
#include "CCamera.h"


// Foraward declarations
///////////////////////////
class QGLViewer;
class QCameraDrag;


/// Dropsite for cameras.
/**
  * This class provides an area where you can drag'n drop
  * cameras.
  *
  * @author Markus Janich
  */

class QCameraDropSite: public QLabel
{
  Q_OBJECT
public:
  ////////////////////
  // PUBLIC METHODS //
  ////////////////////

  QCameraDropSite(QWidget *parent=0, const char * name = 0);
  ~QCameraDropSite();

  void setCamera(CCamera *pCamera) { m_pCamera = pCamera; };

signals:
  void sigCameraDropped(const CCamera &cCamera);

protected:
  ///////////////////////
  // PROTECTED METHODS //
  ///////////////////////
  void dragEnterEvent(QDragEnterEvent *pqEvent);
  void dragLeaveEvent(QDragLeaveEvent *pqEvent);
  void dropEvent(QDropEvent *pqEvent);

  void mousePressEvent(QMouseEvent *pqEvent);
  void mouseReleaseEvent(QMouseEvent *pqEvent);

private:
  /////////////////////
  // PRIVATE MEMBERS //
  /////////////////////

  CCamera *m_pCamera;
};

#endif // __QCAMERADROPSITE_H
