/*
 * CCameraKeyPathPoint.cpp
 * $Id: 
 *
 * Copyright (C) 2000, 2001 Alexander Buck, Michael Meissner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */



// Qt
///////


// System
///////////


// Own
///////////
#include "CCameraKeyPathPoint.h"



// Function  : setCamera
// Parameters: CCamera camera
// Purpose   : Sets camera to given camera.
// Comments  : See docu for details.
void CCameraKeyPathPoint::setCamera(CCamera camera)
/***********************************************************/
{
   m_camera = camera;
}


// Function  : setAttributes
// Parameters: CCamPathAttributes atts
// Purpose   : Sets attributes to given attributes.
// Comments  : See docu for details.
void CCameraKeyPathPoint::setAttributes(CCameraKeyPathAttributes atts)
/***********************************************************/
{
   m_attributes = atts;
}


// Function  : setAttributes
// Parameters: int nFrames, float rfTension, float rfCon, float rfBias
// Purpose   : Sets attributes to given attributes.
// Comments  : See docu for details.
void CCameraKeyPathPoint::setAttributes(int nFrames, float rfTension, float rfCon, float rfBias)
/***********************************************************/
{
   m_attributes.setFrames(nFrames);
   m_attributes.setTension(rfTension);
   m_attributes.setContinuity(rfCon);
   m_attributes.setBias(rfBias);
}


// Function  : setName
// Parameters: QString qName
// Purpose   : Sets name to given name.
// Comments  : See docu for details.
void CCameraKeyPathPoint::setName(QString qName)
/***********************************************************/
{
   m_qName = qName;
}
