/***************************************************************************
                          main.cpp  -   QGrid
                             -------------------
    begin                : Fri Jan 12 13:46:56 CET 2001
    copyright            : (C) 2001 by Johan Maes - ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qpalette.h>
#include "qgridglobal.h"
#include "configtable.h"
#include "qgrid.h"
#include "icons/marble.xpm"


int main(int argc, char *argv[])
{
  QApplication a(argc, argv);
	registerOptions();
	QPixmap background(marble_xpm);
	QColor backCol( 227,227,227 );
	QColorGroup active(a.palette().active());
	QColorGroup disabled(a.palette().disabled());
	active.setBrush(QColorGroup::Background,QBrush(backCol, background));
	disabled.setBrush(QColorGroup::Background,QBrush(backCol, background));
	QPalette newPalette( active, disabled, active );
  a.setPalette(newPalette, TRUE ); 	
  a.setFont(QFont("helvetica", 12));
  QgridApp *qgrid=new QgridApp();
  a.setMainWidget(qgrid);
  qgrid->show();
  return a.exec();
}


