/***************************************************************************
                          qgrid.h  -   QGrid
                             -------------------
    begin                : Fri Jan 12 13:46:56 CET 2001
    copyright            : (C) 2001 by Johan Maes - ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef QGRID_H
#define QGRID_H

// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qpainter.h>

// application specific includes
#include "qgridview.h"
//#include "qgriddoc.h"

class QgridApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    QgridApp();
    /** destructor */
    ~QgridApp();
    /** initializes all QActions of the application */
    void initActions();
    /** initMenuBar creates the menu_bar and inserts the menuitems */
    void initMenuBar();
    /** setup the mainview*/
    void initView();
    /** overloaded for Message box on last window exit */
    bool queryExit();

  public slots:

    void slotFileQuit();
	/** shows the documentation*/
		void slotHelpContents();
	/** sets the path to the helpfiles*/
		void slotHelpLocation();
    /** shows an about dlg*/
    void slotHelpAbout();
  /** Selection of Km or Miles for distance calculation */
  void slotSelectKmMiles(bool toggle);

  private:

    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    QgridView *view;
    /** options_menu contains all items of the menubar entry "Options" */
		QPopupMenu *fileMenu;	
    QPopupMenu *optionMenu;

    /** help_menu contains all items of the menubar entry "Help" */
    QPopupMenu *helpMenu;
    QAction *fileQuit;
		QAction *selectKmMiles;
		QAction *helpContents;
		QAction *helpLocation;
    QAction *helpAboutApp;
};
#endif 

