/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.AlignBox;
import driftwood.gui.FoldingBox;
import driftwood.gui.IndentBox;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import king.KMessage;
import king.KinCanvas;
import king.KinTree;
import king.KingMain;
import king.KingPrefs;
import king.core.AGE;
import king.core.KGroup;
import king.core.KList;
import king.core.Kinemage;
import king.core.MasterGroup;

public class ContentPane
extends JPanel
implements KMessage.Subscriber {
    KingMain kMain = null;
    JScrollPane buttonScroll = null;
    JSplitPane minorSplit = null;
    JSplitPane majorSplit = null;
    Map<JCheckBox, AGE> btnMap = new LinkedHashMap<JCheckBox, AGE>();
    static final long REBUILD_BUTTONS_P = 28L;
    static final int REBUILD_BUTTONS_K = 264203;
    static final int RESYNC_BUTTONS = 4;

    public ContentPane(KingMain kingMain) {
        super(new BorderLayout());
        this.kMain = kingMain;
        this.kMain.subscribe(this);
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(65, 0), "anim1fwd");
        actionMap.put("anim1fwd", new ReflectiveAction(null, null, this, "onAnimForward"));
        inputMap.put(KeyStroke.getKeyStroke(65, 1), "anim1back");
        actionMap.put("anim1back", new ReflectiveAction(null, null, this, "onAnimBackward"));
        inputMap.put(KeyStroke.getKeyStroke(66, 0), "anim2fwd");
        actionMap.put("anim2fwd", new ReflectiveAction(null, null, this, "onAnim2Forward"));
        inputMap.put(KeyStroke.getKeyStroke(66, 1), "anim2back");
        actionMap.put("anim2back", new ReflectiveAction(null, null, this, "onAnim2Backward"));
        inputMap.put(KeyStroke.getKeyStroke(61, 0), "accum1");
        actionMap.put("accum1", new ReflectiveAction(null, null, this, "onAccumulate"));
        inputMap.put(KeyStroke.getKeyStroke(61, 1), "accum2");
        actionMap.put("accum2", new ReflectiveAction(null, null, this, "onAccumulate2"));
    }

    public void deliverMessage(KMessage kMessage) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null) {
            this.btnMap.clear();
            this.setButtons(Box.createVerticalBox());
        } else if (kMessage.testProg(28L)) {
            this.setButtons(this.rebuildButtons(kinemage));
        } else if (kMessage.testKin(264203)) {
            this.setButtons(this.rebuildButtons(kinemage));
        } else if (kMessage.testKin(4)) {
            this.resyncButtons();
        }
    }

    public void buildGUI() {
        this.buildGUI(true, true);
    }

    public void buildGUI(boolean bl, boolean bl2) {
        JComponent jComponent;
        ContentPane contentPane = this;
        KinCanvas kinCanvas = this.kMain.getCanvas();
        JComponent jComponent2 = this.buildButtons();
        Component component = this.buildBottomArea();
        if (bl) {
            this.minorSplit = new JSplitPane(1, kinCanvas, jComponent2);
            this.minorSplit.setOneTouchExpandable(true);
            this.minorSplit.setResizeWeight(1.0);
            jComponent = this.minorSplit;
        } else {
            this.minorSplit = null;
            jComponent = kinCanvas;
        }
        if (bl2) {
            this.majorSplit = new JSplitPane(0, jComponent, component);
            this.majorSplit.setOneTouchExpandable(true);
            this.majorSplit.setResizeWeight(1.0);
            contentPane.add((Component)this.majorSplit, "Center");
        } else {
            this.majorSplit = null;
            contentPane.add((Component)jComponent, "Center");
        }
    }

    public void setGraphicsComponent(Component component) {
        if (this.minorSplit == null) {
            if (this.majorSplit == null) {
                this.removeAll();
                this.add(component);
            } else {
                this.majorSplit.setTopComponent(component);
            }
        } else {
            this.minorSplit.setLeftComponent(component);
        }
    }

    public Component getGraphicsComponent() {
        if (this.minorSplit == null) {
            if (this.majorSplit == null) {
                return this.getComponent(0);
            }
            return this.majorSplit.getTopComponent();
        }
        return this.minorSplit.getLeftComponent();
    }

    JComponent buildButtons() {
        this.buttonScroll = new JScrollPane();
        this.buttonScroll.setPreferredSize(new Dimension(150, 200));
        JScrollPane jScrollPane = new JScrollPane(this.kMain.getStable().getChooser());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "North");
        jPanel.add((Component)this.buttonScroll, "Center");
        return jPanel;
    }

    public Container rebuildButtons(Kinemage kinemage) {
        this.btnMap.clear();
        Box box = Box.createVerticalBox();
        for (KGroup aGE : kinemage) {
            this.ageButtons(aGE, box);
        }
        box.add(Box.createRigidArea(new Dimension(0, 15)));
        for (MasterGroup masterGroup : kinemage.masterList()) {
            this.masterButtons(masterGroup, box);
        }
        return box;
    }

    void ageButtons(AGE aGE, Container container) {
        Object object;
        String string = aGE.getName();
        if (aGE instanceof KGroup) {
            object = (KGroup)aGE;
            if (((KGroup)object).isAnimate()) {
                string = "* " + string;
            } else if (((KGroup)object).is2Animate()) {
                string = "% " + string;
            }
        }
        object = new JCheckBox(string, aGE.isOn());
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
        if (aGE.hasButton()) {
            ((AbstractButton)object).addActionListener(new ButtonListener((JCheckBox)object, aGE));
            this.btnMap.put((JCheckBox)object, aGE);
            container.add((Component)object);
        }
        if (!aGE.isDominant() && !(aGE instanceof KList)) {
            AlignBox alignBox = new AlignBox(1);
            alignBox.setAlignmentX(0.0f);
            for (Object c : aGE) {
                this.ageButtons((AGE)c, alignBox);
            }
            IndentBox indentBox = aGE.isCollapsible() ? new FoldingBox((AbstractButton)object, (Component)alignBox) : new IndentBox(alignBox);
            indentBox.setIndent(8);
            container.add(indentBox);
        }
    }

    void masterButtons(MasterGroup masterGroup, Container container) {
        if (masterGroup.hasButton()) {
            JCheckBox jCheckBox = new JCheckBox(masterGroup.getName(), masterGroup.isOn());
            jCheckBox.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            jCheckBox.addActionListener(new ButtonListener(jCheckBox, masterGroup));
            this.btnMap.put(jCheckBox, masterGroup);
            if (masterGroup.getIndent()) {
                IndentBox indentBox = new IndentBox(jCheckBox);
                indentBox.setIndent(8);
                container.add(indentBox);
            } else {
                container.add(jCheckBox);
            }
        }
    }

    void resyncButtons() {
        for (Map.Entry<JCheckBox, AGE> entry : this.btnMap.entrySet()) {
            JCheckBox jCheckBox = entry.getKey();
            AGE aGE = entry.getValue();
            if (jCheckBox.isSelected() == aGE.isOn()) continue;
            jCheckBox.setSelected(aGE.isOn());
        }
    }

    Component buildBottomArea() {
        JLabel jLabel = new JLabel("Zoom");
        JSlider jSlider = new JSlider(this.kMain.getCanvas().getZoomModel());
        JLabel jLabel2 = new JLabel("Clipping");
        JSlider jSlider2 = new JSlider(this.kMain.getCanvas().getClipModel());
        JButton jButton = new JButton(new ReflectiveAction("Show hierarchy", null, this, "onShowHierarchy"));
        jButton.setToolTipText("Show an editable tree view of the kinemage");
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.weights(0.0, 1.0).insets(1).hfill(true).memorize();
        tablePane2.addCell(jLabel).weights(1.0, 1.0).addCell(jSlider);
        tablePane2.addCell(this.kMain.getCanvas().getPickcenterButton());
        if (this.kMain.getTextWindow() != null) {
            JButton jButton2 = this.kMain.getTextWindow().getButton();
            jButton2.setToolTipText("Display/edit the textual annotation of this kinemage");
            tablePane2.addCell(jButton2);
        } else {
            tablePane2.skip();
        }
        tablePane2.newRow();
        tablePane2.addCell(jLabel2).weights(1.0, 1.0).addCell(jSlider2);
        tablePane2.addCell(this.kMain.getCanvas().getMarkersButton());
        tablePane2.addCell(jButton);
        tablePane2.newRow();
        return tablePane2;
    }

    public void setButtons(Component component) {
        JButton jButton;
        JButton jButton2;
        KingPrefs kingPrefs = this.kMain.getPrefs();
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage == null || kingPrefs == null) {
            this.buttonScroll.setViewportView(component);
            return;
        }
        TablePane2 tablePane2 = new TablePane2();
        tablePane2.hfill(true).vfill(true).insets(0).addCell(component, 2, 1).newRow();
        tablePane2.weights(1.0, 0.0).insets(1).memorize();
        if (kinemage.hasAnimateGroups()) {
            jButton2 = new JButton(new ReflectiveAction(null, kingPrefs.stepBackIcon, this, "onAnimBackward"));
            jButton2.setToolTipText("Step backward one frame in the main animation");
            jButton = new JButton(new ReflectiveAction(null, kingPrefs.stepForwardIcon, this, "onAnimForward"));
            jButton.setToolTipText("Step forward one frame in the main animation");
            tablePane2.addCell(TablePane2.strut(0, 8), 2, 1).newRow();
            tablePane2.center().addCell(new JLabel("Animate"), 2, 1).newRow();
            tablePane2.right().addCell(jButton2).left().addCell(jButton).newRow();
        }
        if (kinemage.has2AnimateGroups()) {
            jButton2 = new JButton(new ReflectiveAction(null, kingPrefs.stepBackIcon, this, "onAnim2Backward"));
            jButton2.setToolTipText("Step backward one frame in the secondary animation");
            jButton = new JButton(new ReflectiveAction(null, kingPrefs.stepForwardIcon, this, "onAnim2Forward"));
            jButton.setToolTipText("Step forward one frame in the secondary animation");
            tablePane2.addCell(TablePane2.strut(0, 8), 2, 1).newRow();
            tablePane2.center().addCell(new JLabel("2-Animate"), 2, 1).newRow();
            tablePane2.right().addCell(jButton2).left().addCell(jButton).newRow();
        }
        this.buttonScroll.setViewportView(tablePane2);
    }

    public void onAnimForward(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.animate(1);
        }
    }

    public void onAnimBackward(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.animate(-1);
        }
    }

    public void onAnim2Forward(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.animate2(1);
        }
    }

    public void onAnim2Backward(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.animate2(-1);
        }
    }

    public void onShowHierarchy(ActionEvent actionEvent) {
        KinTree kinTree = this.kMain.getKinTree();
        if (kinTree != null) {
            kinTree.show();
        }
    }

    public void onAccumulate(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.accumulate();
        }
    }

    public void onAccumulate2(ActionEvent actionEvent) {
        Kinemage kinemage = this.kMain.getKinemage();
        if (kinemage != null) {
            kinemage.accumulate2();
        }
    }

    static class ButtonListener
    implements ActionListener {
        JCheckBox cbox;
        AGE age;

        public ButtonListener(JCheckBox jCheckBox, AGE aGE) {
            this.cbox = jCheckBox;
            this.age = aGE;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.age.setOn(this.cbox.isSelected());
        }
    }
}

